/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurSelectionHighlight;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ControleurClicMovement
implements MouseListener,
MouseMotionListener,
PopupMenuListener {
    private VARNAPanel _vp;
    private boolean _presenceMenuSelection;
    private JMenu _submenuSelection;
    public Point _spawnPoint;
    public Point _initialPoint;
    public Point _prevPoint;
    public Point _currentPoint;
    public static final double MIN_SELECTION_DISTANCE = 40.0;
    public static final double HYSTERESIS_DISTANCE = 10.0;
    private ModeleBase _selectedBase = null;
    private MouseStates _currentState = MouseStates.NONE;

    public ControleurClicMovement(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
        this._vp.getPopup().addPopupMenuListener(this);
        this._presenceMenuSelection = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._vp.requestFocus();
        boolean bl = mouseEvent.getButton() == 1;
        boolean bl2 = mouseEvent.getButton() == 2;
        boolean bl3 = mouseEvent.getButton() == 3;
        boolean bl4 = mouseEvent.isShiftDown();
        boolean bl5 = mouseEvent.isControlDown();
        boolean bl6 = mouseEvent.isAltDown();
        this._vp.removeSelectedAnnotation();
        if (bl && !bl5 && !bl6 && !bl4) {
            if (this._vp.isModifiable()) {
                this._currentState = MouseStates.MOVE_OR_SELECT_ELEMENT;
                if (this._vp.getRealCoords() != null && this._vp.getRealCoords().length != 0 && this._vp.getRNA().get_listeBases().size() != 0) {
                    this._selectedBase = this._vp.getNearestBase(mouseEvent.getX(), mouseEvent.getY(), false, false);
                    TextAnnotation textAnnotation = this._vp.getNearestAnnotation(mouseEvent.getX(), mouseEvent.getY());
                    this._initialPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                    this._currentPoint = new Point(this._initialPoint);
                    this._prevPoint = new Point(this._initialPoint);
                    if (this._selectedBase != null) {
                        if (this._vp.getRNA().get_drawMode() == 2) {
                            this._vp.highlightSelectedBase(this._selectedBase);
                        } else if (!this._vp.getSelectionIndices().contains(this._selectedBase.getIndex())) {
                            this._vp.highlightSelectedBase(this._selectedBase);
                        }
                    } else if (textAnnotation != null) {
                        this._currentState = MouseStates.MOVE_ANNOTATION;
                        this._vp.set_selectedAnnotation(textAnnotation);
                        this._vp.highlightSelectedAnnotation();
                    } else {
                        this._vp.clearSelection();
                        this._selectedBase = null;
                        this._currentState = MouseStates.SELECT_REGION_OR_UNSELECT;
                        this._initialPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                        this._prevPoint = new Point(this._initialPoint);
                        this._currentPoint = new Point(this._initialPoint);
                    }
                }
            }
        } else if (bl && bl5 && !bl6 && !bl4) {
            this._selectedBase = this._vp.getNearestBase(mouseEvent.getX(), mouseEvent.getY(), false, false);
            if (this._selectedBase != null) {
                this._vp.clearSelection();
                this._currentState = MouseStates.CREATE_BP;
                this._vp.highlightSelectedBase(this._selectedBase);
                this._vp.setOriginLink(this._vp.logicToPanel(this._selectedBase.getCoords()));
                this._initialPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                this._currentPoint = new Point(this._initialPoint);
            }
        } else if (bl && !bl5 && !bl6 && bl4) {
            this._currentState = MouseStates.SELECT_ELEMENT;
            this._initialPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
            this._currentPoint = new Point(this._initialPoint);
        } else if (bl3) {
            this._currentState = MouseStates.POPUP_MENU;
            if (this._presenceMenuSelection) {
                this._vp.getPopupMenu().removeSelectionMenu();
            }
            if (this._vp.getRealCoords() != null && this._vp.getRNA().get_listeBases().size() != 0) {
                this.updateNearestBase(mouseEvent);
                this.addMenu(mouseEvent);
                if (this._vp.get_selectedAnnotation() != null) {
                    this._vp.highlightSelectedAnnotation();
                }
            }
            if (this._vp.getRNA().get_drawMode() == 4) {
                this._vp.getPopup().get_rotation().setEnabled(false);
            } else {
                this._vp.getPopup().get_rotation().setEnabled(true);
            }
            this._vp.getPopup().updateDialog();
            this._vp.getPopup().show(this._vp, mouseEvent.getX(), mouseEvent.getY());
        }
        this._vp.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._currentState == MouseStates.MOVE_OR_SELECT_ELEMENT || this._currentState == MouseStates.MOVE_ELEMENT) {
            this._vp.lockScrolling();
            this._currentState = MouseStates.MOVE_ELEMENT;
            if (this._selectedBase != null) {
                if (this._vp.getRNA().get_drawMode() == 2) {
                    this._vp.highlightSelectedStem(this._selectedBase);
                    this._vp.getVARNAUI().UIMoveHelixAtom(this._selectedBase.getIndex(), this._vp.panelToLogicPoint(new Point2D.Double(mouseEvent.getX(), mouseEvent.getY())));
                } else {
                    this._currentPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                    this.moveSelection(this._prevPoint, this._currentPoint);
                    this._prevPoint = new Point(this._currentPoint);
                }
                this._vp.repaint();
            }
        } else if (this._currentState == MouseStates.MOVE_ANNOTATION) {
            if (this._vp.get_selectedAnnotation() != null) {
                Point2D.Double double_ = this._vp.panelToLogicPoint(new Point2D.Double(mouseEvent.getX(), mouseEvent.getY()));
                this._vp.get_selectedAnnotation().setAncrage(double_.x, double_.y);
                this._vp.repaint();
            }
        } else if (this._currentState == MouseStates.SELECT_ELEMENT || this._currentState == MouseStates.SELECT_REGION_OR_UNSELECT) {
            if (this._initialPoint.distance(mouseEvent.getX(), mouseEvent.getY()) > 10.0) {
                this._currentState = MouseStates.SELECT_REGION;
            }
        } else if (this._currentState == MouseStates.SELECT_REGION) {
            this._currentPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = Math.min(this._currentPoint.x, this._initialPoint.x);
            int n2 = Math.min(this._currentPoint.y, this._initialPoint.y);
            int n3 = Math.max(this._currentPoint.x, this._initialPoint.x);
            int n4 = Math.max(this._currentPoint.y, this._initialPoint.y);
            this._vp.setSelectionRectangle(new Rectangle(n, n2, n3 - n, n4 - n2));
        } else if (this._currentState == MouseStates.CREATE_BP && this._initialPoint.distance(mouseEvent.getX(), mouseEvent.getY()) > 10.0) {
            ModeleBase modeleBase = this._vp.getNearestBase(mouseEvent.getX(), mouseEvent.getY(), false, false);
            this._vp.setHoverBase(modeleBase);
            if (modeleBase == null) {
                this._vp.setDestinationLink(new Point2D.Double(mouseEvent.getX(), mouseEvent.getY()));
                this._vp.clearSelection();
                this._vp.addToSelection(this._selectedBase.getIndex());
            } else {
                ModeleBase modeleBase2 = this._selectedBase;
                this._vp.clearSelection();
                this._vp.addToSelection(modeleBase.getIndex());
                this._vp.addToSelection(modeleBase2.getIndex());
                this._vp.setDestinationLink(this._vp.logicToPanel(modeleBase.getCoords()));
            }
            this._vp.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this._vp.fireBaseClicked(this._selectedBase, mouseEvent);
            if (this._currentState == MouseStates.MOVE_ELEMENT) {
                this._vp.clearSelection();
                this._selectedBase = null;
                this._vp.unlockScrolling();
                this._vp.removeSelectedAnnotation();
            } else if (this._currentState == MouseStates.SELECT_REGION_OR_UNSELECT) {
                this._vp.clearSelection();
                this._selectedBase = null;
                this._vp.removeSelectedAnnotation();
            } else if (this._currentState == MouseStates.SELECT_ELEMENT) {
                int n;
                if (this._vp.getRealCoords() != null && this._vp.getRealCoords().length != 0 && this._vp.getRNA().get_listeBases().size() != 0 && (n = this._vp.getNearestBaseIndex(mouseEvent.getX(), mouseEvent.getY(), false, false)) != -1) {
                    this._vp.toggleSelection(n);
                }
                this._selectedBase = null;
            } else if (this._currentState == MouseStates.SELECT_REGION) {
                this._vp.removeSelectionRectangle();
            } else if (this._currentState == MouseStates.CREATE_BP) {
                int n;
                if (this._initialPoint.distance(mouseEvent.getX(), mouseEvent.getY()) > 10.0 && (n = this._vp.getNearestBaseIndex(mouseEvent.getX(), mouseEvent.getY(), false, false)) >= 0) {
                    ModeleBase modeleBase = this._vp.getNearestBase(mouseEvent.getX(), mouseEvent.getY(), false, false);
                    ModeleBase modeleBase2 = this._selectedBase;
                    ModeleBP modeleBP = new ModeleBP(modeleBase, modeleBase2);
                    if (modeleBase != modeleBase2) {
                        this._vp.getVARNAUI().UIAddBP(modeleBase.getIndex(), modeleBase2.getIndex(), modeleBP);
                    }
                }
                this._vp.removeLink();
                this._vp.clearSelection();
                this._vp.repaint();
            } else {
                this._vp.clearSelection();
            }
        }
        this._currentState = MouseStates.NONE;
        this._vp.repaint();
    }

    private void addMenu(MouseEvent mouseEvent) {
        this._submenuSelection = new JMenu("Selection");
        this.addCurrent();
        this.addMenuBase();
        if (this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase()).getElementStructure() != -1) {
            this.addMenuBasePair();
        }
        this.detectBulge();
        this.detect3Prime();
        this.detect5Prime();
        this.detectLoop();
        this.detectHelix();
        this.detectStem();
        this.addAllBase();
        this.detectAnnotation(mouseEvent);
        this._vp.getPopup().addSelectionMenu(this._submenuSelection);
        this._presenceMenuSelection = true;
    }

    private void detectAnnotation(MouseEvent mouseEvent) {
        if (this._vp.getListeAnnotations().size() != 0) {
            double d = Double.MAX_VALUE;
            for (TextAnnotation textAnnotation : this._vp.getListeAnnotations()) {
                Point2D.Double double_ = textAnnotation.getCenterPosition();
                double_ = this._vp.transformCoord(double_);
                double d2 = Math.sqrt(Math.pow(double_.x - (double)mouseEvent.getX(), 2.0) + Math.pow(double_.y - (double)mouseEvent.getY(), 2.0));
                if (!(d > d2)) continue;
                this._vp.set_selectedAnnotation(textAnnotation);
                d = d2;
            }
            this._submenuSelection.addSeparator();
            this._vp.getPopup().addAnnotationMenu(this._submenuSelection, true);
        }
    }

    private void detectBulge() {
        int n = this._vp.getNearestBase();
        ArrayList<Integer> arrayList = this._vp.getRNA().findBulge(n);
        if (arrayList.size() > 0 && this._vp.getRNA().getHelixCountOnLoop(this._vp.getNearestBase()) == 2) {
            JMenu jMenu = new JMenu("Bulge");
            jMenu.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(arrayList), this._vp, (JMenuItem)jMenu));
            jMenu.setActionCommand("bulge");
            if (!this._vp.isModifiable()) {
                jMenu.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(jMenu);
            this._submenuSelection.add(jMenu);
        }
    }

    private void detectHelix() {
        int n = this._vp.getNearestBase();
        ArrayList<Integer> arrayList = this._vp.getRNA().findHelix(n);
        if (arrayList.size() != 0) {
            JMenu jMenu = new JMenu("Helix");
            jMenu.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(arrayList), this._vp, (JMenuItem)jMenu));
            jMenu.setActionCommand("helix");
            if (!this._vp.isModifiable()) {
                jMenu.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(jMenu);
            jMenu.addSeparator();
            this._vp.getPopupMenu().addAnnotationMenu(jMenu);
            this._submenuSelection.add(jMenu);
        }
    }

    private void detectStem() {
        int n = this._vp.getNearestBase();
        ArrayList<Integer> arrayList = this._vp.getRNA().findStem(n);
        if (arrayList.size() > 0) {
            JMenu jMenu = new JMenu("Stem");
            jMenu.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(arrayList), this._vp, (JMenuItem)jMenu));
            jMenu.setActionCommand("stem");
            if (!this._vp.isModifiable()) {
                jMenu.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(jMenu);
            this._submenuSelection.add(jMenu);
        }
    }

    private void detect3Prime() {
        int n = this._vp.getNearestBase();
        ArrayList<Integer> arrayList = this._vp.getRNA().find3Prime(n);
        if (arrayList.size() != 0) {
            JMenu jMenu = new JMenu("3'");
            jMenu.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(arrayList), this._vp, (JMenuItem)jMenu));
            jMenu.setActionCommand("3'");
            if (!this._vp.isModifiable()) {
                jMenu.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(jMenu);
            this._submenuSelection.add(jMenu);
        }
    }

    private void detect5Prime() {
        int n = this._vp.getNearestBase();
        ArrayList<Integer> arrayList = this._vp.getRNA().find5Prime(n);
        if (arrayList.size() != 0) {
            JMenu jMenu = new JMenu("5'");
            jMenu.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(arrayList), this._vp, (JMenuItem)jMenu));
            jMenu.setActionCommand("5'");
            if (!this._vp.isModifiable()) {
                jMenu.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(jMenu);
            this._submenuSelection.add(jMenu);
        }
    }

    private void detectLoop() {
        int n = this._vp.getNearestBase();
        if (this._vp.getRNA().get_listeBases().get(n).getElementStructure() == -1) {
            ArrayList<Integer> arrayList = this._vp.getRNA().findLoop(n);
            JMenu jMenu = new JMenu("Loop");
            jMenu.addChangeListener(new ControleurSelectionHighlight(arrayList, this._vp, (JMenuItem)jMenu));
            jMenu.setActionCommand("loop1");
            if (!this._vp.isModifiable()) {
                jMenu.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(jMenu);
            jMenu.addSeparator();
            this._vp.getPopupMenu().addAnnotationMenu(jMenu);
            this._submenuSelection.add(jMenu);
        } else {
            Serializable serializable;
            ArrayList<Integer> arrayList = this._vp.getRNA().findLoopForward(n);
            if (arrayList.size() > 0) {
                serializable = new JMenu("Forward loop");
                ((AbstractButton)serializable).addChangeListener(new ControleurSelectionHighlight(arrayList, this._vp, (JMenuItem)serializable));
                ((AbstractButton)serializable).setActionCommand("loop1");
                if (!this._vp.isModifiable()) {
                    ((JMenuItem)serializable).setEnabled(false);
                }
                this._vp.getPopupMenu().addColorOptions((JMenu)serializable);
                ((JMenu)serializable).addSeparator();
                this._vp.getPopupMenu().addAnnotationMenu((JMenu)serializable);
                this._submenuSelection.add((JMenuItem)serializable);
            }
            if (((ArrayList)(serializable = this._vp.getRNA().findLoopBackward(n))).size() > 0) {
                JMenu jMenu = new JMenu("Backward loop");
                jMenu.addChangeListener(new ControleurSelectionHighlight((ArrayList<Integer>)serializable, this._vp, (JMenuItem)jMenu));
                jMenu.setActionCommand("loop2");
                if (!this._vp.isModifiable()) {
                    jMenu.setEnabled(false);
                }
                this._vp.getPopupMenu().addColorOptions(jMenu);
                jMenu.addSeparator();
                this._vp.getPopupMenu().addAnnotationMenu(jMenu);
                this._submenuSelection.add(jMenu);
            }
        }
    }

    private void addCurrent() {
        ArrayList<ModeleBase> arrayList = this._vp.getSelection().getBases();
        if (arrayList.size() > 0) {
            JMenu jMenu = new JMenu("Current");
            jMenu.addChangeListener(new ControleurSelectionHighlight((Collection<? extends ModeleBase>)arrayList, this._vp, (JMenuItem)jMenu));
            jMenu.setActionCommand("current");
            if (!this._vp.isModifiable()) {
                jMenu.setEnabled(false);
            }
            this._vp.getPopupMenu().addColorOptions(jMenu);
            this._submenuSelection.add(jMenu);
        }
    }

    private void addMenuBase() {
        JMenu jMenu = new JMenu();
        ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase());
        if (modeleBase instanceof ModeleBasesComparison) {
            jMenu.setText("Base #" + modeleBase.getBaseNumber() + ":" + ((ModeleBasesComparison)modeleBase).getBases());
        } else {
            jMenu.setText("Base #" + modeleBase.getBaseNumber() + ":" + ((ModeleBaseNucleotide)modeleBase).getBase());
        }
        jMenu.addChangeListener(new ControleurSelectionHighlight(modeleBase.getIndex(), this._vp, (JMenuItem)jMenu));
        jMenu.setActionCommand("base");
        if (!this._vp.isModifiable()) {
            jMenu.setEnabled(false);
        }
        JMenuItem jMenuItem = new JMenuItem("Edit base");
        jMenuItem.setActionCommand("baseChar");
        jMenuItem.addActionListener(this._vp.getPopupMenu().get_controleurMenu());
        jMenu.add(jMenuItem);
        this._vp.getPopupMenu().addColorOptions(jMenu);
        jMenu.addSeparator();
        this._vp.getPopupMenu().addAnnotationMenu(jMenu);
        this._submenuSelection.add(jMenu);
    }

    private void addAllBase() {
        ArrayList<Integer> arrayList = this._vp.getRNA().findAll();
        JMenu jMenu = new JMenu("All");
        jMenu.addChangeListener(new ControleurSelectionHighlight(new Vector<Integer>(arrayList), this._vp, (JMenuItem)jMenu));
        jMenu.setActionCommand("all");
        if (!this._vp.isModifiable()) {
            jMenu.setEnabled(false);
        }
        this._vp.getPopupMenu().addColorOptions(jMenu);
        this._submenuSelection.add(jMenu);
    }

    private void addMenuBasePair() {
        int n = this._vp.getNearestBase();
        ArrayList<Integer> arrayList = this._vp.getRNA().findPair(n);
        ModeleBase modeleBase = this._vp.getRNA().get_listeBases().get(this._vp.getNearestBase());
        if (modeleBase.getElementStructure() != -1) {
            JMenu jMenu = new JMenu();
            ModeleBase modeleBase2 = this._vp.getRNA().get_listeBases().get(modeleBase.getElementStructure());
            jMenu.addChangeListener(new ControleurSelectionHighlight(arrayList, this._vp, (JMenuItem)jMenu));
            jMenu.setText("Base pair #(" + Math.min(modeleBase.getBaseNumber(), modeleBase2.getBaseNumber()) + "," + Math.max(modeleBase.getBaseNumber(), modeleBase2.getBaseNumber()) + ")");
            jMenu.setActionCommand("bp");
            if (!this._vp.isModifiable()) {
                jMenu.setEnabled(false);
            }
            JMenuItem jMenuItem = new JMenuItem("Edit BP");
            jMenuItem.setActionCommand("basepair");
            jMenuItem.addActionListener(this._vp.getPopupMenu().get_controleurMenu());
            this._vp.getPopupMenu().addColorOptions(jMenu);
            Component[] componentArray = jMenu.getMenuComponents();
            int n2 = -1;
            for (int i = 0; i < componentArray.length; ++i) {
                JMenuItem jMenuItem2;
                Component component = componentArray[i];
                if (!(component instanceof JMenuItem) || !(jMenuItem2 = (JMenuItem)component).getActionCommand().contains(",BPColor")) continue;
                n2 = i;
            }
            if (n2 != -1) {
                jMenu.insert(jMenuItem, n2);
            } else {
                jMenu.add(jMenuItem);
            }
            this._submenuSelection.add(jMenu);
        }
    }

    private void updateNearestBase(MouseEvent mouseEvent) {
        int n = this._vp.getNearestBaseIndex(mouseEvent.getX(), mouseEvent.getY(), true, false);
        if (n != -1) {
            this._vp.setNearestBase(n);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this._selectedBase = this._vp.getNearestBase(mouseEvent.getX(), mouseEvent.getY());
        TextAnnotation textAnnotation = this._vp.getNearestAnnotation(mouseEvent.getX(), mouseEvent.getY());
        this._vp.setHoverBase(this._selectedBase);
        if (this._selectedBase == null && textAnnotation != null) {
            this._vp.set_selectedAnnotation(textAnnotation);
            this._vp.highlightSelectedAnnotation();
            this._vp.repaint();
        }
        this._vp.setLastSelectedPosition(new Point2D.Double(mouseEvent.getX(), mouseEvent.getY()));
    }

    private void moveSelection(Point point, Point point2) {
        Point2D.Double double_ = this._vp.panelToLogicPoint(new Point2D.Double(point.x, point.y));
        Point2D.Double double_2 = this._vp.panelToLogicPoint(new Point2D.Double(point2.x, point2.y));
        double d = double_2.x - double_.x;
        double d2 = double_2.y - double_.y;
        if (this._vp.isModifiable()) {
            double d3 = d;
            double d4 = d2;
            if (this._vp.getRNA().get_drawMode() == 4) {
                d4 = 0.0;
            }
            this._vp.getVARNAUI().UIShiftBaseCoord(this._vp.getSelectionIndices(), d3, d4);
            this._vp.fireLayoutChanged();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this._vp.resetAnnotationHighlight();
        this._selectedBase = null;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public static enum MouseStates {
        NONE,
        MOVE_ELEMENT,
        MOVE_OR_SELECT_ELEMENT,
        SELECT_ELEMENT,
        SELECT_REGION_OR_UNSELECT,
        SELECT_REGION,
        CREATE_BP,
        POPUP_MENU,
        MOVE_ANNOTATION;

    }
}

