/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.components;

import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class GradientEditorPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    ModeleColorMap _mcm;
    private static final int TRIGGERS_SEMI_WIDTH = 2;
    private static final int PALETTE_HEIGHT = 11;
    private static final int REMOVE_HEIGHT = 11;
    private static final int TOLERANCE = 5;
    private static final int GAP = 4;
    private final Color EDGES = Color.gray.brighter();
    private final Color BUTTONS = Color.LIGHT_GRAY.brighter();
    private int _selectedIndex = -1;

    public GradientEditorPanel(ModeleColorMap modeleColorMap) {
        this._mcm = modeleColorMap;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setColorMap(ModeleColorMap modeleColorMap) {
        this._mcm = modeleColorMap;
    }

    public ModeleColorMap getColorMap() {
        return this._mcm;
    }

    public int getStartChoose() {
        return this.getHeight() - 11 - 11 - 4 - 1;
    }

    public int getEndChoose() {
        return this.getStartChoose() + 11;
    }

    public int getStartRemove() {
        return this.getEndChoose() + 4;
    }

    public int getEndRemove() {
        return this.getStartRemove() + 11;
    }

    private int getStripeHeight() {
        return this.getHeight() - 11 - 11 - 8 - 1;
    }

    private Color alterColor(Color color, int n) {
        int n2 = Math.min(Math.max(color.getRed() + n, 0), 255);
        int n3 = Math.min(Math.max(color.getGreen() + n, 0), 255);
        int n4 = Math.min(Math.max(color.getBlue() + n, 0), 255);
        return new Color(n2, n3, n4);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        double d;
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = this.getStripeHeight();
        double d2 = this._mcm.getMinValue();
        double d3 = this._mcm.getMaxValue();
        for (n = 0; n <= this.getWidth(); ++n) {
            d = (double)n / (double)this.getWidth();
            double d4 = d2 + (d3 - d2) * d;
            graphics2D.setColor(this._mcm.getColorForValue(d4));
            graphics2D.drawLine(n, 0, n, n2);
        }
        for (n = 0; n < this._mcm.getNumColors(); ++n) {
            d = this._mcm.getValueAt(n);
            Color color = this._mcm.getColorAt(n);
            double d5 = (d - this._mcm.getMinValue()) / (this._mcm.getMaxValue() - this._mcm.getMinValue());
            int n3 = (int)(d5 * (double)(this.getWidth() - 1));
            graphics2D.setColor(color);
            graphics2D.fillRect(n3 - 2 + 1, 0, 3, this.getHeight() - 1);
            graphics2D.setColor(this.EDGES);
            graphics2D.drawLine(n3 - 2, 0, n3 - 2, this.getHeight());
            graphics2D.drawLine(n3 + 2, 0, n3 + 2, this.getHeight());
            if (n == 0) {
                graphics2D.setColor(this.EDGES);
                graphics2D.drawRect(n3, n2 + 4, 11, 26);
                graphics2D.setColor(color);
                graphics2D.fillRect(n3 + 1, n2 + 4 + 1, 10, 25);
                continue;
            }
            if (n == this._mcm.getNumColors() - 1) {
                graphics2D.setColor(this.EDGES);
                graphics2D.drawRect(n3 - 11, n2 + 4, 11, 26);
                graphics2D.setColor(color);
                graphics2D.fillRect(n3 - 11 + 1, n2 + 4 + 1, 10, 25);
                continue;
            }
            graphics2D.setColor(this.EDGES);
            graphics2D.drawRect(n3 - 5, n2 + 4, 11, 11);
            graphics2D.setColor(this.alterColor(color, -15));
            graphics2D.fillRect(n3 - 5 + 1, n2 + 4 + 1, 10, 10);
            graphics2D.setColor(color);
            graphics2D.fillOval(n3 - 5 + 1, n2 + 4 + 1, 10, 10);
            graphics2D.setColor(this.alterColor(color, 10));
            graphics2D.fillOval(n3 - 5 + 1 + 2, n2 + 4 + 1 + 2, 6, 6);
            graphics2D.setColor(this.EDGES);
            graphics2D.drawRect(n3 - 5, n2 + 8 + 11, 11, 11);
            graphics2D.setColor(this.BUTTONS);
            graphics2D.fillRect(n3 - 5 + 1, n2 + 8 + 1 + 11, 10, 10);
            int n4 = n3 - 5 + 2;
            int n5 = n2 + 8 + 11 + 2;
            int n6 = n4 + 11 - 4;
            int n7 = n5 + 11 - 4;
            graphics2D.setColor(Color.red);
            graphics2D.drawLine(n4, n5, n6, n7);
            graphics2D.drawLine(n4, n7, n6, n5);
        }
    }

    private boolean isChooseColor(int n, int n2) {
        if (this._selectedIndex != -1) {
            if (this._selectedIndex == 0 || this._selectedIndex == this._mcm.getNumColors() - 1) {
                return n2 <= this.getEndRemove() && n2 >= this.getStartChoose() && Math.abs(this.getXPos(this._selectedIndex) - n) <= 11;
            }
            if (n2 <= this.getEndChoose() && n2 >= this.getStartChoose()) {
                return Math.abs(this.getXPos(this._selectedIndex) - n) <= 5;
            }
        }
        return false;
    }

    private boolean isRemove(int n, int n2) {
        if (this._selectedIndex != -1) {
            if (this._selectedIndex == 0 || this._selectedIndex == this._mcm.getNumColors() - 1) {
                return false;
            }
            if (n2 <= this.getEndRemove() && n2 >= this.getStartRemove()) {
                return Math.abs(this.getXPos(this._selectedIndex) - n) <= 5;
            }
        }
        return false;
    }

    private int getXPos(int n) {
        double d = this._mcm.getValueAt(n);
        double d2 = (d - this._mcm.getMinValue()) / (this._mcm.getMaxValue() - this._mcm.getMinValue());
        return (int)(d2 * (double)(this.getWidth() - 1));
    }

    private int locateSelectedIndex(int n, int n2) {
        double d = Double.MAX_VALUE;
        int n3 = -1;
        for (int i = 0; i < this._mcm.getNumColors(); ++i) {
            int n4 = this.getXPos(i);
            double d2 = Math.abs(n - n4);
            if (!(d2 < d)) continue;
            n3 = i;
            d = d2;
        }
        return n3;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this._selectedIndex = this.locateSelectedIndex(mouseEvent.getX(), mouseEvent.getY());
        if (this._selectedIndex != -1) {
            if (this.isRemove(mouseEvent.getX(), mouseEvent.getY())) {
                this.removeEntry(this._selectedIndex);
            } else if (Math.abs(this.getXPos(this._selectedIndex) - mouseEvent.getX()) > 5) {
                double d = this._mcm.getMinValue() + (double)mouseEvent.getX() * (this._mcm.getMaxValue() - this._mcm.getMinValue()) / (double)(this.getWidth() - 1);
                Color color = JColorChooser.showDialog(this, "Choose new color", this._mcm.getColorAt(this._selectedIndex));
                if (color != null) {
                    this._mcm.addColor(d, color);
                    this.repaint();
                    this.firePropertyChange("PaletteChanged", "a", "b");
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Color color;
        this.requestFocus();
        this._selectedIndex = this.locateSelectedIndex(mouseEvent.getX(), mouseEvent.getY());
        if (this._selectedIndex != -1 && this.isChooseColor(mouseEvent.getX(), mouseEvent.getY()) && (color = JColorChooser.showDialog(this, "Choose new color", this._mcm.getColorAt(this._selectedIndex))) != null) {
            double d = this._mcm.getValueAt(this._selectedIndex);
            this.replaceEntry(this._selectedIndex, color, d);
            this._selectedIndex = -1;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._selectedIndex = -1;
    }

    private void replaceEntry(int n, Color color, double d) {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        for (int i = 0; i < this._mcm.getNumColors(); ++i) {
            if (i != n) {
                double d2 = this._mcm.getValueAt(i);
                Color color2 = this._mcm.getColorAt(i);
                modeleColorMap.addColor(d2, color2);
                continue;
            }
            modeleColorMap.addColor(d, color);
        }
        this._mcm = modeleColorMap;
        this.repaint();
        this.firePropertyChange("PaletteChanged", "a", "b");
    }

    private void removeEntry(int n) {
        ModeleColorMap modeleColorMap = new ModeleColorMap();
        for (int i = 0; i < this._mcm.getNumColors(); ++i) {
            if (i == n) continue;
            double d = this._mcm.getValueAt(i);
            Color color = this._mcm.getColorAt(i);
            modeleColorMap.addColor(d, color);
        }
        this._mcm = modeleColorMap;
        this.repaint();
        this.firePropertyChange("PaletteChanged", "a", "b");
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._selectedIndex != -1 && this._selectedIndex != 0 && this._selectedIndex != this._mcm.getNumColors() - 1) {
            Color color = this._mcm.getColorAt(this._selectedIndex);
            double d = this._mcm.getMinValue() + (double)mouseEvent.getX() * (this._mcm.getMaxValue() - this._mcm.getMinValue()) / (double)(this.getWidth() - 1);
            this.replaceEntry(this._selectedIndex, color, d);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Cursor cursor = Cursor.getPredefinedCursor(0);
        this._selectedIndex = this.locateSelectedIndex(mouseEvent.getX(), mouseEvent.getY());
        if (this._selectedIndex != -1) {
            if (this.isChooseColor(mouseEvent.getX(), mouseEvent.getY())) {
                cursor = Cursor.getPredefinedCursor(12);
            } else if (this._selectedIndex != 0 && this._selectedIndex != this._mcm.getNumColors() - 1) {
                if (this.isRemove(mouseEvent.getX(), mouseEvent.getY())) {
                    cursor = Cursor.getPredefinedCursor(12);
                } else if (Math.abs(this.getXPos(this._selectedIndex) - mouseEvent.getX()) <= 5) {
                    cursor = Cursor.getPredefinedCursor(11);
                } else if (mouseEvent.getY() < this.getHeight() - this.getStripeHeight()) {
                    cursor = Cursor.getPredefinedCursor(12);
                } else {
                    Cursor.getPredefinedCursor(0);
                }
            }
        }
        this.setCursor(cursor);
    }
}

