/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.components.ReorderableJList;
import fr.orsay.lri.varna.components.ZoomWindow;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNARNAListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNASelectionListener;
import fr.orsay.lri.varna.models.BaseList;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class VARNAGUI
extends JFrame
implements DropTargetListener,
InterfaceVARNAListener,
MouseListener,
AdjustmentListener {
    private static final long serialVersionUID = -790155708306987257L;
    private static final String DEFAULT_SEQUENCE = "CAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIA";
    private static final String DEFAULT_STRUCTURE1 = "..(((((...(((((...(((((...(((((.....)))))...))))).....(((((...(((((.....)))))...))))).....)))))...)))))..";
    private static final String DEFAULT_STRUCTURE2 = "..(((((...(((((...(((((........(((((...(((((.....)))))...)))))..................))))).....)))))...)))))..";
    private VARNAPanel _vp;
    private JPanel _tools = new JPanel();
    private JPanel _input = new JPanel();
    private JPanel _seqPanel = new JPanel();
    private JPanel _strPanel = new JPanel();
    private JLabel _info = new JLabel();
    private JTextField _str = new JTextField("..(((((...(((((...(((((...(((((.....)))))...))))).....(((((...(((((.....)))))...))))).....)))))...)))))..");
    Object _hoverHighlightStr = null;
    ArrayList<Object> _selectionHighlightStr = new ArrayList();
    private JTextField _seq = new JTextField("CAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIACAGCACGACACUAGCAGUCAGUGUCAGACUGCAIA");
    Object _hoverHighlightSeq = null;
    ArrayList<Object> _selectionHighlightSeq = new ArrayList();
    private ZoomWindow _zoomWindow;
    private JLabel _strLabel = new JLabel(" Str:");
    private JLabel _seqLabel = new JLabel(" Seq:");
    private JButton _createButton = new JButton("Create");
    private JButton _deleteButton = new JButton("Delete");
    private JButton _duplicateButton = new JButton("Snapshot");
    private JPanel _listPanel = new JPanel();
    private ReorderableJList _sideList = null;
    private static String errorOpt = "error";
    private boolean _error;
    private Color _backgroundColor = Color.white;
    private JScrollBar _vert = new JScrollBar(1);
    private JScrollBar _horiz = new JScrollBar(0);
    private static int _nextID = 1;
    private int _algoCode;
    private BackupHolder _rnaList;

    public VARNAGUI() {
        super("VARNA GUI");
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        DefaultListModel defaultListModel = new DefaultListModel();
        int n = 40;
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setSelectionMode(0);
        defaultListSelectionModel.setLeadAnchorNotificationEnabled(false);
        this._sideList = new ReorderableJList();
        this._sideList.setModel(defaultListModel);
        this._sideList.addMouseListener(this);
        this._sideList.setSelectionModel(defaultListSelectionModel);
        this._sideList.setPreferredSize(null);
        this._sideList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!VARNAGUI.this._sideList.isSelectionEmpty() && !listSelectionEvent.getValueIsAdjusting()) {
                    FullBackup fullBackup = (FullBackup)VARNAGUI.this._sideList.getSelectedValue();
                    VARNAGUI.this._vp.setConfig(fullBackup.config);
                    VARNAGUI.this.showRNA(fullBackup.rna);
                    VARNAGUI.this._seq.setText(fullBackup.rna.getSeq());
                    VARNAGUI.this._str.setText(fullBackup.rna.getStructDBN(true));
                }
            }
        });
        this._rnaList = new BackupHolder(defaultListModel, this._sideList);
        RNA rNA = new RNA("User defined 1");
        RNA rNA2 = new RNA("User defined 2");
        try {
            this._vp = new VARNAPanel("0", ".");
            this._zoomWindow = new ZoomWindow(this._vp);
            rNA.setRNA(DEFAULT_SEQUENCE, DEFAULT_STRUCTURE1);
            rNA.drawRNARadiate(this._vp.getConfig());
            rNA2.setRNA(DEFAULT_SEQUENCE, DEFAULT_STRUCTURE2);
            rNA2.drawRNARadiate(this._vp.getConfig());
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            this._vp.errorDialog(exceptionNonEqualLength);
        }
        catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
            exceptionUnmatchedClosingParentheses.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            exceptionFileFormatOrSyntax.printStackTrace();
        }
        this._vp.setPreferredSize(new Dimension(400, 400));
        this._rnaList.add(this._vp.getConfig().clone(), rNA2, VARNAGUI.generateDefaultName());
        this._rnaList.add(this._vp.getConfig().clone(), rNA, VARNAGUI.generateDefaultName(), true);
        JScrollPane jScrollPane = new JScrollPane(this._sideList);
        jScrollPane.setPreferredSize(new Dimension(150, 0));
        this.setBackground(this._backgroundColor);
        this._vp.setBackground(this._backgroundColor);
        Font font = Font.decode("MonoSpaced-PLAIN-12");
        this._seqLabel.setHorizontalTextPosition(2);
        this._seqLabel.setPreferredSize(new Dimension(n, 15));
        this._seq.setFont(font);
        this._seq.setText(DEFAULT_SEQUENCE);
        this._createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RNA rNA = new RNA(VARNAGUI.generateDefaultName());
                    rNA.setRNA(VARNAGUI.this._seq.getText(), VARNAGUI.this._str.getText());
                    rNA.drawRNARadiate(VARNAGUI.this._vp.getConfig());
                    VARNAGUI.this._rnaList.add(new VARNAConfig(), rNA, true);
                }
                catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                    JOptionPane.showMessageDialog(VARNAGUI.this._vp, exceptionUnmatchedClosingParentheses.getMessage(), "Error", 0);
                }
                catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                    JOptionPane.showMessageDialog(VARNAGUI.this._vp, exceptionFileFormatOrSyntax.getMessage(), "Error", 0);
                }
            }
        });
        this._seqPanel.setLayout(new BorderLayout());
        this._seqPanel.add((Component)this._seqLabel, "West");
        this._seqPanel.add((Component)this._seq, "Center");
        this._strLabel.setPreferredSize(new Dimension(n, 15));
        this._strLabel.setHorizontalTextPosition(2);
        this._str.setFont(font);
        this._strPanel.setLayout(new BorderLayout());
        this._strPanel.add((Component)this._strLabel, "West");
        this._strPanel.add((Component)this._str, "Center");
        this._input.setLayout(new GridLayout(2, 0));
        this._input.add(this._seqPanel);
        this._input.add(this._strPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._tools.setLayout(new BorderLayout());
        this._tools.add((Component)this._input, "Center");
        this._tools.add((Component)this._info, "South");
        this._tools.add((Component)jPanel, "East");
        this._deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VARNAGUI.this._rnaList.removeSelected();
            }
        });
        this._duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VARNAGUI.this._rnaList.add(VARNAGUI.this._vp.getConfig().clone(), VARNAGUI.this._vp.getRNA().clone(), VARNAGUI.this._vp.getRNA().getName() + "-" + DateFormat.getTimeInstance(1).format(new Date()), true);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(this._deleteButton);
        jPanel2.add(this._duplicateButton);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)this._zoomWindow, "South");
        this._zoomWindow.setPreferredSize(new Dimension(-1, 200));
        JLabel jLabel = new JLabel("Structure Manager", 0);
        this._listPanel.setLayout(new BorderLayout());
        this._listPanel.add((Component)jPanel3, "South");
        this._listPanel.add((Component)jLabel, "North");
        this._listPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this._createButton, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        this._horiz.setVisible(false);
        this._horiz.addAdjustmentListener(this);
        this._vert.setVisible(false);
        this._vert.addAdjustmentListener(this);
        jPanel4.add((Component)this._horiz, "South");
        jPanel4.add((Component)this._vert, "East");
        jPanel4.add((Component)this._vp, "Center");
        JSplitPane jSplitPane = new JSplitPane(1, true, this._listPanel, jPanel4);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)this._tools, "North");
        this.setVisible(true);
        DropTarget dropTarget = new DropTarget(this._vp, this);
        this._vp.addRNAListener(new InterfaceVARNARNAListener(){

            @Override
            public void onSequenceModified(int n, String string, String string2) {
            }

            @Override
            public void onStructureModified(Set<ModeleBP> set, Set<ModeleBP> set2, Set<ModeleBP> set3) {
                String string = "";
                for (ModeleBP modeleBP : set2) {
                    string = string + modeleBP;
                }
                string = "";
                for (ModeleBP modeleBP : set3) {
                    string = string + modeleBP;
                }
            }

            @Override
            public void onRNALayoutChanged(Hashtable<Integer, Point2D.Double> hashtable) {
                String string = "";
                for (Integer n : hashtable.keySet()) {
                    string = string + n + " ";
                }
            }
        });
        this._vp.addSelectionListener(new InterfaceVARNASelectionListener(){

            @Override
            public void onHoverChanged(ModeleBase modeleBase, ModeleBase modeleBase2) {
                if (VARNAGUI.this._hoverHighlightSeq != null) {
                    VARNAGUI.this._seq.getHighlighter().removeHighlight(VARNAGUI.this._hoverHighlightSeq);
                    VARNAGUI.this._hoverHighlightSeq = null;
                }
                if (VARNAGUI.this._hoverHighlightStr != null) {
                    VARNAGUI.this._str.getHighlighter().removeHighlight(VARNAGUI.this._hoverHighlightStr);
                    VARNAGUI.this._hoverHighlightStr = null;
                }
                if (modeleBase2 != null) {
                    try {
                        int n = modeleBase2.getIndex();
                        int[] nArray = VARNAGUI.this._vp.getRNA().getStrandShifts();
                        VARNAGUI.this._hoverHighlightSeq = VARNAGUI.this._seq.getHighlighter().addHighlight(n + nArray[n], n + nArray[n] + 1, new DefaultHighlighter.DefaultHighlightPainter(Color.green));
                        VARNAGUI.this._hoverHighlightStr = VARNAGUI.this._str.getHighlighter().addHighlight(n + nArray[n], n + nArray[n] + 1, new DefaultHighlighter.DefaultHighlightPainter(Color.green));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            }

            @Override
            public void onSelectionChanged(BaseList baseList, BaseList baseList2, BaseList baseList3) {
                for (Object iterator : VARNAGUI.this._selectionHighlightSeq) {
                    VARNAGUI.this._seq.getHighlighter().removeHighlight(iterator);
                }
                VARNAGUI.this._selectionHighlightSeq.clear();
                for (Object object : VARNAGUI.this._selectionHighlightStr) {
                    VARNAGUI.this._str.getHighlighter().removeHighlight(object);
                }
                VARNAGUI.this._selectionHighlightStr.clear();
                Object object = VARNAGUI.this._vp.getRNA().getStrandShifts();
                for (ModeleBase modeleBase : baseList.getBases()) {
                    try {
                        int n = modeleBase.getIndex();
                        VARNAGUI.this._selectionHighlightSeq.add(VARNAGUI.this._seq.getHighlighter().addHighlight(n + object[n], n + object[n] + 1, new DefaultHighlighter.DefaultHighlightPainter(Color.orange)));
                        VARNAGUI.this._selectionHighlightStr.add(VARNAGUI.this._str.getHighlighter().addHighlight(n + object[n], n + object[n] + 1, new DefaultHighlighter.DefaultHighlightPainter(Color.orange)));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            }
        });
        this._vp.addVARNAListener(this);
        new Thread(this._zoomWindow).start();
    }

    protected void showRNA(RNA rNA) {
        this._vp.showRNAInterpolated(rNA);
        this._zoomWindow.repaint();
    }

    public void addRNA(RNA rNA, VARNAConfig vARNAConfig) {
        this._rnaList.add(vARNAConfig, rNA);
    }

    public static String generateDefaultName() {
        return "User file #" + _nextID++;
    }

    public RNA getRNA() {
        return (RNA)this._sideList.getSelectedValue();
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"sequenceDBN", "String", "A raw RNA sequence"}, {"structureDBN", "String", "An RNA structure in dot bracket notation (DBN)"}, {errorOpt, "boolean", "To show errors"}};
        return stringArray;
    }

    public void init() {
        this._vp.setBackground(this._backgroundColor);
        this._error = true;
    }

    private Color getSafeColor(String string, Color color) {
        Color color2;
        try {
            color2 = Color.decode(string);
        }
        catch (Exception exception) {
            try {
                color2 = Color.getColor(string, color);
            }
            catch (Exception exception2) {
                return color;
            }
        }
        return color2;
    }

    public VARNAPanel get_varnaPanel() {
        return this._vp;
    }

    public void set_varnaPanel(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
    }

    public JTextField get_seq() {
        return this._seq;
    }

    public void set_seq(JTextField jTextField) {
        this._seq = jTextField;
    }

    public JLabel get_info() {
        return this._info;
    }

    public void set_info(JLabel jLabel) {
        this._info = jLabel;
    }

    public static void main(String[] stringArray) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(Toolkit.getDefaultToolkit().getImage("./VARNA16x16.png"));
        arrayList.add(Toolkit.getDefaultToolkit().getImage("./VARNA32x32.png"));
        arrayList.add(Toolkit.getDefaultToolkit().getImage("./VARNA64x64.png"));
        VARNAGUI vARNAGUI = new VARNAGUI();
        vARNAGUI.setDefaultCloseOperation(3);
        vARNAGUI.pack();
        vARNAGUI.setIconImages(arrayList);
        vARNAGUI.setVisible(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
                dropTargetDropEvent.acceptDrop(3);
                Object object = transferable.getTransferData(dataFlavorArray[i]);
                if (object instanceof List) {
                    List list = (List)object;
                    for (int j = 0; j < list.size(); ++j) {
                        DropTarget dropTarget;
                        Component component;
                        Object e = list.get(j);
                        if (!(dropTargetDropEvent.getSource() instanceof DropTarget) || !((component = (dropTarget = (DropTarget)dropTargetDropEvent.getSource()).getComponent()) instanceof VARNAPanel)) continue;
                        String string = e.toString();
                        VARNAPanel vARNAPanel = (VARNAPanel)component;
                        try {
                            FullBackup fullBackup = VARNAPanel.importSession(string);
                            this._rnaList.add(fullBackup.config, fullBackup.rna, fullBackup.name, true);
                            continue;
                        }
                        catch (ExceptionLoadingFailed exceptionLoadingFailed) {
                            ArrayList<RNA> arrayList = RNAFactory.loadSecStr(string);
                            if (arrayList.isEmpty()) {
                                throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from that source.");
                            }
                            dropTargetDropEvent.dropComplete(true);
                            this._vp.getVARNAUI().UIChooseRNAs(arrayList);
                            return;
                        }
                    }
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void onStructureRedrawn() {
    }

    @Override
    public void onUINewStructure(VARNAConfig vARNAConfig, RNA rNA) {
        this._rnaList.add(vARNAConfig, rNA, rNA.getName(), true);
        this.onZoomLevelChanged();
    }

    @Override
    public void onWarningEmitted(String string) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int n = this._sideList.locationToIndex(mouseEvent.getPoint());
            ListModel listModel = this._sideList.getModel();
            FullBackup fullBackup = (FullBackup)listModel.getElementAt(n);
            this._sideList.ensureIndexIsVisible(n);
            Object object = JOptionPane.showInputDialog(this, "Specify a new name for this RNA", "Rename RNA", 3, null, null, fullBackup.toString());
            if (object != null) {
                fullBackup.name = object.toString();
                this._sideList.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void onZoomLevelChanged() {
        if (this._vp.getZoom() > 1.02) {
            Rectangle rectangle = this._vp.getZoomedInTranslationBox();
            this._horiz.setMinimum(rectangle.x);
            this._horiz.setMaximum(rectangle.x + rectangle.width + this._vp.getWidth());
            this._horiz.getModel().setExtent(this._vp.getWidth());
            this._horiz.getModel().setValue(this._vp.getTranslation().x);
            this._horiz.doLayout();
            this._horiz.setVisible(true);
            this._vert.setMinimum(rectangle.y);
            this._vert.setMaximum(rectangle.y + rectangle.height + this._vp.getHeight());
            this._vert.getModel().setExtent(this._vp.getHeight());
            this._vert.getModel().setValue(this._vp.getTranslation().y);
            this._vert.doLayout();
            this._vert.setVisible(true);
        } else {
            this._horiz.setVisible(false);
            this._vert.setVisible(false);
        }
    }

    @Override
    public void onTranslationChanged() {
        if (this._vp.getZoom() > 1.02) {
            int n = this._horiz.getMaximum() - (this._vp.getTranslation().x - this._horiz.getMinimum()) - this._vp.getWidth();
            int n2 = this._vert.getMaximum() - (this._vp.getTranslation().y - this._vert.getMinimum()) - this._vp.getHeight();
            this._horiz.getModel().setValue(n);
            this._horiz.doLayout();
            this._vert.getModel().setValue(n2);
            this._vert.doLayout();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this._horiz) {
            this._vp.setTranslation(new Point(this._horiz.getMaximum() - (adjustmentEvent.getValue() - this._horiz.getMinimum()) - this._vp.getWidth(), this._vp.getTranslation().y));
            this._vp.repaint();
        } else if (adjustmentEvent.getSource() == this._vert) {
            this._vp.setTranslation(new Point(this._vp.getTranslation().x, this._vert.getMaximum() - (adjustmentEvent.getValue() - this._vert.getMinimum()) - this._vp.getHeight()));
            this._vp.repaint();
        }
    }

    private class BackupHolder {
        private DefaultListModel _rnaList;
        private ArrayList<RNA> _rnas = new ArrayList();
        JList _l;

        public BackupHolder(DefaultListModel defaultListModel, JList jList) {
            this._rnaList = defaultListModel;
            this._l = jList;
        }

        public void add(VARNAConfig vARNAConfig, RNA rNA) {
            this.add(vARNAConfig, rNA, rNA.getName(), false);
        }

        public void add(VARNAConfig vARNAConfig, RNA rNA, boolean bl) {
            this.add(vARNAConfig, rNA, rNA.getName(), bl);
        }

        public void add(VARNAConfig vARNAConfig, RNA rNA, String string) {
            this.add(vARNAConfig, rNA, string, false);
        }

        public void add(VARNAConfig vARNAConfig, RNA rNA, String string, boolean bl) {
            if (!this._rnas.contains(rNA)) {
                if (bl) {
                    this._l.removeSelectionInterval(0, this._rnaList.size());
                }
                if (string.equals("")) {
                    string = VARNAGUI.generateDefaultName();
                }
                FullBackup fullBackup = new FullBackup(vARNAConfig, rNA, string);
                this._rnas.add(0, rNA);
                this._rnaList.add(0, fullBackup);
                this._l.doLayout();
                if (bl) {
                    this._l.setSelectedIndex(0);
                }
            }
        }

        public void remove(int n) {
            this._rnas.remove(n);
            this._rnaList.remove(n);
        }

        public DefaultListModel getModel() {
            return this._rnaList;
        }

        public boolean contains(RNA rNA) {
            return this._rnas.contains(rNA);
        }

        public FullBackup getElementAt(int n) {
            return (FullBackup)this._rnaList.getElementAt(n);
        }

        public void removeSelected() {
            int n = this._l.getSelectedIndex();
            if (n != -1) {
                if (this._rnaList.getSize() == 1) {
                    RNA rNA = new RNA();
                    try {
                        rNA.setRNA(" ", ".");
                    }
                    catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                    }
                    catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                        // empty catch block
                    }
                    VARNAGUI.this.showRNA(rNA);
                } else {
                    int n2 = n + 1;
                    if (n2 == this._rnaList.getSize()) {
                        n2 = this._rnaList.getSize() - 2;
                    }
                    FullBackup fullBackup = (FullBackup)this._rnaList.getElementAt(n2);
                    this._l.setSelectedValue(fullBackup, true);
                }
                this._rnaList.remove(n);
            }
        }
    }
}

