/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AlignmentDemo
extends JFrame {
    private static final long serialVersionUID = -790155708306987257L;
    private static final String DEFAULT_SEQUENCE1 = "CGCGCACGCGA----UAUU----UCGCGUCGCGCAUUUGCGCGUAGCGCG";
    private static final String DEFAULT_STRUCTURE1 = "(((((.(((((----....----))))).(((((....)))))..)))))";
    private static final String DEFAULT_SEQUENCE2 = "CGCGCACGCGSGCGCGUUUGCGCUCGCGU---------------AGCGCG";
    private static final String DEFAULT_STRUCTURE2 = "(((((.(((((((((....))))))))).--------------..)))))";
    private VARNAPanel _vpMaster;
    private JPanel _tools = new JPanel();
    private JPanel _input = new JPanel();
    private JPanel _seq1Panel = new JPanel();
    private JPanel _seq2Panel = new JPanel();
    private JPanel _struct1Panel = new JPanel();
    private JPanel _struct2Panel = new JPanel();
    private JLabel _info = new JLabel();
    private JTextField _struct1 = new JTextField("(((((.(((((----....----))))).(((((....)))))..)))))");
    private JTextField _struct2 = new JTextField("(((((.(((((((((....))))))))).--------------..)))))");
    private JTextField _seq1 = new JTextField("CGCGCACGCGA----UAUU----UCGCGUCGCGCAUUUGCGCGUAGCGCG");
    private JTextField _seq2 = new JTextField("CGCGCACGCGSGCGCGUUUGCGCUCGCGU---------------AGCGCG");
    private JLabel _struct1Label = new JLabel(" Str1:");
    private JLabel _struct2Label = new JLabel(" Str2:");
    private JLabel _seq1Label = new JLabel(" Seq1:");
    private JLabel _seq2Label = new JLabel(" Seq2:");
    private JButton _goButton = new JButton("Go");
    private String _str1Backup = "";
    private String _str2Backup = "";
    private String _seq1Backup = "";
    private String _seq2Backup = "";
    private RNA _RNA = new RNA();
    private static String errorOpt = "error";
    private boolean _error;
    private Color _backgroundColor = Color.white;
    private int _algoCode;

    public AlignmentDemo() {
        this._vpMaster = new VARNAPanel(this.getSeq1(), this.getStruct1(), this.getSeq2(), this.getStruct2(), 2, "");
        this._vpMaster.setPreferredSize(new Dimension(600, 400));
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        int n = 40;
        this.setBackground(this._backgroundColor);
        this._vpMaster.setBackground(this._backgroundColor);
        Font font = Font.decode("MonoSpaced-PLAIN-12");
        this._goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlignmentDemo.this._vpMaster.drawRNA(AlignmentDemo.this.getSeq1(), AlignmentDemo.this.getStruct1(), AlignmentDemo.this.getSeq2(), AlignmentDemo.this.getStruct2(), AlignmentDemo.this._vpMaster.getDrawMode());
                AlignmentDemo.this._vpMaster.repaint();
            }
        });
        this._seq1Label.setHorizontalTextPosition(2);
        this._seq1Label.setPreferredSize(new Dimension(n, 15));
        this._seq1.setFont(font);
        this._seq1Panel.setLayout(new BorderLayout());
        this._seq1Panel.add((Component)this._seq1Label, "West");
        this._seq1Panel.add((Component)this._seq1, "Center");
        this._seq2Label.setHorizontalTextPosition(2);
        this._seq2Label.setPreferredSize(new Dimension(n, 15));
        this._seq2.setFont(font);
        this._seq2Panel.setLayout(new BorderLayout());
        this._seq2Panel.add((Component)this._seq2Label, "West");
        this._seq2Panel.add((Component)this._seq2, "Center");
        this._struct1Label.setPreferredSize(new Dimension(n, 15));
        this._struct1Label.setHorizontalTextPosition(2);
        this._struct1.setFont(font);
        this._struct1Panel.setLayout(new BorderLayout());
        this._struct1Panel.add((Component)this._struct1Label, "West");
        this._struct1Panel.add((Component)this._struct1, "Center");
        this._struct2Label.setPreferredSize(new Dimension(n, 15));
        this._struct2Label.setHorizontalTextPosition(2);
        this._struct2.setFont(font);
        this._struct2Panel.setLayout(new BorderLayout());
        this._struct2Panel.add((Component)this._struct2Label, "West");
        this._struct2Panel.add((Component)this._struct2, "Center");
        this._input.setLayout(new GridLayout(4, 0));
        this._input.add(this._seq1Panel);
        this._input.add(this._struct1Panel);
        this._input.add(this._seq2Panel);
        this._input.add(this._struct2Panel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._tools.setLayout(new BorderLayout());
        this._tools.add((Component)this._input, "Center");
        this._tools.add((Component)this._info, "South");
        this._tools.add((Component)jPanel, "East");
        jPanel.add((Component)this._goButton, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel2.add(this._vpMaster);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)this._tools, "South");
        this.setVisible(true);
        this._vpMaster.getVARNAUI().UIRadiate();
    }

    public RNA getRNA() {
        if (!(this._str1Backup.equals(this.getStruct1()) && this._str2Backup.equals(this.getStruct2()) && this._seq1Backup.equals(this.getSeq1()) && this._seq2Backup.equals(this.getSeq2()))) {
            this._vpMaster.drawRNA(this.getSeq1(), this.getStruct1(), this.getSeq2(), this.getStruct2(), this._vpMaster.getDrawMode());
            this._RNA = this._vpMaster.getRNA();
            this._str1Backup = this.getStruct1();
            this._str2Backup = this.getStruct2();
            this._seq1Backup = this.getSeq1();
            this._seq2Backup = this.getSeq2();
        }
        return this._RNA;
    }

    public String getStruct1() {
        return this.cleanStruct(this._struct1.getText());
    }

    public String getStruct2() {
        return this.cleanStruct(this._struct2.getText());
    }

    public String getSeq1() {
        return this.cleanStruct(this._seq1.getText());
    }

    public String getSeq2() {
        return this.cleanStruct(this._seq2.getText());
    }

    private String cleanStruct(String string) {
        string = string.replaceAll("[:-]", "-");
        return string;
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"sequenceDBN", "String", "A raw RNA sequence"}, {"structureDBN", "String", "An RNA structure in dot bracket notation (DBN)"}, {errorOpt, "boolean", "To show errors"}};
        return stringArray;
    }

    public void init() {
        this._vpMaster.setBackground(this._backgroundColor);
        this._error = true;
    }

    private Color getSafeColor(String string, Color color) {
        Color color2;
        try {
            color2 = Color.decode(string);
        }
        catch (Exception exception) {
            try {
                color2 = Color.getColor(string, color);
            }
            catch (Exception exception2) {
                return color;
            }
        }
        return color2;
    }

    public VARNAPanel get_varnaPanel() {
        return this._vpMaster;
    }

    public void set_varnaPanel(VARNAPanel vARNAPanel) {
        this._vpMaster = vARNAPanel;
    }

    public JTextField get_struct() {
        return this._struct1;
    }

    public void set_struct(JTextField jTextField) {
        this._struct1 = jTextField;
    }

    public JTextField get_seq() {
        return this._seq1;
    }

    public void set_seq(JTextField jTextField) {
        this._seq1 = jTextField;
    }

    public JLabel get_info() {
        return this._info;
    }

    public void set_info(JLabel jLabel) {
        this._info = jLabel;
    }

    public static void main(String[] stringArray) {
        AlignmentDemo alignmentDemo = new AlignmentDemo();
        alignmentDemo.setDefaultCloseOperation(3);
        alignmentDemo.pack();
        alignmentDemo.setVisible(true);
    }

    public void onWarningEmitted(String string) {
    }
}

