/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.Log;
import com.threerings.getdown.cache.GarbageCollector;
import com.threerings.getdown.cache.ResourceCache;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.ClassPath;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;

public class PathBuilder {
    public static final String CODE_CACHE_DIR = ".cache";
    public static final String NATIVE_CACHE_DIR = ".ncache";

    public static ClassPath buildClassPath(Application app) throws IOException {
        return app.useCodeCache() ? PathBuilder.buildCachedClassPath(app) : PathBuilder.buildDefaultClassPath(app);
    }

    public static ClassPath buildDefaultClassPath(Application app) {
        LinkedHashSet<File> classPathEntries = new LinkedHashSet<File>();
        for (Resource resource : app.getActiveCodeResources()) {
            classPathEntries.add(resource.getFinalTarget());
        }
        return new ClassPath(classPathEntries);
    }

    public static ClassPath buildCachedClassPath(Application app) throws IOException {
        File codeCacheDir = new File(app.getAppDir(), CODE_CACHE_DIR);
        long retainMillis = TimeUnit.DAYS.toMillis(app.getCodeCacheRetentionDays());
        if (retainMillis != 0L) {
            GarbageCollector.collect(codeCacheDir, retainMillis);
        }
        ResourceCache cache = new ResourceCache(codeCacheDir);
        LinkedHashSet<File> classPathEntries = new LinkedHashSet<File>();
        for (Resource resource : app.getActiveCodeResources()) {
            String digest = app.getDigest(resource);
            File entry = cache.cacheFile(resource.getFinalTarget(), digest.substring(0, 2), digest);
            classPathEntries.add(entry);
        }
        return new ClassPath(classPathEntries);
    }

    public static ClassPath buildLibsPath(Application app, boolean addCurrentLibraryPath) throws IOException {
        List<Resource> resources = app.getNativeResources();
        if (resources.isEmpty()) {
            return null;
        }
        LinkedHashSet<File> nativedirs = new LinkedHashSet<File>();
        File nativeCacheDir = new File(app.getAppDir(), NATIVE_CACHE_DIR);
        ResourceCache cache = new ResourceCache(nativeCacheDir);
        long retainMillis = TimeUnit.DAYS.toMillis(app.getCodeCacheRetentionDays());
        if (retainMillis != 0L) {
            GarbageCollector.collectNative(nativeCacheDir, retainMillis);
        }
        for (Resource resource : resources) {
            String digest = app.getDigest(resource);
            File cachedFile = cache.cacheFile(resource.getFinalTarget(), digest, digest);
            File cachedParent = cachedFile.getParentFile();
            File unpackedIndicator = new File(cachedParent, cachedFile.getName() + ".unpacked");
            if (!unpackedIndicator.exists()) {
                try {
                    FileUtil.unpackJar(new JarFile(cachedFile), cachedParent, false);
                    unpackedIndicator.createNewFile();
                }
                catch (IOException ioe) {
                    Log.log.warning("Failed to unpack native jar", "file", cachedFile.getAbsolutePath(), ioe);
                }
            }
            nativedirs.add(cachedFile.getParentFile());
        }
        if (addCurrentLibraryPath) {
            for (String path : System.getProperty("java.library.path").split(File.pathSeparator)) {
                nativedirs.add(new File(path));
            }
        }
        return new ClassPath(nativedirs);
    }
}

