/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.server;

import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.streaming.TidyXMLStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class SDDocumentSource {
    public abstract XMLStreamReader read(XMLInputFactory var1) throws IOException, XMLStreamException;

    public abstract XMLStreamReader read() throws IOException, XMLStreamException;

    public abstract URL getSystemId();

    public static SDDocumentSource create(Class<?> clazz, String string) {
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL != null) {
            return SDDocumentSource.create(uRL);
        }
        return SDDocumentSource.create(string, clazz);
    }

    public static SDDocumentSource create(final URL uRL) {
        return new SDDocumentSource(){
            private final URL systemId;
            {
                this.systemId = uRL;
            }

            @Override
            public XMLStreamReader read(XMLInputFactory xMLInputFactory) throws IOException, XMLStreamException {
                InputStream inputStream = uRL.openStream();
                return new TidyXMLStreamReader(xMLInputFactory.createXMLStreamReader(this.systemId.toExternalForm(), inputStream), inputStream);
            }

            @Override
            public XMLStreamReader read() throws IOException, XMLStreamException {
                InputStream inputStream = uRL.openStream();
                return new TidyXMLStreamReader(XMLStreamReaderFactory.create(this.systemId.toExternalForm(), inputStream, false), inputStream);
            }

            @Override
            public URL getSystemId() {
                return this.systemId;
            }
        };
    }

    private static SDDocumentSource create(final String string, final Class<?> clazz) {
        return new SDDocumentSource(){

            @Override
            public XMLStreamReader read(XMLInputFactory xMLInputFactory) throws IOException, XMLStreamException {
                InputStream inputStream = this.inputStream();
                return new TidyXMLStreamReader(xMLInputFactory.createXMLStreamReader(string, inputStream), inputStream);
            }

            @Override
            public XMLStreamReader read() throws IOException, XMLStreamException {
                InputStream inputStream = this.inputStream();
                return new TidyXMLStreamReader(XMLStreamReaderFactory.create(string, inputStream, false), inputStream);
            }

            @Override
            public URL getSystemId() {
                try {
                    return new URL("file://" + string);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }

            private InputStream inputStream() throws IOException {
                Module module = clazz.getModule();
                InputStream inputStream = module.getResourceAsStream(string);
                if (inputStream != null) {
                    return inputStream;
                }
                throw new ServerRtException("cannot.load.wsdl", string);
            }
        };
    }

    public static SDDocumentSource create(final URL uRL, final XMLStreamBuffer xMLStreamBuffer) {
        return new SDDocumentSource(){

            @Override
            public XMLStreamReader read(XMLInputFactory xMLInputFactory) throws XMLStreamException {
                return xMLStreamBuffer.readAsXMLStreamReader();
            }

            @Override
            public XMLStreamReader read() throws XMLStreamException {
                return xMLStreamBuffer.readAsXMLStreamReader();
            }

            @Override
            public URL getSystemId() {
                return uRL;
            }
        };
    }
}

