/*
 * Decompiled with CFR 0.152.
 */
package jalview.javascript.web;

import jalview.javascript.json.JSON;
import jalview.util.Platform;
import java.net.URL;
import java.util.Map;

public class ClientResponse {
    private String response;
    private boolean isJSON;
    private Object jsonData;
    int responseCode = -1;

    public ClientResponse(URL url, String[] encoding) {
        this.response = Platform.getFileAsString(url.toString());
        this.responseCode = this.response == null || this.response == "" ? 404 : 200;
        this.isJSON = encoding[0].equals("application/json");
        if (this.isJSON) {
            try {
                this.jsonData = JSON.parse(this.response);
            }
            catch (Exception e) {
                this.jsonData = null;
            }
            if (this.jsonData == null) {
                this.responseCode = 400;
            }
        }
    }

    public Object getEntity(Class<?> c) {
        if (c == Map.class) {
            return this.jsonData;
        }
        return this.response;
    }

    public int getStatus() {
        return this.responseCode;
    }

    public Object getJSONData() {
        return this.jsonData;
    }
}

