/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignSeq;
import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.PaintRefresher;
import jalview.jbgui.GSliderPanel;
import jalview.util.MessageManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class RedundancyPanel
extends GSliderPanel
implements Runnable {
    AlignFrame af;
    AlignmentPanel ap;
    Stack<CommandI> historyList = new Stack();
    float[] redundancy;
    SequenceI[] originalSequences;
    JInternalFrame frame;
    Vector redundantSeqs;

    public RedundancyPanel(final AlignmentPanel ap, AlignFrame af) {
        this.ap = ap;
        this.af = af;
        this.redundantSeqs = new Vector();
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RedundancyPanel.this.valueField.setText("" + RedundancyPanel.this.slider.getValue());
                RedundancyPanel.this.sliderValueChanged();
            }
        });
        this.applyButton.setText(MessageManager.getString("action.remove"));
        this.allGroupsCheck.setVisible(false);
        this.slider.setMinimum(0);
        this.slider.setMaximum(100);
        this.slider.setValue(100);
        Thread worker = new Thread(this);
        worker.start();
        this.frame = new JInternalFrame();
        this.frame.setFrameIcon(null);
        this.frame.setContentPane(this);
        Desktop.addInternalFrame(this.frame, MessageManager.getString("label.redundancy_threshold_selection"), true, 420, 120, false, true);
        this.frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                ap.getIdPanel().getIdCanvas().setHighlighted(null);
            }
        });
    }

    @Override
    public void run() {
        int end;
        int start;
        JProgressBar progress = new JProgressBar();
        progress.setIndeterminate(true);
        this.southPanel.add((Component)progress, "South");
        this.label.setText(MessageManager.getString("label.calculating"));
        this.slider.setVisible(false);
        this.applyButton.setEnabled(false);
        this.valueField.setVisible(false);
        this.validate();
        String[] omitHidden = null;
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null && sg.getSize() >= 1) {
            this.originalSequences = sg.getSequencesInOrder(this.ap.av.getAlignment());
            start = sg.getStartRes();
            end = sg.getEndRes();
        } else {
            this.originalSequences = this.ap.av.getAlignment().getSequencesArray();
            start = 0;
            end = this.ap.av.getAlignment().getWidth();
        }
        int height = this.originalSequences.length;
        if (this.ap.av.hasHiddenColumns()) {
            omitHidden = this.ap.av.getViewAsString(sg != null);
        }
        this.redundancy = AlignSeq.computeRedundancyMatrix(this.originalSequences, omitHidden, start, end, false);
        progress.setIndeterminate(false);
        progress.setVisible(false);
        progress = null;
        this.label.setText(MessageManager.getString("label.enter_redundancy_threshold"));
        this.slider.setVisible(true);
        this.applyButton.setEnabled(true);
        this.valueField.setVisible(true);
        this.validate();
        this.sliderValueChanged();
    }

    void sliderValueChanged() {
        if (this.redundancy == null) {
            return;
        }
        float value = this.slider.getValue();
        ArrayList<SequenceI> redundantSequences = new ArrayList<SequenceI>();
        for (int i = 0; i < this.redundancy.length; ++i) {
            if (!(value <= this.redundancy[i])) continue;
            redundantSequences.add(this.originalSequences[i]);
        }
        this.ap.getIdPanel().getIdCanvas().setHighlighted(redundantSequences);
    }

    @Override
    public void applyButton_actionPerformed(ActionEvent e) {
        ArrayList<SequenceI> del = new ArrayList<SequenceI>();
        this.undoButton.setEnabled(true);
        float value = this.slider.getValue();
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        for (int i = 0; i < this.redundancy.length; ++i) {
            if (!(value <= this.redundancy[i])) continue;
            del.add(this.originalSequences[i]);
        }
        if (del.size() > 0) {
            SequenceI[] deleted = new SequenceI[del.size()];
            int width = 0;
            for (int i = 0; i < del.size(); ++i) {
                deleted[i] = (SequenceI)del.get(i);
                if (deleted[i].getLength() <= width) continue;
                width = deleted[i].getLength();
            }
            EditCommand cut = new EditCommand(MessageManager.getString("action.remove_redundancy"), EditCommand.Action.CUT, deleted, 0, width, this.ap.av.getAlignment());
            for (int i = 0; i < del.size(); ++i) {
                this.ap.av.getAlignment().deleteSequence(deleted[i]);
                if (sg == null) continue;
                sg.deleteSequence(deleted[i], false);
            }
            this.historyList.push(cut);
            this.ap.alignFrame.addHistoryItem(cut);
            PaintRefresher.Refresh(this, this.ap.av.getSequenceSetId(), true, true);
            this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
        }
    }

    @Override
    public void undoButton_actionPerformed(ActionEvent e) {
        if (this.historyList == null || this.historyList.isEmpty()) {
            this.undoButton.setEnabled(false);
            return;
        }
        CommandI command = this.historyList.pop();
        if (this.ap.av.getHistoryList().contains(command)) {
            command.undoCommand(this.af.getViewAlignments());
            this.ap.av.getHistoryList().remove(command);
            this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
            this.af.updateEditMenuBar();
        }
        this.ap.paintAlignment(true, true);
        if (this.historyList.size() == 0) {
            this.undoButton.setEnabled(false);
        }
    }
}

