/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.AlignViewportI;
import jalview.api.analysis.ScoreModelI;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.gui.ImageExporter;
import jalview.gui.JalviewColourChooser;
import jalview.gui.OOMWarning;
import jalview.gui.PaintRefresher;
import jalview.gui.PairwiseAlignPanel;
import jalview.gui.ProgressBar;
import jalview.gui.RotatableCanvas;
import jalview.jbgui.GPaSiMapPanel;
import jalview.math.RotatableMatrix;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import jalview.viewmodel.PaSiMapModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class PaSiMapPanel
extends GPaSiMapPanel
implements Runnable,
IProgressIndicator {
    private static final int MIN_WIDTH = 470;
    private static final int MIN_HEIGHT = 250;
    private static final int MAX_PASIMAP_SEQ = 20000;
    private final int GAP_OPEN_COST = 100;
    private final int GAP_EXTEND_COST = 5;
    private RotatableCanvas rc;
    AlignmentPanel ap;
    AlignmentViewport av;
    private PaSiMapModel pasimapModel;
    private int top = 0;
    private IProgressIndicator progressBar;
    private long progId;
    private boolean working;
    private String newPasimapTitle;

    public PaSiMapPanel(AlignmentPanel alignPanel, String modelName) {
        super(8);
        this.av = alignPanel.av;
        this.ap = alignPanel;
        boolean nucleotide = this.av.getAlignment().isNucleotide();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                PaSiMapPanel.this.close_actionPerformed();
            }
        });
        boolean selected = this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSize() > 0;
        SequenceI[] seqs = !selected ? this.av.getAlignment().getSequencesArray() : this.av.getSelectionGroup().getSequencesInOrder(this.av.getAlignment());
        ScoreModelI scoreModel = ScoreModels.getInstance().getScoreModel(modelName, this.ap);
        this.setPasimapModel(new PaSiMapModel(this.av, seqs, nucleotide, scoreModel));
        this.newPasimapTitle = alignPanel.alignFrame.formCalculationTitle(MessageManager.formatMessage("label.calc_title", "PaSiMap", scoreModel.getName()), selected, this.ap.alignFrame.getTitle());
        PaintRefresher.Register(this, this.av.getSequenceSetId());
        this.setRotatableCanvas(new RotatableCanvas(alignPanel));
        this.getContentPane().add((Component)this.getRotatableCanvas(), "Center");
        this.addKeyListener(this.getRotatableCanvas());
        this.validate();
    }

    protected void close_actionPerformed() {
        this.setPasimapModel(null);
        if (this.rc != null) {
            this.rc.sequencePoints = null;
            this.rc.setAxisEndPoints(null);
            this.rc = null;
        }
    }

    @Override
    protected void bgcolour_actionPerformed() {
        String ttl = MessageManager.getString("label.select_background_colour");
        JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

            @Override
            public void colourSelected(Color c) {
                PaSiMapPanel.this.rc.setBgColour(c);
                PaSiMapPanel.this.rc.repaint();
            }
        };
        JalviewColourChooser.showColourChooser(this, ttl, this.rc.getBgColour(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.working = true;
        this.progId = System.currentTimeMillis();
        this.progressBar = new ProgressBar(this.statusPanel, this.statusBar);
        String message = MessageManager.getString("label.pasimap_recalculating");
        if (this.getParent() == null) {
            this.progressBar = this.ap.alignFrame;
            message = MessageManager.getString("label.pasimap_calculating");
        }
        this.progressBar.setProgressBar(message, this.progId);
        try {
            SequenceGroup selGroup = this.av.getSelectionGroup();
            if (selGroup == null) {
                selGroup = new SequenceGroup(this.av.getAlignment().getSequences());
                selGroup.setStartRes(0);
                selGroup.setEndRes(this.av.getAlignment().getWidth() - 1);
            }
            if (selGroup.getSize() > 20000) {
                int start = selGroup.getStartRes();
                int end = selGroup.getEndRes();
                selGroup = new SequenceGroup(selGroup.getSequences().subList(0, 20000));
                selGroup.setStartRes(start);
                selGroup.setEndRes(end);
                Console.warn("Truncated input sequences for PASIMAP analysis to 20000");
            }
            PairwiseAlignPanel pap = new PairwiseAlignPanel(this.av, selGroup, true, 100, 5, false, null);
            pap.setDiscardAlignments(true);
            pap.setQuiet(true);
            System.out.println(pap != null);
            this.addProgressListenerFor(pap);
            this.progressBar.registerHandler(this.progId, new IProgressIndicatorHandler(){

                @Override
                public boolean cancelActivity(long id) {
                    PaSiMapPanel.this.getPasimapModel().cancel();
                    return true;
                }

                @Override
                public boolean canCancel() {
                    return PaSiMapPanel.this.getPasimapModel().canCancel();
                }
            });
            this.getPasimapModel().calculate(pap);
            if (!this.getPasimapModel().isCancelled()) {
                this.outputAlignment.setVisible(!pap.isDiscardAlignments() && !pap.isQuiet());
                this.xCombobox.setSelectedIndex(0);
                this.yCombobox.setSelectedIndex(1);
                this.zCombobox.setSelectedIndex(2);
                this.getPasimapModel().updateRc(this.getRotatableCanvas());
                this.setTop(this.getPasimapModel().getTop());
            }
        }
        catch (OutOfMemoryError er) {
            new OOMWarning("calculating PaSiMap", er);
            this.working = false;
            return;
        }
        finally {
            if (!this.getPasimapModel().isCancelled()) {
                this.progressBar.setProgressBar("", this.progId);
            }
        }
        this.repaint();
        if (!this.getPasimapModel().isCancelled() && this.getParent() == null) {
            Desktop.addInternalFrame(this, this.newPasimapTitle, 475, 450);
            this.setMinimumSize(new Dimension(470, 250));
        }
        this.working = false;
    }

    @Override
    protected void doDimensionChange() {
        if (this.getTop() == 0) {
            return;
        }
        int dim1 = this.getTop() - this.xCombobox.getSelectedIndex();
        int dim2 = this.getTop() - this.yCombobox.getSelectedIndex();
        int dim3 = this.getTop() - this.zCombobox.getSelectedIndex();
        this.getPasimapModel().updateRcView(dim1, dim2, dim3);
        this.getRotatableCanvas().resetView();
    }

    public void setSelectedDimensionIndex(int index, RotatableMatrix.Axis axis) {
        switch (axis) {
            case X: {
                this.xCombobox.setSelectedIndex(index);
                break;
            }
            case Y: {
                this.yCombobox.setSelectedIndex(index);
                break;
            }
            case Z: {
                this.zCombobox.setSelectedIndex(index);
                break;
            }
        }
    }

    @Override
    protected void outputValues_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            cap.setText(this.getPasimapModel().getDetails());
            Desktop.addInternalFrame(cap, MessageManager.getString("label.pasimap_details"), 500, 500);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("opening PaSiMap details", oom);
            cap.dispose();
        }
    }

    @Override
    protected void showLabels_actionPerformed() {
        this.getRotatableCanvas().showLabels(this.showLabels.getState());
    }

    @Override
    protected void print_actionPerformed() {
        PaSiMapPrinter printer = new PaSiMapPrinter();
        printer.start();
    }

    @Override
    public void originalSeqData_actionPerformed() {
        if (this.getPasimapModel().getInputData() == null) {
            Console.info("Unexpected call to originalSeqData_actionPerformed - should have hidden this menu action.");
            return;
        }
        char gc = '-';
        try {
            gc = this.av.getGapCharacter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] alAndColsel = this.getPasimapModel().getInputData().getAlignmentView(false).getAlignmentAndHiddenColumns(gc);
        if (alAndColsel != null && alAndColsel[0] != null) {
            AlignmentI dataset;
            Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
            AlignmentI alignmentI = dataset = this.av != null && this.av.getAlignment() != null ? this.av.getAlignment().getDataset() : null;
            if (dataset != null) {
                al.setDataset(dataset);
            }
            AlignFrame af = new AlignFrame((AlignmentI)al, (HiddenColumns)alAndColsel[1], 700, 500);
            Desktop.addInternalFrame(af, MessageManager.formatMessage("label.original_data_for_params", new String[]{this.title}), 700, 500);
        }
    }

    public void makePaSiMapImage(ImageMaker.TYPE type) throws Exception {
        int width = this.getRotatableCanvas().getWidth();
        int height = this.getRotatableCanvas().getHeight();
        ImageExporter.ImageWriterI writer = new ImageExporter.ImageWriterI(){

            @Override
            public void exportImage(Graphics g) throws Exception {
                RotatableCanvas canvas = PaSiMapPanel.this.getRotatableCanvas();
                canvas.drawBackground(g);
                canvas.drawScene(g);
                if (canvas.drawAxes) {
                    canvas.drawAxes(g);
                }
            }
        };
        String pasimap = MessageManager.getString("label.pasimap");
        ImageExporter exporter = new ImageExporter(writer, null, type, pasimap);
        exporter.doExport(null, this, width, height, pasimap);
    }

    @Override
    protected void viewMenu_menuSelected() {
        this.buildAssociatedViewMenu();
    }

    void buildAssociatedViewMenu() {
        AlignmentPanel[] aps = PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        if (aps.length == 1 && this.getRotatableCanvas().av == aps[0].av) {
            this.associateViewsMenu.setVisible(false);
            return;
        }
        this.associateViewsMenu.setVisible(true);
        if (this.viewMenu.getItem(this.viewMenu.getItemCount() - 2) instanceof JMenuItem) {
            this.viewMenu.insertSeparator(this.viewMenu.getItemCount() - 1);
        }
        this.associateViewsMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final AlignmentPanel panel : aps) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(panel.av.getViewName(), panel.av == this.getRotatableCanvas().av);
            buttonGroup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PaSiMapPanel.this.selectAssociatedView(panel);
                }
            });
            this.associateViewsMenu.add(item);
        }
        final JRadioButtonMenuItem itemf = new JRadioButtonMenuItem("All Views");
        buttonGroup.add(itemf);
        itemf.setSelected(this.getRotatableCanvas().isApplyToAllViews());
        itemf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaSiMapPanel.this.getRotatableCanvas().setApplyToAllViews(itemf.isSelected());
            }
        });
        this.associateViewsMenu.add(itemf);
    }

    @Override
    protected void outputPoints_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            cap.setText(this.getPasimapModel().getPointsasCsv(false, this.xCombobox.getSelectedIndex(), this.yCombobox.getSelectedIndex(), this.zCombobox.getSelectedIndex()));
            Desktop.addInternalFrame(cap, MessageManager.formatMessage("label.points_for_params", new String[]{this.getTitle()}), 500, 500);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("exporting PaSiMap points", oom);
            cap.dispose();
        }
    }

    @Override
    protected void outputProjPoints_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            cap.setText(this.getPasimapModel().getPointsasCsv(true, this.xCombobox.getSelectedIndex(), this.yCombobox.getSelectedIndex(), this.zCombobox.getSelectedIndex()));
            Desktop.addInternalFrame(cap, MessageManager.formatMessage("label.transformed_points_for_params", new String[]{this.getTitle()}), 500, 500);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("exporting transformed PaSiMap points", oom);
            cap.dispose();
        }
    }

    @Override
    protected void outputAlignment_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            cap.setText(this.getPasimapModel().getAlignmentOutput());
            Desktop.addInternalFrame(cap, MessageManager.formatMessage("label.pairwise_alignment_for_params", new String[]{this.getTitle()}), 500, 500);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("exporting pairwise alignments", oom);
            cap.dispose();
        }
    }

    @Override
    public void setProgressBar(String message, long id) {
        this.progressBar.setProgressBar(message, id);
    }

    @Override
    public String getMessage(long id) {
        return this.progressBar.getMessage(id);
    }

    @Override
    public void setProgressBarMessage(long id, String message) {
        this.progressBar.setProgressBarMessage(id, message);
    }

    public void updateProgressBar(int lengthOfTask, int progress) {
        JProgressBar pBar = this.progressBar.getProgressBar(this.progId);
        if (pBar == null) {
            return;
        }
        if (pBar.isIndeterminate()) {
            pBar.setMaximum(lengthOfTask);
            pBar.setValue(0);
            pBar.setIndeterminate(false);
        }
        if (progress < -1 || lengthOfTask <= 0) {
            pBar.setIndeterminate(true);
            pBar.repaint();
            return;
        }
        this.updateProgressBar(progress);
    }

    public void updateProgressBarWithEta(int progress, double minutes) {
        JProgressBar pBar = this.progressBar.getProgressBar(this.progId);
        if (pBar == null) {
            return;
        }
        int max = pBar.getMaximum();
        this.updateProgressBarEta(minutes);
        pBar.setMaximum(max);
        pBar.setValue(progress);
    }

    public void updateProgressBarEta(double minutes) {
        JProgressBar pBar = this.progressBar.getProgressBar(this.progId);
        if (pBar == null) {
            return;
        }
        this.progressBar.setProgressBarMessage(this.progId, this.progressBar.getMessage(this.progId) + " (" + (String)(Double.isNaN(minutes) ? " .. working ..)" : (minutes < 1.0 ? "Less than a minute)" : (int)Math.ceil(minutes) + " mins. to go)")));
    }

    public void updateProgressBar(int progress) {
        JProgressBar pBar = this.progressBar.getProgressBar(this.progId);
        if (pBar == null) {
            return;
        }
        pBar.setValue(progress);
        pBar.repaint();
    }

    public void addProgressListenerFor(Container pap) {
        pap.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pcEvent) {
                if ("progress".equals(pcEvent.getPropertyName())) {
                    PaSiMapPanel.this.updateProgressBar((Integer)pcEvent.getNewValue());
                } else if ("total".equals(pcEvent.getPropertyName())) {
                    PaSiMapPanel.this.updateProgressBar((Integer)pcEvent.getNewValue(), 0);
                } else if ("eta_in_minutes".equals(pcEvent.getPropertyName())) {
                    PaSiMapPanel.this.updateProgressBarEta((Double)pcEvent.getNewValue());
                } else if ("message_in_progress".equals(pcEvent.getPropertyName())) {
                    PaSiMapPanel.this.setProgressBarMessage(PaSiMapPanel.this.progId, (String)pcEvent.getNewValue());
                } else if ("finished_stop_progress".equals(pcEvent.getPropertyName())) {
                    PaSiMapPanel.this.setProgressBarMessage(PaSiMapPanel.this.progId, (String)pcEvent.getNewValue());
                }
            }
        });
    }

    @Override
    public void registerHandler(long id, IProgressIndicatorHandler handler) {
        this.progressBar.registerHandler(id, handler);
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBar.operationInProgress();
    }

    @Override
    protected void resetButton_actionPerformed() {
        int t = this.getTop();
        this.setTop(0);
        this.xCombobox.setSelectedIndex(0);
        this.yCombobox.setSelectedIndex(1);
        this.setTop(t);
        this.zCombobox.setSelectedIndex(2);
    }

    public boolean isWorking() {
        return this.working;
    }

    public int getSelectedDimensionIndex(RotatableMatrix.Axis axis) {
        switch (axis) {
            case X: {
                return this.xCombobox.getSelectedIndex();
            }
            case Y: {
                return this.yCombobox.getSelectedIndex();
            }
        }
        return this.zCombobox.getSelectedIndex();
    }

    public void setShowLabels(boolean show) {
        this.showLabels.setSelected(show);
    }

    public void setInputData(AlignmentViewport data) {
        this.getPasimapModel().setInputData(data);
        this.originalSeqData.setVisible(data != null);
    }

    public AlignViewportI getAlignViewport() {
        return this.av;
    }

    public PaSiMapModel getPasimapModel() {
        return this.pasimapModel;
    }

    public void setPasimapModel(PaSiMapModel pasimapModel) {
        this.pasimapModel = pasimapModel;
    }

    public RotatableCanvas getRotatableCanvas() {
        return this.rc;
    }

    public void setRotatableCanvas(RotatableCanvas rc) {
        this.rc = rc;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void selectAssociatedView(AlignmentPanel panel) {
        this.getRotatableCanvas().setApplyToAllViews(false);
        this.ap = panel;
        this.av = panel.av;
        this.getRotatableCanvas().av = panel.av;
        this.getRotatableCanvas().ap = panel;
        PaintRefresher.Register(this, panel.av.getSequenceSetId());
    }

    @Override
    public JProgressBar getProgressBar(long id) {
        return this.progressBar.getProgressBar(id);
    }

    class PaSiMapPrinter
    extends Thread
    implements Printable {
        PaSiMapPrinter() {
        }

        @Override
        public void run() {
            PageFormat pf;
            PrinterJob printJob = PrinterJob.getPrinterJob();
            PageFormat defaultPage = printJob.defaultPage();
            if (defaultPage == (pf = printJob.pageDialog(defaultPage))) {
                return;
            }
            printJob.setPrintable(this, pf);
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (Exception PrintException) {
                    PrintException.printStackTrace();
                }
            }
        }

        @Override
        public int print(Graphics pg, PageFormat pf, int pi) throws PrinterException {
            pg.translate((int)pf.getImageableX(), (int)pf.getImageableY());
            PaSiMapPanel.this.getRotatableCanvas().drawBackground(pg);
            PaSiMapPanel.this.getRotatableCanvas().drawScene(pg);
            if (PaSiMapPanel.this.getRotatableCanvas().drawAxes) {
                PaSiMapPanel.this.getRotatableCanvas().drawAxes(pg);
            }
            if (pi == 0) {
                return 0;
            }
            return 1;
        }
    }
}

