/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.bin.Console;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.datamodel.StructureViewerModel;
import jalview.ext.jmol.JmolCommands;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmolBinding;
import jalview.gui.Desktop;
import jalview.gui.ImageExporter;
import jalview.gui.OOMWarning;
import jalview.gui.StructureViewer;
import jalview.gui.StructureViewerBase;
import jalview.io.exceptions.ImageOutputException;
import jalview.structure.StructureCommand;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.BrowserLauncher;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.util.imagemaker.BitmapImageSizing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class AppJmol
extends StructureViewerBase {
    private static final int JMOL_LOAD_TIMEOUT = 20000;
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    AppJmolBinding jmb;
    JPanel scriptWindow;
    JSplitPane splitPane;
    RenderPanel renderPanel;

    public AppJmol(StructureViewerModel viewerModel, AlignmentPanel ap, String sessionFile, String viewid) {
        Map<File, StructureViewerModel.StructureData> pdbData = viewerModel.getFileData();
        PDBEntry[] pdbentrys = new PDBEntry[pdbData.size()];
        SequenceI[][] seqs = new SequenceI[pdbData.size()][];
        int i = 0;
        for (StructureViewerModel.StructureData data : pdbData.values()) {
            PDBEntry pdbentry;
            pdbentrys[i] = pdbentry = new PDBEntry(data.getPdbId(), null, PDBEntry.Type.PDB, data.getFilePath());
            List<SequenceI> sequencesForPdb = data.getSeqList();
            seqs[i] = sequencesForPdb.toArray(new SequenceI[sequencesForPdb.size()]);
            ++i;
        }
        this.jmb = new AppJmolBinding(this, ap.getStructureSelectionManager(), pdbentrys, seqs, null);
        this.jmb.setLoadingFromArchive(true);
        this.addAlignmentPanel(ap);
        if (viewerModel.isAlignWithPanel()) {
            this.useAlignmentPanelForSuperposition(ap);
        }
        this.initMenus();
        boolean useToColour = viewerModel.isColourWithAlignPanel();
        boolean leaveColouringToJmol = viewerModel.isColourByViewer();
        if (leaveColouringToJmol || !useToColour) {
            this.jmb.setColourBySequence(false);
            this.seqColour.setSelected(false);
            this.viewerColour.setSelected(true);
        } else if (useToColour) {
            this.useAlignmentPanelForColourbyseq(ap);
            this.jmb.setColourBySequence(true);
            this.seqColour.setSelected(true);
            this.viewerColour.setSelected(false);
        }
        this.setBounds(viewerModel.getX(), viewerModel.getY(), viewerModel.getWidth(), viewerModel.getHeight());
        this.setViewId(viewid);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                AppJmol.this.closeViewer(false);
            }
        });
        StringBuilder cmd = new StringBuilder();
        cmd.append(this.jmb.getCommandGenerator().loadFile(sessionFile));
        this.initJmol(cmd.toString());
    }

    @Override
    protected void initMenus() {
        super.initMenus();
        this.viewerColour.setText(MessageManager.getString("label.colour_with_jmol"));
        this.viewerColour.setToolTipText(MessageManager.getString("label.let_jmol_manage_structure_colours"));
    }

    public AppJmol(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap) {
        this.setProgressIndicator(ap.alignFrame);
        this.openNewJmol(ap, this.alignAddedStructures, new PDBEntry[]{pdbentry}, new SequenceI[][]{seq});
    }

    private void openNewJmol(AlignmentPanel ap, boolean alignAdded, PDBEntry[] pdbentrys, SequenceI[][] seqs) {
        this.setProgressIndicator(ap.alignFrame);
        this.jmb = new AppJmolBinding(this, ap.getStructureSelectionManager(), pdbentrys, seqs, null);
        this.addAlignmentPanel(ap);
        this.useAlignmentPanelForColourbyseq(ap);
        this.alignAddedStructures = alignAdded;
        if (pdbentrys.length > 1) {
            this.useAlignmentPanelForSuperposition(ap);
        }
        this.jmb.setColourBySequence(true);
        this.setSize(400, 400);
        this.initMenus();
        this.addingStructures = false;
        this.worker = new Thread(this);
        this.worker.start();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                AppJmol.this.closeViewer(false);
            }
        });
    }

    public AppJmol(AlignmentPanel ap, boolean alignAdded, PDBEntry[] pe, SequenceI[][] seqs) {
        this.openNewJmol(ap, alignAdded, pe, seqs);
    }

    void initJmol(String command) {
        this.jmb.setFinishedInit(false);
        this.renderPanel = new RenderPanel();
        this.getContentPane().add((Component)this.renderPanel, "Center");
        Desktop.addInternalFrame(this, this.jmb.getViewerTitle(), this.getBounds().width, this.getBounds().height);
        if (this.scriptWindow == null) {
            BorderLayout bl = new BorderLayout();
            bl.setHgap(0);
            bl.setVgap(0);
            this.scriptWindow = new JPanel(bl);
            this.scriptWindow.setVisible(false);
        }
        this.jmb.allocateViewer(this.renderPanel, true, "", null, null, "", this.scriptWindow, null);
        if (command == null) {
            command = "";
        }
        this.jmb.executeCommand(new StructureCommand(command, new String[0]), false);
        this.jmb.executeCommand(new StructureCommand("set hoverDelay=0.1", new String[0]), false);
        this.jmb.executeCommand(new StructureCommand("set antialiasdisplay on", new String[0]), false);
        this.jmb.setFinishedInit(true);
    }

    @Override
    public void run() {
        this._started = true;
        try {
            List<String> files = this.jmb.fetchPdbFiles(this);
            if (files.size() > 0) {
                this.showFilesInViewer(files);
            }
        }
        catch (Throwable t) {
            Console.warn("Unexpected exception ", t);
        }
        finally {
            this._started = false;
            this.worker = null;
        }
    }

    void showFilesInViewer(List<String> files) {
        long lastnotify = this.jmb.getLoadNotifiesHandled();
        StringBuilder fileList = new StringBuilder();
        for (String s : files) {
            fileList.append(SPACE).append(QUOTE).append(JmolCommands.escapeQuotedFilename(s)).append(QUOTE);
        }
        String filesString = fileList.toString();
        if (!this.addingStructures) {
            try {
                this.initJmol("load FILES " + filesString);
            }
            catch (OutOfMemoryError oomerror) {
                new OOMWarning("When trying to open the Jmol viewer!", oomerror);
                Console.debug("File locations are " + filesString);
            }
            catch (Exception ex) {
                Console.error("Couldn't open Jmol viewer!", ex);
                ex.printStackTrace();
                return;
            }
        } else {
            StringBuilder cmd = new StringBuilder();
            cmd.append("loadingJalviewdata=true\nload APPEND ");
            cmd.append(filesString);
            cmd.append("\nloadingJalviewdata=null");
            StructureCommand command = new StructureCommand(cmd.toString(), new String[0]);
            lastnotify = this.jmb.getLoadNotifiesHandled();
            try {
                this.jmb.executeCommand(command, false);
            }
            catch (OutOfMemoryError oomerror) {
                new OOMWarning("When trying to add structures to the Jmol viewer!", oomerror);
                Console.debug("File locations are " + filesString);
                return;
            }
            catch (Exception ex) {
                Console.error("Couldn't add files to Jmol viewer!", ex);
                ex.printStackTrace();
                return;
            }
        }
        int waitMax = 20000;
        int waitFor = 35;
        int waitTotal = 0;
        while (this.addingStructures ? lastnotify >= this.jmb.getLoadNotifiesHandled() : !this.jmb.isFinishedInit() || this.jmb.getStructureFiles() == null || this.jmb.getStructureFiles().length != files.size()) {
            try {
                Console.debug("Waiting around for jmb notify.");
                waitTotal += waitFor;
                Thread.sleep(waitFor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (waitTotal <= waitMax) continue;
            Console.errPrintln("Timed out waiting for Jmol to load files after " + waitTotal + "ms");
            this.jmb.getStructureFiles();
            break;
        }
        for (AlignmentViewPanel ap : this._colourwith) {
            this.jmb.updateColours(ap);
        }
        if (this.alignAddedStructures) {
            this.alignAddedStructures();
        }
        this.addingStructures = false;
    }

    void alignAddedStructures() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AppJmol.this.jmb.jmolViewer.isScriptExecuting()) {
                    Thread timer = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(5L);
                                SwingUtilities.invokeLater(this);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    });
                    timer.start();
                    return;
                }
                Thread aligner = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AppJmol.this.alignStructsWithAllAlignPanels();
                    }
                });
                aligner.start();
            }
        });
    }

    public boolean isRepainting() {
        if (this.renderPanel != null && this.renderPanel.isVisible()) {
            return this.renderPanel.repainting;
        }
        return false;
    }

    @Override
    public void makePDBImage(final ImageMaker.TYPE type) {
        Runnable exporter = new Runnable(){

            @Override
            public void run() {
                while (!AppJmol.this.isRepainting()) {
                    try {
                        Thread.sleep(2L);
                    }
                    catch (Exception exception) {}
                }
                try {
                    AppJmol.this.makePDBImage(null, type, null, BitmapImageSizing.defaultBitmapImageSizing());
                }
                catch (ImageOutputException ioex) {
                    Console.error("Unexpected error whilst writing " + type.toString(), ioex);
                }
            }
        };
        Executors.newCachedThreadPool().execute(exporter);
    }

    public void makePDBImage(final File file, final ImageMaker.TYPE type, final String renderer, final BitmapImageSizing userBis) throws ImageOutputException {
        final int width = this.getWidth();
        final int height = this.getHeight();
        BitmapImageSizing bis = ImageMaker.getScaleWidthHeight(width, height, userBis);
        final float usescale = bis.scale();
        final int usewidth = bis.width();
        final int useheight = bis.height();
        ImageExporter.ImageWriterI writer = new ImageExporter.ImageWriterI(){

            @Override
            public void exportImage(Graphics g) throws Exception {
                Graphics2D ig2 = (Graphics2D)g;
                ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (type == ImageMaker.TYPE.PNG && usescale > 0.0f && usescale > 0.0f) {
                    ig2.scale(1.0f / usescale, 1.0f / usescale);
                }
                AppJmol.this.jmb.jmolViewer.requestRepaintAndWait("image export");
                AppJmol.this.jmb.jmolViewer.renderScreenImage((Object)ig2, usewidth, useheight);
            }
        };
        final String view = MessageManager.getString("action.view").toLowerCase(Locale.ROOT);
        final ImageExporter exporter = new ImageExporter(writer, this.getProgressIndicator(), type, this.getTitle());
        final Throwable[] exceptions = new Throwable[]{null};
        final AppJmol us = this;
        try {
            Thread runner = Executors.defaultThreadFactory().newThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        exporter.doExport(file, us, width, height, view, renderer, userBis);
                    }
                    catch (Throwable t) {
                        exceptions[0] = t;
                    }
                }
            });
            runner.start();
            long time = 0L;
            do {
                Thread.sleep(25L);
            } while (runner.isAlive() && time++ < 4000L);
            if (time >= 4000L) {
                runner.interrupt();
                throw new ImageOutputException("Jmol took too long to export. Waited for 100 seconds.");
            }
        }
        catch (Throwable e) {
            throw new ImageOutputException("Unexpected error when generating image", e);
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof ImageOutputException) {
                throw (ImageOutputException)exceptions[0];
            }
            throw new ImageOutputException("Unexpected error when generating image", exceptions[0]);
        }
    }

    @Override
    public void showHelp_actionPerformed() {
        try {
            BrowserLauncher.openURL("http://wiki.jmol.org");
        }
        catch (Exception ex) {
            Console.errPrintln("Show Jmol help failed with: " + ex.getMessage());
        }
    }

    @Override
    public void showConsole(boolean showConsole) {
        if (showConsole) {
            if (this.splitPane == null) {
                this.splitPane = new JSplitPane(0);
                this.splitPane.setTopComponent(this.renderPanel);
                this.splitPane.setBottomComponent(this.scriptWindow);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.splitPane.setDividerLocation(this.getHeight() - 200);
                this.scriptWindow.setVisible(true);
                this.scriptWindow.validate();
                this.splitPane.validate();
            }
        } else {
            if (this.splitPane != null) {
                this.splitPane.setVisible(false);
            }
            this.splitPane = null;
            this.getContentPane().add((Component)this.renderPanel, "Center");
        }
        this.validate();
    }

    @Override
    public AAStructureBindingModel getBinding() {
        return this.jmb;
    }

    @Override
    public StructureViewer.ViewerType getViewerType() {
        return StructureViewer.ViewerType.JMOL;
    }

    @Override
    protected String getViewerName() {
        return "Jmol";
    }

    class RenderPanel
    extends JPanel {
        final Dimension currentSize = new Dimension();
        volatile boolean repainting = false;

        RenderPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            this.getSize(this.currentSize);
            if (AppJmol.this.jmb != null && AppJmol.this.jmb.hasFileLoadingError()) {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.currentSize.width, this.currentSize.height);
                g.setColor(Color.white);
                g.setFont(new Font("Verdana", 1, 14));
                g.drawString(MessageManager.getString("label.error_loading_file") + "...", 20, this.currentSize.height / 2);
                StringBuffer sb = new StringBuffer();
                int lines = 0;
                for (int e = 0; e < AppJmol.this.jmb.getPdbCount(); ++e) {
                    sb.append(AppJmol.this.jmb.getPdbEntry(e).getId());
                    if (e < AppJmol.this.jmb.getPdbCount() - 1) {
                        sb.append(",");
                    }
                    if (e != AppJmol.this.jmb.getPdbCount() - 1 && sb.length() <= 20) continue;
                    g.drawString(sb.toString(), 20, this.currentSize.height / 2 - ++lines * g.getFontMetrics().getHeight());
                }
            } else if (AppJmol.this.jmb == null || AppJmol.this.jmb.jmolViewer == null || !AppJmol.this.jmb.isFinishedInit()) {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.currentSize.width, this.currentSize.height);
                g.setColor(Color.white);
                g.setFont(new Font("Verdana", 1, 14));
                g.drawString(MessageManager.getString("label.retrieving_pdb_data"), 20, this.currentSize.height / 2);
            } else {
                this.repainting = true;
                AppJmolBinding appJmolBinding = AppJmol.this.jmb;
                synchronized (appJmolBinding) {
                    AppJmol.this.jmb.jmolViewer.renderScreenImage((Object)g, this.currentSize.width, this.currentSize.height);
                }
                this.repainting = false;
            }
        }
    }
}

