/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.Conservation;
import jalview.appletgui.AlignmentPanel;
import jalview.bin.JalviewLite;
import jalview.datamodel.SequenceGroup;
import jalview.renderer.ResidueShaderI;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;

public class SliderPanel
extends Panel
implements ActionListener,
AdjustmentListener,
MouseListener {
    private static final String BACKGROUND = "Background";
    AlignmentPanel ap;
    boolean forConservation = true;
    ResidueShaderI cs;
    static Frame conservationSlider;
    static Frame PIDSlider;
    protected Scrollbar slider = new Scrollbar();
    protected TextField valueField = new TextField();
    protected Label label = new Label();
    Panel jPanel1 = new Panel();
    Panel jPanel2 = new Panel();
    protected Button applyButton = new Button();
    protected Button undoButton = new Button();
    FlowLayout flowLayout1 = new FlowLayout();
    protected Checkbox allGroupsCheck = new Checkbox();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout2 = new FlowLayout();

    public static int setConservationSlider(AlignmentPanel ap, ResidueShaderI ccs, String source) {
        SliderPanel sp = null;
        if (conservationSlider == null) {
            sp = new SliderPanel(ap, ccs.getConservationInc(), true, ccs);
            conservationSlider = new Frame();
            conservationSlider.add(sp);
        } else {
            sp = (SliderPanel)conservationSlider.getComponent(0);
            sp.cs = ccs;
            sp.valueField.setText(String.valueOf(ccs.getConservationInc()));
        }
        conservationSlider.setTitle(MessageManager.formatMessage("label.conservation_colour_increment", new String[]{source == null ? BACKGROUND : source}));
        List<SequenceGroup> groups = ap.av.getAlignment().getGroups();
        if (groups != null && !groups.isEmpty()) {
            sp.setAllGroupsCheckEnabled(true);
        } else {
            sp.setAllGroupsCheckEnabled(false);
        }
        return sp.getValue();
    }

    public static void showConservationSlider() {
        try {
            PIDSlider.setVisible(false);
            PIDSlider = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!conservationSlider.isVisible()) {
            JalviewLite.addFrame(conservationSlider, conservationSlider.getTitle(), 420, 100);
            conservationSlider.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    conservationSlider = null;
                }
            });
        }
    }

    public static int setPIDSliderSource(AlignmentPanel ap, ResidueShaderI ccs, String source) {
        SliderPanel pid = null;
        if (PIDSlider == null) {
            pid = new SliderPanel(ap, ccs.getThreshold(), false, ccs);
            PIDSlider = new Frame();
            PIDSlider.add(pid);
        } else {
            pid = (SliderPanel)PIDSlider.getComponent(0);
            pid.cs = ccs;
            pid.valueField.setText(String.valueOf(ccs.getThreshold()));
        }
        PIDSlider.setTitle(MessageManager.formatMessage("label.percentage_identity_threshold", new String[]{source == null ? BACKGROUND : source}));
        if (ap.av.getAlignment().getGroups() != null) {
            pid.setAllGroupsCheckEnabled(true);
        } else {
            pid.setAllGroupsCheckEnabled(false);
        }
        return pid.getValue();
    }

    public static void showPIDSlider() {
        try {
            conservationSlider.setVisible(false);
            conservationSlider = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!PIDSlider.isVisible()) {
            JalviewLite.addFrame(PIDSlider, PIDSlider.getTitle(), 420, 100);
            PIDSlider.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PIDSlider = null;
                }
            });
        }
    }

    public static void hidePIDSlider() {
        if (PIDSlider != null) {
            PIDSlider.setVisible(false);
            PIDSlider = null;
        }
    }

    public static void hideConservationSlider() {
        if (conservationSlider != null) {
            conservationSlider.setVisible(false);
            conservationSlider = null;
        }
    }

    public SliderPanel(AlignmentPanel ap, int value, boolean forConserve, ResidueShaderI shader) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ap = ap;
        this.cs = shader;
        this.forConservation = forConserve;
        this.undoButton.setVisible(false);
        this.applyButton.setVisible(false);
        if (this.forConservation) {
            this.label.setText(MessageManager.getString("label.modify_conservation_visibility"));
            this.slider.setMinimum(0);
            this.slider.setMaximum(50 + this.slider.getVisibleAmount());
            this.slider.setUnitIncrement(1);
        } else {
            this.label.setText(MessageManager.getString("label.colour_residues_above_occurrence"));
            this.slider.setMinimum(0);
            this.slider.setMaximum(100 + this.slider.getVisibleAmount());
            this.slider.setBlockIncrement(1);
        }
        this.slider.addAdjustmentListener(this);
        this.slider.addMouseListener(this);
        this.slider.setValue(value);
        this.valueField.setText("" + value);
    }

    public void valueChanged(int i) {
        if (this.cs == null) {
            return;
        }
        if (this.forConservation) {
            this.cs.setConservationApplied(true);
            this.cs.setConservationInc(i);
        } else {
            this.cs.setThreshold(i, this.ap.av.isIgnoreGapsConsensus());
        }
        if (this.allGroupsCheck.getState()) {
            for (SequenceGroup group : this.ap.av.getAlignment().getGroups()) {
                ResidueShaderI groupColourScheme = group.getGroupColourScheme();
                if (this.forConservation) {
                    if (!groupColourScheme.conservationApplied()) {
                        Conservation c = new Conservation("Group", group.getSequences(null), group.getStartRes(), group.getEndRes());
                        c.calculate();
                        c.verdict(false, this.ap.av.getConsPercGaps());
                        group.cs.setConservation(c);
                    }
                    groupColourScheme.setConservationApplied(true);
                    groupColourScheme.setConservationInc(i);
                    continue;
                }
                groupColourScheme.setThreshold(i, this.ap.av.isIgnoreGapsConsensus());
            }
        }
        this.ap.seqPanel.seqCanvas.repaint();
    }

    public void setAllGroupsCheckEnabled(boolean b) {
        this.allGroupsCheck.setState(this.ap.av.getColourAppliesToAllGroups());
        this.allGroupsCheck.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.applyButton) {
            this.applyButton_actionPerformed();
        } else if (evt.getSource() == this.undoButton) {
            this.undoButton_actionPerformed();
        } else if (evt.getSource() == this.valueField) {
            this.valueField_actionPerformed();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.valueField.setText("" + this.slider.getValue());
        this.valueChanged(this.slider.getValue());
    }

    public void valueField_actionPerformed() {
        try {
            int i = Integer.valueOf(this.valueField.getText());
            this.slider.setValue(i);
        }
        catch (NumberFormatException ex) {
            this.valueField.setText(String.valueOf(this.slider.getValue()));
        }
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public int getValue() {
        return Integer.parseInt(this.valueField.getText());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.slider.setBackground(Color.white);
        this.slider.setFont(new Font("Verdana", 0, 11));
        this.slider.setOrientation(0);
        this.valueField.setFont(new Font("Verdana", 0, 11));
        this.valueField.setText("   ");
        this.valueField.addActionListener(this);
        this.valueField.setColumns(3);
        this.valueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SliderPanel.this.valueField_actionPerformed();
                SliderPanel.this.valueChanged(SliderPanel.this.slider.getValue());
            }
        });
        this.label.setFont(new Font("Verdana", 0, 11));
        this.label.setText(MessageManager.getString("label.set_this_label_text"));
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.flowLayout1);
        this.applyButton.setFont(new Font("Verdana", 0, 11));
        this.applyButton.setLabel(MessageManager.getString("action.apply"));
        this.applyButton.addActionListener(this);
        this.undoButton.setEnabled(false);
        this.undoButton.setFont(new Font("Verdana", 0, 11));
        this.undoButton.setLabel(MessageManager.getString("action.undo"));
        this.undoButton.addActionListener(this);
        this.allGroupsCheck.setEnabled(false);
        this.allGroupsCheck.setFont(new Font("Verdana", 0, 11));
        this.allGroupsCheck.setLabel(MessageManager.getString("action.apply_threshold_all_groups"));
        this.allGroupsCheck.setName(MessageManager.getString("action.apply_all_groups"));
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.jPanel2.add((Component)this.label, null);
        this.jPanel2.add((Component)this.applyButton, null);
        this.jPanel2.add((Component)this.undoButton, null);
        this.jPanel2.add(this.allGroupsCheck);
        this.jPanel1.add((Component)this.valueField, "East");
        this.jPanel1.add((Component)this.slider, "Center");
        this.add((Component)this.jPanel1, "South");
        this.add((Component)this.jPanel2, "Center");
    }

    protected void applyButton_actionPerformed() {
    }

    protected void undoButton_actionPerformed() {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.ap.paintAlignment(true, true);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }
}

