/*
 * Decompiled with CFR 0.152.
 */
package intervalstore.impl;

import intervalstore.api.IntervalI;
import intervalstore.impl.BinarySearcher;
import intervalstore.impl.NCNode;
import intervalstore.impl.Range;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class NCList<T extends IntervalI>
extends AbstractCollection<T> {
    private int size;
    private List<NCNode<T>> subranges = new ArrayList<NCNode<T>>();

    public NCList(List<T> ranges) {
        this();
        this.build(ranges);
    }

    protected void build(List<T> ranges) {
        List<IntervalI> sublists = this.partitionNestedSublists(ranges);
        for (IntervalI sublist : sublists) {
            this.subranges.add(new NCNode<List<T>>(ranges.subList(sublist.getBegin(), sublist.getEnd() + 1)));
        }
        this.size = ranges.size();
    }

    public NCList() {
    }

    protected List<IntervalI> partitionNestedSublists(List<T> ranges) {
        ArrayList<IntervalI> sublists = new ArrayList<IntervalI>();
        if (ranges.isEmpty()) {
            return sublists;
        }
        Collections.sort(ranges, IntervalI.COMPARE_BEGIN_ASC_END_DESC);
        int listStartIndex = 0;
        IntervalI lastParent = (IntervalI)ranges.get(0);
        boolean first = true;
        int i = 0;
        while (i < ranges.size()) {
            IntervalI nextInterval = (IntervalI)ranges.get(i);
            if (!first && !lastParent.properlyContainsInterval(nextInterval)) {
                sublists.add(new Range(listStartIndex, i - 1));
                listStartIndex = i;
                lastParent = nextInterval;
            }
            first = false;
            ++i;
        }
        sublists.add(new Range(listStartIndex, ranges.size() - 1));
        return sublists;
    }

    @Override
    public synchronized boolean add(T entry) {
        NCNode<T> newNode = new NCNode<T>(entry);
        this.addNode(newNode);
        return true;
    }

    protected void addNode(NCNode<T> newNode) {
        long start = newNode.getBegin();
        long end = newNode.getEnd();
        this.size += newNode.size();
        int candidateIndex = this.findFirstOverlap(start);
        boolean enclosing = false;
        int firstEnclosed = 0;
        int lastEnclosed = 0;
        int j = candidateIndex;
        while (j < this.subranges.size()) {
            NCNode<T> subrange = this.subranges.get(j);
            if (subrange.equalsInterval(newNode)) {
                this.subranges.add(j, newNode);
                return;
            }
            if (end < (long)subrange.getBegin() && !enclosing) {
                this.subranges.add(j, newNode);
                return;
            }
            if (subrange.properlyContainsInterval(newNode)) {
                subrange.addNode(newNode);
                return;
            }
            if (start <= (long)subrange.getBegin()) {
                if (end >= (long)subrange.getEnd()) {
                    if (!enclosing) {
                        firstEnclosed = j;
                    }
                    lastEnclosed = j;
                    enclosing = true;
                } else {
                    if (enclosing) {
                        this.push(newNode, firstEnclosed, lastEnclosed);
                    } else {
                        this.subranges.add(j, newNode);
                    }
                    return;
                }
            }
            ++j;
        }
        if (enclosing) {
            this.push(newNode, firstEnclosed, lastEnclosed);
        } else {
            this.subranges.add(newNode);
        }
    }

    @Override
    public boolean contains(Object entry) {
        if (!(entry instanceof IntervalI)) {
            return false;
        }
        IntervalI interval = (IntervalI)entry;
        int candidateIndex = this.findFirstOverlap(interval.getBegin());
        int to = interval.getEnd();
        int i = candidateIndex;
        while (i < this.subranges.size()) {
            NCNode<T> candidate = this.subranges.get(i);
            if (candidate.getBegin() > to) break;
            if (candidate.contains(interval)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected synchronized void push(NCNode<T> node, int i, int j) {
        int k = i;
        while (k <= j) {
            NCNode<T> n = this.subranges.get(k);
            if (!node.containsInterval(n)) {
                throw new IllegalArgumentException("Can't push " + n.toString() + " inside " + node.toString());
            }
            node.addNode(n);
            ++k;
        }
        k = j;
        while (k >= i) {
            this.subranges.remove(k);
            --k;
        }
        this.subranges.add(i, node);
    }

    public List<T> findOverlaps(long from, long to) {
        ArrayList result = new ArrayList();
        this.findOverlaps(from, to, result);
        return result;
    }

    protected void findOverlaps(long from, long to, List<T> result) {
        int candidateIndex;
        int i = candidateIndex = this.findFirstOverlap(from);
        while (i < this.subranges.size()) {
            NCNode<T> candidate = this.subranges.get(i);
            if ((long)candidate.getBegin() > to) break;
            candidate.findOverlaps(from, to, result);
            ++i;
        }
    }

    protected int findFirstOverlap(long from) {
        return BinarySearcher.findFirst(this.subranges, false, BinarySearcher.Compare.GE, (int)from);
    }

    @Override
    public String toString() {
        return this.subranges.toString();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder(512);
        int offset = 0;
        int indent = 2;
        this.prettyPrint(sb, offset, indent);
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    void prettyPrint(StringBuilder sb, int offset, int indent) {
        boolean first = true;
        for (NCNode<T> subrange : this.subranges) {
            if (!first) {
                sb.append(System.lineSeparator());
            }
            first = false;
            subrange.prettyPrint(sb, offset, indent);
        }
    }

    public boolean isValid() {
        int count = 0;
        for (NCNode<T> subrange : this.subranges) {
            count += subrange.size();
        }
        if (count != this.size) {
            return false;
        }
        return this.isValid(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    boolean isValid(int start, int end) {
        NCNode<T> lastRange = null;
        for (NCNode<T> subrange : this.subranges) {
            if (subrange.getBegin() < start) {
                System.err.println("error in NCList: range " + subrange.toString() + " starts before " + end);
                return false;
            }
            if (subrange.getEnd() > end) {
                System.err.println("error in NCList: range " + subrange.toString() + " ends after " + end);
                return false;
            }
            if (lastRange != null) {
                if (subrange.getBegin() < lastRange.getBegin()) {
                    System.err.println("error in NCList: range " + subrange.toString() + " starts before " + lastRange.toString());
                    return false;
                }
                if (subrange.properlyContainsInterval(lastRange)) {
                    System.err.println("error in NCList: range " + subrange.toString() + " encloses preceding: " + lastRange.toString());
                    return false;
                }
                if (lastRange.properlyContainsInterval(subrange)) {
                    System.err.println("error in NCList: range " + subrange.toString() + " enclosed by preceding: " + lastRange.toString());
                    return false;
                }
            }
            lastRange = subrange;
            if (subrange.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    public List<T> getEntries() {
        ArrayList result = new ArrayList();
        this.getEntries(result);
        return result;
    }

    void getEntries(List<T> result) {
        for (NCNode<T> subrange : this.subranges) {
            subrange.getEntries(result);
        }
    }

    @Override
    public synchronized boolean remove(T entry) {
        if (entry == null) {
            return false;
        }
        int i = this.findFirstOverlap(entry.getBegin());
        while (i < this.subranges.size()) {
            NCNode<T> subrange = this.subranges.get(i);
            if (subrange.getBegin() > entry.getBegin()) {
                return false;
            }
            NCList<T> subRegions = subrange.getSubRegions();
            if (subrange.getRegion().equals(entry)) {
                this.subranges.remove(i);
                this.size -= subrange.size();
                if (subRegions != null) {
                    for (NCNode<T> r : subRegions.subranges) {
                        this.addNode(r);
                    }
                }
                return true;
            }
            if (subrange.remove(entry)) {
                --this.size;
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getDepth() {
        int subDepth = 0;
        for (NCNode<T> subrange : this.subranges) {
            subDepth = Math.max(subDepth, subrange.getDepth());
        }
        return subDepth;
    }

    @Override
    public Iterator<T> iterator() {
        return new NCListIterator();
    }

    @Override
    public synchronized void clear() {
        this.subranges.clear();
        this.size = 0;
    }

    private class NCListIterator
    implements Iterator<T> {
        int subrangeIndex = this.nextSubrange(-1);
        Iterator<T> nodeIterator;

        NCListIterator() {
        }

        private int nextSubrange(int after) {
            int nextIndex = after + 1;
            if (nextIndex < NCList.this.subranges.size()) {
                this.nodeIterator = ((NCNode)NCList.this.subranges.get(nextIndex)).iterator();
                return nextIndex;
            }
            this.nodeIterator = null;
            return -1;
        }

        @Override
        public boolean hasNext() {
            return this.nodeIterator != null && this.nodeIterator.hasNext();
        }

        @Override
        public T next() {
            if (this.nodeIterator == null || !this.nodeIterator.hasNext()) {
                throw new NoSuchElementException();
            }
            IntervalI result = (IntervalI)this.nodeIterator.next();
            if (!this.nodeIterator.hasNext()) {
                this.subrangeIndex = this.nextSubrange(this.subrangeIndex);
            }
            return result;
        }
    }
}

