/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class StreamUtil {
    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                Log.log.warning("Error closing input stream", "stream", in, "cause", ioe);
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                Log.log.warning("Error closing output stream", "stream", out, "cause", ioe);
            }
        }
    }

    public static void close(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                Log.log.warning("Error closing reader", "reader", in, "cause", ioe);
            }
        }
    }

    public static void close(Writer out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                Log.log.warning("Error closing writer", "writer", out, "cause", ioe);
            }
        }
    }

    public static <T extends OutputStream> T copy(InputStream in, T out) throws IOException {
        byte[] buffer = new byte[4096];
        int read = 0;
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        return out;
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        return StreamUtil.copy(stream, new ByteArrayOutputStream()).toByteArray();
    }
}

