/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.Base64;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class ConnectionUtil {
    public static URLConnection open(Proxy proxy, URL url, int connectTimeout, int readTimeout) throws IOException {
        String userInfo;
        int rtimeout;
        int ctimeout;
        URLConnection conn = url.openConnection(proxy);
        int n = ctimeout = connectTimeout > 0 ? connectTimeout : SysProps.connectTimeout();
        if (ctimeout > 0) {
            conn.setConnectTimeout(ctimeout * 1000);
        }
        int n2 = rtimeout = readTimeout > 0 ? readTimeout : SysProps.readTimeout();
        if (rtimeout > 0) {
            conn.setReadTimeout(rtimeout * 1000);
        }
        if ((userInfo = url.getUserInfo()) != null) {
            userInfo = URLDecoder.decode(userInfo, "UTF-8");
            String encoded = Base64.encodeToString(userInfo.getBytes(StandardCharsets.UTF_8), 0).replaceAll("\\n", "").replaceAll("\\r", "");
            conn.setRequestProperty("Authorization", "Basic " + encoded);
        }
        return conn;
    }

    public static HttpURLConnection openHttp(Proxy proxy, URL url, int connectTimeout, int readTimeout) throws IOException {
        return (HttpURLConnection)ConnectionUtil.open(proxy, url, connectTimeout, readTimeout);
    }
}

