/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.exceptions.ExceptionXmlLoading;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.templates.Benchmark;
import fr.orsay.lri.varna.models.templates.DrawRNATemplateCurveMethod;
import fr.orsay.lri.varna.models.templates.DrawRNATemplateMethod;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateDrawingAlgorithmException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BatchBenchmark {
    private VARNAConfig conf = new VARNAConfig();

    public static RNA loadRNA(File file) throws ExceptionFileFormatOrSyntax, ExceptionUnmatchedClosingParentheses, FileNotFoundException, ExceptionExportFailed, ExceptionPermissionDenied, ExceptionLoadingFailed {
        ArrayList<RNA> arrayList = RNAFactory.loadSecStr(file.getPath());
        if (arrayList.isEmpty()) {
            throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from that source.");
        }
        return (RNA)arrayList.iterator().next();
    }

    public void benchmarkRNA(File file, File file2, BufferedWriter bufferedWriter) throws ExceptionXmlLoading, RNATemplateDrawingAlgorithmException, ExceptionFileFormatOrSyntax, ExceptionUnmatchedClosingParentheses, ExceptionExportFailed, ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionNAViewAlgorithm, IOException {
        RNATemplate rNATemplate = RNATemplate.fromXMLFile(file);
        RNA rNA = BatchBenchmark.loadRNA(file2);
        block11: for (int i = 0; i <= 100; ++i) {
            String string = "";
            switch (i) {
                case 2: {
                    rNA.drawRNARadiate(this.conf);
                    string = "Radiate";
                    break;
                }
                case 3: {
                    rNA.drawRNANAView(this.conf);
                    string = "NAView";
                    break;
                }
                case 10: {
                    string = "Template/noadj";
                    rNA.drawRNATemplate(rNATemplate, this.conf, DrawRNATemplateMethod.NOADJUST, DrawRNATemplateCurveMethod.EXACTLY_AS_IN_TEMPLATE);
                    break;
                }
                case 11: {
                    string = "Template/noadj/ellipses";
                    rNA.drawRNATemplate(rNATemplate, this.conf, DrawRNATemplateMethod.NOADJUST, DrawRNATemplateCurveMethod.ALWAYS_REPLACE_BY_ELLIPSES);
                    break;
                }
                case 12: {
                    string = "Template/noadj/smart";
                    rNA.drawRNATemplate(rNATemplate, this.conf, DrawRNATemplateMethod.NOADJUST, DrawRNATemplateCurveMethod.SMART);
                    break;
                }
                case 6: {
                    string = "Template/mininter";
                    rNA.drawRNATemplate(rNATemplate, this.conf, DrawRNATemplateMethod.NOINTERSECT, DrawRNATemplateCurveMethod.EXACTLY_AS_IN_TEMPLATE);
                    break;
                }
                case 30: {
                    string = "Template/translate";
                    rNA.drawRNATemplate(rNATemplate, this.conf, DrawRNATemplateMethod.HELIXTRANSLATE, DrawRNATemplateCurveMethod.EXACTLY_AS_IN_TEMPLATE);
                    break;
                }
                case 31: {
                    string = "Template/translate/ellipses";
                    rNA.drawRNATemplate(rNATemplate, this.conf, DrawRNATemplateMethod.HELIXTRANSLATE, DrawRNATemplateCurveMethod.ALWAYS_REPLACE_BY_ELLIPSES);
                    break;
                }
                case 32: {
                    string = "Template/translate/smart";
                    rNA.drawRNATemplate(rNATemplate, this.conf, DrawRNATemplateMethod.HELIXTRANSLATE, DrawRNATemplateCurveMethod.SMART);
                    break;
                }
                default: {
                    continue block11;
                }
            }
            Benchmark benchmark = new Benchmark(rNA);
            bufferedWriter.write(BatchBenchmark.removeExt(file2.getName()) + "\t" + string + "\t" + benchmark.backboneCrossings + "\t" + benchmark.averageUnpairedDistance / benchmark.targetConsecutiveBaseDistance * 100.0 + "\t" + benchmark.tooNearConsecutiveBases + "\t" + benchmark.tooFarConsecutiveBases + "\n");
        }
    }

    public void runBenchmark(List<File> list, List<File> list2, File file) throws Exception {
        if (list.size() != list2.size()) {
            throw new Error("templates and rnas list size differ");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write("RNA\tAlgorithm\tBackbone crossings\tAverage unpaired distance %\tToo near\tToo far\n");
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("Benchmarking for RNA " + BatchBenchmark.removeExt(list2.get(i).getName()));
            this.benchmarkRNA(list.get(i), list2.get(i), bufferedWriter);
        }
        bufferedWriter.close();
        System.out.println("******* Benchmark finished. *******");
    }

    public void runExamples() throws Exception {
        File file = new File("templates");
        File file2 = new File(file, "examples");
        File file3 = new File(new File(file, "benchmark"), "benchmark.txt");
        String[] stringArray = new String[]{"RNase P E Coli.ct", "RNase P Synechocystis-PCC6803.ct", "RNase P M Musculus.ct"};
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (String string : stringArray) {
            arrayList.add(new File(file2, "RNase P E Coli.xml"));
            arrayList2.add(new File(file2, string));
        }
        this.runBenchmark(arrayList, arrayList2, file3);
    }

    public static void readFASTA(File file, List<String> list, List<String> list2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.length() != 0) {
                if (string.charAt(0) == '>') {
                    String string2 = string.substring(1);
                    list.add(string2);
                    list2.add("");
                } else {
                    list2.set(list2.size() - 1, list2.get(list2.size() - 1) + string);
                }
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public void benchmarkAllDir(File file) throws Exception {
        File file2 = new File(file, "sequences");
        File file3 = new File(file, "template.xml");
        Object[] objectArray = file2.listFiles();
        Arrays.sort(objectArray);
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (Object object : objectArray) {
            if (!((File)object).getPath().endsWith(".dbn")) continue;
            arrayList2.add((File)object);
            arrayList.add(file3);
        }
        File file4 = new File(file, "benchmark.txt");
        this.runBenchmark(arrayList, arrayList2, file4);
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File("templates");
        if (stringArray.length < 1) {
            System.out.println("Command-line argument required: RNA");
            System.out.println("Example: RNaseP_bact_a");
            System.exit(1);
        }
        for (String string : stringArray) {
            new BatchBenchmark().benchmarkAllDir(new File(file, string));
        }
    }

    public static String removeExt(String string) {
        return string.substring(0, string.lastIndexOf(46));
    }

    public static File removeExt(File file) {
        return new File(BatchBenchmark.removeExt(file.getPath()));
    }
}

