/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.ArcCommand;
import fr.orsay.lri.varna.models.export.CircleCommand;
import fr.orsay.lri.varna.models.export.ColorCommand;
import fr.orsay.lri.varna.models.export.FillCircleCommand;
import fr.orsay.lri.varna.models.export.FillPolygonCommand;
import fr.orsay.lri.varna.models.export.FontCommand;
import fr.orsay.lri.varna.models.export.GraphicElement;
import fr.orsay.lri.varna.models.export.LineCommand;
import fr.orsay.lri.varna.models.export.PolygonCommand;
import fr.orsay.lri.varna.models.export.RectangleCommand;
import fr.orsay.lri.varna.models.export.TextCommand;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public abstract class SecStrDrawingProducer {
    public static final int FONT_TIMES_ROMAN = 0;
    public static final int FONT_TIMES_BOLD = 1;
    public static final int FONT_TIMES_ITALIC = 2;
    public static final int FONT_TIMES_BOLD_ITALIC = 3;
    public static final int FONT_HELVETICA = 16;
    public static final int FONT_HELVETICA_OBLIQUE = 17;
    public static final int FONT_HELVETICA_BOLD = 18;
    public static final int FONT_HELVETICA_BOLD_OBLIQUE = 19;
    public static final int FONT_COURIER = 12;
    public static final int FONT_COURIER_BOLD = 13;
    public static final int FONT_COURIER_OBLIQUE = 14;
    public static final int FONT_COURIER_BOLD_OBLIQUE = 15;
    private Vector<GraphicElement> _commands = new Vector();
    private double _scale = 1.0;
    private double _xmin = Double.MAX_VALUE;
    private double _ymin = Double.MAX_VALUE;
    private double _xmax = -1.7976931348623157E308;
    private double _ymax = -1.7976931348623157E308;
    protected Color _curColor = Color.black;
    protected Color _backgroundColor = null;
    protected double _fontsize = 10.0;
    protected int _font = 18;

    public Color getCurrentColor() {
        return this._curColor;
    }

    public double getCurFontSize() {
        return this._fontsize;
    }

    public int getCurrentFont() {
        return this._font;
    }

    public abstract String drawLineS(Point2D.Double var1, Point2D.Double var2, double var3);

    public abstract String drawArcS(Point2D.Double var1, double var2, double var4, double var6, double var8);

    public abstract String drawTextS(Point2D.Double var1, String var2);

    public abstract String drawRectangleS(Point2D.Double var1, Point2D.Double var2, double var3);

    public abstract String drawCircleS(Point2D.Double var1, double var2, double var4);

    public abstract String fillCircleS(Point2D.Double var1, double var2, double var4, Color var6);

    public abstract String drawPolygonS(Point2D.Double[] var1, double var2);

    public abstract String fillPolygonS(Point2D.Double[] var1, Color var2);

    public abstract String setFontS(int var1, double var2);

    public String setColorS(Color color) {
        this._curColor = color;
        return "";
    }

    public abstract String headerS(Rectangle2D.Double var1);

    public abstract String footerS();

    private void resetBoundingBox() {
        this._xmin = Double.MAX_VALUE;
        this._ymin = Double.MAX_VALUE;
        this._xmax = -1.7976931348623157E308;
        this._ymax = -1.7976931348623157E308;
    }

    private void updateBoundingBox(double d, double d2) {
        this._xmin = Math.min(this._xmin, d - 10.0);
        this._ymin = Math.min(this._ymin, d2 - 10.0);
        this._xmax = Math.max(this._xmax, d + 10.0);
        this._ymax = Math.max(this._ymax, d2 + 10.0);
    }

    public void drawLine(double d, double d2, double d3, double d4, double d5) {
        this.updateBoundingBox(d, d2);
        this.updateBoundingBox(d3, d4);
        this._commands.add(new LineCommand(new Point2D.Double(d, d2), new Point2D.Double(d3, d4), d5));
    }

    public void drawArc(Point2D.Double double_, double d, double d2, double d3, double d4) {
        this.updateBoundingBox(double_.x + d, double_.y + d2 / 2.0);
        this._commands.add(new ArcCommand(double_, d, d2, d3, d4));
    }

    public void drawText(double d, double d2, String string) {
        this.updateBoundingBox(d, d2);
        this._commands.add(new TextCommand(new Point2D.Double(d, d2), new String(string)));
    }

    public void drawRectangle(double d, double d2, double d3, double d4, double d5) {
        this.updateBoundingBox(d, d2);
        this.updateBoundingBox(d + d3, d2 + d4);
        this._commands.add(new RectangleCommand(new Point2D.Double(d, d2), new Point2D.Double(d3, d4), d5));
    }

    public void fillRectangle(double d, double d2, double d3, double d4, Color color) {
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        dArray[0] = d;
        dArray[1] = d + d3;
        dArray[2] = d + d3;
        dArray[3] = d;
        dArray2[0] = d2;
        dArray2[1] = d2;
        dArray2[2] = d2 + d4;
        dArray2[3] = d2 + d4;
        this.fillPolygon(dArray, dArray2, color);
    }

    public void drawCircle(double d, double d2, double d3, double d4) {
        this.updateBoundingBox(d - d3, d2 - d3);
        this.updateBoundingBox(d + d3, d2 + d3);
        this._commands.add(new CircleCommand(new Point2D.Double(d, d2), d3, d4));
    }

    public void setColor(Color color) {
        this._curColor = color;
        this._commands.add(new ColorCommand(color));
    }

    public void setBackgroundColor(Color color) {
        this._backgroundColor = color;
    }

    public void removeBackgroundColor() {
        this._backgroundColor = null;
    }

    public void fillCircle(double d, double d2, double d3, double d4, Color color) {
        this.updateBoundingBox(d - d3, d2 - d3);
        this.updateBoundingBox(d + d3, d2 + d3);
        this._commands.add(new FillCircleCommand(new Point2D.Double(d, d2), d3, d4, color));
    }

    public void drawPolygon(double[] dArray, double[] dArray2, double d) {
        if (dArray.length == dArray2.length) {
            Point2D.Double[] doubleArray = new Point2D.Double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                doubleArray[i] = new Point2D.Double(dArray[i], dArray2[i]);
                this.updateBoundingBox(dArray[i], dArray2[i]);
            }
            this._commands.add(new PolygonCommand(doubleArray, d));
        }
    }

    public void drawPolygon(GeneralPath generalPath, double d) {
        PathIterator pathIterator = generalPath.getPathIterator(null);
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                vector.add(new Point2D.Double(dArray[0], dArray[1]));
            }
            if (n == 1) {
                vector.add(new Point2D.Double(dArray[0], dArray[1]));
            }
            pathIterator.next();
        }
        double[] dArray2 = new double[vector.size()];
        double[] dArray3 = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            dArray2[i] = ((Point2D.Double)vector.get((int)i)).x;
            dArray3[i] = ((Point2D.Double)vector.get((int)i)).y;
        }
        this.drawPolygon(dArray2, dArray3, d);
    }

    public void fillPolygon(GeneralPath generalPath, Color color) {
        PathIterator pathIterator = generalPath.getPathIterator(null);
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                vector.add(new Point2D.Double(dArray[0], dArray[1]));
            }
            if (n == 1) {
                vector.add(new Point2D.Double(dArray[0], dArray[1]));
            }
            pathIterator.next();
        }
        double[] dArray2 = new double[vector.size()];
        double[] dArray3 = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            dArray2[i] = ((Point2D.Double)vector.get((int)i)).x;
            dArray3[i] = ((Point2D.Double)vector.get((int)i)).y;
        }
        this.fillPolygon(dArray2, dArray3, color);
    }

    public void fillPolygon(double[] dArray, double[] dArray2, Color color) {
        if (dArray.length == dArray2.length) {
            Point2D.Double[] doubleArray = new Point2D.Double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                doubleArray[i] = new Point2D.Double(dArray[i], dArray2[i]);
                this.updateBoundingBox(dArray[i], dArray2[i]);
            }
            this._commands.add(new FillPolygonCommand(doubleArray, color));
        }
    }

    public void setFont(int n, double d) {
        this._fontsize = d;
        this._font = n;
        this._commands.add(new FontCommand(n, d));
    }

    public void setScale(double d) {
        this._scale = d;
    }

    public Rectangle2D.Double getBoundingBox() {
        return new Rectangle2D.Double(this._xmin, this._ymin, this._xmax - this._xmin, this._ymax - this._ymin);
    }

    private Point2D.Double transform(Point2D.Double double_, double d, double d2, double d3) {
        return this.transform(double_.x, double_.y, d, d2, d3);
    }

    private Point2D.Double transform(double d, double d2, double d3, double d4, double d5) {
        return new Point2D.Double((d + d4) * d3, (d2 + d5) * d3);
    }

    public String export() {
        Object object;
        Rectangle2D.Double double_ = this.getBoundingBox();
        double d = -double_.x;
        double d2 = -double_.y;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, double_.width * this._scale, double_.height * this._scale);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.headerS(double_2));
        if (this._backgroundColor != null) {
            double d3 = double_.width * this._scale;
            double d4 = double_.height * this._scale;
            object = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(d3, 0.0), new Point2D.Double(d3, d4), new Point2D.Double(0.0, d4)};
            stringBuffer.append(this.fillPolygonS((Point2D.Double[])object, this._backgroundColor));
        }
        for (int i = 0; i < this._commands.size(); ++i) {
            Object object2;
            GraphicElement graphicElement = this._commands.elementAt(i);
            if (graphicElement instanceof LineCommand) {
                LineCommand lineCommand = (LineCommand)graphicElement;
                object2 = this.drawLineS(this.transform(lineCommand.get_orig(), this._scale, d, d2), this.transform(lineCommand.get_dest(), this._scale, d, d2), lineCommand.get_thickness());
                stringBuffer.append((String)object2);
                continue;
            }
            if (graphicElement instanceof TextCommand) {
                TextCommand textCommand = (TextCommand)graphicElement;
                object2 = this.drawTextS(this.transform(textCommand.get_base(), this._scale, d, d2), textCommand.get_txt());
                stringBuffer.append((String)object2);
                continue;
            }
            if (graphicElement instanceof RectangleCommand) {
                RectangleCommand rectangleCommand = (RectangleCommand)graphicElement;
                object2 = this.drawRectangleS(this.transform(rectangleCommand.get_orig(), this._scale, d, d2), this.transform(rectangleCommand.get_dims(), this._scale, 0.0, 0.0), rectangleCommand.get_thickness());
                stringBuffer.append((String)object2);
                continue;
            }
            if (graphicElement instanceof CircleCommand) {
                CircleCommand circleCommand = (CircleCommand)graphicElement;
                object2 = this.drawCircleS(this.transform(circleCommand.get_base(), this._scale, d, d2), circleCommand.get_radius() * this._scale, circleCommand.get_thickness());
                stringBuffer.append((String)object2);
                continue;
            }
            if (graphicElement instanceof FillCircleCommand) {
                FillCircleCommand fillCircleCommand = (FillCircleCommand)graphicElement;
                object2 = this.fillCircleS(this.transform(fillCircleCommand.get_base(), this._scale, d, d2), fillCircleCommand.get_radius() * this._scale, fillCircleCommand.get_thickness(), fillCircleCommand.get_color());
                stringBuffer.append((String)object2);
                continue;
            }
            if (graphicElement instanceof FontCommand) {
                FontCommand fontCommand = (FontCommand)graphicElement;
                object2 = this.setFontS(fontCommand.get_font(), fontCommand.get_size());
                stringBuffer.append((String)object2);
                continue;
            }
            if (graphicElement instanceof ColorCommand) {
                ColorCommand colorCommand = (ColorCommand)graphicElement;
                object2 = this.setColorS(colorCommand.getColor());
                stringBuffer.append((String)object2);
                continue;
            }
            if (graphicElement instanceof ArcCommand) {
                ArcCommand arcCommand = (ArcCommand)graphicElement;
                object2 = this.drawArcS(this.transform(arcCommand.getOrigine(), this._scale, d, d2), arcCommand.getWidth() * this._scale, arcCommand.getHeight() * this._scale, arcCommand.getStartAngle(), arcCommand.getEndAngle());
                stringBuffer.append((String)object2);
                continue;
            }
            if (graphicElement instanceof PolygonCommand) {
                PolygonCommand polygonCommand = (PolygonCommand)graphicElement;
                object2 = polygonCommand.get_points();
                for (int j = 0; j < ((Point2D.Double[])object2).length; ++j) {
                    object2[j] = this.transform(object2[j], this._scale, d, d2);
                }
                object = this.drawPolygonS((Point2D.Double[])object2, polygonCommand.get_thickness());
                stringBuffer.append((String)object);
                continue;
            }
            if (!(graphicElement instanceof FillPolygonCommand)) continue;
            FillPolygonCommand fillPolygonCommand = (FillPolygonCommand)graphicElement;
            object2 = fillPolygonCommand.get_points();
            for (int j = 0; j < ((Point2D.Double[])object2).length; ++j) {
                object2[j] = this.transform(object2[j], this._scale, d, d2);
            }
            object = this.fillPolygonS((Point2D.Double[])object2, fillPolygonCommand.get_color());
            stringBuffer.append((String)object);
        }
        stringBuffer.append(this.footerS());
        return stringBuffer.toString();
    }

    public void reset() {
    }
}

