/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Connection;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.TemplatePanel;
import java.awt.geom.Point2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class TemplateEdits {
    public static final double MAX_DISTANCE = 15.0;

    public static class HelixFlipTemplateEdit
    extends AbstractUndoableEdit {
        private Helix _h;
        private TemplatePanel _p;

        public HelixFlipTemplateEdit(Helix helix, TemplatePanel templatePanel) {
            this._h = helix;
            this._p = templatePanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._h.toggleFlipped();
            this._p.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._h.toggleFlipped();
            this._p.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Helix flipped ";
        }
    }

    public static class ElementEdgeMoveTemplateEdit
    extends AbstractUndoableEdit {
        private GraphicalTemplateElement _ur;
        GraphicalTemplateElement.RelativePosition _edge;
        private double _ox;
        private double _oy;
        private double _nx;
        private double _ny;
        private TemplatePanel _p;

        public ElementEdgeMoveTemplateEdit(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition, double d, double d2, TemplatePanel templatePanel) {
            this._ur = graphicalTemplateElement;
            this._edge = relativePosition;
            this._ox = graphicalTemplateElement.getEdgePosition((GraphicalTemplateElement.RelativePosition)relativePosition).x;
            this._oy = graphicalTemplateElement.getEdgePosition((GraphicalTemplateElement.RelativePosition)relativePosition).y;
            this._nx = d;
            this._ny = d2;
            this._p = templatePanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._ur.setEdgePosition(this._edge, new Point2D.Double(this._ox, this._oy));
            this._p.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._ur.setEdgePosition(this._edge, new Point2D.Double(this._nx, this._ny));
            this._p.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Edge moved " + (Object)((Object)this._edge);
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof ElementEdgeMoveTemplateEdit) {
                ElementEdgeMoveTemplateEdit elementEdgeMoveTemplateEdit = (ElementEdgeMoveTemplateEdit)undoableEdit;
                if (elementEdgeMoveTemplateEdit._edge == this._edge) {
                    Point2D.Double double_ = new Point2D.Double(this._ox, this._oy);
                    Point2D.Double double_2 = new Point2D.Double(this._nx, this._ny);
                    Point2D.Double double_3 = new Point2D.Double(elementEdgeMoveTemplateEdit._ox, elementEdgeMoveTemplateEdit._oy);
                    Point2D.Double double_4 = new Point2D.Double(elementEdgeMoveTemplateEdit._nx, elementEdgeMoveTemplateEdit._ny);
                    if (this._ur == elementEdgeMoveTemplateEdit._ur && double_2.equals(double_3) && double_.distance(double_4) < 15.0) {
                        this._nx = elementEdgeMoveTemplateEdit._nx;
                        this._ny = elementEdgeMoveTemplateEdit._ny;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class ElementDetachTemplateEdit
    extends AbstractUndoableEdit {
        Connection _c;
        private TemplatePanel _p;

        public ElementDetachTemplateEdit(Connection connection, TemplatePanel templatePanel) {
            this._c = connection;
            this._p = templatePanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._c = this._p.addConnection(this._c._h1, this._c._edge1, this._c._h2, this._c._edge2);
            this._p.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._p.removeConnection(this._c);
            this._p.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Graphical elements detached";
        }
    }

    public static class ElementAttachTemplateEdit
    extends AbstractUndoableEdit {
        Connection _c;
        private TemplatePanel _p;

        public ElementAttachTemplateEdit(Connection connection, TemplatePanel templatePanel) {
            this._c = connection;
            this._p = templatePanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._p.removeConnection(this._c);
            this._p.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._c = this._p.addConnection(this._c._h1, this._c._edge1, this._c._h2, this._c._edge2);
            this._p.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Graphical elements attached";
        }
    }

    public static class ElementRemoveTemplateEdit
    extends AbstractUndoableEdit {
        private GraphicalTemplateElement _h;
        private TemplatePanel _p;

        public ElementRemoveTemplateEdit(GraphicalTemplateElement graphicalTemplateElement, TemplatePanel templatePanel) {
            this._h = graphicalTemplateElement;
            this._p = templatePanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._p.addElement(this._h);
            this._p.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._p.removeElement(this._h);
            this._p.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Graphical element removed";
        }
    }

    public static class ElementAddTemplateEdit
    extends AbstractUndoableEdit {
        private GraphicalTemplateElement _h;
        private TemplatePanel _p;

        public ElementAddTemplateEdit(GraphicalTemplateElement graphicalTemplateElement, TemplatePanel templatePanel) {
            this._h = graphicalTemplateElement;
            this._p = templatePanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._p.removeElement(this._h);
            this._p.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._p.addElement(this._h);
            this._p.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Graphical element added";
        }
    }
}

