/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.UnpairedRegion;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Helix
extends GraphicalTemplateElement {
    RNATemplate.RNATemplateHelix _h;
    public static final double BASE_PAIR_DISTANCE = 65.0;
    public static final double LOOP_DISTANCE = 40.0;
    public static final double SELECTION_RADIUS = 15.0;
    public static final double EDIT_RADIUS = 10.0;
    public static final double MOVE_RADIUS = 13.0;
    public static final double BASE_RADIUS = 8.0;
    public static final double EDGE_BASE_RADIUS = 7.0;

    public Helix(double d, double d2, RNATemplate rNATemplate, List<GraphicalTemplateElement> list) {
        this(d, d2, Helix.getNextAutomaticCaption(list), rNATemplate);
    }

    public Helix(double d, double d2, String string, RNATemplate rNATemplate) {
        RNATemplate rNATemplate2 = rNATemplate;
        rNATemplate2.getClass();
        this._h = new RNATemplate.RNATemplateHelix(rNATemplate2, string);
        this._h.setStartPosition(new Point2D.Double(d, d2));
        this._h.setEndPosition(new Point2D.Double(d, d2));
        this._h.setLength(1);
        this._h.setCaption(string);
    }

    public Helix(RNATemplate.RNATemplateHelix rNATemplateHelix) {
        this._h = rNATemplateHelix;
    }

    private static String getNextAutomaticCaption(List<GraphicalTemplateElement> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (GraphicalTemplateElement object : list) {
            Helix helix;
            if (!(object instanceof Helix) || (helix = (Helix)object).getCaption() == null) continue;
            hashSet.add(helix.getCaption());
        }
        int n = 1;
        String string;
        while (hashSet.contains(string = "H" + n)) {
            ++n;
        }
        return string;
    }

    public void toggleFlipped() {
        this._h.setFlipped(!this._h.isFlipped());
        this.updateAttachedUnpairedRegions();
    }

    public void updateAttachedUnpairedRegions() {
        for (GraphicalTemplateElement.RelativePosition relativePosition : this.getConnectedEdges()) {
            Couple<GraphicalTemplateElement.RelativePosition, GraphicalTemplateElement> couple = this.getAttachedElement(relativePosition);
            if (couple == null || !(couple.second instanceof UnpairedRegion)) continue;
            UnpairedRegion unpairedRegion = (UnpairedRegion)couple.second;
            Point2D.Double double_ = this.getEdgePosition(relativePosition);
            if (couple.first == GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5) {
                unpairedRegion.setEdge5(double_);
                continue;
            }
            if (couple.first != GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3) continue;
            unpairedRegion.setEdge3(double_);
        }
    }

    public double getPosX() {
        return this._h.getStartPosition().x;
    }

    public String getCaption() {
        return this._h.getCaption();
    }

    public double getPosY() {
        return this._h.getStartPosition().y;
    }

    @Override
    public RNATemplate.RNATemplateHelix getTemplateElement() {
        return this._h;
    }

    public void setX(double d) {
        this._h.getStartPosition().x = d;
    }

    public void setY(double d) {
        this._h.getStartPosition().y = d;
    }

    public void setPos(Point2D.Double double_) {
        this._h.setStartPosition(double_);
        this.updateLength();
    }

    public void setPos(double d, double d2) {
        this.setPos(new Point2D.Double(d, d2));
    }

    public Point2D.Double getPos() {
        return this._h.getStartPosition();
    }

    public void moveCenter(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double((this._h.getStartPosition().x + this._h.getEndPosition().x) / 2.0, (this._h.getStartPosition().y + this._h.getEndPosition().y) / 2.0);
        double d3 = d - double_.x;
        double d4 = d2 - double_.y;
        this._h.setStartPosition(new Point2D.Double(this._h.getStartPosition().x + d3, this._h.getStartPosition().y + d4));
        this._h.setEndPosition(new Point2D.Double(this._h.getEndPosition().x + d3, this._h.getEndPosition().y + d4));
    }

    public void setExtent(double d, double d2) {
        this.setExtent(new Point2D.Double(d, d2));
    }

    private void updateLength() {
        this._h.setLength(this.getNbBP());
    }

    public void setExtent(Point2D.Double double_) {
        this._h.setEndPosition(double_);
        this.updateLength();
    }

    public double getExtentX() {
        return this._h.getEndPosition().x;
    }

    public Point2D.Double getExtent() {
        return this._h.getEndPosition();
    }

    public double getExtentY() {
        return this._h.getEndPosition().y;
    }

    public Point2D.Double getAbsStart5() {
        double d;
        double d2 = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d3 = d = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d4 = -d2;
        Point2D.Double double_ = new Point2D.Double(this.getPosX() - 65.0 * d3 / 2.0, this.getPosY() - 65.0 * d4 / 2.0);
        return double_;
    }

    public Point2D.Double getAbsStart3() {
        double d;
        double d2 = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d3 = d = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d4 = -d2;
        Point2D.Double double_ = new Point2D.Double(this.getPosX() + 65.0 * d3 / 2.0, this.getPosY() + 65.0 * d4 / 2.0);
        return double_;
    }

    public Point2D.Double getAbsEnd5() {
        double d;
        double d2 = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d3 = d = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d4 = -d2;
        Point2D.Double double_ = new Point2D.Double(this.getExtentX() - 65.0 * d3 / 2.0, this.getExtentY() - 65.0 * d4 / 2.0);
        return double_;
    }

    public Point2D.Double getAbsEnd3() {
        double d;
        double d2 = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d3 = d = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d4 = -d2;
        Point2D.Double double_ = new Point2D.Double(this.getExtentX() + 65.0 * d3 / 2.0, this.getExtentY() + 65.0 * d4 / 2.0);
        return double_;
    }

    public Point2D.Double getStart5() {
        if (this._h.isFlipped()) {
            return this.getAbsStart3();
        }
        return this.getAbsStart5();
    }

    public Point2D.Double getStart3() {
        if (this._h.isFlipped()) {
            return this.getAbsStart5();
        }
        return this.getAbsStart3();
    }

    public Point2D.Double getEnd5() {
        if (this._h.isFlipped()) {
            return this.getAbsEnd3();
        }
        return this.getAbsEnd5();
    }

    public Point2D.Double getEnd3() {
        if (this._h.isFlipped()) {
            return this.getAbsEnd5();
        }
        return this.getAbsEnd3();
    }

    @Override
    public Polygon getBoundingPolygon() {
        double d;
        double d2 = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d3 = d = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d4 = -d2;
        Point2D.Double double_ = new Point2D.Double(this.getPosX() + 65.0 * d3 / 2.0, this.getPosY() + 65.0 * d4 / 2.0);
        Point2D.Double double_2 = new Point2D.Double(this.getExtentX() + 65.0 * d3 / 2.0, this.getExtentY() + 65.0 * d4 / 2.0);
        Point2D.Double double_3 = new Point2D.Double(this.getPosX() - 65.0 * d3 / 2.0, this.getPosY() - 65.0 * d4 / 2.0);
        Point2D.Double double_4 = new Point2D.Double(this.getExtentX() - 65.0 * d3 / 2.0, this.getExtentY() - 65.0 * d4 / 2.0);
        Polygon polygon = new Polygon();
        polygon.addPoint((int)double_.x, (int)double_.y);
        polygon.addPoint((int)double_2.x, (int)double_2.y);
        polygon.addPoint((int)double_4.x, (int)double_4.y);
        polygon.addPoint((int)double_3.x, (int)double_3.y);
        return polygon;
    }

    public Point2D.Double getCenter() {
        return new Point2D.Double((int)((this._h.getStartPosition().x + this._h.getEndPosition().x) / 2.0), (int)((this._h.getStartPosition().y + this._h.getEndPosition().y) / 2.0));
    }

    public Point2D.Double getCenterEditStart() {
        double d = this._h.getStartPosition().distance(this._h.getEndPosition());
        double d2 = (this._h.getEndPosition().x - this._h.getStartPosition().x) / d;
        double d3 = (this._h.getEndPosition().y - this._h.getStartPosition().y) / d;
        return new Point2D.Double((int)(this._h.getStartPosition().x + (d - 10.0) * d2), (int)(this._h.getStartPosition().y + (d - 10.0) * d3));
    }

    public Point2D.Double getCenterEditEnd() {
        double d = this._h.getStartPosition().distance(this._h.getEndPosition());
        double d2 = (this._h.getEndPosition().x - this._h.getStartPosition().x) / d;
        double d3 = (this._h.getEndPosition().y - this._h.getStartPosition().y) / d;
        return new Point2D.Double((int)(this._h.getStartPosition().x + 10.0 * d2), (int)(this._h.getStartPosition().y + 10.0 * d3));
    }

    public Shape getSelectionBox() {
        double d;
        double d2 = (this._h.getStartPosition().x - this._h.getEndPosition().x) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d3 = d = (this._h.getStartPosition().y - this._h.getEndPosition().y) / this._h.getStartPosition().distance(this._h.getEndPosition());
        double d4 = -d2;
        Polygon polygon = this.getBoundingPolygon();
        Polygon polygon2 = new Polygon();
        Point2D.Double double_ = new Point2D.Double((double)polygon.xpoints[0] + 15.0 * (d2 + d3), (double)polygon.ypoints[0] + 15.0 * (d + d4));
        Point2D.Double double_2 = new Point2D.Double((double)polygon.xpoints[1] + 15.0 * (-d2 + d3), (double)polygon.ypoints[1] + 15.0 * (-d + d4));
        Point2D.Double double_3 = new Point2D.Double((double)polygon.xpoints[2] + 15.0 * (-d2 - d3), (double)polygon.ypoints[2] + 15.0 * (-d - d4));
        Point2D.Double double_4 = new Point2D.Double((double)polygon.xpoints[3] + 15.0 * (d2 - d3), (double)polygon.ypoints[3] + 15.0 * (d - d4));
        polygon2.addPoint((int)double_.x, (int)double_.y);
        polygon2.addPoint((int)double_2.x, (int)double_2.y);
        polygon2.addPoint((int)double_3.x, (int)double_3.y);
        polygon2.addPoint((int)double_4.x, (int)double_4.y);
        return polygon2;
    }

    @Override
    public Shape getArea() {
        return this.getSelectionBox();
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getRelativePosition(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Shape shape = this.getSelectionBox();
        if (shape.contains(double_)) {
            if (this.getCenterEditStart().distance(double_) < 10.0) {
                return GraphicalTemplateElement.RelativePosition.RP_EDIT_START;
            }
            if (this.getCenterEditEnd().distance(double_) < 10.0) {
                return GraphicalTemplateElement.RelativePosition.RP_EDIT_END;
            }
            if (this.getCenter().distance(double_) < 13.0) {
                return GraphicalTemplateElement.RelativePosition.RP_INNER_MOVE;
            }
            if (this.getEnd3().distance(double_) < 7.0) {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
            if (this.getEnd5().distance(double_) < 7.0) {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5;
            }
            if (this.getStart3().distance(double_) < 7.0) {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3;
            }
            if (this.getStart5().distance(double_) < 7.0) {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
            return GraphicalTemplateElement.RelativePosition.RP_INNER_GENERAL;
        }
        return GraphicalTemplateElement.RelativePosition.RP_OUTER;
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getClosestEdge(double d, double d2) {
        GraphicalTemplateElement.RelativePosition relativePosition = GraphicalTemplateElement.RelativePosition.RP_OUTER;
        double d3 = Double.MAX_VALUE;
        Point2D.Double double_ = new Point2D.Double(d, d2);
        double d4 = this.getStart5().distance(double_);
        if (d4 < d3) {
            d3 = d4;
            relativePosition = GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
        }
        if ((d4 = this.getStart3().distance(double_)) < d3) {
            d3 = d4;
            relativePosition = GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3;
        }
        if ((d4 = this.getEnd5().distance(double_)) < d3) {
            d3 = d4;
            relativePosition = GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5;
        }
        if ((d4 = this.getEnd3().distance(double_)) < d3) {
            d3 = d4;
            relativePosition = GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
        }
        return relativePosition;
    }

    @Override
    public Point2D.Double getEdgePosition(GraphicalTemplateElement.RelativePosition relativePosition) {
        switch (relativePosition) {
            case RP_CONNECT_END3: {
                return this.getEnd3();
            }
            case RP_CONNECT_END5: {
                return this.getEnd5();
            }
            case RP_CONNECT_START5: {
                return this.getStart5();
            }
            case RP_CONNECT_START3: {
                return this.getStart3();
            }
            case RP_EDIT_START: {
                return this.getPos();
            }
            case RP_EDIT_END: {
                return this.getExtent();
            }
            case RP_INNER_MOVE: {
                return this.getCenter();
            }
        }
        return this.getCenter();
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getConnectedEdge(GraphicalTemplateElement.RelativePosition relativePosition) {
        switch (relativePosition) {
            case RP_CONNECT_END3: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3;
            }
            case RP_CONNECT_END5: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
            case RP_CONNECT_START5: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5;
            }
            case RP_CONNECT_START3: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
        }
        return GraphicalTemplateElement.RelativePosition.RP_OUTER;
    }

    public boolean isAnchored5Start() {
        return this._h.getIn1().getOtherElement() != null;
    }

    public boolean isAnchored5End() {
        return this._h.getOut1().getOtherElement() != null;
    }

    public boolean isAnchored3Start() {
        return this._h.getOut2().getOtherElement() != null;
    }

    public boolean isAnchored3End() {
        return this._h.getIn2().getOtherElement() != null;
    }

    public int getNbBP() {
        Point2D.Double double_ = this.getPos();
        Point2D.Double double_2 = this.getExtent();
        double d = double_.distance(double_2);
        return Math.max((int)Math.round(d / 40.0) + 1, 2);
    }

    @Override
    public void draw(Graphics2D graphics2D, boolean bl) {
        Point2D.Double double_;
        graphics2D.setStroke(this._solidStroke);
        Point2D.Double double_2 = this.getPos();
        Point2D.Double double_3 = this.getExtent();
        double d = (double_2.x - double_3.x) / double_2.distance(double_3);
        double d2 = (double_2.y - double_3.y) / double_2.distance(double_3);
        double d3 = 65.0 * d2 / 2.0;
        double d4 = -65.0 * d / 2.0;
        Point2D.Double double_4 = this.getStart5();
        Point2D.Double double_5 = this.getEnd5();
        Point2D.Double double_6 = this.getStart3();
        Point2D.Double double_7 = this.getEnd3();
        for (GraphicalTemplateElement.RelativePosition relativePosition : this.getConnectedEdges()) {
            graphics2D.setStroke(this._solidStroke);
            graphics2D.setColor(BACKBONE_COLOR);
            Point2D.Double double_8 = this.getEdgePosition(relativePosition);
            Point2D.Double double_9 = this.getEdgePosition(this.getConnectedEdge(relativePosition));
            if (this._mainColors.containsKey((Object)relativePosition)) {
                graphics2D.setColor((Color)this._mainColors.get((Object)relativePosition));
                graphics2D.setStroke(this._boldStroke);
            }
            graphics2D.drawLine((int)double_8.x, (int)double_8.y, (int)(double_8.x + double_9.x) / 2, (int)(double_8.y + double_9.y) / 2);
        }
        graphics2D.setColor(NUMBER_COLOR);
        double d5 = (this._h.isFlipped() ? -1.0 : 1.0) * 1.5 * d3 + (double_6.x + double_7.x) / 2.0;
        double d6 = (this._h.isFlipped() ? -1.0 : 1.0) * 1.5 * d4 + (double_6.y + double_7.y) / 2.0;
        this.drawStringCentered(graphics2D, this.getCaption(), d5, d6);
        int n = this._h.getLength();
        graphics2D.setStroke(this._solidStroke);
        for (int i = 0; i < n; ++i) {
            graphics2D.setColor(BASE_PAIR_COLOR);
            double_ = new Point2D.Double(((double)i * double_4.x + (double)(n - 1 - i) * double_5.x) / (double)(n - 1), ((double)i * double_4.y + (double)(n - 1 - i) * double_5.y) / (double)(n - 1));
            Point2D.Double double_10 = new Point2D.Double(((double)i * double_6.x + (double)(n - 1 - i) * double_7.x) / (double)(n - 1), ((double)i * double_6.y + (double)(n - 1 - i) * double_7.y) / (double)(n - 1));
            graphics2D.drawLine((int)double_10.x, (int)double_10.y, (int)double_.x, (int)double_.y);
            if (i == 0) {
                if (this.isAnchored5End()) {
                    this.drawMagnet(graphics2D, double_);
                } else {
                    this.drawAnchor3(graphics2D, double_);
                }
                if (this.isAnchored3End()) {
                    this.drawMagnet(graphics2D, double_10);
                    continue;
                }
                this.drawAnchor5(graphics2D, double_10);
                continue;
            }
            if (i == n - 1) {
                if (this.isAnchored5Start()) {
                    this.drawMagnet(graphics2D, double_);
                } else {
                    this.drawAnchor5(graphics2D, double_);
                }
                if (this.isAnchored3Start()) {
                    this.drawMagnet(graphics2D, double_10);
                    continue;
                }
                this.drawAnchor3(graphics2D, double_10);
                continue;
            }
            this.drawBase(graphics2D, double_10);
            this.drawBase(graphics2D, double_);
        }
        if (bl) {
            d3 = d2;
            d4 = -d;
            Shape shape = this.getSelectionBox();
            graphics2D.setColor(BACKBONE_COLOR);
            graphics2D.setStroke(this._dashedStroke);
            graphics2D.draw(shape);
            double_ = this.getCenter();
            graphics2D.setStroke(this._solidStroke);
            this.drawMove(graphics2D, double_);
            this.drawEditStart(graphics2D, this, -d, -d2, d3, d4);
            this.drawEditEnd(graphics2D, this, -d, -d2, d3, d4);
        }
    }

    @Override
    public void translate(double d, double d2) {
        Point2D.Double double_ = this.getPos();
        Point2D.Double double_2 = this.getExtent();
        this.setPos(double_.x + d, double_.y + d2);
        this.setExtent(double_2.x + d, double_2.y + d2);
    }

    public RNATemplate.RNATemplateHelix getHelix() {
        return this._h;
    }

    @Override
    public RNATemplate.RNATemplateElement.EdgeEndPoint getEndPoint(GraphicalTemplateElement.RelativePosition relativePosition) {
        switch (relativePosition) {
            case RP_CONNECT_START5: {
                return this._h.getIn1();
            }
            case RP_CONNECT_START3: {
                return this._h.getOut2();
            }
            case RP_CONNECT_END3: {
                return this._h.getIn2();
            }
            case RP_CONNECT_END5: {
                return this._h.getOut1();
            }
        }
        return null;
    }

    @Override
    public boolean isIn(GraphicalTemplateElement.RelativePosition relativePosition) {
        switch (relativePosition) {
            case RP_CONNECT_START5: {
                return true;
            }
            case RP_CONNECT_START3: {
                return false;
            }
            case RP_CONNECT_END3: {
                return true;
            }
            case RP_CONNECT_END5: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void attach(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition, GraphicalTemplateElement.RelativePosition relativePosition2) throws ExceptionInvalidRNATemplate {
        super.attach(graphicalTemplateElement, relativePosition, relativePosition2);
        RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint = this.getEndPoint(relativePosition);
        RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint2 = graphicalTemplateElement.getEndPoint(relativePosition2);
        boolean bl = this.isIn(relativePosition);
        boolean bl2 = graphicalTemplateElement.isIn(relativePosition2);
        if (edgeEndPoint != null && edgeEndPoint2 != null && bl != bl2) {
            edgeEndPoint.disconnect();
            edgeEndPoint2.disconnect();
            edgeEndPoint.connectTo(edgeEndPoint2);
        }
    }

    @Override
    public void detach(GraphicalTemplateElement.RelativePosition relativePosition) {
        if (this.getEndPoint(relativePosition).isConnected()) {
            this.getEndPoint(relativePosition).disconnect();
        }
        super.detach(relativePosition);
    }

    @Override
    public void setEdgePosition(GraphicalTemplateElement.RelativePosition relativePosition, Point2D.Double double_) {
        switch (relativePosition) {
            case RP_EDIT_START: {
                this.setPos(double_);
                break;
            }
            case RP_EDIT_END: {
                this.setExtent(double_);
                break;
            }
            case RP_INNER_MOVE: {
                this.moveCenter(double_.x, double_.y);
            }
        }
        this.updateAttachedUnpairedRegions();
    }

    @Override
    public ArrayList<GraphicalTemplateElement.RelativePosition> getConnectedEdges() {
        ArrayList<GraphicalTemplateElement.RelativePosition> arrayList = new ArrayList<GraphicalTemplateElement.RelativePosition>();
        arrayList.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5);
        arrayList.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3);
        arrayList.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5);
        arrayList.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3);
        return arrayList;
    }

    public String toString() {
        return "Helix " + this.getCaption();
    }

    @Override
    public GraphicalTemplateElement.RelativePosition relativePositionFromEdgeEndPointPosition(RNATemplate.EdgeEndPointPosition edgeEndPointPosition) {
        switch (edgeEndPointPosition) {
            case IN1: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
            case OUT1: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5;
            }
            case IN2: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
            case OUT2: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3;
            }
        }
        return null;
    }
}

