/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.applications.fragseq.FragSeqFileModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqRNASecStrModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqTreeModel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class FragSeqCellRenderer
extends DefaultTreeCellRenderer {
    JTree _j;
    FragSeqTreeModel _m;
    private static FragSeqCellRenderer _default = new FragSeqCellRenderer(null, null);

    public FragSeqCellRenderer(JTree jTree, FragSeqTreeModel fragSeqTreeModel) {
        this._j = jTree;
        this._m = fragSeqTreeModel;
    }

    public JComponent baseElements(JTree jTree, FragSeqTreeModel fragSeqTreeModel, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jLabel.setBorder(null);
        jPanel.setBorder(null);
        jPanel.setBackground(jLabel.getBackground());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof String) {
            if (bl2) {
                jLabel.setIcon(_default.getOpenIcon());
            } else {
                jLabel.setIcon(_default.getClosedIcon());
            }
            jPanel.add((Component)jLabel, "West");
            JButton jButton = new JButton();
            jButton.setIcon(new SimpleIcon(Color.red, 26, false));
            Dimension dimension = this.getPreferredSize();
            dimension.width = 24;
            jButton.setPreferredSize(dimension);
            jButton.addActionListener(new FolderCloses((String)object2, jTree, fragSeqTreeModel));
            jPanel.add((Component)jButton, "East");
        } else if (object2 instanceof FragSeqRNASecStrModel) {
            jLabel.setIcon(new SimpleIcon(Color.blue.darker()));
            jPanel.add((Component)jLabel, "West");
        } else if (object2 instanceof FragSeqFileModel) {
            jLabel.setIcon(_default.getLeafIcon());
            FragSeqFileModel fragSeqFileModel = (FragSeqFileModel)object2;
            jPanel.add((Component)jLabel, "West");
            if (fragSeqFileModel.hasChanged()) {
                JButton jButton = new JButton("Refresh");
                jPanel.add((Component)jButton, "East");
            }
        } else if (object2 instanceof FragSeqModel) {
            FragSeqModel fragSeqModel = (FragSeqModel)object2;
            jLabel.setIcon(new SimpleIcon());
            jPanel.add((Component)jLabel, "West");
        }
        return jPanel;
    }

    public Component getDefaultTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        return this.baseElements(jTree, this._m, object, bl, bl2, bl3, n, bl4);
    }

    public Dimension getPreferredSize(int n) {
        Dimension dimension = super.getPreferredSize();
        dimension.width = this._j.getWidth();
        System.out.println(dimension);
        return dimension;
    }

    public class SimpleIcon
    implements Icon {
        private int _w = 16;
        private int _h = 16;
        private BasicStroke stroke = new BasicStroke(3.0f);
        private Color _r;
        private boolean _drawBackground = true;

        public SimpleIcon() {
            this(Color.magenta.darker());
        }

        public SimpleIcon(Color color) {
            this(color, 16, true);
        }

        public SimpleIcon(Color color, int n, boolean bl) {
            this(color, n, n, bl);
        }

        public SimpleIcon(Color color, int n, int n2, boolean bl) {
            this._r = color;
            this._w = n;
            this._h = n2;
            this._drawBackground = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this._drawBackground) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(n + 1, n2 + 1, this._w - 2, this._h - 2);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawRect(n + 1, n2 + 1, this._w - 2, this._h - 2);
            }
            graphics2D.setColor(this._r);
            graphics2D.setStroke(this.stroke);
            graphics2D.drawLine(n + 10, n2 + 10, n + this._w - 10, n2 + this._h - 10);
            graphics2D.drawLine(n + 10, n2 + this._h - 10, n + this._w - 10, n2 + 10);
            graphics2D.dispose();
        }

        @Override
        public int getIconWidth() {
            return this._w;
        }

        @Override
        public int getIconHeight() {
            return this._h;
        }
    }

    public class FolderCloses
    implements ActionListener {
        String _path;
        JComponent _p;
        FragSeqTreeModel _m;

        public FolderCloses(String string, JComponent jComponent, FragSeqTreeModel fragSeqTreeModel) {
            this._path = string;
            this._p = jComponent;
            this._m = fragSeqTreeModel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JOptionPane.showConfirmDialog(this._p, "This folder will cease to be watched. Confirm?", "Closing folder", 0) == 0) {
                this._m.removeFolder(this._path);
                System.out.println(FragSeqCellRenderer.this._j);
                FragSeqCellRenderer.this._j.updateUI();
            }
        }
    }
}

