/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.util.Hashtable;
import java.util.Random;

public class FragSeqAnnotationDataModel
extends FragSeqModel {
    private String _id;
    private String _name;
    private Hashtable<Integer, ChemProbModel> _values = new Hashtable();
    static Random _rnd = new Random();
    public static DataFlavor Flavor = new DataFlavor(FragSeqAnnotationDataModel.class, "RNA Chem Prob Data");

    public FragSeqAnnotationDataModel(String string, String string2) {
        this._id = string;
        this._name = string2;
    }

    public FragSeqAnnotationDataModel() {
        this(Long.toHexString(Double.doubleToLongBits(Math.random())), Long.toHexString(Double.doubleToLongBits(Math.random())));
    }

    public void addValue(ChemProbModel chemProbModel) {
        this._values.put(chemProbModel._baseNumber1, chemProbModel);
    }

    public static void addRandomAnnotations(RNA rNA, FragSeqAnnotationDataModel fragSeqAnnotationDataModel) {
        int n = rNA.getSize() / 5 + _rnd.nextInt(rNA.getSize() / 3);
        Color[] colorArray = new Color[]{Color.orange, Color.black, Color.blue.darker(), Color.green.darker(), Color.gray};
        ChemProbAnnotation.ChemProbAnnotationType[] chemProbAnnotationTypeArray = ChemProbAnnotation.ChemProbAnnotationType.values();
        for (int i = 0; i < n; ++i) {
            int n2 = _rnd.nextInt(rNA.getSize() - 1);
            int n3 = rNA.getBaseNumber(n2);
            int n4 = rNA.getBaseNumber(n2 + 1);
            FragSeqAnnotationDataModel fragSeqAnnotationDataModel2 = fragSeqAnnotationDataModel;
            fragSeqAnnotationDataModel2.getClass();
            ChemProbModel chemProbModel = fragSeqAnnotationDataModel2.new ChemProbModel(n3, n4, colorArray[_rnd.nextInt(colorArray.length)], 2.0 * _rnd.nextDouble(), chemProbAnnotationTypeArray[_rnd.nextInt(chemProbAnnotationTypeArray.length)], true);
            fragSeqAnnotationDataModel.addValue(chemProbModel);
        }
    }

    public String toString() {
        return this._name;
    }

    @Override
    public String getID() {
        return this._id;
    }

    public void applyTo(RNA rNA) {
        rNA.clearChemProbAnnotations();
        for (ChemProbModel chemProbModel : this._values.values()) {
            chemProbModel.applyTo(rNA);
        }
    }

    public class ChemProbModel {
        private Color _color;
        private double _intensity;
        private ChemProbAnnotation.ChemProbAnnotationType _type;
        private boolean _out;
        private int _baseNumber1;
        private int _baseNumber2;

        public ChemProbModel(int n, int n2, Color color, double d, ChemProbAnnotation.ChemProbAnnotationType chemProbAnnotationType, boolean bl) {
            this._color = color;
            this._intensity = d;
            this._type = chemProbAnnotationType;
            this._out = bl;
            this._baseNumber1 = n;
            this._baseNumber2 = n2;
        }

        public void applyTo(RNA rNA) {
            System.out.println(this);
            int n = rNA.getIndexFromBaseNumber(this._baseNumber1);
            int n2 = rNA.getIndexFromBaseNumber(this._baseNumber2);
            if (n != -1 && n2 != -1) {
                ModeleBase modeleBase = rNA.getBaseAt(n);
                ModeleBase modeleBase2 = rNA.getBaseAt(n2);
                rNA.addChemProbAnnotation(new ChemProbAnnotation(modeleBase, modeleBase2, this._type, this._intensity, this._color, this._out));
            }
        }

        public String toString() {
            return "" + this._baseNumber1 + ": col=" + this._color + " int=" + this._intensity + " type=" + (Object)((Object)this._type) + " out=" + this._out;
        }
    }
}

