/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.resolver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jnati.FileUtils;
import net.sf.jnati.NativeCodeException;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.artefact.ArtefactFile;
import net.sf.jnati.deploy.source.ArtefactSource;
import org.apache.log4j.Logger;

public class ArtefactResolver {
    private static final Logger LOG = Logger.getLogger(ArtefactResolver.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(Artefact artefact, ArtefactSource source, File target) throws IOException, NativeCodeException {
        try {
            source.loadManifest(artefact);
            boolean linux = artefact.getOsArch().contains("LINUX");
            LOG.info((Object)("Copying files to repository: " + target));
            for (ArtefactFile artefactFile : artefact.getFileList()) {
                String path = artefactFile.getPath();
                File outFile = new File(target, path);
                File outDir = outFile.getParentFile();
                if (!outDir.isDirectory() && !outDir.mkdirs()) {
                    throw new IOException();
                }
                LOG.trace((Object)("Copying file: " + path));
                InputStream in = source.openFile(path);
                FileUtils.writeStreamToFile(in, outFile);
                if (!linux || !artefactFile.isExe()) continue;
                this.makeExecutable(outFile);
            }
            File outFile = new File(target, "MANIFEST.xml");
            InputStream in = source.openFile("MANIFEST.xml");
            FileUtils.writeStreamToFile(in, outFile);
            artefact.setPath(target);
        }
        finally {
            source.close();
        }
    }

    private void makeExecutable(File file) throws NativeCodeException {
        int exit;
        String fp = file.getAbsolutePath();
        LOG.debug((Object)("Making file executable: " + fp));
        ProcessBuilder pb = new ProcessBuilder("chmod", "u+x", fp);
        try {
            Process p = pb.start();
            exit = p.waitFor();
        }
        catch (InterruptedException e) {
            throw new NativeCodeException("Error setting file executable: " + fp, e);
        }
        catch (IOException e) {
            throw new NativeCodeException("Error setting file executable: " + fp, e);
        }
        if (exit != 0) {
            String message = "Failed to set file as executable: " + fp;
            LOG.error((Object)message);
            throw new NativeCodeException(message);
        }
    }
}

