/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javajs.api.js.J2SObjectInterface;
import javajs.util.Rdr;
import swingjs.api.JSUtilI;

public class AjaxURLConnection
extends HttpURLConnection {
    private static JSUtilI jsutil = null;
    byte[] bytesOut;
    String postOut = "";
    ByteArrayOutputStream streamOut;
    private Object ajax = null;
    Object info;
    private Object formData;
    static Map<String, Object> urlCache;
    private static final int[] NETWORK_ERROR;

    public static URLConnection newConnection(URL url) {
        return url.getProtocol() == "https" ? new AjaxHttpsURLConnection(url) : new AjaxURLConnection(url);
    }

    protected AjaxURLConnection(URL url) {
        super(url);
    }

    @Override
    public String getHeaderField(String name) {
        try {
            if (this.getResponseCode() != -1) {
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try {
            Object data;
            if (this.getResponseCode() != -1 && (data = null) != null) {
                for (int i = 0; i < (data).length; ++i) {
                    String[] parts = data[i].split(":");
                    String key = parts[0].trim();
                    ArrayList<String> list = (ArrayList<String>)map.get(key);
                    if (list == null) {
                        list = new ArrayList<String>();
                        map.put(key, list);
                    }
                    list.add(parts[1].trim());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return map;
    }

    private Object doAjax(boolean isBinary, Function<Object, Void> whenDone) {
        Object result;
        Object info;
        this.getBytesOut();
        J2SObjectInterface J2S = null;
        this.info = info = this.ajax;
        Map<String, List<String>> map = this.getRequestProperties();
        boolean isnocache = false;
        String type = null;
        if (map != null) {
            for (Map.Entry<String, List<String>> e : map.entrySet()) {
                String key = e.getKey();
                switch (key.toLowerCase()) {
                    case "content-type": {
                        type = e.getValue().get(0);
                        break;
                    }
                    case "cache-control": {
                        isnocache = e.getValue().get(0).equalsIgnoreCase("no-cache");
                    }
                }
                String s = "";
                List<String> values = e.getValue();
                for (int i = 0; i < values.size(); ++i) {
                    s = s + (i == 0 ? "" : ", ") + values.get(i);
                }
                if (s.length() <= 0) continue;
            }
        }
        if ("application/json".equals(type)) {
            // empty if block
        }
        String myURL = this.url.toString();
        boolean isEmpty = false;
        if (myURL.startsWith("file:/TEMP/")) {
            result = jsutil.getCachedBytes(myURL);
            boolean bl = isEmpty = result == null;
            if (whenDone != null) {
                whenDone.apply(isEmpty ? null : result);
                return null;
            }
            this.responseCode = isEmpty ? 404 : 202;
        } else {
            if (myURL.startsWith("file:")) {
                String j2s = null;
                if (myURL.startsWith("file:/./")) {
                    myURL = j2s + myURL.substring(7);
                } else if (myURL.startsWith("file:/" + j2s)) {
                    myURL = myURL.substring(6);
                } else {
                    String base = this.getFileDocumentDir();
                    if (base != null && myURL.indexOf(base) == 0) {
                        myURL = myURL.substring(base.length());
                    } else {
                        URL path = jsutil.getCodeBase();
                        if (path != null) {
                            j2s = path.toString();
                            myURL = myURL.indexOf(j2s) >= 0 ? path + myURL.split(j2s)[1] : path + myURL.substring(5);
                        }
                    }
                }
            }
            result = J2S.doAjax(myURL, this.postOut, (Object)this.bytesOut, info);
            if (whenDone != null) {
                return null;
            }
            this.responseCode = isEmpty ? 404 : 0;
        }
        return result;
    }

    private String getFileDocumentDir() {
        String base = jsutil.getDocumentBase().getPath();
        int pt = base.lastIndexOf("/");
        return "file:" + base.substring(0, pt + 1);
    }

    @Override
    public void connect() throws IOException {
    }

    public void outputBytes(byte[] bytes) {
        this.bytesOut = bytes;
    }

    public void setFormData(Map<String, Object> map) {
        this.formData = map;
    }

    public void addFormData(String name, Object value, String contentType, String fileName) {
        if (this.formData == null) {
            this.formData = new Object[0][];
        }
    }

    private byte[] getBytesOut() {
        if (this.streamOut != null) {
            if (this.formData == null) {
                this.formData = null;
            }
            if (this.formData == null) {
                this.bytesOut = this.streamOut.toByteArray();
            }
            this.streamOut = null;
        }
        if (this.formData != null) {
            this.ajax = null;
            Object map = null;
            if (this.formData instanceof Map) {
                Map data = (Map)this.formData;
                for (Map.Entry e : data.entrySet()) {
                    String key = (String)e.getKey();
                    Object val = e.getValue();
                    if (!(val instanceof byte[])) continue;
                    val = AjaxURLConnection.toBlob((byte[])val, null);
                }
            } else {
                Object[][] adata = (Object[][])this.formData;
                for (int i = 0; i < adata.length; ++i) {
                    Object[] d = adata[i];
                    String name = (String)d[0];
                    Object value = d[1];
                    String contentType = (String)d[2];
                    String filename = (String)d[3];
                    if (value instanceof String && (contentType != null || filename != null)) {
                        value = ((String)value).getBytes();
                    }
                    if (!(value instanceof byte[])) continue;
                    value = AjaxURLConnection.toBlob((byte[])value, contentType);
                }
            }
            this.formData = null;
            this.bytesOut = null;
            this.useCaches = false;
        }
        return this.bytesOut;
    }

    private static Object toBlob(byte[] val, String contentType) {
        return null;
    }

    public void outputString(String post) {
        this.postOut = post;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.streamOut = new ByteArrayOutputStream();
        return this.streamOut;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        InputStream is = null;
        if (is != null) {
            return is;
        }
        this.responseCode = -1;
        is = this.getInputStreamAndResponse(false);
        if (is == null) {
            throw new FileNotFoundException("opening " + this.url);
        }
        return is;
    }

    public void getBytesAsync(final Function<byte[], Void> whenDone) {
        this.getInputStreamAsync(new Function<InputStream, Void>(){

            @Override
            public Void apply(InputStream is) {
                try {
                    if (is != null) {
                        Object bytes = null;
                        whenDone.apply(bytes);
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                whenDone.apply(null);
                return null;
            }
        });
    }

    private void getInputStreamAsync(Function<InputStream, Void> whenDone) {
        Object is = null;
        if (is != null) {
            whenDone.apply((InputStream)is);
            return;
        }
        this.responseCode = -1;
        this.getInputStreamAndResponseAsync(whenDone);
    }

    private void getInputStreamAndResponseAsync(final Function<InputStream, Void> whenDone) {
        BufferedInputStream is = AjaxURLConnection.getAttachedStreamData(this.url, false);
        if (is != null || this.doCache() && (is = this.getCachedStream(false)) != null) {
            whenDone.apply(is);
            return;
        }
        this.doAjax(true, new Function<Object, Void>(){

            @Override
            public Void apply(Object data) {
                if (data instanceof String) {
                    whenDone.apply(null);
                    return null;
                }
                BufferedInputStream is = AjaxURLConnection.attachStreamData(AjaxURLConnection.this.url, data);
                if (AjaxURLConnection.this.doCache() && is != null) {
                    AjaxURLConnection.this.isNetworkError(is);
                    AjaxURLConnection.this.setCachedStream();
                } else if (AjaxURLConnection.this.isNetworkError(is)) {
                    is = null;
                }
                whenDone.apply(is);
                return null;
            }
        });
    }

    private InputStream getInputStreamAndResponse(boolean allowNWError) {
        BufferedInputStream is = AjaxURLConnection.getAttachedStreamData(this.url, false);
        if (is != null || this.doCache() && (is = this.getCachedStream(allowNWError)) != null) {
            return is;
        }
        is = AjaxURLConnection.attachStreamData(this.url, this.doAjax(this.ajax == null, null));
        if (this.doCache() && is != null) {
            this.isNetworkError(is);
            this.setCachedStream();
            return is;
        }
        if (!this.isNetworkError(is)) {
            // empty if block
        }
        return is;
    }

    private boolean doCache() {
        if (!this.useCaches || !this.getRequestMethod().equals("POST")) {
            return this.useCaches;
        }
        String cc = this.getRequestProperty("Cache-Control");
        return cc == null || !cc.equals("no-cache");
    }

    private BufferedInputStream getCachedStream(boolean allowNWError) {
        boolean isAjax;
        BufferedInputStream bis;
        Object data = urlCache.get(this.getCacheKey());
        if (data == null) {
            return null;
        }
        URL url = this.url;
        if (data instanceof byte[]) {
            // empty if block
        }
        return !this.isNetworkError(bis = AjaxURLConnection.getBIS(data, isAjax = false)) || allowNWError ? bis : null;
    }

    private static BufferedInputStream getBIS(Object data, boolean isJSON) {
        Object jsonData;
        if (data == null) {
            return null;
        }
        Object object = jsonData = isJSON ? data : null;
        if (isJSON) {
            // empty if block
        }
        BufferedInputStream bis = Rdr.toBIS(data);
        if (isJSON) {
            // empty if block
        }
        return bis;
    }

    private void setCachedStream() {
        Object data = null;
        if (data != null) {
            int code = this.responseCode;
            urlCache.put(this.getCacheKey(), data);
        }
    }

    private String getCacheKey() {
        String key = this.url.toString();
        if (this.getRequestMethod().equals("POST")) {
            key = key + ((this.postOut != null ? this.postOut.hashCode() : 0) | (this.getBytesOut() != null ? this.getBytesOut().hashCode() : 0));
        }
        return key;
    }

    private boolean isNetworkError(BufferedInputStream is) {
        if (is != null) {
            this.responseCode = 200;
            is.mark(15);
            byte[] bytes = new byte[13];
            try {
                is.read(bytes);
                is.reset();
                int i = NETWORK_ERROR.length;
                while (--i >= 0) {
                    if (bytes[i] == NETWORK_ERROR[i]) continue;
                    return false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.responseCode = 404;
        return true;
    }

    public static BufferedInputStream getAttachedStreamData(URL url, boolean andDelete) {
        Object data = null;
        boolean isJSON = false;
        return AjaxURLConnection.getBIS(data, isJSON);
    }

    public static BufferedInputStream attachStreamData(URL url, Object o) {
        return AjaxURLConnection.getBIS(o, false);
    }

    public Object getContents() {
        return this.doAjax(false, null);
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.responseCode == -1) {
            try {
                this.getInputStreamAndResponse(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.responseCode;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public int getContentLength() {
        try {
            InputStream is = this.getInputStream();
            return is.available();
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Override
    public String toString() {
        return this.url == null ? "[AjaxURLConnection]" : this.url.toString();
    }

    static {
        try {
            jsutil = (JSUtilI)Class.forName("swingjs.JSUtil").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        urlCache = new Hashtable<String, Object>();
        NETWORK_ERROR = new int[]{78, 101, 116, 119, 111, 114, 107, 69, 114, 114, 111, 114};
    }

    public static class AjaxHttpsURLConnection
    extends AjaxURLConnection {
        protected AjaxHttpsURLConnection(URL url) {
            super(url);
        }
    }
}

