/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.SessionHandle;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.client.simpleclient.FileWatcher;
import uk.ac.vamsas.client.simpleclient.IdFactory;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.SimpleDocBinding;
import uk.ac.vamsas.client.simpleclient.VamsasArchive;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.client.simpleclient.VamsasFile;
import uk.ac.vamsas.objects.core.AppData;
import uk.ac.vamsas.objects.core.ApplicationData;
import uk.ac.vamsas.objects.core.User;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.objects.utils.AppDataReference;
import uk.ac.vamsas.objects.utils.document.VersionEntries;
import uk.ac.vamsas.test.objects.Core;
import uk.ac.vamsas.test.simpleclient.ArchiveReports;
import uk.ac.vamsas.test.simpleclient.ClientDoc;

public class ArchiveClient
extends IdFactory {
    private Log log = LogFactory.getLog((Class)ArchiveClient.class);
    VamsasFile vsess;
    protected boolean watchForChange = true;
    public static int WATCH_SLEEP = 300;

    public ArchiveClient(UserHandle user, VamsasFile vsess) {
        super(new SessionHandle("vamsasfile://" + vsess.getVamsasFile()), new ClientHandle("ArchiveClient", "0.01"), user);
        this.vsess = vsess;
        this.valid();
    }

    private void _openVsess(File vsess) {
        try {
            this.vsess = new VamsasFile(vsess);
        }
        catch (Exception e) {
            this.log.error((Object)("Couldn't open session for file " + vsess), (Throwable)e);
            this.vsess = null;
        }
    }

    public ArchiveClient(String username, String organization, File vsess) {
        super(new SessionHandle("vamsasfile://" + vsess), new ClientHandle("ArchiveClient", "0.01"), new UserHandle(username, organization));
        this._openVsess(vsess);
        this.valid();
    }

    public ArchiveClient(String username, String organization, String clientName, String clientVersion, File vsess) {
        super(new SessionHandle("vamsasfile://" + vsess), new ClientHandle(clientName, clientVersion), new UserHandle(username, organization));
        this._openVsess(vsess);
        this.valid();
    }

    public void valid() {
        if (this.vsess == null) {
            throw new Error("ArchiveClient instance is invalid!.");
        }
    }

    public ClientDoc watch(long time) {
        this.valid();
        this.vsess.unLock();
        FileWatcher watcher = new FileWatcher(this.vsess.getVamsasFile());
        this.watchForChange = true;
        long endtime = System.currentTimeMillis() + time;
        try {
            Lock doclock;
            do {
                if ((doclock = watcher.getChangedState()) != null) continue;
                Thread.sleep(WATCH_SLEEP);
            } while (this.watchForChange && doclock == null && (time == 0L || endtime > System.currentTimeMillis()));
            if (doclock == null) {
                return null;
            }
            return this.getUpdateable(this.vsess.getLock(doclock));
        }
        catch (Exception e) {
            this.log.error((Object)("Whilst watching file " + this.vsess.getVamsasFile()), (Throwable)e);
            return null;
        }
    }

    private AppData[] getAppData(VamsasDocument doc) {
        if (doc == null) {
            this.log.debug((Object)"extractAppData called for null document object");
            return null;
        }
        ApplicationData appsGlobal = null;
        User usersData = null;
        Vector apldataset = AppDataReference.getUserandApplicationsData(doc, this.getUserHandle(), this.getClientHandle());
        if (apldataset != null && apldataset.size() > 0) {
            AppData clientdat = (AppData)apldataset.get(0);
            if (clientdat instanceof ApplicationData) {
                appsGlobal = (ApplicationData)clientdat;
                if (apldataset.size() > 1) {
                    clientdat = (AppData)apldataset.get(1);
                    if (clientdat instanceof User) {
                        usersData = (User)clientdat;
                    }
                    if (apldataset.size() > 2) {
                        this.log.info((Object)("Ignoring additional (" + (apldataset.size() - 2) + ") AppDatas returned by document appdata query."));
                    }
                }
            } else {
                this.log.warn((Object)("Unexpected entry in AppDataReference query: id=" + clientdat.getVorbaId() + " type=" + clientdat.getClass().getName()));
            }
            apldataset.removeAllElements();
        }
        return new AppData[]{appsGlobal, usersData};
    }

    protected ClientDoc _getReadonly(VamsasArchiveReader vreader) throws IOException, ValidationException, MarshalException {
        this.valid();
        if (vreader != null) {
            SimpleDocBinding docb = new SimpleDocBinding();
            docb.setVorba(this);
            VamsasDocument d = docb.getVamsasDocument(vreader);
            if (d != null) {
                ClientDoc creader = new ClientDoc(d, null, vreader, this.getClientHandle().getClientUrn(), this.getProvenanceUser(), this.getVorbaIdHash());
                return creader;
            }
        }
        return null;
    }

    protected String getProvenanceUser() {
        return new String(this.getUserHandle().getFullName() + " [" + this.getClientHandle().getClientUrn() + "]");
    }

    public ClientDoc getUpdateable() {
        return this.getUpdateable(null);
    }

    public ClientDoc getUpdateable(Lock lock) {
        this.getVorbaIdHash().clear();
        this.valid();
        try {
            long tries = 5000L;
            while (!(lock != null || (lock = this.vsess.getLock()) != null && lock.isLocked() || --tries <= 0L)) {
                this.log.debug((Object)("Trying to get a document lock for the " + tries + "'th time."));
            }
            VamsasArchive varc = new VamsasArchive(this.vsess, true, false);
            varc.setVorba(this);
            VamsasDocument d = varc.getVamsasDocument(this.getProvenanceUser(), "Created new document.", VersionEntries.latestVersion());
            if (d == null) {
                this.log.warn((Object)"Backing out from opening a VamsasArchive writable IO session");
                varc.cancelArchive();
                return null;
            }
            ClientDoc cdoc = new ClientDoc(d, varc, varc.getOriginalArchiveReader(), this.getClientHandle().getClientUrn(), this.getProvenanceUser(), this.getVorbaIdHash());
            return cdoc;
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to get Updateable version of " + this.vsess.getVamsasFile()), (Throwable)e);
            return null;
        }
    }

    public boolean doUpdate(ClientDoc cdoc) {
        this.valid();
        if (cdoc == null) {
            this.log.warn((Object)"Invalid ClientDoc passed to uk.ac.vamsas.test.simpleclient.doUpdate()");
            return false;
        }
        if (cdoc.iohandler == null) {
            this.log.warn((Object)"Read only ClientDoc object passed to uk.ac.vamsas.test.simpleclient.doUpdate()");
            return false;
        }
        if (cdoc.iohandler.getVorba() != this) {
            this.log.error((Object)"Mismatch between ClientDoc instances and ArchiveClient instances!");
            return false;
        }
        try {
            if (cdoc.iohandler.transferRemainingAppDatas()) {
                this.log.debug((Object)"Remaining appdatas were transfered.");
            }
            cdoc.updateDocumentRoots();
            cdoc.iohandler.putVamsasDocument(cdoc.doc);
            cdoc.iohandler.closeArchive();
            this.extantids.clear();
            cdoc.iohandler = null;
            cdoc = null;
            this.vsess.unLock();
        }
        catch (Exception e) {
            this.log.warn((Object)("While updating archive in " + this.vsess.getVamsasFile()), (Throwable)e);
            return false;
        }
        return true;
    }

    public static void usage() {
        throw new Error("Usage: Username Organization VamsasFile [command,args]*");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            ArchiveClient.usage();
        }
        ArchiveClient client = new ArchiveClient(args[0], args[1], new File(args[2]));
        ClientDoc cdoc = null;
        try {
            cdoc = client.getUpdateable();
            System.out.println("Report Roots :");
            ArchiveReports.rootReport(cdoc.getVamsasRoots(), true, System.out);
            cdoc.addVamsasRoot(Core.getDemoVamsas());
            System.out.println("Doing update.");
            client.doUpdate(cdoc);
            cdoc.closeDoc();
            cdoc = null;
            int u = 5;
            while (--u > 0) {
                System.out.println("Watch for more... (" + u + " left)");
                ClientDoc ucdoc = client.watch(0L);
                if (ucdoc != null) {
                    System.out.println("****\nUpdate detected at " + new Date());
                    ArchiveReports.reportDocument(ucdoc.doc, ucdoc.getReader(), true, System.out);
                    ucdoc.closeDoc();
                    ucdoc = null;
                    continue;
                }
                System.out.println("!!!! Null document update detected at " + new Date());
            }
        }
        catch (Exception e) {
            client.log.error((Object)"Broken!", (Throwable)e);
        }
        System.out.println("Finished at " + new Date());
    }

    public Vobject getObject(VorbaId id) {
        Hashtable idhash = this.getVorbaIdHash();
        if (idhash != null && idhash.containsKey(id)) {
            return (Vobject)idhash.get(id);
        }
        return null;
    }
}

