/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.picking;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.picking.CustomMessage;
import uk.ac.vamsas.client.picking.Message;
import uk.ac.vamsas.client.picking.MouseOverMessage;
import uk.ac.vamsas.client.picking.SelectionMessage;
import uk.ac.vamsas.client.picking.SocketManager;

class PickEndPoint
extends Thread {
    private Log logger = LogFactory.getLog((Class)PickEndPoint.class);
    private Socket socket;
    private int rPort;
    private BufferedWriter os;
    private BufferedReader in;
    private SocketManager manager;

    PickEndPoint(SocketManager manager, Socket s) {
        this.manager = manager;
        this.socket = s;
    }

    boolean openConnection() {
        try {
            if (this.socket == null) {
                this.socket = new Socket(InetAddress.getLocalHost(), 53782);
            }
            this.rPort = this.socket.getPort();
            this.socket.setKeepAlive(true);
            this.os = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.logger.debug((Object)("CLIENT: connection successful to port " + this.socket.getPort() + " via port " + this.socket.getLocalPort()));
            this.start();
            return true;
        }
        catch (Exception e) {
            this.logger.info((Object)("CLIENT: connection failed: " + e));
            return false;
        }
    }

    void send(Message message) {
        try {
            String str = message.getRawMessage();
            this.os.write(str);
            this.os.newLine();
            this.os.flush();
        }
        catch (Exception e) {
            this.terminate();
        }
    }

    public void run() {
        try {
            while (this.manager != null) {
                String str = this.in.readLine();
                Message message = this.strToMessage(str);
                if (message == null) continue;
                this.manager.processMessage(this, message);
            }
        }
        catch (Exception e) {
            this.terminate();
        }
    }

    void terminate() {
        SocketManager mgr = this.manager;
        this.manager = null;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
        if (mgr != null) {
            mgr.removeEndPoint(this);
        }
    }

    private Message strToMessage(String str) {
        try {
            if (str == null || str.length() == 1) {
                return null;
            }
            if (str.startsWith("CUSTOM")) {
                return new CustomMessage(str.substring(6));
            }
            if (str.startsWith("MOUSEOVER")) {
                return new MouseOverMessage(str);
            }
            if (str.startsWith("SELECTION")) {
                return new SelectionMessage(str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

