/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.location;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.location.SimplePoint;
import org.biojava.nbio.core.sequence.location.template.AbstractLocation;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.location.template.Point;

public class SimpleLocation
extends AbstractLocation {
    private static final List<Location> EMPTY_LOCS = Collections.emptyList();

    public SimpleLocation(int start, int end) {
        this(new SimplePoint(start), new SimplePoint(end));
    }

    public SimpleLocation(Point start, Point end) {
        this(start, end, Strand.POSITIVE);
    }

    public SimpleLocation(int start, int end, Strand strand) {
        this(new SimplePoint(start), new SimplePoint(end), strand);
    }

    public SimpleLocation(int start, int end, Strand strand, List<Location> subLocations) {
        this((Point)new SimplePoint(start), (Point)new SimplePoint(end), strand, subLocations);
    }

    public SimpleLocation(Point start, Point end, Strand strand) {
        super(start, end, strand, false, false, new ArrayList<Location>());
    }

    public SimpleLocation(Point start, Point end, Strand strand, AccessionID accession) {
        super(start, end, strand, false, false, accession, EMPTY_LOCS);
    }

    public SimpleLocation(Point start, Point end, Strand strand, boolean betweenCompounds, AccessionID accession) {
        super(start, end, strand, false, betweenCompounds, accession, EMPTY_LOCS);
    }

    public SimpleLocation(Point start, Point end, Strand strand, boolean circular, boolean betweenBases) {
        super(start, end, strand, circular, betweenBases, EMPTY_LOCS);
    }

    public SimpleLocation(int start, int end, Strand strand, Location ... subLocations) {
        this((Point)new SimplePoint(start), (Point)new SimplePoint(end), strand, subLocations);
    }

    public SimpleLocation(Point start, Point end, Strand strand, Location ... subLocations) {
        super(start, end, strand, false, false, Arrays.asList(subLocations));
    }

    public SimpleLocation(Point start, Point end, Strand strand, boolean circular, Location ... subLocations) {
        super(start, end, strand, circular, false, Arrays.asList(subLocations));
    }

    public SimpleLocation(Point start, Point end, Strand strand, boolean circular, List<Location> subLocations) {
        super(start, end, strand, circular, false, subLocations);
    }

    public SimpleLocation(Point start, Point end, Strand strand, List<Location> subLocations) {
        super(start, end, strand, false, false, subLocations);
    }

    public SimpleLocation(Point start, Point end, Strand strand, boolean circular, boolean betweenBases, List<Location> subLocations) {
        super(start, end, strand, circular, betweenBases, subLocations);
    }
}

