/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionDrawingAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.interfaces.InterfaceParameterLoader;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;

public class VARNAConfigLoader {
    private static final int MAXSTYLE = 50;
    public static String algoOpt = "algorithm";
    public static String annotationsOpt = "annotations";
    public static String applyBasesStyleOpt = "applyBasesStyle";
    public static String auxBPsOpt = "auxBPs";
    public static String autoHelicesOpt = "autoHelices";
    public static String autoInteriorLoopsOpt = "autoInteriorLoops";
    public static String autoTerminalLoopsOpt = "autoTerminalLoops";
    public static String backboneColorOpt = "backbone";
    public static String backgroundColorOpt = "background";
    public static String baseInnerColorOpt = "baseInner";
    public static String baseNameColorOpt = "baseName";
    public static String baseNumbersColorOpt = "baseNum";
    public static String baseOutlineColorOpt = "baseOutline";
    public static String basesStyleOpt = "basesStyle";
    public static String borderOpt = "border";
    public static String bondColorOpt = "bp";
    public static String bpIncrementOpt = "bpIncrement";
    public static String bpStyleOpt = "bpStyle";
    public static String colorMapOpt = "colorMap";
    public static String colorMapCaptionOpt = "colorMapCaption";
    public static String colorMapDefOpt = "colorMapStyle";
    public static String colorMapMinOpt = "colorMapMin";
    public static String colorMapMaxOpt = "colorMapMax";
    public static String comparisonModeOpt = "comparisonMode";
    public static String chemProbOpt = "chemProb";
    public static String customBasesOpt = "customBases";
    public static String customBPsOpt = "customBPs";
    public static String drawNCOpt = "drawNC";
    public static String drawBasesOpt = "drawBases";
    public static String drawTertiaryOpt = "drawTertiary";
    public static String drawColorMapOpt = "drawColorMap";
    public static String drawBackboneOpt = "drawBackbone";
    public static String errorOpt = "error";
    public static String fillBasesOpt = "fillBases";
    public static String firstSequenceForComparisonOpt = "firstSequence";
    public static String firstStructureForComparisonOpt = "firstStructure";
    public static String flatExteriorLoopOpt = "flat";
    public static String flipOpt = "flip";
    public static String gapsBaseColorOpt = "gapsColor";
    public static String highlightRegionOpt = "highlightRegion";
    public static String nonStandardColorOpt = "nsBasesColor";
    public static String numColumnsOpt = "rows";
    public static String numRowsOpt = "columns";
    public static String orientationOpt = "orientation";
    public static String modifiableOpt = "modifiable";
    public static String periodNumOpt = "periodNum";
    public static String rotationOpt = "rotation";
    public static String secondSequenceForComparisonOpt = "secondSequence";
    public static String secondStructureForComparisonOpt = "secondStructure";
    public static String sequenceOpt = "sequenceDBN";
    public static String spaceBetweenBasesOpt = "spaceBetweenBases";
    public static String structureOpt = "structureDBN";
    public static String titleOpt = "title";
    public static String titleColorOpt = "titleColor";
    public static String titleSizeOpt = "titleSize";
    public static String URLOpt = "url";
    public static String warningOpt = "warning";
    public static String zoomOpt = "zoom";
    public static String zoomAmountOpt = "zoomAmount";
    private String _algo;
    public String _annotations;
    public String _chemProbs;
    private double _rotation;
    private String _sseq;
    private String _sstruct;
    private int _numRows;
    private int _numColumns;
    private String _title;
    private int _titleSize;
    private Color _titleColor;
    private String _auxBPs;
    private String _highlightRegion;
    private boolean _autoHelices;
    private boolean _autoInteriorLoops;
    private boolean _autoTerminalLoops;
    private boolean _drawBackbone;
    private Color _backboneColor;
    private Color _bondColor;
    private VARNAConfig.BP_STYLE _bpStyle;
    private Color _baseOutlineColor;
    private Color _baseInnerColor;
    private Color _baseNumColor;
    private Color _baseNameColor;
    private Color _gapsColor;
    private Color _nonStandardColor;
    private boolean _flatExteriorLoop;
    private String _flip;
    private String _customBases;
    private String _customBPs;
    private String _colorMapStyle;
    private String _colorMapCaption;
    private String _colorMapValues;
    private double _colorMapMin = Double.MIN_VALUE;
    private double _colorMapMax = Double.MAX_VALUE;
    private double _spaceBetweenBases = Double.MIN_VALUE;
    private boolean _drawNC;
    private boolean _drawBases;
    private boolean _drawTertiary;
    private boolean _drawColorMap;
    private boolean _fillBases;
    private int _periodResNum;
    private Dimension _border;
    private Color _backgroundColor;
    private String _orientation;
    private boolean _warning;
    private boolean _error;
    private boolean _modifiable;
    private double _zoom;
    private double _zoomAmount;
    private ArrayList<ModelBaseStyle> _basesStyleList;
    private boolean _comparisonMode;
    private String _firstSequence;
    private String _secondSequence;
    private String _firstStructure;
    private String _secondStructure;
    private VARNAPanel _mainSurface;
    private boolean _useNonStandardColor;
    private boolean _useGapsColor;
    private double _bpIncrement;
    private boolean _useInnerBaseColor;
    private boolean _useBaseNameColor;
    private boolean _useBaseNumbersColor;
    private boolean _useBaseOutlineColor;
    private String _URL;
    protected ArrayList<VARNAPanel> _VARNAPanelList = new ArrayList();
    InterfaceParameterLoader _optionProducer;
    public static final String LEONTIS_WESTHOF_BP_STYLE = "lw";
    public static final String LEONTIS_WESTHOF_BP_STYLE_ALT = "lwalt";
    public static final String SIMPLE_BP_STYLE = "simple";
    public static final String RNAVIZ_BP_STYLE = "rnaviz";
    public static final String NONE_BP_STYLE = "none";
    private RNA _defaultRNA = new RNA();
    public static final String ALGORITHM_CIRCULAR = "circular";
    public static final String ALGORITHM_NAVIEW = "naview";
    public static final String ALGORITHM_LINE = "line";
    public static final String ALGORITHM_RADIATE = "radiate";
    public static final String ALGORITHM_VARNA_VIEW = "varnaview";
    public static final String ALGORITHM_MOTIF_VIEW = "motifview";

    public VARNAConfigLoader(InterfaceParameterLoader interfaceParameterLoader) {
        this._optionProducer = interfaceParameterLoader;
    }

    public ArrayList<VARNAPanel> createVARNAPanels() throws ExceptionParameterError, ExceptionModeleStyleBaseSyntaxError, ExceptionNonEqualLength, IOException, ExceptionFileFormatOrSyntax, ExceptionLoadingFailed {
        this._VARNAPanelList.clear();
        this.retrieveParametersValues();
        return this._VARNAPanelList;
    }

    public int getNbRows() {
        return this._numRows;
    }

    public int getNbColumns() {
        return this._numColumns;
    }

    private void initValues() {
        this._algo = ALGORITHM_RADIATE;
        this._auxBPs = "";
        this._autoHelices = false;
        this._autoInteriorLoops = false;
        this._autoTerminalLoops = false;
        this._annotations = "";
        this._backgroundColor = VARNAConfig.DEFAULT_BACKGROUND_COLOR;
        this._customBases = "";
        this._customBPs = "";
        this._chemProbs = "";
        this._colorMapStyle = "";
        this._colorMapValues = "";
        this._colorMapCaption = "";
        this._drawColorMap = false;
        this._drawBases = true;
        this._fillBases = true;
        this._drawNC = true;
        this._drawTertiary = true;
        this._border = new Dimension(0, 0);
        this._sseq = "";
        this._sstruct = "";
        this._periodResNum = 10;
        this._rotation = 0.0;
        this._title = "";
        this._titleSize = VARNAConfig.DEFAULT_TITLE_FONT.getSize();
        this._backboneColor = VARNAConfig.DEFAULT_BACKBONE_COLOR;
        this._drawBackbone = true;
        this._bondColor = VARNAConfig.DEFAULT_BOND_COLOR;
        this._bpStyle = VARNAConfig.DEFAULT_BP_STYLE;
        this._highlightRegion = "";
        this._baseOutlineColor = VARNAConfig.BASE_OUTLINE_COLOR_DEFAULT;
        this._baseInnerColor = VARNAConfig.BASE_INNER_COLOR_DEFAULT;
        this._baseNumColor = VARNAConfig.BASE_NUMBER_COLOR_DEFAULT;
        this._baseNameColor = VARNAConfig.BASE_NAME_COLOR_DEFAULT;
        this._titleColor = VARNAConfig.DEFAULT_TITLE_COLOR;
        this._warning = false;
        this._error = true;
        this._modifiable = true;
        this._zoom = 1.0;
        this._zoomAmount = 1.2;
        this._comparisonMode = false;
        this._firstSequence = "";
        this._firstStructure = "";
        this._secondSequence = "";
        this._secondStructure = "";
        this._gapsColor = VARNAConfig.DEFAULT_DASH_BASE_COLOR;
        this._useGapsColor = false;
        this._nonStandardColor = VARNAConfig.DEFAULT_SPECIAL_BASE_COLOR;
        this._useNonStandardColor = false;
        this._useInnerBaseColor = false;
        this._useBaseNameColor = false;
        this._useBaseNumbersColor = false;
        this._useBaseOutlineColor = false;
        this._bpIncrement = 0.65;
        this._URL = "";
        this._flatExteriorLoop = true;
        this._flip = "";
        this._orientation = "";
        this._spaceBetweenBases = VARNAConfig.DEFAULT_SPACE_BETWEEN_BASES;
    }

    public static Color getSafeColor(String string, Color color) {
        Color color2;
        try {
            color2 = Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                color2 = Color.getColor(string, color);
            }
            catch (Exception exception) {
                return color;
            }
        }
        return color2;
    }

    private VARNAConfig.BP_STYLE getSafeBPStyle(String string, VARNAConfig.BP_STYLE bP_STYLE) {
        VARNAConfig.BP_STYLE bP_STYLE2 = VARNAConfig.BP_STYLE.getStyle(string);
        if (bP_STYLE2 != null) {
            return bP_STYLE2;
        }
        return bP_STYLE;
    }

    public static String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{algoOpt, "String", "Drawing algorithm, choosen from [naview,line,radiate,circular]"}, {annotationsOpt, "string", "A set of textual annotations"}, {applyBasesStyleOpt, "String", "Base style application"}, {auxBPsOpt, "String", "Adds a list of (possibly non-canonical) base-pairs to those already defined by the main secondary structure (Ex: \"(1,10);(2,11);(3,12)\"). Custom BP styles can be specified (Ex: \"(2,11):thickness=4;(3,12):color=#FF0000\")."}, {autoHelicesOpt, "", ""}, {autoInteriorLoopsOpt, "", ""}, {autoTerminalLoopsOpt, "", ""}, {backboneColorOpt, "Color", "Backbone color (Ex: #334455)"}, {backgroundColorOpt, "Color", "Background color (Ex: #334455)"}, {baseInnerColorOpt, "Color", "Default value for inner base color (Ex: #334455)"}, {baseNameColorOpt, "Color", "Residues font color (Ex: #334455)"}, {baseNumbersColorOpt, "Color", "Base numbers font color (Ex: #334455)"}, {baseOutlineColorOpt, "Color", "Base outline color (Ex: #334455)"}, {basesStyleOpt, "String", "Base style declaration"}, {borderOpt, "String", "Border width and height in pixels (Ex: \"20x40\")"}, {bondColorOpt, "Color", "Base pair color (Ex: #334455)"}, {bpIncrementOpt, "float", "Distance between nested base-pairs (i.e. arcs) in linear representation"}, {bpStyleOpt, "String", "Look and feel for base pairs drawings, choosen from [lw,lwalt,none,simple,rnaviz]"}, {chemProbOpt, "", ""}, {colorMapOpt, "String", "Associates a list of numerical values (eg '0.2,0.4,0.6,0.8') with the RNA bases with respect to their natural order, and modifies the color used to fill these bases according to current color map style."}, {colorMapCaptionOpt, "String", "Sets current color map caption."}, {colorMapDefOpt, "String", "Selects a specific color map style. It can be either one of the predefined styles (eg 'red', 'green', 'blue', 'bw', 'heat', 'energy') or a new one (eg '0:#FFFF00;1:#ffFFFF;6:#FF0000')."}, {colorMapMinOpt, "", ""}, {colorMapMaxOpt, "", ""}, {comparisonModeOpt, "boolean", "Activates comparison mode"}, {customBasesOpt, "", ""}, {customBPsOpt, "", ""}, {drawBackboneOpt, "boolean", "True if the backbone must be drawn, false otherwise"}, {drawColorMapOpt, "", ""}, {drawNCOpt, "boolean", "Toggles on/off display of non-canonical base-pairs"}, {drawBasesOpt, "boolean", "Shows/hide the outline of bases"}, {drawTertiaryOpt, "boolean", "Toggles on/off display of tertiary interaction, ie pseudoknots"}, {errorOpt, "boolean", "Show errors"}, {fillBasesOpt, "boolean", "Fills or leaves empty the inner portions of bases"}, {firstSequenceForComparisonOpt, "String", "In comparison mode, sequence of first RNA"}, {firstStructureForComparisonOpt, "String", "In comparison mode, structure of first RNA"}, {flatExteriorLoopOpt, "boolean", "Toggles on/off (true/false) drawing exterior bases on a straight line"}, {flipOpt, "String", "Draws a set of exterior helices, identified by the argument string, in clockwise order (default drawing is counter-clockwise). The argument is a semicolon-separated list of helices, each identified by a base or a base-pair (eg. \"2;20-34\")."}, {gapsBaseColorOpt, "Color", "Define and use custom color for gaps bases in comparison mode"}, {highlightRegionOpt, "string", "Highlight a set of contiguous regions"}, {modifiableOpt, "boolean", "Allows/prohibits modifications"}, {nonStandardColorOpt, "Color", "Define and use custom color for non-standard bases in comparison mode"}, {numColumnsOpt, "int", "Sets number of columns"}, {numRowsOpt, "int", "Sets number of rows"}, {orientationOpt, "float", "Sets the general orientation of an RNA, i.e. the deviation of the longest axis (defined by the most distant couple of bases) from the horizontal axis."}, {periodNumOpt, "int", "Periodicity of base-numbering"}, {secondSequenceForComparisonOpt, "String", "In comparison mode, sequence of second RNA"}, {secondStructureForComparisonOpt, "String", "In comparison mode, structure of second RNA"}, {sequenceOpt, "String", "Raw RNA sequence"}, {structureOpt, "String", "RNA structure given in dot bracket notation (DBN)"}, {rotationOpt, "float", "Rotates RNA after initial drawing (Ex: '20' for a 20 degree counter-clockwise rotation)"}, {titleOpt, "String", "RNA drawing title"}, {titleColorOpt, "Color", "Title color (Ex: #334455)"}, {titleSizeOpt, "int", "Title font size"}, {spaceBetweenBasesOpt, "float", "Sets the space between consecutive bases"}, {warningOpt, "boolean", "Show warnings"}, {zoomOpt, "int", "Zoom coefficient"}, {zoomAmountOpt, "int", "Zoom increment on user interaction"}};
        return stringArray;
    }

    private void retrieveParametersValues() throws ExceptionParameterError {
        String string;
        int n;
        this._numRows = 1;
        this._numColumns = 1;
        this._basesStyleList = new ArrayList();
        try {
            this._numRows = Integer.parseInt(this._optionProducer.getParameterValue(numRowsOpt, "" + this._numRows));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(numRowsOpt, "" + this._numRows) + "' is not a integer value for the number of rows !");
        }
        try {
            this._numColumns = Integer.parseInt(this._optionProducer.getParameterValue(numColumnsOpt, "" + this._numColumns));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(numColumnsOpt, "" + this._numColumns) + "' is not a integer value for the number of columns !");
        }
        String string2 = null;
        for (n = 0; n < 50; ++n) {
            string = basesStyleOpt + n;
            string2 = this._optionProducer.getParameterValue(string, null);
            if (string2 != null) {
                ModelBaseStyle modelBaseStyle = new ModelBaseStyle();
                try {
                    modelBaseStyle.assignParameters(string2);
                }
                catch (ExceptionModeleStyleBaseSyntaxError exceptionModeleStyleBaseSyntaxError) {
                    VARNAPanel.emitWarningStatic(exceptionModeleStyleBaseSyntaxError, null);
                }
                this._basesStyleList.add(modelBaseStyle);
                continue;
            }
            this._basesStyleList.add(null);
        }
        this.initValues();
        for (int i = 0; i < this._numColumns; ++i) {
            for (int j = 0; j < this._numRows; ++j) {
                try {
                    n = 1 + j + i * this._numRows;
                    string = "" + n;
                    if (this._numColumns == 1 && this._numRows == 1) {
                        string = "";
                    }
                    this._useGapsColor = false;
                    this._useNonStandardColor = false;
                    string2 = this._optionProducer.getParameterValue(baseNameColorOpt + string, "");
                    if (!string2.equals("")) {
                        this._useBaseNameColor = true;
                        this._baseNameColor = VARNAConfigLoader.getSafeColor(string2, this._baseNameColor);
                    }
                    if (!(string2 = this._optionProducer.getParameterValue(baseNumbersColorOpt + string, "")).equals("")) {
                        this._useBaseNumbersColor = true;
                        this._baseNumColor = VARNAConfigLoader.getSafeColor(string2, this._baseNumColor);
                    }
                    if (!(string2 = this._optionProducer.getParameterValue(baseOutlineColorOpt + string, "")).equals("")) {
                        this._useBaseOutlineColor = true;
                        this._baseOutlineColor = VARNAConfigLoader.getSafeColor(string2, this._baseOutlineColor);
                    }
                    if (!(string2 = this._optionProducer.getParameterValue(baseInnerColorOpt + string, "")).equals("")) {
                        this._useInnerBaseColor = true;
                        this._baseInnerColor = VARNAConfigLoader.getSafeColor(string2, this._baseInnerColor);
                    }
                    if (!(string2 = this._optionProducer.getParameterValue(nonStandardColorOpt + string, "")).equals("")) {
                        this._nonStandardColor = VARNAConfigLoader.getSafeColor(string2, this._nonStandardColor);
                        this._useNonStandardColor = true;
                    }
                    if (!(string2 = this._optionProducer.getParameterValue(gapsBaseColorOpt + string, this._gapsColor.toString())).equals("")) {
                        this._gapsColor = VARNAConfigLoader.getSafeColor(string2, this._gapsColor);
                        this._useGapsColor = true;
                    }
                    try {
                        this._rotation = Double.parseDouble(this._optionProducer.getParameterValue(rotationOpt + string, Double.toString(this._rotation)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(rotationOpt + string, "" + this._rotation) + "' is not a valid float value for rotation!");
                    }
                    try {
                        this._colorMapMin = Double.parseDouble(this._optionProducer.getParameterValue(colorMapMinOpt + string, Double.toString(this._colorMapMin)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(colorMapMinOpt + string, "" + this._colorMapMin) + "' is not a valid double value for min color map values range!");
                    }
                    try {
                        this._colorMapMax = Double.parseDouble(this._optionProducer.getParameterValue(colorMapMaxOpt + string, Double.toString(this._colorMapMax)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(colorMapMaxOpt + string, "" + this._colorMapMax) + "' is not a valid double value for max color map values range!");
                    }
                    try {
                        this._bpIncrement = Double.parseDouble(this._optionProducer.getParameterValue(bpIncrementOpt + string, Double.toString(this._bpIncrement)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        this._periodResNum = Integer.parseInt(this._optionProducer.getParameterValue(periodNumOpt + string, "" + this._periodResNum));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(periodNumOpt + string, "" + this._periodResNum) + "' is not a valid integer value for the period of residue numbers!");
                    }
                    try {
                        this._titleSize = Integer.parseInt(this._optionProducer.getParameterValue(titleSizeOpt + string, "" + this._titleSize));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(titleSizeOpt + string, "" + this._titleSize) + "' is not a valid integer value for the number of rows !");
                    }
                    try {
                        this._zoom = Double.parseDouble(this._optionProducer.getParameterValue(zoomOpt + string, "" + this._zoom));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(zoomOpt + string, "" + this._zoom) + "' is not a valid integer value for the zoom !");
                    }
                    try {
                        this._zoomAmount = Double.parseDouble(this._optionProducer.getParameterValue(zoomAmountOpt + string, "" + this._zoomAmount));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(zoomAmountOpt + string, "" + this._zoomAmount) + "' is not a valid integer value for the zoom amount!");
                    }
                    try {
                        this._spaceBetweenBases = Double.parseDouble(this._optionProducer.getParameterValue(spaceBetweenBasesOpt + string, "" + this._spaceBetweenBases));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionParameterError(numberFormatException.getMessage(), "'" + this._optionProducer.getParameterValue(spaceBetweenBasesOpt + string, "" + this._spaceBetweenBases) + "' is not a valid integer value for the base spacing!");
                    }
                    this._drawBases = Boolean.parseBoolean(this._optionProducer.getParameterValue(drawBasesOpt + string, "" + this._drawBases));
                    this._fillBases = Boolean.parseBoolean(this._optionProducer.getParameterValue(fillBasesOpt + string, "" + this._fillBases));
                    this._autoHelices = Boolean.parseBoolean(this._optionProducer.getParameterValue(autoHelicesOpt + string, "" + this._autoHelices));
                    this._drawColorMap = Boolean.parseBoolean(this._optionProducer.getParameterValue(drawColorMapOpt + string, "" + this._drawColorMap));
                    this._drawBackbone = Boolean.parseBoolean(this._optionProducer.getParameterValue(drawBackboneOpt + string, "" + this._drawBackbone));
                    this._colorMapValues = this._optionProducer.getParameterValue(colorMapOpt + string, this._colorMapValues);
                    this._autoTerminalLoops = Boolean.parseBoolean(this._optionProducer.getParameterValue(autoTerminalLoopsOpt + string, "" + this._autoTerminalLoops));
                    this._autoInteriorLoops = Boolean.parseBoolean(this._optionProducer.getParameterValue(autoInteriorLoopsOpt + string, "" + this._autoInteriorLoops));
                    this._drawNC = Boolean.parseBoolean(this._optionProducer.getParameterValue(drawNCOpt + string, "" + this._drawNC));
                    this._flatExteriorLoop = Boolean.parseBoolean(this._optionProducer.getParameterValue(flatExteriorLoopOpt + string, "" + this._flatExteriorLoop));
                    this._drawTertiary = Boolean.parseBoolean(this._optionProducer.getParameterValue(drawTertiaryOpt + string, "" + this._drawTertiary));
                    this._warning = Boolean.parseBoolean(this._optionProducer.getParameterValue(warningOpt + string, "false"));
                    this._error = Boolean.parseBoolean(this._optionProducer.getParameterValue(errorOpt + string, "true"));
                    this._border = this.parseDimension(this._optionProducer.getParameterValue(borderOpt + string, "0X0"));
                    this._comparisonMode = Boolean.parseBoolean(this._optionProducer.getParameterValue(comparisonModeOpt + string, "false"));
                    this._firstSequence = this._optionProducer.getParameterValue(firstSequenceForComparisonOpt + string, this._firstSequence);
                    this._firstStructure = this._optionProducer.getParameterValue(firstStructureForComparisonOpt + string, this._firstStructure);
                    this._secondSequence = this._optionProducer.getParameterValue(secondSequenceForComparisonOpt + string, this._secondSequence);
                    this._secondStructure = this._optionProducer.getParameterValue(secondStructureForComparisonOpt + string, this._secondStructure);
                    this._annotations = this._optionProducer.getParameterValue(annotationsOpt + string, this._annotations);
                    this._URL = this._optionProducer.getParameterValue(URLOpt + string, this._URL);
                    this._algo = this._optionProducer.getParameterValue(algoOpt + string, this._algo);
                    this._customBases = this._optionProducer.getParameterValue(customBasesOpt + string, this._customBases);
                    this._auxBPs = this._optionProducer.getParameterValue(auxBPsOpt + string, this._auxBPs);
                    this._highlightRegion = this._optionProducer.getParameterValue(highlightRegionOpt + string, this._highlightRegion);
                    this._chemProbs = this._optionProducer.getParameterValue(chemProbOpt + string, this._chemProbs);
                    this._customBPs = this._optionProducer.getParameterValue(customBPsOpt + string, this._customBPs);
                    this._colorMapStyle = this._optionProducer.getParameterValue(colorMapDefOpt + string, this._colorMapStyle);
                    this._colorMapCaption = this._optionProducer.getParameterValue(colorMapCaptionOpt + string, this._colorMapCaption);
                    this._backboneColor = VARNAConfigLoader.getSafeColor(this._optionProducer.getParameterValue(backboneColorOpt + string, this._backboneColor.toString()), this._backboneColor);
                    this._backgroundColor = VARNAConfigLoader.getSafeColor(this._optionProducer.getParameterValue(backgroundColorOpt + string, this._backgroundColor.toString()), this._backgroundColor);
                    this._bondColor = VARNAConfigLoader.getSafeColor(this._optionProducer.getParameterValue(bondColorOpt + string, this._bondColor.toString()), this._bondColor);
                    this._bpStyle = this.getSafeBPStyle(this._optionProducer.getParameterValue(bpStyleOpt + string, ""), this._bpStyle);
                    this._flip = this._optionProducer.getParameterValue(flipOpt + string, this._flip);
                    this._orientation = this._optionProducer.getParameterValue(orientationOpt + string, this._orientation);
                    this._titleColor = VARNAConfigLoader.getSafeColor(this._optionProducer.getParameterValue(titleColorOpt + string, this._titleColor.toString()), this._titleColor);
                    if (!this._URL.equals("")) {
                        this._sstruct = "";
                        this._sseq = "";
                        this._title = "";
                    }
                    this._title = this._optionProducer.getParameterValue(titleOpt + string, this._title);
                    if (!this._comparisonMode || this._firstSequence == null || this._firstStructure == null || this._secondSequence == null || this._secondStructure == null) {
                        this._sseq = this._optionProducer.getParameterValue(sequenceOpt + string, this._sseq);
                        this._sstruct = this._optionProducer.getParameterValue(structureOpt + string, this._sstruct);
                        if (!this._sseq.equals("") && !this._sstruct.equals("")) {
                            this._URL = "";
                        }
                        this._comparisonMode = false;
                    }
                    this.applyValues(string);
                    continue;
                }
                catch (ExceptionParameterError exceptionParameterError) {
                    VARNAPanel.errorDialogStatic(exceptionParameterError, this._mainSurface);
                    continue;
                }
                catch (ExceptionNonEqualLength exceptionNonEqualLength) {
                    VARNAPanel.errorDialogStatic(exceptionNonEqualLength, this._mainSurface);
                    continue;
                }
                catch (IOException iOException) {
                    VARNAPanel.errorDialogStatic(iOException, this._mainSurface);
                    continue;
                }
                catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                    VARNAPanel.errorDialogStatic(exceptionFileFormatOrSyntax, this._mainSurface);
                    continue;
                }
                catch (ExceptionLoadingFailed exceptionLoadingFailed) {
                    VARNAPanel.errorDialogStatic(exceptionLoadingFailed, this._mainSurface);
                }
            }
        }
    }

    public void setRNA(RNA rNA) {
        this._defaultRNA = rNA;
    }

    private void applyValues(String string) throws ExceptionParameterError, ExceptionNonEqualLength, IOException, ExceptionFileFormatOrSyntax, ExceptionLoadingFailed {
        boolean bl = true;
        int n = this._algo.equals(ALGORITHM_CIRCULAR) ? 1 : (this._algo.equals(ALGORITHM_NAVIEW) ? 3 : (this._algo.equals(ALGORITHM_LINE) ? 4 : (this._algo.equals(ALGORITHM_RADIATE) ? 2 : (this._algo.equals(ALGORITHM_VARNA_VIEW) ? 5 : (this._algo.equals(ALGORITHM_MOTIF_VIEW) ? 6 : 2)))));
        this._mainSurface = this._comparisonMode ? new VARNAPanel(this._firstSequence, this._firstStructure, this._secondSequence, this._secondStructure, n, "") : new VARNAPanel();
        this._VARNAPanelList.add(this._mainSurface);
        this._mainSurface.setSpaceBetweenBases(this._spaceBetweenBases);
        this._mainSurface.setTitle(this._title);
        if (!this._URL.equals("")) {
            URL uRL = null;
            try {
                this._mainSurface.setSpaceBetweenBases(this._spaceBetweenBases);
                uRL = new URL(this._URL);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                InputStream inputStream = uRLConnection.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                if (this._URL.toLowerCase().endsWith(VARNAPanel.VARNA_SESSION_EXTENSION)) {
                    FullBackup fullBackup = VARNAPanel.importSession(inputStream, this._URL);
                    this._mainSurface.setConfig(fullBackup.config);
                    this._mainSurface.showRNA(fullBackup.rna);
                    bl = false;
                } else {
                    ArrayList<RNA> arrayList = RNAFactory.loadSecStr(new BufferedReader(inputStreamReader), RNAFactory.guessFileTypeFromExtension(this._URL));
                    if (arrayList.isEmpty()) {
                        throw new ExceptionFileFormatOrSyntax("No RNA in file '" + this._URL + "'.");
                    }
                    RNA rNA = (RNA)arrayList.iterator().next();
                    rNA.drawRNA(n, this._mainSurface.getConfig());
                    this._mainSurface.drawRNA(rNA, n);
                }
                if (!this._title.isEmpty()) {
                    this._mainSurface.setTitle(this._title);
                }
            }
            catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                if (uRL != null) {
                    exceptionFileFormatOrSyntax.setPath(uRL.getPath());
                }
            }
            catch (ExceptionDrawingAlgorithm exceptionDrawingAlgorithm) {
                this._mainSurface.emitWarning(exceptionDrawingAlgorithm.getMessage());
            }
        } else if (!this._comparisonMode) {
            if (!this._sstruct.equals("")) {
                this._mainSurface.drawRNA(this._sseq, this._sstruct, n);
            } else {
                try {
                    System.err.println("Printing default RNA " + this._defaultRNA);
                    this._defaultRNA.drawRNA(n, this._mainSurface.getConfig());
                }
                catch (ExceptionDrawingAlgorithm exceptionDrawingAlgorithm) {
                    exceptionDrawingAlgorithm.printStackTrace();
                }
                this._mainSurface.drawRNA(this._defaultRNA);
            }
        }
        if (bl) {
            if (this._useInnerBaseColor) {
                this._mainSurface.setBaseInnerColor(this._baseInnerColor);
            }
            if (this._useBaseOutlineColor) {
                this._mainSurface.setBaseOutlineColor(this._baseOutlineColor);
            }
            if (this._useBaseNameColor) {
                this._mainSurface.setBaseNameColor(this._baseNameColor);
            }
            if (this._useBaseNumbersColor) {
                this._mainSurface.setBaseNumbersColor(this._baseNumColor);
            }
            this._mainSurface.setBackground(this._backgroundColor);
            this._mainSurface.setNumPeriod(this._periodResNum);
            this._mainSurface.setBackboneColor(this._backboneColor);
            this._mainSurface.setDefaultBPColor(this._bondColor);
            this._mainSurface.setBPHeightIncrement(this._bpIncrement);
            this._mainSurface.setBPStyle(this._bpStyle);
            this._mainSurface.setDrawBackbone(this._drawBackbone);
            this._mainSurface.setTitleFontColor(this._titleColor);
            this._mainSurface.setTitleFontSize(this._titleSize);
            this._mainSurface.getPopupMenu().get_itemShowWarnings().setState(this._warning);
            this._mainSurface.setErrorsOn(this._error);
            this._mainSurface.setFlatExteriorLoop(this._flatExteriorLoop);
            this._mainSurface.setZoom(this._zoom);
            this._mainSurface.setZoomIncrement(this._zoomAmount);
            this._mainSurface.setBorderSize(this._border);
            if (this._useGapsColor) {
                this._mainSurface.setGapsBasesColor(this._gapsColor);
                this._mainSurface.setColorGapsBases(true);
            }
            if (this._useNonStandardColor) {
                this._mainSurface.setNonStandardBasesColor(this._nonStandardColor);
                this._mainSurface.setColorNonStandardBases(true);
            }
            this._mainSurface.setShowNonPlanarBP(this._drawTertiary);
            this._mainSurface.setShowNonCanonicalBP(this._drawNC);
            this.applyBasesStyle(string);
            if (!this._customBases.equals("")) {
                this.applyBasesCustomStyles(this._mainSurface);
            }
            if (!this._highlightRegion.equals("")) {
                this.applyHighlightRegion(this._mainSurface);
            }
            if (!this._auxBPs.equals("")) {
                this.applyAuxBPs(this._mainSurface);
            }
            if (!this._chemProbs.equals("")) {
                this.applyChemProbs(this._mainSurface);
            }
            if (!this._customBPs.equals("")) {
                this.applyBPsCustomStyles(this._mainSurface);
            }
            this._mainSurface.setDrawOutlineBases(this._drawBases);
            this._mainSurface.setFillBases(this._fillBases);
            this._mainSurface.drawRNA();
            if (!this._annotations.equals("")) {
                this.applyAnnotations(this._mainSurface);
            }
            if (this._autoHelices) {
                this._mainSurface.getVARNAUI().UIAutoAnnotateHelices();
            }
            if (this._autoTerminalLoops) {
                this._mainSurface.getVARNAUI().UIAutoAnnotateTerminalLoops();
            }
            if (this._autoInteriorLoops) {
                this._mainSurface.getVARNAUI().UIAutoAnnotateInteriorLoops();
            }
            if (!this._orientation.equals("")) {
                try {
                    double d = 360.0 * this._mainSurface.getOrientation() / (Math.PI * 2);
                    this._rotation = Double.parseDouble(this._orientation) - d;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this._mainSurface.globalRotation(this._rotation);
            this._mainSurface.setModifiable(this._modifiable);
            this._mainSurface.setColorMapCaption(this._colorMapCaption);
            this.applyColorMapStyle(this._mainSurface);
            this.applyFlips(this._mainSurface);
            this.applyColorMapValues(this._mainSurface);
        }
    }

    private void applyBasesStyle(String string) throws ExceptionParameterError {
        String string2 = null;
        for (int i = 0; i < this._basesStyleList.size(); ++i) {
            int n;
            if (this._basesStyleList.get(i) == null) continue;
            string2 = this._optionProducer.getParameterValue(applyBasesStyleOpt + i + "on" + string, null);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (string2 == null) continue;
            String[] stringArray = string2.split(",");
            for (n = 0; n < stringArray.length; ++n) {
                String string3 = stringArray[n].trim();
                try {
                    int n2;
                    int n3;
                    String[] stringArray2 = string3.split("-");
                    if (stringArray2.length == 1) {
                        n3 = Integer.parseInt(string3);
                        n2 = this._mainSurface.getRNA().getIndexFromBaseNumber(n3);
                        if (n2 == -1) continue;
                        arrayList.add(n2);
                        continue;
                    }
                    if (stringArray2.length != 2) continue;
                    n3 = Integer.parseInt(stringArray2[0].trim());
                    n2 = this._mainSurface.getRNA().getIndexFromBaseNumber(n3);
                    int n4 = Integer.parseInt(stringArray2[1].trim());
                    int n5 = this._mainSurface.getRNA().getIndexFromBaseNumber(n4);
                    if (n2 == -1 || n5 == -1) continue;
                    for (int j = n2; j <= n5; ++j) {
                        arrayList.add(j);
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExceptionParameterError(numberFormatException.getMessage(), "Bad Base Index: " + stringArray[n]);
                }
            }
            for (n = 0; n < arrayList.size(); ++n) {
                int n6 = (Integer)arrayList.get(n);
                if (n6 < 0 || n6 >= this._mainSurface.getRNA().get_listeBases().size()) continue;
                this._mainSurface.getRNA().get_listeBases().get(n6).setStyleBase(this._basesStyleList.get(i));
            }
        }
    }

    private void applyColorMapStyle(VARNAPanel vARNAPanel) {
        if (this._colorMapStyle.length() != 0) {
            vARNAPanel.setColorMap(ModeleColorMap.parseColorMap(this._colorMapStyle));
        }
    }

    private void applyColorMapValues(VARNAPanel vARNAPanel) {
        if (!this._colorMapValues.equals("")) {
            String[] stringArray = this._colorMapValues.split("[;,]");
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    arrayList.add(Double.parseDouble(stringArray[i]));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Double[] doubleArray = new Double[arrayList.size()];
            arrayList.toArray(doubleArray);
            vARNAPanel.setColorMapValues(doubleArray);
            ModeleColorMap modeleColorMap = vARNAPanel.getColorMap();
            if (this._colorMapMin != Double.MIN_VALUE) {
                modeleColorMap.setMinValue(this._colorMapMin);
            }
            if (this._colorMapMax != Double.MAX_VALUE) {
                modeleColorMap.setMaxValue(this._colorMapMax);
            }
            this._drawColorMap = true;
        }
    }

    private void applyBasesCustomStyles(VARNAPanel vARNAPanel) {
        String[] stringArray = this._customBases.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split(":");
            try {
                if (stringArray2.length != 2) continue;
                int n = Integer.parseInt(stringArray2[0]);
                int n2 = this._mainSurface.getRNA().getIndexFromBaseNumber(n);
                if (n2 == -1) continue;
                String string2 = stringArray2[1];
                ModelBaseStyle modelBaseStyle = vARNAPanel.getRNA().get_listeBases().get(n2).getStyleBase().clone();
                modelBaseStyle.assignParameters(string2);
                vARNAPanel.getRNA().get_listeBases().get(n2).setStyleBase(modelBaseStyle);
                continue;
            }
            catch (Exception exception) {
                System.err.println("ApplyBasesCustomStyle: " + exception.toString());
            }
        }
    }

    private void applyHighlightRegion(VARNAPanel vARNAPanel) {
        String[] stringArray = this._highlightRegion.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                HighlightRegionAnnotation highlightRegionAnnotation = HighlightRegionAnnotation.parseHighlightRegionAnnotation(string, vARNAPanel);
                if (highlightRegionAnnotation == null) continue;
                vARNAPanel.addHighlightRegion(highlightRegionAnnotation);
                continue;
            }
            catch (Exception exception) {
                System.err.println("applyHighlightRegion: " + exception.toString());
            }
        }
    }

    private Dimension parseDimension(String string) {
        Dimension dimension = new Dimension(0, 0);
        try {
            string = string.toLowerCase();
            int n = string.indexOf(120);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            dimension.width = Integer.parseInt(string2);
            dimension.height = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dimension;
    }

    private void applyBPsCustomStyles(VARNAPanel vARNAPanel) {
        String[] stringArray = this._customBPs.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split(":");
            try {
                if (stringArray2.length != 2) continue;
                String string2 = stringArray2[0];
                String string3 = stringArray2[1];
                String[] stringArray3 = string2.split(",");
                if (stringArray3.length != 2) continue;
                String string4 = stringArray3[0];
                String string5 = stringArray3[1];
                if (!string4.startsWith("(") || !string5.endsWith(")")) continue;
                int n = Integer.parseInt(string4.substring(1));
                int n2 = Integer.parseInt(string5.substring(0, string5.length() - 1));
                ModeleBP modeleBP = vARNAPanel.getRNA().getBPStyle(n, n2);
                if (modeleBP == null) continue;
                modeleBP.assignParameters(string3);
                continue;
            }
            catch (Exception exception) {
                System.err.println("ApplyBPsCustomStyle: " + exception.toString());
            }
        }
    }

    private void applyChemProbs(VARNAPanel vARNAPanel) {
        String[] stringArray = this._chemProbs.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split(":");
            try {
                if (stringArray2.length != 2) continue;
                String string2 = stringArray2[0];
                String string3 = stringArray2[1];
                String[] stringArray3 = string2.split("-");
                if (stringArray3.length != 2) continue;
                int n = Integer.parseInt(stringArray3[0]);
                int n2 = Integer.parseInt(stringArray3[1]);
                int n3 = vARNAPanel.getRNA().getIndexFromBaseNumber(n);
                int n4 = vARNAPanel.getRNA().getIndexFromBaseNumber(n2);
                ArrayList<ModeleBase> arrayList = vARNAPanel.getRNA().get_listeBases();
                ChemProbAnnotation chemProbAnnotation = new ChemProbAnnotation(arrayList.get(n3), arrayList.get(n4), string3);
                vARNAPanel.getRNA().addChemProbAnnotation(chemProbAnnotation);
                continue;
            }
            catch (Exception exception) {
                System.err.println("ChempProbs: " + exception.toString());
            }
        }
    }

    private void applyAuxBPs(VARNAPanel vARNAPanel) {
        String[] stringArray = this._auxBPs.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split(":");
            try {
                String string2;
                String[] stringArray3;
                if (stringArray2.length < 1 || (stringArray3 = (string2 = stringArray2[0]).split(",")).length != 2) continue;
                String string3 = stringArray3[0];
                String string4 = stringArray3[1];
                if (!string3.startsWith("(") || !string4.endsWith(")")) continue;
                int n = Integer.parseInt(string3.substring(1));
                int n2 = Integer.parseInt(string4.substring(0, string4.length() - 1));
                int n3 = vARNAPanel.getRNA().getIndexFromBaseNumber(n);
                int n4 = vARNAPanel.getRNA().getIndexFromBaseNumber(n2);
                ModeleBP modeleBP = new ModeleBP(vARNAPanel.getRNA().get_listeBases().get(n3), vARNAPanel.getRNA().get_listeBases().get(n4));
                if (stringArray2.length >= 2) {
                    String string5 = stringArray2[1];
                    modeleBP.assignParameters(string5);
                }
                vARNAPanel.getRNA().addBPToStructureUsingNumbers(n, n2, modeleBP);
                continue;
            }
            catch (ExceptionModeleStyleBaseSyntaxError exceptionModeleStyleBaseSyntaxError) {
                System.err.println("AuxApplyBPs: " + exceptionModeleStyleBaseSyntaxError.toString());
                continue;
            }
            catch (ExceptionParameterError exceptionParameterError) {
                exceptionParameterError.printStackTrace();
            }
        }
    }

    private void applyFlips(VARNAPanel vARNAPanel) {
        String[] stringArray;
        for (String string : stringArray = this._flip.split(";")) {
            if (string.isEmpty()) continue;
            try {
                String[] stringArray2 = string.split("-");
                int n = -1;
                if (stringArray2.length == 1) {
                    n = Integer.parseInt(stringArray2[0]);
                } else if (stringArray2.length == 2) {
                    n = Integer.parseInt(stringArray2[1]);
                }
                if (n == -1) continue;
                int n2 = vARNAPanel.getRNA().getIndexFromBaseNumber(n);
                Point point = vARNAPanel.getRNA().getExteriorHelix(n2);
                vARNAPanel.getRNA().flipHelix(point);
            }
            catch (Exception exception) {
                System.err.println("Flip Helices: " + exception.toString());
            }
        }
    }

    private void applyAnnotations(VARNAPanel vARNAPanel) {
        String[] stringArray = this._annotations.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split(":");
            String string2 = "";
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            TextAnnotation.AnchorType anchorType = TextAnnotation.AnchorType.LOOP;
            Font font = TextAnnotation.DEFAULTFONT;
            Color color = TextAnnotation.DEFAULTCOLOR;
            TextAnnotation textAnnotation = null;
            try {
                Iterator iterator;
                Object object;
                Object object2;
                int n4;
                if (stringArray2.length != 2) continue;
                string2 = stringArray2[0];
                String[] stringArray3 = stringArray2[1].split(",");
                for (n4 = 0; n4 < stringArray3.length; ++n4) {
                    object2 = stringArray3[n4];
                    object = ((String)object2).split("=");
                    if (((String[])object).length != 2) continue;
                    iterator = object[0].toLowerCase();
                    String string3 = object[1];
                    if (((String)((Object)iterator)).equals("type")) {
                        if (string3.toUpperCase().equals("H")) {
                            anchorType = TextAnnotation.AnchorType.HELIX;
                            continue;
                        }
                        if (string3.toUpperCase().equals("L")) {
                            anchorType = TextAnnotation.AnchorType.LOOP;
                            continue;
                        }
                        if (string3.toUpperCase().equals("P")) {
                            anchorType = TextAnnotation.AnchorType.POSITION;
                            continue;
                        }
                        if (!string3.toUpperCase().equals("B")) continue;
                        anchorType = TextAnnotation.AnchorType.BASE;
                        continue;
                    }
                    if (((String)((Object)iterator)).equals("x")) {
                        n2 = Integer.parseInt(string3);
                        continue;
                    }
                    if (((String)((Object)iterator)).equals("y")) {
                        n3 = Integer.parseInt(string3);
                        continue;
                    }
                    if (((String)((Object)iterator)).equals("anchor")) {
                        n = Integer.parseInt(string3);
                        continue;
                    }
                    if (((String)((Object)iterator)).equals("size")) {
                        font = font.deriveFont((float)Integer.parseInt(string3));
                        continue;
                    }
                    if (!((String)((Object)iterator)).equals("color")) continue;
                    color = VARNAConfigLoader.getSafeColor(string3, color);
                }
                switch (anchorType) {
                    case POSITION: {
                        if (n2 == -1 || n3 == -1) break;
                        Point2D.Double double_ = vARNAPanel.panelToLogicPoint(new Point2D.Double(n2, n3));
                        textAnnotation = new TextAnnotation(string2, double_.x, double_.y);
                        break;
                    }
                    case BASE: {
                        if (n == -1) break;
                        n4 = vARNAPanel.getRNA().getIndexFromBaseNumber(n);
                        object2 = vARNAPanel.getRNA().get_listeBases().get(n4);
                        textAnnotation = new TextAnnotation(string2, (ModeleBase)object2);
                        break;
                    }
                    case HELIX: {
                        if (n == -1) break;
                        ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
                        int n5 = vARNAPanel.getRNA().getIndexFromBaseNumber(n);
                        object = vARNAPanel.getRNA().findHelix(n5);
                        iterator = ((ArrayList)object).iterator();
                        while (iterator.hasNext()) {
                            int n6 = (Integer)iterator.next();
                            arrayList.add(vARNAPanel.getRNA().get_listeBases().get(n6));
                        }
                        textAnnotation = new TextAnnotation(string2, arrayList, anchorType);
                        break;
                    }
                    case LOOP: {
                        if (n == -1) break;
                        ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
                        int n7 = vARNAPanel.getRNA().getIndexFromBaseNumber(n);
                        object = vARNAPanel.getRNA().findLoop(n7);
                        iterator = ((ArrayList)object).iterator();
                        while (iterator.hasNext()) {
                            int n8 = (Integer)iterator.next();
                            arrayList.add(vARNAPanel.getRNA().get_listeBases().get(n8));
                        }
                        textAnnotation = new TextAnnotation(string2, arrayList, anchorType);
                    }
                }
                if (textAnnotation == null) continue;
                textAnnotation.setColor(color);
                textAnnotation.setFont(font);
                vARNAPanel.addAnnotation(textAnnotation);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Apply Annotations: " + exception.toString());
            }
        }
    }
}

