/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.factories;

import fr.orsay.lri.varna.factories.RNAAlignment;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;

public class StockholmIO {
    public static RNAAlignment readAlignementFromFile(String string) throws IOException {
        return StockholmIO.readAlignement(new BufferedReader(new FileReader(string)));
    }

    public static RNAAlignment readAlignementFromURL(String string) throws UnsupportedEncodingException, IOException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream(), "UTF-8");
        return StockholmIO.readAlignement(new BufferedReader(inputStreamReader));
    }

    public static RNAAlignment readAlignement(BufferedReader bufferedReader) throws IOException {
        String string;
        LinkedHashMap<String, StringBuffer> linkedHashMap = new LinkedHashMap<String, StringBuffer>();
        RNAAlignment rNAAlignment = new RNAAlignment();
        String string2 = bufferedReader.readLine();
        String string3 = "";
        while (string2 != null) {
            String[] stringArray;
            if (!string2.startsWith("#")) {
                stringArray = string2.split("\\s+");
                if (stringArray.length > 1) {
                    String object = stringArray[0].trim();
                    string = stringArray[1].trim();
                    if (!linkedHashMap.containsKey(object)) {
                        linkedHashMap.put(object, new StringBuffer());
                    }
                    StringBuffer stringBuffer = (StringBuffer)linkedHashMap.get(object);
                    stringBuffer.append(string);
                }
            } else if (string2.startsWith("#")) {
                stringArray = string2.split("\\s+");
                if (string2.startsWith("#=GC SS_cons")) {
                    string3 = string3 + stringArray[2].trim();
                } else if (string2.startsWith("#=GS") && stringArray[2].trim().equals("AC")) {
                    rNAAlignment.setAccession(stringArray[1].trim(), stringArray[3].trim());
                }
            }
            string2 = bufferedReader.readLine();
        }
        rNAAlignment.setSecStr(string3);
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            string = ((StringBuffer)entry.getValue()).toString();
            rNAAlignment.addSequence((String)entry.getKey(), string);
        }
        return rNAAlignment;
    }
}

