/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.views.VueAnnotation;
import fr.orsay.lri.varna.views.VueChemProbAnnotation;
import fr.orsay.lri.varna.views.VueHighlightRegionEdit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;

public class ControleurTableAnnotations
implements MouseListener,
MouseMotionListener {
    public static final int REMOVE = 0;
    public static final int EDIT = 1;
    private JTable _table;
    private VARNAPanel _vp;
    private int _type;

    public ControleurTableAnnotations(JTable jTable, VARNAPanel vARNAPanel, int n) {
        this._table = jTable;
        this._vp = vARNAPanel;
        this._type = n;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        switch (this._type) {
            case 1: {
                this.edit();
                break;
            }
            case 0: {
                this.remove();
                break;
            }
        }
    }

    private void remove() {
        this._vp.set_selectedAnnotation(null);
        Object object = this._table.getValueAt(this._table.getSelectedRow(), 0);
        if (object instanceof TextAnnotation) {
            if (!this._vp.removeAnnotation((TextAnnotation)object)) {
                this._vp.errorDialog(new Exception("Impossible de supprimer"));
            }
            this._table.setValueAt("Deleted!", this._table.getSelectedRow(), 0);
        } else if (object instanceof ChemProbAnnotation) {
            this._vp.getRNA().removeChemProbAnnotation((ChemProbAnnotation)object);
            this._table.setValueAt("Deleted!", this._table.getSelectedRow(), 0);
        } else if (object instanceof HighlightRegionAnnotation) {
            this._vp.getRNA().removeHighlightRegion((HighlightRegionAnnotation)object);
            this._table.setValueAt("Deleted!", this._table.getSelectedRow(), 0);
        }
        this._vp.repaint();
    }

    private void edit() {
        Object object = this._table.getValueAt(this._table.getSelectedRow(), 0);
        if (object instanceof TextAnnotation) {
            TextAnnotation textAnnotation = (TextAnnotation)object;
            VueAnnotation vueAnnotation = new VueAnnotation(this._vp, textAnnotation, false);
            vueAnnotation.show();
        } else if (object instanceof HighlightRegionAnnotation) {
            HighlightRegionAnnotation highlightRegionAnnotation = (HighlightRegionAnnotation)object;
            HighlightRegionAnnotation highlightRegionAnnotation2 = highlightRegionAnnotation.clone();
            VueHighlightRegionEdit vueHighlightRegionEdit = new VueHighlightRegionEdit(this._vp, highlightRegionAnnotation);
            if (!vueHighlightRegionEdit.show()) {
                highlightRegionAnnotation.setBases(highlightRegionAnnotation2.getBases());
                highlightRegionAnnotation.setFillColor(highlightRegionAnnotation2.getFillColor());
                highlightRegionAnnotation.setOutlineColor(highlightRegionAnnotation2.getOutlineColor());
                highlightRegionAnnotation.setRadius(highlightRegionAnnotation2.getRadius());
            }
        } else if (object instanceof ChemProbAnnotation) {
            ChemProbAnnotation chemProbAnnotation = (ChemProbAnnotation)object;
            ChemProbAnnotation chemProbAnnotation2 = chemProbAnnotation.clone();
            VueChemProbAnnotation vueChemProbAnnotation = new VueChemProbAnnotation(this._vp, chemProbAnnotation);
            if (!vueChemProbAnnotation.show()) {
                chemProbAnnotation.setColor(chemProbAnnotation2.getColor());
                chemProbAnnotation.setIntensity(chemProbAnnotation2.getIntensity());
                chemProbAnnotation.setType(chemProbAnnotation2.getType());
                chemProbAnnotation.setOut(chemProbAnnotation2.isOut());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this._vp.set_selectedAnnotation(null);
        this._vp.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._table.rowAtPoint(mouseEvent.getPoint()) < 0) {
            return;
        }
        Object object = this._table.getValueAt(this._table.rowAtPoint(mouseEvent.getPoint()), 0);
        if (object.getClass().equals(TextAnnotation.class) && object != this._vp.get_selectedAnnotation()) {
            this._vp.set_selectedAnnotation((TextAnnotation)object);
            this._vp.repaint();
        }
    }
}

