/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.components;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.export.SwingGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;

public class ZoomWindow
extends JPanel
implements ImageObserver,
Runnable,
MouseMotionListener,
MouseListener {
    VARNAPanel _vp = null;
    BufferedImage _bi = null;
    Rectangle2D.Double rnaRect = null;

    public ZoomWindow(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public synchronized void setPanel(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
    }

    public synchronized void drawPanel() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this._bi = new BufferedImage(this.getWidth(), this.getHeight(), 6);
            Graphics2D graphics2D = this._bi.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            SwingGraphics swingGraphics = new SwingGraphics(graphics2D);
            this.rnaRect = this._vp.renderRNA(swingGraphics, new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()), false, true);
            Point2D.Double double_ = this._vp.panelToLogicPoint(new Point2D.Double(0.0, 0.0));
            Point2D.Double double_2 = this._vp.panelToLogicPoint(new Point2D.Double(this._vp.getWidth(), this._vp.getHeight()));
            double d = double_2.x - double_.x;
            double d2 = double_2.y - double_.y;
            Rectangle2D.Double double_3 = this._vp.getRNA().getBBox();
            double d3 = d / double_3.width;
            double d4 = d2 / double_3.height;
            Rectangle2D.Double double_4 = new Rectangle2D.Double(this.rnaRect.x + this.rnaRect.width * (double_.x - double_3.x) / double_3.width, this.rnaRect.y + this.rnaRect.height * (double_.y - double_3.y) / double_3.height, d3 * this.rnaRect.width, d4 * this.rnaRect.height);
            Color color = new Color(0.9f, 0.9f, 0.9f, 0.4f);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.getWidth(), (int)double_4.y);
            graphics2D.fillRect(0, (int)double_4.y, (int)double_4.x, (int)double_4.height + 1);
            graphics2D.fillRect((int)(double_4.x + double_4.width), (int)double_4.y, (int)((double)this.getHeight() - (double_4.x + double_4.width)), (int)(double_4.height + 1.0));
            graphics2D.fillRect(0, (int)(double_4.y + double_4.height), this.getWidth(), (int)((double)this.getHeight() - (double_4.y + double_4.height)));
            graphics2D.setColor(new Color(0.7f, 0.7f, 0.7f, 0.3f));
            graphics2D.draw(double_4);
            graphics2D.drawLine(0, 0, (int)double_4.x, (int)double_4.y);
            swingGraphics.drawLine(this.getWidth(), 0.0, double_4.x + double_4.width, double_4.y);
            swingGraphics.drawLine(this.getWidth(), this.getHeight(), double_4.x + double_4.width, double_4.y + double_4.height);
            swingGraphics.drawLine(0.0, this.getHeight(), double_4.x, double_4.y + double_4.height);
            graphics2D.dispose();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.setBackground(this._vp.getBackground());
        super.paintComponent(graphics);
        this.drawPanel();
        if (this._bi != null) {
            graphics.drawImage(this._bi, 0, 0, this);
        }
    }

    @Override
    public void run() {
        while (true) {
            this.repaint();
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

