/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.applications.BasicINI;
import fr.orsay.lri.varna.applications.fragseq.FragSeqAnnotationDataModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqCellEditor;
import fr.orsay.lri.varna.applications.fragseq.FragSeqCellRenderer;
import fr.orsay.lri.varna.applications.fragseq.FragSeqFileModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqNode;
import fr.orsay.lri.varna.applications.fragseq.FragSeqRNASecStrModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqTree;
import fr.orsay.lri.varna.applications.fragseq.FragSeqTreeModel;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.models.FullBackup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class FragSeqGUI
extends JFrame
implements TreeModelListener,
MouseListener,
DropTargetListener,
WindowListener,
ComponentListener,
ActionListener,
TreeSelectionListener {
    private static final long serialVersionUID = -790155708306987257L;
    private String _INIFilename = "FragSeqUI.ini";
    private boolean redrawOnSlide = false;
    private int dividerWidth = 5;
    private JPanel _varnaUpperPanels = new JPanel();
    private JPanel _varnaLowerPanels = new JPanel();
    private JPanel _listPanel = new JPanel();
    private JPanel _infoPanel = new JPanel();
    private FragSeqTree _sideList = null;
    private FragSeqTreeModel _treeModel;
    private JToolBar _toolbar = new JToolBar();
    private JFileChooser _choice = new JFileChooser();
    private JScrollPane _listScroller;
    private JList _selectedElems;
    private JSplitPane _splitLeft;
    private JSplitPane _splitRight;
    private JSplitPane _splitVARNA;
    private JComboBox _lnf;
    int index = 0;
    private ArrayList<VARNAHolder> _varnaPanels = new ArrayList();

    public FragSeqGUI() {
        super("VARNA Explorer");
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.addWindowListener(this);
        this._selectedElems = new JList();
        this._lnf = new JComboBox<UIManager.LookAndFeelInfo>(UIManager.getInstalledLookAndFeels());
        this._treeModel = new FragSeqTreeModel();
        this._treeModel.addTreeModelListener(this);
        this._sideList = new FragSeqTree(this._treeModel);
        this._sideList.addMouseListener(this);
        this._sideList.setLargeModel(true);
        this._sideList.setEditable(true);
        this._sideList.addTreeWillExpandListener(this._treeModel);
        FragSeqCellRenderer fragSeqCellRenderer = new FragSeqCellRenderer(this._sideList, this._treeModel);
        this._sideList.setCellRenderer(fragSeqCellRenderer);
        this._sideList.setCellEditor(new FragSeqCellEditor((JTree)this._sideList, (DefaultTreeCellRenderer)fragSeqCellRenderer, this._treeModel));
        TreeSelectionModel treeSelectionModel = this._sideList.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this._sideList.setSelectionModel(treeSelectionModel);
        treeSelectionModel.addTreeSelectionListener(this);
        this._sideList.setShowsRootHandles(true);
        this._sideList.setDragEnabled(true);
        this._sideList.setRootVisible(false);
        this._sideList.setTransferHandler(new TransferHandler(null){

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 3;
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                JTree jTree = (JTree)jComponent;
                TreePath treePath = jTree.getSelectionPath();
                if (treePath != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    if (defaultMutableTreeNode.getUserObject() instanceof FragSeqRNASecStrModel) {
                        return new Transferable(){

                            @Override
                            public DataFlavor[] getTransferDataFlavors() {
                                DataFlavor[] dataFlavorArray = new DataFlavor[]{FragSeqRNASecStrModel.Flavor};
                                return dataFlavorArray;
                            }

                            @Override
                            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                                if (!this.isDataFlavorSupported(dataFlavor)) {
                                    throw new UnsupportedFlavorException(dataFlavor);
                                }
                                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FragSeqGUI.this._sideList.getSelectionPath().getLastPathComponent();
                                return defaultMutableTreeNode.getUserObject();
                            }

                            @Override
                            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                                return FragSeqRNASecStrModel.Flavor.equals(dataFlavor);
                            }
                        };
                    }
                    if (defaultMutableTreeNode.getUserObject() instanceof FragSeqAnnotationDataModel) {
                        return new Transferable(){

                            @Override
                            public DataFlavor[] getTransferDataFlavors() {
                                DataFlavor[] dataFlavorArray = new DataFlavor[]{FragSeqAnnotationDataModel.Flavor};
                                return dataFlavorArray;
                            }

                            @Override
                            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                                if (!this.isDataFlavorSupported(dataFlavor)) {
                                    throw new UnsupportedFlavorException(dataFlavor);
                                }
                                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FragSeqGUI.this._sideList.getSelectionPath().getLastPathComponent();
                                return defaultMutableTreeNode.getUserObject();
                            }

                            @Override
                            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                                return FragSeqAnnotationDataModel.Flavor.equals(dataFlavor);
                            }
                        };
                    }
                    return null;
                }
                return null;
            }
        });
        JButton jButton = new JButton("Refresh All");
        jButton.setActionCommand("" + (Object)((Object)Commands.REFRESH_ALL));
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Add folder");
        jButton2.setActionCommand("" + (Object)((Object)Commands.NEW_FOLDER));
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("+Up");
        jButton3.setActionCommand("" + (Object)((Object)Commands.ADD_PANEL_UP));
        jButton3.addActionListener(this);
        JButton jButton4 = new JButton("-Up");
        jButton4.setActionCommand("" + (Object)((Object)Commands.REMOVE_PANEL_UP));
        jButton4.addActionListener(this);
        JButton jButton5 = new JButton("+Down");
        jButton5.setActionCommand("" + (Object)((Object)Commands.ADD_PANEL_DOWN));
        jButton5.addActionListener(this);
        JButton jButton6 = new JButton("-Down");
        jButton6.setActionCommand("" + (Object)((Object)Commands.REMOVE_PANEL_DOWN));
        jButton6.addActionListener(this);
        JButton jButton7 = new JButton("Change");
        jButton7.setActionCommand("" + (Object)((Object)Commands.CHANGE_LNF));
        jButton7.addActionListener(this);
        JButton jButton8 = new JButton("Test XML");
        jButton8.setActionCommand("" + (Object)((Object)Commands.TEST_XML));
        jButton8.addActionListener(this);
        this._toolbar.setFloatable(false);
        this._toolbar.add(jButton);
        this._toolbar.addSeparator();
        this._toolbar.add(jButton3);
        this._toolbar.add(jButton4);
        this._toolbar.add(jButton5);
        this._toolbar.add(jButton6);
        this._toolbar.addSeparator();
        this._toolbar.add(jButton8);
        this._toolbar.addSeparator();
        this._toolbar.add(this._lnf);
        this._toolbar.add(jButton7);
        this._listScroller = new JScrollPane(this._sideList, 22, 32);
        this._listScroller.setPreferredSize(new Dimension(300, 200));
        this._listScroller.addComponentListener(this);
        this._listPanel.setLayout(new BorderLayout());
        this._listPanel.add((Component)this._listScroller, "Center");
        this._listPanel.add((Component)this._selectedElems, "South");
        this._listPanel.setBorder(BorderFactory.createTitledBorder("Structures"));
        this._listPanel.setPreferredSize(new Dimension(300, 0));
        this._varnaUpperPanels.setLayout(new GridLayout());
        this._varnaUpperPanels.setPreferredSize(new Dimension(800, 600));
        this._varnaLowerPanels.setLayout(new GridLayout());
        this._varnaLowerPanels.setPreferredSize(new Dimension(800, 0));
        JRadioButton jRadioButton = new JRadioButton("Directory");
        jRadioButton.setActionCommand("sortfilename");
        jRadioButton.setSelected(true);
        jRadioButton.setOpaque(false);
        jRadioButton.setActionCommand("" + (Object)((Object)Commands.SORT_FILENAME));
        jRadioButton.addActionListener(this);
        JRadioButton jRadioButton2 = new JRadioButton("ID");
        jRadioButton2.setActionCommand("sortid");
        jRadioButton2.setOpaque(false);
        jRadioButton2.setActionCommand("" + (Object)((Object)Commands.SORT_ID));
        jRadioButton2.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel("Sort by"));
        jToolBar.add(jRadioButton);
        jToolBar.add(jRadioButton2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jToolBar, "North");
        jPanel.add((Component)this._listPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this._splitVARNA = new JSplitPane(0, this.redrawOnSlide, this._varnaUpperPanels, this._varnaLowerPanels);
        this._splitVARNA.setDividerSize(this.dividerWidth);
        this._splitVARNA.setResizeWeight(1.0);
        this._splitLeft = new JSplitPane(1, this.redrawOnSlide, jPanel, this._splitVARNA);
        this._splitLeft.setResizeWeight(0.1);
        this._splitLeft.setDividerSize(this.dividerWidth);
        this._splitRight = new JSplitPane(1, this.redrawOnSlide, this._splitLeft, this._infoPanel);
        this._splitRight.setResizeWeight(0.85);
        this._splitRight.setDividerSize(this.dividerWidth);
        this._infoPanel.setLayout(new GridLayout(0, 1));
        this.restoreConfig();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._splitRight, "Center");
        this.getContentPane().add((Component)this._toolbar, "North");
        this.addUpperPanel();
        this.addUpperPanel();
        this.setVisible(true);
    }

    public FragSeqGUI getSelf() {
        return this;
    }

    public VARNAHolder createIntegratedPanel(int n) {
        VARNAHolder vARNAHolder = new VARNAHolder(this);
        this._varnaPanels.add(vARNAHolder);
        return vARNAHolder;
    }

    public void removeUpperPanel() {
        if (this._varnaUpperPanels.getComponentCount() > 1) {
            VARNAHolder vARNAHolder = (VARNAHolder)this._varnaUpperPanels.getComponent(this._varnaUpperPanels.getComponentCount() - 1);
            this._infoPanel.remove(vARNAHolder.getInfoPane());
            this._varnaUpperPanels.remove(vARNAHolder);
            this._splitLeft.validate();
            this._splitRight.validate();
        }
    }

    public void addUpperPanel() {
        VARNAHolder vARNAHolder = this.createIntegratedPanel(100);
        this._varnaUpperPanels.add(vARNAHolder);
        this._infoPanel.add(vARNAHolder.getInfoPane());
        this._splitRight.validate();
        this._splitLeft.validate();
    }

    public void removeLowerPanel() {
        if (this._varnaLowerPanels.getComponentCount() > 0) {
            this._varnaLowerPanels.remove(this._varnaLowerPanels.getComponentCount() - 1);
            if (this._varnaLowerPanels.getComponentCount() == 0) {
                this._splitVARNA.setDividerLocation(1.0);
                this._splitVARNA.validate();
                this._splitVARNA.repaint();
            }
            this._splitLeft.validate();
        }
    }

    public void addLowerPanel() {
        if (this._varnaLowerPanels.getComponentCount() == 0) {
            this._splitVARNA.setDividerLocation(0.7);
            this._splitVARNA.validate();
        }
        this._varnaLowerPanels.add(this.createIntegratedPanel(400));
        this._splitLeft.validate();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
        try {
            int n = treeModelEvent.getChildIndices()[0];
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addFolder(String string) {
        this.addFolder(string, true);
    }

    public void addFolder(String string, boolean bl) {
        FragSeqNode fragSeqNode = this._treeModel.addFolder(string);
        if (fragSeqNode != null && bl) {
            System.out.println("  Expanding: " + fragSeqNode.getUserObject());
            TreePath treePath = new TreePath(fragSeqNode.getPath());
            this._sideList.scrollPathToVisible(treePath);
            this._sideList.expandRow(this._sideList.getRowForPath(treePath));
            this._sideList.updateUI();
            this._sideList.validate();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        System.out.println(treeModelEvent);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        TreePath treePath;
        if (mouseEvent.getSource() == this._sideList && mouseEvent.getClickCount() != 1 && mouseEvent.getClickCount() == 2 && (treePath = this._sideList.getSelectionPath()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode.getUserObject() instanceof FragSeqFileModel) {
                if (!this._sideList.isExpanded(treePath)) {
                    try {
                        this._sideList.fireTreeWillExpand(treePath);
                        this._sideList.expandPath(treePath);
                    }
                    catch (ExpandVetoException expandVetoException) {
                        expandVetoException.printStackTrace();
                    }
                } else {
                    try {
                        this._sideList.fireTreeWillCollapse(treePath);
                        this._sideList.collapsePath(treePath);
                    }
                    catch (ExpandVetoException expandVetoException) {
                        expandVetoException.printStackTrace();
                    }
                }
            } else if (defaultMutableTreeNode.getUserObject() instanceof FragSeqModel) {
                FragSeqModel fragSeqModel = (FragSeqModel)defaultMutableTreeNode.getUserObject();
                int n = fragSeqModel instanceof FragSeqRNASecStrModel ? this.index % (this._varnaUpperPanels.getComponentCount() + this._varnaLowerPanels.getComponentCount()) : (this.index + this._varnaUpperPanels.getComponentCount() + this._varnaLowerPanels.getComponentCount() - 1) % (this._varnaUpperPanels.getComponentCount() + this._varnaLowerPanels.getComponentCount());
                VARNAHolder vARNAHolder = null;
                vARNAHolder = n < this._varnaUpperPanels.getComponentCount() ? (VARNAHolder)this._varnaUpperPanels.getComponent(n) : (VARNAHolder)this._varnaLowerPanels.getComponent(n -= this._varnaUpperPanels.getComponentCount());
                if (vARNAHolder instanceof VARNAHolder) {
                    VARNAHolder vARNAHolder2 = vARNAHolder;
                    if (fragSeqModel instanceof FragSeqRNASecStrModel) {
                        vARNAHolder2.setSecStrModel((FragSeqRNASecStrModel)fragSeqModel);
                        ++this.index;
                    } else if (fragSeqModel instanceof FragSeqAnnotationDataModel) {
                        vARNAHolder2.setDataModel((FragSeqAnnotationDataModel)fragSeqModel);
                    }
                }
            }
        }
    }

    private VARNAHolder getHolder(Component component) {
        int n;
        if (component instanceof VARNAHolder && (n = this._varnaPanels.indexOf(component)) != -1) {
            return this._varnaPanels.get(n);
        }
        if (component instanceof VARNAPanel) {
            for (VARNAHolder vARNAHolder : this._varnaPanels) {
                if (vARNAHolder.getVARNAPanel() != component) continue;
                return vARNAHolder;
            }
        }
        return null;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            VARNAHolder vARNAHolder;
            DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
            if (dropTarget.getComponent() instanceof VARNAPanel && (vARNAHolder = this.getHolder(dropTarget.getComponent())) != null) {
                System.out.println("[X]");
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(FragSeqRNASecStrModel.Flavor)) {
                    Object object = transferable.getTransferData(FragSeqRNASecStrModel.Flavor);
                    if (object instanceof FragSeqRNASecStrModel) {
                        vARNAHolder.setSecStrModel((FragSeqRNASecStrModel)object);
                    }
                } else if (transferable.isDataFlavorSupported(FragSeqAnnotationDataModel.Flavor)) {
                    System.out.println("[Y]");
                    Object object = transferable.getTransferData(FragSeqAnnotationDataModel.Flavor);
                    if (object instanceof FragSeqAnnotationDataModel) {
                        FragSeqAnnotationDataModel fragSeqAnnotationDataModel = (FragSeqAnnotationDataModel)object;
                        vARNAHolder.setDataModel(fragSeqAnnotationDataModel);
                    }
                }
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.saveConfig();
        System.exit(0);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void restoreConfig() {
        BasicINI basicINI = BasicINI.loadINI(this._INIFilename);
        ArrayList<String> arrayList = basicINI.getItemList("folders");
        System.out.print("[C]" + arrayList);
        for (String string : arrayList) {
            System.out.println("Loading folder " + string);
            this.addFolder(string);
        }
        this._sideList.validate();
        this._listScroller.validate();
    }

    private void saveConfig() {
        BasicINI basicINI = new BasicINI();
        int n = 0;
        for (String string : this._treeModel.getFolders()) {
            basicINI.addItem("folders", "val" + n, string);
            ++n;
        }
        BasicINI.saveINI(basicINI, this._INIFilename);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this._sideList.validate();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block28: {
            String string = actionEvent.getActionCommand();
            System.out.println(string);
            if (string.equals("" + (Object)((Object)Commands.NEW_FOLDER))) {
                this._choice.setDialogTitle("Watch new folder...");
                this._choice.setFileSelectionMode(1);
                this._choice.setAcceptAllFileFilterUsed(false);
                try {
                    if (this._choice.showOpenDialog(this.getSelf()) == 0) {
                        this.addFolder(this._choice.getSelectedFile().getCanonicalPath());
                        break block28;
                    }
                    System.out.println("No Selection ");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (string.equals("" + (Object)((Object)Commands.ADD_PANEL_DOWN))) {
                this.addLowerPanel();
            } else if (string.equals("" + (Object)((Object)Commands.ADD_PANEL_UP))) {
                this.addUpperPanel();
            } else if (string.equals("" + (Object)((Object)Commands.REMOVE_PANEL_DOWN))) {
                this.removeLowerPanel();
            } else if (string.equals("" + (Object)((Object)Commands.REMOVE_PANEL_UP))) {
                this.removeUpperPanel();
            } else if (string.equals("" + (Object)((Object)Commands.SORT_FILENAME))) {
                this._sideList.switchToPath();
            } else if (string.equals("" + (Object)((Object)Commands.SORT_ID))) {
                this._sideList.switchToID();
            } else if (string.equals("" + (Object)((Object)Commands.TEST_XML))) {
                String string2 = "temp.xml";
                VARNAHolder vARNAHolder = (VARNAHolder)this._varnaUpperPanels.getComponent(0);
                vARNAHolder.vp.toXML(string2);
                try {
                    VARNAPanel cfr_ignored_0 = vARNAHolder.vp;
                    FullBackup fullBackup = VARNAPanel.importSession(string2);
                    VARNAHolder vARNAHolder2 = (VARNAHolder)this._varnaUpperPanels.getComponent(1);
                    vARNAHolder2.vp.setConfig(fullBackup.config);
                    vARNAHolder2.vp.showRNAInterpolated(fullBackup.rna);
                    vARNAHolder2.vp.repaint();
                }
                catch (ExceptionLoadingFailed exceptionLoadingFailed) {
                    exceptionLoadingFailed.printStackTrace();
                }
            } else if (string.equals("" + (Object)((Object)Commands.CHANGE_LNF))) {
                try {
                    Object object = this._lnf.getModel().getSelectedItem();
                    System.out.println(object);
                    UIManager.setLookAndFeel(((UIManager.LookAndFeelInfo)this._lnf.getModel().getSelectedItem()).getClassName());
                    SwingUtilities.updateComponentTreeUI(this);
                    this.pack();
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    unsupportedLookAndFeelException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(this, "Command '" + string + "' not implemented yet.");
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        int[] nArray = this._sideList.getSelectionRows();
        if (nArray == null) {
            System.out.print("null");
        } else {
            System.out.print("[");
            for (int i = 0; i < nArray.length; ++i) {
                System.out.print(nArray[i] + ",");
            }
            System.out.println("]");
        }
    }

    public static void main(String[] stringArray) {
        FragSeqGUI fragSeqGUI = new FragSeqGUI();
        fragSeqGUI.setDefaultCloseOperation(3);
        fragSeqGUI.pack();
        fragSeqGUI.setVisible(true);
    }

    class VARNAHolder
    extends JPanel {
        VARNAPanel vp = new VARNAPanel();
        FragSeqRNASecStrModel _m;
        FragSeqAnnotationDataModel _data;
        JPanel _infoPanel;
        JTextPane _infoTxt;

        public VARNAHolder(DropTargetListener dropTargetListener) {
            this.vp.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                }
            });
            this.vp.setPreferredSize(new Dimension(800, 400));
            this._infoTxt = new JTextPane();
            this._infoTxt.setPreferredSize(new Dimension(200, 0));
            this._infoTxt.setContentType("text/html");
            JScrollPane jScrollPane = new JScrollPane(this._infoTxt, 22, 32);
            this._infoPanel = new JPanel();
            this._infoPanel.setLayout(new BorderLayout());
            this._infoPanel.setPreferredSize(new Dimension(200, 0));
            this._infoPanel.setBorder(BorderFactory.createTitledBorder("Info"));
            this._infoPanel.add((Component)jScrollPane, "Center");
            this._infoPanel.validate();
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(300, 600));
            this.setBorder(BorderFactory.createTitledBorder("None"));
            this.add((Component)this.vp, "Center");
            DropTarget dropTarget = new DropTarget(this.vp, dropTargetListener);
        }

        VARNAPanel getVARNAPanel() {
            return this.vp;
        }

        void setSecStrModel(FragSeqRNASecStrModel fragSeqRNASecStrModel) {
            this._m = fragSeqRNASecStrModel;
            this.vp.showRNAInterpolated(fragSeqRNASecStrModel.getRNA());
            this.setBorder(BorderFactory.createTitledBorder(fragSeqRNASecStrModel.toString()));
            this._infoTxt.setText(fragSeqRNASecStrModel.getRNA().getHTMLDescription());
            this._infoPanel.setBorder(BorderFactory.createTitledBorder("Info (" + this._m + ")"));
            this.vp.requestFocus();
        }

        void setDataModel(FragSeqAnnotationDataModel fragSeqAnnotationDataModel) {
            this._data = fragSeqAnnotationDataModel;
            fragSeqAnnotationDataModel.applyTo(this.vp.getRNA());
            this.vp.repaint();
            this.vp.requestFocus();
        }

        FragSeqModel getModel() {
            this.setBorder(BorderFactory.createTitledBorder(this._m.toString()));
            return this._m;
        }

        public void setInfoTxt(String string) {
            this._infoTxt.setText(this.vp.getRNA().getHTMLDescription());
            this._infoTxt.validate();
        }

        public JPanel getInfoPane() {
            return this._infoPanel;
        }
    }

    private static enum Commands {
        NEW_FOLDER,
        ADD_PANEL_UP,
        ADD_PANEL_DOWN,
        REMOVE_PANEL_UP,
        REMOVE_PANEL_DOWN,
        SORT_ID,
        SORT_FILENAME,
        REFRESH_ALL,
        CHANGE_LNF,
        TEST_XML;

    }
}

