/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.interfaces.InterfaceVARNABasesListener;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class NussinovDemo
extends JFrame
implements InterfaceVARNAListener,
InterfaceVARNABasesListener {
    private static final long serialVersionUID = -790155708306987257L;
    private static final String SEQUENCE_DUMMY = "AAAAAAAAAA";
    private static final String SEQUENCE_A = "AGGCACGUCU";
    private static final String SEQUENCE_B = "GAGUAGCCUC";
    private static final String SEQUENCE_C = "GCAUAGCUGC";
    private static final String SEQUENCE_INRIA = "GAGAAGUACUUGAAAUUGGCCUCCUC";
    private static final String SEQUENCE_BIG = "AAAACAAAAACACCAUGGUGUUUUCACCCAAUUGGGUGAAAACAGAGAUCUCGAGAUCUCUGUUUUUGUUUU";
    private static final String DEFAULT_STRUCTURE = "..........";
    private VARNAPanel _vpMaster;
    private InfoPanel _infos = new InfoPanel();
    private JPanel _tools = new JPanel();
    private JPanel _input = new JPanel();
    private JPanel _seqPanel = new JPanel();
    private JPanel _structPanel = new JPanel();
    private JLabel _actions = new JLabel();
    private JLabel _struct = new JLabel("..........");
    private JComboBox _seq1 = new JComboBox();
    private JLabel _structLabel = new JLabel("Structure Secondaire");
    private JLabel _seqLabel = new JLabel("Sequence d'ARN");
    private JButton _goButton = new JButton("Repliement");
    private JButton _switchButton = new JButton("Effacer");
    private Color _backgroundColor = Color.white;
    public static Font textFieldsFont = Font.decode("MonoSpaced-BOLD-16");
    public static Font labelsFont = new JLabel().getFont().deriveFont(16.0f);
    public static final int marginTools = 250;
    public static String APP_TITLE = "Nuit des Chercheurs - INRIA AMIB - Repliement d'ARN";
    private String _cache = "";
    ArrayList<String> _cacheStructs = new ArrayList();
    static final String[] _bases = new String[]{"A", "C", "G", "U"};
    static final String[] _basesComp = new String[]{"U", "G", "C", "A"};

    public static ModelBaseStyle createStyle(String string) {
        ModelBaseStyle modelBaseStyle = new ModelBaseStyle();
        try {
            modelBaseStyle.assignParameters(string);
        }
        catch (ExceptionModeleStyleBaseSyntaxError exceptionModeleStyleBaseSyntaxError) {
            exceptionModeleStyleBaseSyntaxError.printStackTrace();
        }
        catch (ExceptionParameterError exceptionParameterError) {
            exceptionParameterError.printStackTrace();
        }
        return modelBaseStyle;
    }

    public void applyTo(VARNAPanel vARNAPanel, ModelBaseStyle modelBaseStyle, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            ModeleBase modeleBase = vARNAPanel.getRNA().getBaseAt(nArray[i]);
            modeleBase.setStyleBase(modelBaseStyle);
            if (modeleBase.getElementStructure() == -1) continue;
            vARNAPanel.getRNA().getBaseAt(modeleBase.getElementStructure()).setStyleBase(modelBaseStyle);
        }
        vARNAPanel.repaint();
    }

    public NussinovDemo() {
        try {
            this._vpMaster = new VARNAPanel(this.getSeq(), "");
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            this._vpMaster.errorDialog(exceptionNonEqualLength);
        }
        this._vpMaster.setPreferredSize(new Dimension(600, 600));
        this.RNAPanelDemoInit();
    }

    public static void formatLabel(JLabel jLabel) {
        jLabel.setHorizontalTextPosition(2);
        jLabel.setPreferredSize(new Dimension(250, 15));
        jLabel.setFont(labelsFont);
    }

    private void RNAPanelDemoInit() {
        this._seq1.setFont(textFieldsFont);
        String[] stringArray = new String[]{SEQUENCE_DUMMY, SEQUENCE_INRIA, SEQUENCE_A, SEQUENCE_B, SEQUENCE_C, SEQUENCE_BIG};
        this._seq1.setModel(new DefaultComboBoxModel<String>(stringArray));
        this._seq1.setEditable(true);
        this.setBackground(this._backgroundColor);
        this._vpMaster.setBackground(this._backgroundColor);
        this._vpMaster.addVARNAListener(this);
        this._vpMaster.setFlatExteriorLoop(true);
        NussinovDemo.formatLabel(this._seqLabel);
        NussinovDemo.formatLabel(this._structLabel);
        this._goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NussinovDemo.this.showSolution();
                NussinovDemo.this.onStructureRedrawn();
            }
        });
        this._switchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RNA rNA = new RNA();
                    rNA.setRNA("", "");
                    NussinovDemo.this._struct.setText("");
                    NussinovDemo.this._vpMaster.setTitle("");
                    NussinovDemo.this._vpMaster.showRNA(rNA);
                    NussinovDemo.this.onStructureRedrawn();
                }
                catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                    exceptionFileFormatOrSyntax.printStackTrace();
                }
                catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                    exceptionUnmatchedClosingParentheses.printStackTrace();
                }
                NussinovDemo.this._vpMaster.repaint();
            }
        });
        this._seqPanel.setLayout(new BorderLayout());
        this._seqPanel.add((Component)this._seqLabel, "West");
        this._seqPanel.add((Component)this._seq1, "Center");
        this._structLabel.setPreferredSize(new Dimension(250, 15));
        this._structLabel.setHorizontalTextPosition(2);
        this._struct.setFont(textFieldsFont);
        this._structPanel.setLayout(new BorderLayout());
        this._structPanel.add((Component)this._structLabel, "West");
        this._structPanel.add((Component)this._struct, "Center");
        this._input.setLayout(new GridLayout(0, 1));
        this._input.add(this._seqPanel);
        this._input.add(this._structPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._infos.setFont(labelsFont);
        this._tools.setLayout(new BorderLayout());
        this._tools.add((Component)this._infos, "South");
        this._tools.add((Component)this._input, "Center");
        this._tools.add((Component)this._actions, "North");
        this._tools.add((Component)jPanel, "East");
        this._tools.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this._goButton, "Center");
        jPanel.add((Component)this._switchButton, "South");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(this._vpMaster);
        jPanel2.setBorder(BorderFactory.createBevelBorder(0));
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)this._tools, "South");
        this.setVisible(true);
        this._vpMaster.getVARNAUI().UIRadiate();
        this._vpMaster.setTitleFontSize(26.0f);
        this._vpMaster.setTitleFontStyle(0);
        this._vpMaster.addVARNABasesListener(this);
        this.setTitle(APP_TITLE);
        this.showSolution();
        this.onStructureRedrawn();
    }

    private synchronized void showSolution() {
        ArrayList<String> arrayList = this.getStructs();
        this._infos.setInfo(arrayList, this.count(this.getSeq()));
    }

    public String getSeq() {
        return ("" + this._seq1.getSelectedItem()).toUpperCase();
    }

    private boolean canBasePairAll(char c, char c2) {
        return true;
    }

    private boolean canBasePairBasic(char c, char c2) {
        if (c == 'G' && c2 == 'C') {
            return true;
        }
        if (c == 'C' && c2 == 'G') {
            return true;
        }
        if (c == 'U' && c2 == 'A') {
            return true;
        }
        if (c == 'A' && c2 == 'U') {
            return true;
        }
        if (c == 'G' && c2 == 'U') {
            return true;
        }
        return c == 'U' && c2 == 'G';
    }

    private double basePairScoreBasic(char c, char c2) {
        if (c == 'G' && c2 == 'C') {
            return 1.0;
        }
        if (c == 'C' && c2 == 'G') {
            return 1.0;
        }
        if (c == 'U' && c2 == 'A') {
            return 1.0;
        }
        if (c == 'A' && c2 == 'U') {
            return 1.0;
        }
        if (c == 'G' && c2 == 'U') {
            return 1.0;
        }
        if (c == 'U' && c2 == 'G') {
            return 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private boolean canBasePairNussinov(char c, char c2) {
        if (c == 'G' && c2 == 'C') {
            return true;
        }
        if (c == 'C' && c2 == 'G') {
            return true;
        }
        if (c == 'U' && c2 == 'A') {
            return true;
        }
        if (c == 'A' && c2 == 'U') {
            return true;
        }
        if (c == 'U' && c2 == 'G') {
            return true;
        }
        return c == 'G' && c2 == 'U';
    }

    private double basePairScoreNussinov(char c, char c2) {
        if (c == 'G' && c2 == 'C') {
            return 3.0;
        }
        if (c == 'C' && c2 == 'G') {
            return 3.0;
        }
        if (c == 'U' && c2 == 'A') {
            return 2.0;
        }
        if (c == 'A' && c2 == 'U') {
            return 2.0;
        }
        if (c == 'U' && c2 == 'G') {
            return 1.0;
        }
        if (c == 'G' && c2 == 'U') {
            return 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private boolean canBasePairINRIA(char c, char c2) {
        if (c == 'U' && c2 == 'A') {
            return true;
        }
        if (c == 'A' && c2 == 'U') {
            return true;
        }
        if (c == 'G' && c2 == 'C') {
            return true;
        }
        if (c == 'C' && c2 == 'G') {
            return true;
        }
        if (c == 'A' && c2 == 'G') {
            return true;
        }
        if (c == 'G' && c2 == 'A') {
            return true;
        }
        if (c == 'U' && c2 == 'C') {
            return true;
        }
        if (c == 'C' && c2 == 'U') {
            return true;
        }
        if (c == 'A' && c2 == 'A') {
            return true;
        }
        if (c == 'U' && c2 == 'U') {
            return true;
        }
        if (c == 'U' && c2 == 'G') {
            return true;
        }
        if (c == 'G' && c2 == 'U') {
            return true;
        }
        if (c == 'A' && c2 == 'C') {
            return true;
        }
        return c == 'C' && c2 == 'A';
    }

    private double basePairScoreINRIA(char c, char c2) {
        if (c == 'U' && c2 == 'A') {
            return 3.0;
        }
        if (c == 'A' && c2 == 'U') {
            return 3.0;
        }
        if (c == 'G' && c2 == 'C') {
            return 3.0;
        }
        if (c == 'C' && c2 == 'G') {
            return 3.0;
        }
        if (c == 'A' && c2 == 'G') {
            return 2.0;
        }
        if (c == 'G' && c2 == 'A') {
            return 2.0;
        }
        if (c == 'U' && c2 == 'C') {
            return 2.0;
        }
        if (c == 'C' && c2 == 'U') {
            return 2.0;
        }
        if (c == 'A' && c2 == 'A') {
            return 2.0;
        }
        if (c == 'U' && c2 == 'U') {
            return 2.0;
        }
        if (c == 'U' && c2 == 'G') {
            return 1.0;
        }
        if (c == 'G' && c2 == 'U') {
            return 1.0;
        }
        if (c == 'A' && c2 == 'C') {
            return 1.0;
        }
        if (c == 'C' && c2 == 'A') {
            return 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private boolean canBasePair(char c, char c2) {
        return this.canBasePairBasic(c, c2);
    }

    private double basePairScore(char c, char c2) {
        return this.basePairScoreBasic(c, c2);
    }

    public double[][] fillMatrix(String string) {
        int n = string.length();
        double[][] dArray = new double[n][n];
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < n - i + 1; ++j) {
                int n2 = j + i - 1;
                dArray[j][n2] = 0.0;
                if (j >= n2) continue;
                dArray[j][n2] = Math.max(dArray[j][n2], dArray[j + 1][n2]);
                for (int k = j + 1; k <= n2; ++k) {
                    if (!this.canBasePair(string.charAt(j), string.charAt(k))) continue;
                    double d = 0.0;
                    if (k > j + 1) {
                        d = dArray[j + 1][k - 1];
                    }
                    double d2 = 0.0;
                    if (k < n2) {
                        d2 = dArray[k + 1][n2];
                    }
                    dArray[j][n2] = Math.max(dArray[j][n2], this.basePairScore(string.charAt(j), string.charAt(k)) + d + d2);
                }
            }
        }
        return dArray;
    }

    public static ArrayList<Double> combine(double d, ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (double d2 : arrayList) {
            for (double d3 : arrayList2) {
                arrayList3.add(d + d2 + d3);
            }
        }
        return arrayList3;
    }

    public static ArrayList<Double> selectBests(ArrayList<Double> arrayList) {
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double d = Double.NEGATIVE_INFINITY;
        for (double d2 : arrayList) {
            d = Math.max(d2, d);
        }
        for (double d2 : arrayList) {
            if (d2 != d) continue;
            arrayList2.add(d2);
        }
        return arrayList2;
    }

    private ArrayList<String> backtrack(double[][] dArray, String string) {
        return this.backtrack(dArray, string, 0, string.length() - 1);
    }

    private ArrayList<String> backtrack(double[][] dArray, String string, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n < n2) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            arrayList2.add(-1);
            for (int i = n + 1; i <= n2; ++i) {
                arrayList2.add(i);
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                if (n3 == -1) {
                    if (dArray[n][n2] != dArray[n + 1][n2]) continue;
                    for (String string2 : this.backtrack(dArray, string, n + 1, n2)) {
                        arrayList.add("." + string2);
                    }
                    continue;
                }
                if (!this.canBasePair(string.charAt(n), string.charAt(n3))) continue;
                double d = 0.0;
                if (n3 > n + 1) {
                    d = dArray[n + 1][n3 - 1];
                }
                double d2 = 0.0;
                if (n3 < n2) {
                    d2 = dArray[n3 + 1][n2];
                }
                if (dArray[n][n2] != this.basePairScore(string.charAt(n), string.charAt(n3)) + d + d2) continue;
                for (String string3 : this.backtrack(dArray, string, n + 1, n3 - 1)) {
                    for (String string4 : this.backtrack(dArray, string, n3 + 1, n2)) {
                        arrayList.add("(" + string3 + ")" + string4);
                    }
                }
            }
        } else if (n == n2) {
            arrayList.add(".");
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    public BigInteger count(String string) {
        int n = string.length();
        BigInteger[][] bigIntegerArray = new BigInteger[n][n];
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < n - i + 1; ++j) {
                int n2 = j + i - 1;
                bigIntegerArray[j][n2] = BigInteger.ZERO;
                if (j < n2) {
                    bigIntegerArray[j][n2] = bigIntegerArray[j][n2].add(bigIntegerArray[j + 1][n2]);
                    for (int k = j + 1; k <= n2; ++k) {
                        if (!this.canBasePair(string.charAt(j), string.charAt(k))) continue;
                        BigInteger bigInteger = BigInteger.ONE;
                        if (k > j + 1) {
                            bigInteger = bigIntegerArray[j + 1][k - 1];
                        }
                        BigInteger bigInteger2 = BigInteger.ONE;
                        if (k < n2) {
                            bigInteger2 = bigIntegerArray[k + 1][n2];
                        }
                        bigIntegerArray[j][n2] = bigIntegerArray[j][n2].add(bigInteger.multiply(bigInteger2));
                    }
                    continue;
                }
                bigIntegerArray[j][n2] = BigInteger.ONE;
            }
        }
        return bigIntegerArray[0][n - 1];
    }

    public ArrayList<String> getStructs() {
        String string = this.getSeq();
        if (!this._cache.equals(string = string.toUpperCase())) {
            double[][] dArray = this.fillMatrix(string);
            this._cacheStructs = this.backtrack(dArray, string);
            this._cache = string;
        }
        return this._cacheStructs;
    }

    public VARNAPanel get_varnaPanel() {
        return this._vpMaster;
    }

    public void set_varnaPanel(VARNAPanel vARNAPanel) {
        this._vpMaster = vARNAPanel;
    }

    public JLabel get_info() {
        return this._actions;
    }

    public void set_info(JLabel jLabel) {
        this._actions = jLabel;
    }

    public static void main(String[] stringArray) {
        NussinovDemo nussinovDemo = new NussinovDemo();
        nussinovDemo.setDefaultCloseOperation(3);
        nussinovDemo.pack();
        nussinovDemo.setVisible(true);
    }

    @Override
    public void onStructureRedrawn() {
        this._vpMaster.repaint();
    }

    @Override
    public void onWarningEmitted(String string) {
    }

    public void onLoad(String string) {
    }

    public void onLoaded() {
    }

    @Override
    public void onUINewStructure(VARNAConfig vARNAConfig, RNA rNA) {
    }

    @Override
    public void onBaseClicked(ModeleBase modeleBase, MouseEvent mouseEvent) {
    }

    @Override
    public void onZoomLevelChanged() {
    }

    @Override
    public void onTranslationChanged() {
    }

    private class InfoPanel
    extends JPanel {
        ArrayList<String> _sols = new ArrayList();
        BigInteger _nbFolds = BigInteger.ZERO;
        JTextArea _text = new JTextArea("");
        JTextArea _subopts = new JTextArea("");
        JPanel _suboptBrowser = new JPanel();
        JPanel _suboptCount = new JPanel();
        int _selectedIndex = 0;
        JButton next = new JButton("Precedent");
        JButton previous = new JButton("Suivant");

        InfoPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this._suboptBrowser, "South");
            this.add((Component)this._suboptCount, "North");
            this.next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (InfoPanel.this._sols.size() > 0) {
                        InfoPanel.this.setSelectedIndex((InfoPanel.this._selectedIndex + 1) % InfoPanel.this._sols.size());
                    }
                }
            });
            this.previous.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (InfoPanel.this._sols.size() > 0) {
                        InfoPanel.this.setSelectedIndex((InfoPanel.this._selectedIndex + InfoPanel.this._sols.size() - 1) % InfoPanel.this._sols.size());
                    }
                }
            });
            this.next.setEnabled(false);
            this.previous.setEnabled(false);
            JLabel jLabel = new JLabel("#Repliements");
            NussinovDemo.formatLabel(jLabel);
            this._suboptCount.setLayout(new BorderLayout());
            this._suboptCount.add((Component)jLabel, "West");
            this._suboptCount.add((Component)this._text, "Center");
            JLabel jLabel2 = new JLabel("#Co-optimaux");
            NussinovDemo.formatLabel(jLabel2);
            JPanel jPanel = new JPanel();
            jPanel.add(this.previous);
            jPanel.add(this.next);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this._subopts, "West");
            jPanel2.add((Component)jPanel, "Center");
            this._suboptBrowser.setLayout(new BorderLayout());
            this._suboptBrowser.add((Component)jLabel2, "West");
            this._suboptBrowser.add((Component)jPanel2, "Center");
        }

        public void setSelectedIndex(int n) {
            this._selectedIndex = n;
            RNA rNA = new RNA();
            try {
                rNA.setRNA(NussinovDemo.this.getSeq(), this._sols.get(n));
                rNA.drawRNARadiate(NussinovDemo.this._vpMaster.getConfig());
                NussinovDemo.this._vpMaster.showRNAInterpolated(rNA);
            }
            catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                exceptionUnmatchedClosingParentheses.printStackTrace();
            }
            catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                exceptionFileFormatOrSyntax.printStackTrace();
            }
            NussinovDemo.this._struct.setText(this._sols.get(n));
            this.formatDescription();
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this._text != null) {
                this._text.setFont(font);
                this._text.setOpaque(false);
            }
            if (this._subopts != null) {
                this._subopts.setFont(font);
                this._subopts.setOpaque(false);
            }
        }

        public void setInfo(ArrayList<String> arrayList, BigInteger bigInteger) {
            this._sols = arrayList;
            this._nbFolds = bigInteger;
            this.formatDescription();
            this.setSelectedIndex(0);
        }

        private void formatDescription() {
            this._text.setText("" + this._nbFolds);
            this._subopts.setText("" + this._sols.size());
            this.next.setEnabled(this._sols.size() > 1);
            this.previous.setEnabled(this._sols.size() > 1);
        }
    }
}

