/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.utils;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MapList {
    public Vector fromShifts;
    public Vector toShifts;
    int fromRatio;
    int toRatio;
    int[] fromRange = null;
    int[] toRange = null;

    public boolean equals(MapList obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.fromRatio == this.fromRatio && obj.toRatio == this.toRatio && obj.fromShifts != null && obj.toShifts != null) {
            int[] mj;
            int[] mi;
            int jSize;
            int iSize = this.fromShifts.size();
            if (iSize != (jSize = obj.fromShifts.size())) {
                return false;
            }
            int i = 0;
            iSize = this.fromShifts.size();
            int j = 0;
            jSize = obj.fromShifts.size();
            while (i < iSize) {
                if ((mi = (int[])this.fromShifts.elementAt(i++))[0] == (mj = (int[])obj.fromShifts.elementAt(j++))[0] && mi[1] == mj[1]) continue;
                return false;
            }
            iSize = this.toShifts.size();
            if (iSize != (jSize = obj.toShifts.size())) {
                return false;
            }
            i = 0;
            j = 0;
            while (i < iSize) {
                if ((mi = (int[])this.toShifts.elementAt(i++))[0] == (mj = (int[])obj.toShifts.elementAt(j++))[0] && mi[1] == mj[1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int[] getFromRanges() {
        return this.getRanges(this.fromShifts);
    }

    public int[] getToRanges() {
        return this.getRanges(this.toShifts);
    }

    private int[] getRanges(Vector shifts) {
        int[] rnges = new int[2 * shifts.size()];
        Enumeration e = shifts.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            int[] r = (int[])e.nextElement();
            rnges[i++] = r[0];
            rnges[i++] = r[1];
        }
        return rnges;
    }

    public int getFromRatio() {
        return this.fromRatio;
    }

    public int getToRatio() {
        return this.toRatio;
    }

    public int getFromLowest() {
        return this.fromRange[0];
    }

    public int getFromHighest() {
        return this.fromRange[1];
    }

    public int getToLowest() {
        return this.toRange[0];
    }

    public int getToHighest() {
        return this.toRange[1];
    }

    private void ensureRange(int[] limits, int pos) {
        if (limits[0] > pos) {
            limits[0] = pos;
        }
        if (limits[1] < pos) {
            limits[1] = pos;
        }
    }

    public MapList(int[] from, int[] to, int fromRatio, int toRatio) {
        int i;
        this.fromRange = new int[]{from[0], from[1]};
        this.toRange = new int[]{to[0], to[1]};
        this.fromShifts = new Vector();
        for (i = 0; i < from.length; i += 2) {
            this.ensureRange(this.fromRange, from[i]);
            this.ensureRange(this.fromRange, from[i + 1]);
            this.fromShifts.addElement(new int[]{from[i], from[i + 1]});
        }
        this.toShifts = new Vector();
        for (i = 0; i < to.length; i += 2) {
            this.ensureRange(this.toRange, to[i]);
            this.ensureRange(this.toRange, to[i + 1]);
            this.toShifts.addElement(new int[]{to[i], to[i + 1]});
        }
        this.fromRatio = fromRatio;
        this.toRatio = toRatio;
    }

    public MapList(MapList map) {
        int[] el;
        Enumeration e;
        this.fromRange = new int[]{map.fromRange[0], map.fromRange[1]};
        this.toRange = new int[]{map.toRange[0], map.toRange[1]};
        this.fromRatio = map.fromRatio;
        this.toRatio = map.toRatio;
        if (map.fromShifts != null) {
            this.fromShifts = new Vector();
            e = map.fromShifts.elements();
            while (e.hasMoreElements()) {
                el = (int[])e.nextElement();
                this.fromShifts.addElement(new int[]{el[0], el[1]});
            }
        }
        if (map.toShifts != null) {
            this.toShifts = new Vector();
            e = map.toShifts.elements();
            while (e.hasMoreElements()) {
                el = (int[])e.nextElement();
                this.toShifts.addElement(new int[]{el[0], el[1]});
            }
        }
    }

    public int[][] makeFromMap() {
        return this.posMap(this.fromShifts, this.fromRatio, this.toShifts, this.toRatio);
    }

    public int[][] makeToMap() {
        return this.posMap(this.toShifts, this.toRatio, this.fromShifts, this.fromRatio);
    }

    private int[][] posMap(Vector intVals, int ratio, Vector toIntVals, int toRatio) {
        int to;
        int[] intv;
        int from;
        int iv = 0;
        int ivSize = intVals.size();
        if (iv >= ivSize) {
            return null;
        }
        if ((from = (intv = (int[])intVals.elementAt(iv++))[0]) > (to = intv[1])) {
            from = intv[1];
            to = intv[0];
        }
        while (iv < ivSize) {
            if ((intv = (int[])intVals.elementAt(iv++))[0] < from) {
                from = intv[0];
            }
            if (intv[1] < from) {
                from = intv[1];
            }
            if (intv[0] > to) {
                to = intv[0];
            }
            if (intv[1] <= to) continue;
            to = intv[1];
        }
        int tF = 0;
        int tT = 0;
        int[][] mp = new int[to - from + 2][];
        for (int i = 0; i < mp.length; ++i) {
            int[] m = this.shift(i + from, intVals, ratio, toIntVals, toRatio);
            if (m != null) {
                if (i == 0) {
                    tF = tT = m[0];
                } else {
                    if (m[0] < tF) {
                        tF = m[0];
                    }
                    if (m[0] > tT) {
                        tT = m[0];
                    }
                }
            }
            mp[i] = m;
        }
        int[][] map = new int[][]{{from, to, tF, tT}, new int[to - from + 2]};
        map[0][2] = tF;
        map[0][3] = tT;
        for (int i = 0; i < mp.length; ++i) {
            map[1][i] = mp[i] != null ? mp[i][0] - tF : -1;
        }
        return map;
    }

    public int[] shiftFrom(int pos) {
        return this.shift(pos, this.fromShifts, this.fromRatio, this.toShifts, this.toRatio);
    }

    public int[] shiftTo(int pos) {
        return this.shift(pos, this.toShifts, this.toRatio, this.fromShifts, this.fromRatio);
    }

    private int[] shift(int pos, Vector fromShifts, int fromRatio, Vector toShifts, int toRatio) {
        int[] fromCount = this.countPos(fromShifts, pos);
        if (fromCount == null) {
            return null;
        }
        int fromRemainder = (fromCount[0] - 1) % fromRatio;
        int toCount = 1 + (fromCount[0] - 1) / fromRatio * toRatio;
        int[] toPos = this.countToPos(toShifts, toCount);
        if (toPos == null) {
            return null;
        }
        return new int[]{toPos[0], fromRemainder, toPos[1]};
    }

    private int[] countPos(Vector intVals, int pos) {
        int count = 0;
        int iv = 0;
        int ivSize = intVals.size();
        while (iv < ivSize) {
            int[] intv;
            if ((intv = (int[])intVals.elementAt(iv++))[0] <= intv[1]) {
                if (pos >= intv[0] && pos <= intv[1]) {
                    return new int[]{count + pos - intv[0] + 1, 1};
                }
                count += intv[1] - intv[0] + 1;
                continue;
            }
            if (pos >= intv[1] && pos <= intv[0]) {
                return new int[]{count + intv[0] - pos + 1, -1};
            }
            count += intv[0] - intv[1] + 1;
        }
        return null;
    }

    private int[] countToPos(Vector intVals, int pos) {
        int count = 0;
        int diff = 0;
        int iv = 0;
        int ivSize = intVals.size();
        int[] intv = new int[]{0, 0};
        while (iv < ivSize) {
            if ((diff = (intv = (int[])intVals.elementAt(iv++))[1] - intv[0]) >= 0) {
                if (pos <= count + 1 + diff) {
                    return new int[]{pos - count - 1 + intv[0], 1};
                }
                count += 1 + diff;
                continue;
            }
            if (pos <= count + 1 - diff) {
                return new int[]{intv[0] - (pos - count - 1), -1};
            }
            count += 1 - diff;
        }
        return null;
    }

    public int[] locateInFrom(int start, int end) {
        int[] fromStart = this.shiftTo(start);
        int[] fromEnd = this.shiftTo(end);
        if (fromStart == null || fromEnd == null) {
            return null;
        }
        int[] iv = this.getIntervals(this.fromShifts, fromStart, fromEnd, this.fromRatio);
        return iv;
    }

    public int[] locateInTo(int start, int end) {
        int[] toStart = this.shiftFrom(start);
        int[] toEnd = this.shiftFrom(end);
        if (toStart == null || toEnd == null) {
            return null;
        }
        int[] iv = this.getIntervals(this.toShifts, toStart, toEnd, this.toRatio);
        return iv;
    }

    private int[] getIntervals(Vector fromShifts2, int[] fromStart, int[] fromEnd, int fromRatio2) {
        int[] iv;
        int startpos = fromStart[0];
        int endpos = fromEnd[0];
        int endindx = fromRatio2 - 1;
        int intv = 0;
        int intvSize = fromShifts2.size();
        int i = 0;
        int fs = -1;
        int fe_s = -1;
        int fe = -1;
        while (intv < intvSize && (fs == -1 || fe == -1)) {
            iv = (int[])fromShifts2.elementAt(intv++);
            if (fe_s > -1) {
                endpos = iv[0];
                --endindx;
            }
            if (iv[0] <= iv[1]) {
                if (fs == -1 && startpos >= iv[0] && startpos <= iv[1]) {
                    fs = i;
                }
                if (endpos >= iv[0] && endpos <= iv[1]) {
                    if (fe_s == -1) {
                        fe_s = i;
                    }
                    if (fe_s != -1) {
                        if (endpos + endindx <= iv[1]) {
                            fe = i;
                            endpos += endindx;
                        } else {
                            endindx -= iv[1] - endpos;
                        }
                    }
                }
            } else {
                if (fs == -1 && startpos <= iv[0] && startpos >= iv[1]) {
                    fs = i;
                }
                if (endpos <= iv[0] && endpos >= iv[1]) {
                    if (fe_s == -1) {
                        fe_s = i;
                    }
                    if (fe_s != -1) {
                        if (endpos - endindx >= iv[1]) {
                            fe = i;
                            endpos -= endindx;
                        } else {
                            endindx -= endpos - iv[1];
                        }
                    }
                }
            }
            ++i;
        }
        if (fs == fe && fe == -1) {
            return null;
        }
        Vector<int[]> ranges = new Vector<int[]>();
        if (fs <= fe) {
            intv = fs;
            i = fs;
            iv = (int[])fromShifts2.elementAt(intv++);
            iv = new int[]{iv[0], iv[1]};
            if (i == fs) {
                iv[0] = startpos;
            }
            while (i != fe) {
                ranges.addElement(iv);
                iv = (int[])fromShifts2.elementAt(intv++);
                iv = new int[]{iv[0], iv[1]};
                ++i;
            }
            if (i == fe) {
                iv[1] = endpos;
            }
            ranges.addElement(iv);
        } else {
            for (i = fromShifts2.size() - 1; i > fs; --i) {
            }
            iv = (int[])fromShifts2.elementAt(i);
            iv = new int[]{iv[1], iv[0]};
            if (i == fs) {
                iv[0] = startpos;
            }
            while (--i != fe) {
                ranges.addElement(iv);
                iv = (int[])fromShifts2.elementAt(i);
                iv = new int[]{iv[1], iv[0]};
            }
            if (i == fe) {
                iv[1] = endpos;
            }
            ranges.addElement(iv);
        }
        int[] range = null;
        if (ranges != null && ranges.size() > 0) {
            range = new int[ranges.size() * 2];
            intv = 0;
            intvSize = ranges.size();
            i = 0;
            while (intv < intvSize) {
                iv = (int[])ranges.elementAt(intv);
                range[i++] = iv[0];
                range[i++] = iv[1];
                ranges.setElementAt(null, intv++);
            }
        }
        return range;
    }

    public int getToPosition(int mpos) {
        int[] mp = this.shiftTo(mpos);
        if (mp != null) {
            return mp[0];
        }
        return mpos;
    }

    public int[] getToWord(int mpos) {
        int[] mp = this.shiftTo(mpos);
        if (mp != null) {
            return new int[]{mp[0], mp[0] + mp[2] * (this.getFromRatio() - 1)};
        }
        return null;
    }

    public int getMappedPosition(int pos) {
        int[] mp = this.shiftFrom(pos);
        if (mp != null) {
            return mp[0];
        }
        return pos;
    }

    public int[] getMappedWord(int pos) {
        int[] mp = this.shiftFrom(pos);
        if (mp != null) {
            return new int[]{mp[0], mp[0] + mp[2] * (this.getToRatio() - 1)};
        }
        return null;
    }

    public static void testMap(MapList ml, int fromS, int fromE) {
        int i;
        int[] rng;
        int t;
        int i2;
        for (int from = 1; from <= 25; ++from) {
            int[] too = ml.shiftFrom(from);
            System.out.print("ShiftFrom(" + from + ")==");
            if (too == null) {
                System.out.print("NaN\n");
                continue;
            }
            System.out.print(too[0] + " % " + too[1] + " (" + too[2] + ")");
            System.out.print("\t+--+\t");
            int[] toofrom = ml.shiftTo(too[0]);
            if (toofrom != null) {
                if (toofrom[0] != from) {
                    System.err.println("Mapping not reflexive:" + from + " " + too[0] + "->" + toofrom[0]);
                }
                System.out.println("ShiftTo(" + too[0] + ")==" + toofrom[0] + " % " + toofrom[1] + " (" + toofrom[2] + ")");
                continue;
            }
            System.out.println("ShiftTo(" + too[0] + ")==" + "NaN! - not Bijective Mapping!");
        }
        int[][] mmap = ml.makeFromMap();
        System.out.println("FromMap : (" + mmap[0][0] + " " + mmap[0][1] + " " + mmap[0][2] + " " + mmap[0][3] + " ");
        for (i2 = 1; i2 <= mmap[1].length; ++i2) {
            if (mmap[1][i2 - 1] == -1) {
                System.out.print(i2 + "=XXX");
            } else {
                System.out.print(i2 + "=" + (mmap[0][2] + mmap[1][i2 - 1]));
            }
            if (i2 % 20 == 0) {
                System.out.print("\n");
                continue;
            }
            System.out.print(",");
        }
        System.out.print("\nTest locateInFrom\n");
        int f = mmap[0][2];
        for (t = mmap[0][3]; f <= t; ++f, --t) {
            System.out.println("Range " + f + " to " + t);
            rng = ml.locateInFrom(f, t);
            if (rng != null) {
                for (i = 0; i < rng.length; ++i) {
                    System.out.print(rng[i] + (i % 2 == 0 ? "," : ";"));
                }
            } else {
                System.out.println("No range!");
            }
            System.out.print("\nReversed\n");
            rng = ml.locateInFrom(t, f);
            if (rng != null) {
                for (i = 0; i < rng.length; ++i) {
                    System.out.print(rng[i] + (i % 2 == 0 ? "," : ";"));
                }
            } else {
                System.out.println("No range!");
            }
            System.out.print("\n");
        }
        System.out.print("\n");
        mmap = ml.makeToMap();
        System.out.println("ToMap : (" + mmap[0][0] + " " + mmap[0][1] + " " + mmap[0][2] + " " + mmap[0][3] + " ");
        for (i2 = 1; i2 <= mmap[1].length; ++i2) {
            if (mmap[1][i2 - 1] == -1) {
                System.out.print(i2 + "=XXX");
            } else {
                System.out.print(i2 + "=" + (mmap[0][2] + mmap[1][i2 - 1]));
            }
            if (i2 % 20 == 0) {
                System.out.print("\n");
                continue;
            }
            System.out.print(",");
        }
        System.out.print("\n");
        System.out.print("\nTest locateInTo\n");
        f = mmap[0][2];
        for (t = mmap[0][3]; f <= t; ++f, --t) {
            System.out.println("Range " + f + " to " + t);
            rng = ml.locateInTo(f, t);
            if (rng != null) {
                for (i = 0; i < rng.length; ++i) {
                    System.out.print(rng[i] + (i % 2 == 0 ? "," : ";"));
                }
            } else {
                System.out.println("No range!");
            }
            System.out.print("\nReversed\n");
            rng = ml.locateInTo(t, f);
            if (rng != null) {
                for (i = 0; i < rng.length; ++i) {
                    System.out.print(rng[i] + (i % 2 == 0 ? "," : ";"));
                }
            } else {
                System.out.println("No range!");
            }
            System.out.print("\n");
        }
    }

    public static void main(String[] argv) {
        MapList ml = new MapList(new int[]{1, 5, 10, 15, 25, 20}, new int[]{51, 1}, 1, 3);
        MapList ml1 = new MapList(new int[]{1, 3, 17, 4}, new int[]{51, 1}, 1, 3);
        MapList ml2 = new MapList(new int[]{1, 60}, new int[]{1, 20}, 3, 1);
        int[] to = new int[51];
        MapList.testMap(ml, 1, 60);
        MapList mldna = new MapList(new int[]{2, 2, 6, 8, 12, 16}, new int[]{1, 3}, 3, 1);
        int[] frm = mldna.locateInFrom(1, 1);
        MapList.testLocateFrom(mldna, 1, 1, new int[]{2, 2, 6, 7});
        MapList.testMap(mldna, 1, 3);
        System.out.print("Success?\n");
    }

    private static void testLocateFrom(MapList mldna, int i, int j, int[] ks) {
        int[] frm = mldna.locateInFrom(i, j);
        if (frm == ks || Arrays.equals(frm, ks)) {
            System.out.println("Success test locate from " + i + " to " + j);
        } else {
            int c;
            System.err.println("Failed test locate from " + i + " to " + j);
            for (c = 0; c < frm.length; ++c) {
                System.err.print(frm[c] + (c % 2 == 0 ? "," : ";"));
            }
            System.err.println("Expected");
            for (c = 0; c < ks.length; ++c) {
                System.err.print(ks[c] + (c % 2 == 0 ? "," : ";"));
            }
        }
    }

    public MapList getInverse() {
        return new MapList(this.getToRanges(), this.getFromRanges(), this.getToRatio(), this.getFromRatio());
    }

    public boolean containsEither(boolean local, MapList map) {
        if (local) {
            return this.getFromLowest() >= map.getFromLowest() && this.getFromHighest() <= map.getFromHighest() || this.getFromLowest() <= map.getFromLowest() && this.getFromHighest() >= map.getFromHighest();
        }
        return this.getToLowest() >= map.getToLowest() && this.getToHighest() <= map.getToHighest() || this.getToLowest() <= map.getToLowest() && this.getToHighest() >= map.getToHighest();
    }
}

