/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.IClientDocument;
import uk.ac.vamsas.objects.IDocumentUpdater;
import uk.ac.vamsas.objects.core.Alignment;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.DataSetAnnotations;
import uk.ac.vamsas.objects.core.Sequence;
import uk.ac.vamsas.objects.core.Tree;
import uk.ac.vamsas.objects.core.VAMSAS;

public class DocumentUpdaterEngine {
    private static Log log = LogFactory.getLog((Class)DocumentUpdaterEngine.class);
    private IDocumentUpdater handler;

    public DocumentUpdaterEngine(IDocumentUpdater handler) {
        this.handler = handler;
    }

    public void callHandlers(IClientDocument cdoc) {
        if (cdoc == null) {
            log.debug((Object)"Null IClientDocument instance.");
            return;
        }
        VAMSAS[] roots = cdoc.getVamsasRoots();
        if (roots != null) {
            for (int r = 0; r < roots.length; ++r) {
                if (!roots[r].isNewInDocument() && !roots[r].isUpdated() || this.updateRoot(roots[r])) continue;
                log.debug((Object)"Calling handler(VAMSAS)");
                this.handler.update(roots[r]);
            }
        } else {
            log.debug((Object)"No Document Roots.");
        }
        log.debug((Object)"Finished.");
    }

    private boolean updateRoot(VAMSAS vamsas) {
        boolean called = false;
        DataSet[] dset = vamsas.getDataSet();
        if (dset != null) {
            for (int ds = 0; ds < dset.length; ++ds) {
                if (!dset[ds].isNewInDocument() && !dset[ds].isUpdated() || this.updateDataset(dset[ds])) continue;
                log.debug((Object)"Calling handler(Dataset)");
                this.handler.update(dset[ds]);
                called = true;
            }
        }
        return called;
    }

    private boolean updateDataset(DataSet set) {
        Alignment[] al;
        DataSetAnnotations[] dann;
        boolean called = false;
        Sequence[] dseq = set.getSequence();
        if (dseq != null) {
            for (int s = 0; s < dseq.length; ++s) {
                if (!dseq[s].isNewInDocument() && !dseq[s].isUpdated() || this.updateSequence(dseq[s])) continue;
                log.debug((Object)"Calling update(Sequence)");
                this.handler.update(dseq[s]);
                called = true;
            }
        }
        if ((dann = set.getDataSetAnnotations()) != null) {
            for (int a = 0; a < dann.length; ++a) {
                if (!dann[a].isNewInDocument() && !dann[a].isUpdated() || this.updateDataSetAnnotation(dann[a])) continue;
                log.debug((Object)"Calling update(DataSetAnnotation)");
                this.handler.update(dann[a]);
                called = true;
            }
        }
        if ((al = set.getAlignment()) != null) {
            for (int a = 0; a < al.length; ++a) {
                if (!al[a].isNewInDocument() && !al[a].isUpdated() || this.updateAlignment(al[a])) continue;
                log.debug((Object)"Calling update(Alignment)");
                this.handler.update(al[a]);
                called = true;
            }
        }
        if (this.updateTrees(set.getTree())) {
            called = true;
        }
        return called;
    }

    private boolean updateTrees(Tree[] trees) {
        boolean called = false;
        if (trees != null) {
            for (int t = 0; t < trees.length; ++t) {
                if (!trees[t].isNewInDocument() && !trees[t].isUpdated() || this.updateTree(trees[t])) continue;
                log.debug((Object)"Calling update(tree)");
                this.handler.update(trees[t]);
                called = true;
            }
        }
        return called;
    }

    private boolean updateDataSetAnnotation(DataSetAnnotations annotations) {
        boolean called = false;
        return called;
    }

    private boolean updateTree(Tree tree) {
        return false;
    }

    private boolean updateAlignment(Alignment alignment) {
        return false;
    }

    private boolean updateSequence(Sequence sequence) {
        return false;
    }
}

