/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.engine.conf.RunnerConfigMarshaller;
import compbio.metadata.AllTestSuit;
import compbio.metadata.RunnerConfig;
import compbio.runner.OptionCombinator;
import compbio.runner.msa.Mafft;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OptionCombinatorTester {
    static final String mafftConfigFile = AllTestSuit.TEST_DATA_PATH + "MafftParameters.xml";
    static final String muscleConfigFile = AllTestSuit.TEST_DATA_PATH + "MuscleParameters.xml";
    static final String clustalConfigFile = AllTestSuit.TEST_DATA_PATH + "ClustalParameters.xml";
    RunnerConfig<Mafft> mafftConfig = null;
    RunnerConfig<Mafft> muscleConfig = null;
    RunnerConfig<Mafft> clustalConfig = null;

    @BeforeMethod
    void setup() {
        try {
            RunnerConfigMarshaller mf = new RunnerConfigMarshaller(RunnerConfig.class);
            this.mafftConfig = (RunnerConfig)mf.read((InputStream)new FileInputStream(new File(mafftConfigFile)), RunnerConfig.class);
            RunnerConfigMarshaller musclemarsh = new RunnerConfigMarshaller(RunnerConfig.class);
            this.muscleConfig = (RunnerConfig)musclemarsh.read((InputStream)new FileInputStream(new File(muscleConfigFile)), RunnerConfig.class);
            RunnerConfigMarshaller clustalmarsh = new RunnerConfigMarshaller(RunnerConfig.class);
            this.clustalConfig = (RunnerConfig)clustalmarsh.read((InputStream)new FileInputStream(new File(clustalConfigFile)), RunnerConfig.class);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (JAXBException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testgetAllOptions() {
        OptionCombinator opc = new OptionCombinator(this.mafftConfig);
        System.out.println(opc.getOptionsAtRandom());
        OptionCombinator muscleOpc = new OptionCombinator(this.muscleConfig);
        System.out.println("Mucle " + muscleOpc.getOptionsAtRandom());
        OptionCombinator clustalOpc = new OptionCombinator(this.clustalConfig);
        System.out.println("Clustal " + clustalOpc.getOptionsAtRandom());
    }

    @Test
    public void testgetAllParameters() {
        OptionCombinator opc = new OptionCombinator(this.mafftConfig);
        System.out.println(opc.getAllParameters());
        OptionCombinator muscleOpc = new OptionCombinator(this.muscleConfig);
        System.out.println("Muscle : " + muscleOpc.getAllParameters());
        OptionCombinator clustalOpc = new OptionCombinator(this.clustalConfig);
        System.out.println("Clustal : " + clustalOpc.getAllParameters());
    }
}

