/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.metadata.AllTestSuit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ClustalAlignmentUtilTester {
    @Test
    public void testReadClustalFile() {
        try {
            ClustalAlignmentUtilTester.readWriteClustal("TO1381.aln");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
    }

    static void readWriteClustal(String fname) throws IOException, UnknownFileFormatException {
        FileInputStream fio = new FileInputStream(AllTestSuit.TEST_DATA_PATH + fname);
        Alignment seqAl = ClustalAlignmentUtil.readClustalFile(fio);
        AssertJUnit.assertTrue((seqAl != null ? 1 : 0) != 0);
        AssertJUnit.assertTrue((seqAl.getSize() == 3 ? 1 : 0) != 0);
        AssertJUnit.assertNotNull(seqAl.getSequences());
        AssertJUnit.assertEquals((int)3, (int)seqAl.getSequences().size());
        FileWriter os = new FileWriter(AllTestSuit.TEST_DATA_PATH + fname + ".written");
        ClustalAlignmentUtil.writeClustalAlignment(os, seqAl);
        fio.close();
        ((Writer)os).close();
        fio = new FileInputStream(AllTestSuit.TEST_DATA_PATH + fname + ".written");
        Alignment readseqs = ClustalAlignmentUtil.readClustalFile(fio);
        AssertJUnit.assertTrue((readseqs != null ? 1 : 0) != 0);
        AssertJUnit.assertTrue((readseqs.getSize() == 3 ? 1 : 0) != 0);
        fio.close();
    }

    @Test
    public void testReadClustalFileShortNames() {
        try {
            ClustalAlignmentUtilTester.readWriteClustal("TO1381s.aln");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReadClustalFileLongNames() {
        try {
            ClustalAlignmentUtilTester.readWriteClustal("TO1381L.aln");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
    }
}

