/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.data;

import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.util.Config;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.StringUtil;
import jalview.util.FileUtils;
import jalview.util.HttpUtils;
import jalview.util.LaunchUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class EnvConfig {
    public final File appDir;
    public final String appId;
    public final String appBase;
    public final List<Certificate> certs;
    public final List<String> appArgs;
    private static boolean relaunched = false;
    private static final String USER_HOME_KEY = "${user.home}";
    private static String applicationFolder = null;
    private static String installerAppdir = null;
    private static String appName = null;
    private static String appDirHash = null;
    public static final String USER_DEFAULT_APPDIR_PROPERTY = "userdefaultappdir";
    protected static final String APPLICATION_APPDIR_PROPERTY = "installer.appdir";
    protected static final String BACKUP_APPLICATION_APPDIR_PROPERTY = "installer.original_appdir";
    protected static final String POPULATE_DEFAULT_APPDIR_PROPERTY = "populatedefaultappdir";
    protected static final String SET_USER_APPDIR_PATH = "setuserappdirpath";
    private static final Map<String, String> osAppDataPathMap = new HashMap<String, String>();

    public static EnvConfig create(String[] argv, List<Note> notes) {
        return EnvConfig.create(argv, notes, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EnvConfig create(String[] argv, List<Note> notes, Class startClass) {
        File appDirFile;
        int skipArgs;
        String appBase;
        String appId;
        block50: {
            String appDir;
            block51: {
                String argvLocatorFilename;
                String argvAppId;
                String argvAppDir;
                String spropsAppBase;
                String spropsAppId;
                String spropsAppDir;
                appDir = null;
                String appDirProv = null;
                appId = null;
                String appIdProv = null;
                appBase = null;
                String appBaseProv = null;
                EnvConfig.setVarsFromProperties();
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle("bootstrap");
                    if (bundle.containsKey("appdir")) {
                        appDir = bundle.getString("appdir");
                        appDir = appDir.replace(USER_HOME_KEY, System.getProperty("user.home"));
                        appDirProv = "bootstrap.properties";
                    }
                    if (bundle.containsKey("appid")) {
                        appId = bundle.getString("appid");
                        appIdProv = "bootstrap.properties";
                    }
                    if (bundle.containsKey("appbase")) {
                        appBase = bundle.getString("appbase");
                        appBaseProv = "bootstrap.properties";
                    }
                    for (String key : bundle.keySet()) {
                        if (!key.startsWith("sys.")) continue;
                        String skey = key.substring(4);
                        String svalue = bundle.getString(key);
                        notes.add(Note.info("Setting system property from bundle: " + skey + "='" + svalue + "'"));
                        System.setProperty(skey, svalue);
                    }
                }
                catch (MissingResourceException bundle) {
                    // empty catch block
                }
                if (!StringUtil.isBlank(spropsAppDir = SysProps.appDir())) {
                    if (appDir == null) {
                        appDir = spropsAppDir;
                        appDirProv = "system property";
                    } else {
                        notes.add(Note.warn("Ignoring 'appdir' system property, have appdir via '" + appDirProv + "'"));
                    }
                }
                if (!StringUtil.isBlank(spropsAppId = SysProps.appId())) {
                    if (appId == null) {
                        appId = spropsAppId;
                        appIdProv = "system property";
                    } else {
                        notes.add(Note.warn("Ignoring 'appid' system property, have appid via '" + appIdProv + "'"));
                    }
                }
                if (!StringUtil.isBlank(spropsAppBase = SysProps.appBase())) {
                    if (appBase == null) {
                        appBase = spropsAppBase;
                        appBaseProv = "system property";
                    } else {
                        notes.add(Note.warn("Ignoring 'appbase' system property, have appbase via '" + appBaseProv + "'"));
                    }
                }
                String string = argvAppDir = argv.length > 0 ? argv[0] : null;
                if (!StringUtil.isBlank(argvAppDir)) {
                    if (appDir == null) {
                        appDir = argvAppDir;
                        appDirProv = "command line";
                    } else {
                        notes.add(Note.warn("Ignoring 'appdir' command line arg, have appdir via '" + appDirProv + "'"));
                    }
                }
                String string2 = argvAppId = argv.length > 1 ? argv[1] : null;
                if (!StringUtil.isBlank(argvAppId)) {
                    if (appId == null) {
                        appId = argvAppId;
                        appIdProv = "command line";
                    } else {
                        notes.add(Note.warn("Ignoring 'appid' command line arg, have appid via '" + appIdProv + "'"));
                    }
                }
                skipArgs = 2;
                boolean userAppDir = false;
                if (StringUtil.isBlank(appDir) && (appDir = EnvConfig.getUserAppdir()) != null) {
                    appDirProv = "user default";
                    userAppDir = true;
                }
                if (appDir == null && Boolean.valueOf(System.getProperty("nouserdefaultappdir")).booleanValue()) {
                    appDir = installerAppdir;
                    appDirProv = "installer appdir";
                    userAppDir = false;
                    notes.add(Note.info("Not using userdefaultappdir, resorting to " + appDirProv + " '" + appDir + "'"));
                } else if (userAppDir && installerAppdir != null) {
                    String getdown = "getdown-launcher.jar";
                    File appdirGetdown = new File(appDir, "getdown-launcher.jar");
                    if (appdirGetdown.exists()) {
                        File installerGetdown = new File(installerAppdir, "getdown-launcher.jar");
                        int launcherVersionComparison = LaunchUtils.compareGetdownLauncherJarVersions(installerGetdown, appdirGetdown);
                        notes.add(Note.info("Comparing launchers: installation launcher '" + installerGetdown.getAbsolutePath() + "', user launcher '" + appdirGetdown.getAbsoluteFile() + "', comparison=" + launcherVersionComparison));
                        if (launcherVersionComparison < 0) {
                            String startClassName;
                            int exitValue;
                            notes.add(Note.info("Using user appdir launcher at '" + appdirGetdown.getAbsolutePath() + "'"));
                            String javaBin = LaunchUtils.findJavaBin(false);
                            ArrayList<String> removeClasspath = new ArrayList<String>();
                            removeClasspath.add(installerGetdown.getAbsolutePath());
                            ArrayList<String> prependClasspath = new ArrayList<String>();
                            prependClasspath.add(appdirGetdown.getAbsolutePath());
                            ArrayList<String> removeArgs = new ArrayList<String>();
                            removeArgs.add(argvAppDir);
                            removeArgs.add(argvAppId);
                            ArrayList<String> addArgs = new ArrayList<String>();
                            addArgs.add(appDir);
                            addArgs.add(appId);
                            ArrayList<String> removeJvmArgs = null;
                            ArrayList<String> addJvmArgs = null;
                            String macIcons = System.getProperty("installer.mac_icons");
                            if (LaunchUtil.isMacOS()) {
                                removeJvmArgs = new ArrayList<String>();
                                addJvmArgs = new ArrayList<String>();
                                if (macIcons != null) {
                                    removeJvmArgs.add("-Xdock:icon=");
                                    addJvmArgs.add("-Xdock:icon=" + installerAppdir + File.separator + "resource" + File.separator + macIcons);
                                }
                                removeJvmArgs.add("-Xdock:name=");
                                addJvmArgs.add("-Xdock:name=" + (appName != null ? appName : "Jalview"));
                            }
                            if ((exitValue = LaunchUtils.startNewJvm(javaBin, removeJvmArgs, addJvmArgs, prependClasspath, null, removeClasspath, startClassName = startClass == null ? null : startClass.getName(), removeArgs, addArgs, Arrays.asList(argv), true, true, false, true, false)) == 0) {
                                notes.add(Note.info("Relaunching getdown succeeded.  Original getdown exiting now."));
                                EnvConfig.setRelaunched(true);
                                return null;
                            }
                            notes.add(Note.warn("Relaunching getdown did not seem to succeed with exit value " + exitValue + ".  Continuing with this getdown process."));
                        } else {
                            notes.add(Note.info("Using user installation launcher at '" + appdirGetdown.getAbsolutePath() + "'"));
                        }
                    }
                }
                String string3 = argvLocatorFilename = argv.length > 2 ? argv[2] : null;
                if (!StringUtil.isBlank(argvLocatorFilename) && argvLocatorFilename.toLowerCase(Locale.ROOT).endsWith(".jvl")) {
                    argvLocatorFilename = HttpUtils.equivalentJalviewUrl(argvLocatorFilename);
                    notes.add(Note.info("locatorFilename in args: '" + argv[2] + "'"));
                    Application.setLocatorFile(argvLocatorFilename);
                    String lfAppBase = EnvConfig.getLocatorFileAppBase(argvLocatorFilename);
                    if (!StringUtil.isBlank(lfAppBase)) {
                        appBase = lfAppBase;
                        appBaseProv = "from jvl file";
                    }
                    ++skipArgs;
                }
                if (appDir == null) {
                    if (SysProps.noUpdate()) return null;
                    notes.add(Note.error("No appDir could be determined. You may need to set -Dsilent=noupdate -Dnouserdefaultappdir"));
                    return null;
                }
                notes.add(Note.info("Using appdir from " + appDirProv + ": " + appDir));
                if (appId != null) {
                    notes.add(Note.info("Using appid from " + appIdProv + ": " + appId));
                }
                if (appBase != null) {
                    notes.add(Note.info("Using appbase from " + appBaseProv + ": " + appBase));
                }
                if ((appDirFile = new File(appDir)).exists()) break block51;
                if (!StringUtil.isBlank(appBase)) {
                    if (FileUtils.mkdirs(appDirFile)) {
                        notes.add(Note.info("Auto-created app directory '" + appDir + "'"));
                        break block50;
                    } else {
                        notes.add(Note.warn("Unable to auto-create app dir: '" + appDir + "'"));
                    }
                    break block50;
                } else if (userAppDir && Boolean.valueOf(System.getProperty(POPULATE_DEFAULT_APPDIR_PROPERTY)).booleanValue()) {
                    appBase = System.getProperty(APPLICATION_APPDIR_PROPERTY);
                    Application.copyApplicationAppDirToUserAppDir(System.getProperty(APPLICATION_APPDIR_PROPERTY), appDir);
                    break block50;
                } else {
                    notes.add(Note.error("Invalid appdir '" + appDir + "': directory does not exist"));
                    return null;
                }
            }
            if (!appDirFile.isDirectory()) {
                notes.add(Note.error("Invalid appdir '" + appDir + "': refers to non-directory"));
                return null;
            }
        }
        List<String> appArgs = argv.length > skipArgs ? Arrays.asList(argv).subList(skipArgs, argv.length) : Collections.emptyList();
        File crtFile = new File(appDirFile, Digest.digestFile(2) + ".crt");
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        if (!crtFile.exists()) return new EnvConfig(appDirFile, appId, appBase, certs, appArgs);
        try (FileInputStream fis = new FileInputStream(crtFile);){
            X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(fis);
            certs.add(certificate);
            return new EnvConfig(appDirFile, appId, appBase, certs, appArgs);
        }
        catch (Exception e) {
            notes.add(Note.error("Certificate error: " + e.getMessage()));
        }
        return new EnvConfig(appDirFile, appId, appBase, certs, appArgs);
    }

    public EnvConfig(File appDir) {
        this(appDir, null, null, Collections.emptyList(), Collections.emptyList());
    }

    private EnvConfig(File appDir, String appId, String appBase, List<Certificate> certs, List<String> appArgs) {
        this.appDir = appDir;
        this.appId = appId;
        this.appBase = appBase;
        this.certs = certs;
        this.appArgs = appArgs;
    }

    public static final String getFullPathToDirectoryHash(String install_app_dir) {
        MessageDigest md = Digest.getMessageDigest(2);
        byte[] contents = install_app_dir.getBytes(StandardCharsets.UTF_8);
        String hash = StringUtil.hexlate(md.digest(contents));
        return hash.substring(0, 8);
    }

    public static final String getUserAppdir() {
        String append;
        String appDataPath;
        String noUseDefaultAppDirProperty = "nouserdefaultappdir";
        if (Boolean.valueOf(System.getProperty("nouserdefaultappdir")).booleanValue()) {
            System.err.println("Not using default user appdir because property 'nouserdefaultappdir' is '" + System.getProperty("nouserdefaultappdir") + "'");
            return null;
        }
        if (!Boolean.valueOf(System.getProperty(USER_DEFAULT_APPDIR_PROPERTY)).booleanValue()) {
            System.err.println("Not using default user appdir because property 'userdefaultappdir' is '" + System.getProperty(USER_DEFAULT_APPDIR_PROPERTY) + "'");
            return null;
        }
        String appdirname = applicationFolder == null || applicationFolder.length() == 0 ? "Jalview" : applicationFolder;
        String home = System.getProperty("user.home");
        if (appName == null) {
            appName = System.getProperty("channel.app_name");
        }
        if (installerAppdir == null) {
            installerAppdir = System.getProperty(APPLICATION_APPDIR_PROPERTY);
        }
        String appname = StringUtil.isBlank(appName) ? "Jalview" : appName;
        String FS = File.separator;
        try {
            EnvConfig.setAppDirHash(installerAppdir);
        }
        catch (IOException ioex) {
            System.err.println("Unable to resolve '" + installerAppdir + "' as a proper path on this system.\nNot generating a user local appdir - getdown may fail to update!");
            return null;
        }
        boolean addHome = true;
        if (LaunchUtil.isMacOS()) {
            appDataPath = osAppDataPathMap.get("macos");
            append = appname;
        } else if (LaunchUtil.isWindows()) {
            appDataPath = osAppDataPathMap.get("windows");
            append = appdirname;
        } else if (LaunchUtil.isLinux()) {
            appDataPath = osAppDataPathMap.get("linux");
            append = appdirname.toLowerCase(Locale.ROOT);
        } else {
            appDataPath = osAppDataPathMap.get("other");
            append = appdirname.toLowerCase(Locale.ROOT);
        }
        String setUserAppDirPath = System.getProperty(SET_USER_APPDIR_PATH);
        if (!StringUtil.isBlank(setUserAppDirPath) && setUserAppDirPath.indexOf("..") == -1) {
            if (setUserAppDirPath.startsWith("~" + FS)) {
                setUserAppDirPath = home + setUserAppDirPath.substring(1);
            }
            String username = System.getProperty("user.name");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < username.length(); ++i) {
                String code = Integer.toHexString(Character.codePointAt(username, i));
                if (i > 0) {
                    sb.append("-");
                }
                sb.append(code);
            }
            String asciiname = sb.toString();
            appDataPath = setUserAppDirPath.replaceAll("%u", username).replaceAll("%h", home).replaceAll("%U", asciiname);
            addHome = false;
        }
        StringBuilder sb = new StringBuilder();
        if (addHome) {
            sb.append(home).append(FS);
        }
        sb.append(appDataPath).append(FS);
        sb.append(append).append(FS);
        sb.append(EnvConfig.getAppDirHash()).append(FS);
        sb.append("app");
        return sb.toString();
    }

    public static void setRelaunched(boolean b) {
        relaunched = b;
    }

    public static boolean getRelaunched() {
        return relaunched;
    }

    public static String getLocatorFileAppBase(String locatorFile) {
        String lfAppBase = null;
        Config.ParseOpts opts = Config.createOpts(false);
        Config checkConfig = Application.createLocatorConfig(opts);
        if (!StringUtil.isBlank(checkConfig.getString("appbase"))) {
            lfAppBase = checkConfig.getString("appbase");
        }
        return lfAppBase;
    }

    public static String getAppname() {
        return appName;
    }

    public static void setVarsFromProperties() {
        installerAppdir = System.getProperty(APPLICATION_APPDIR_PROPERTY);
        if (!new File(installerAppdir).exists() && System.getProperty(BACKUP_APPLICATION_APPDIR_PROPERTY) != null && new File(System.getProperty(BACKUP_APPLICATION_APPDIR_PROPERTY)).exists()) {
            installerAppdir = System.getProperty(BACKUP_APPLICATION_APPDIR_PROPERTY);
            System.setProperty(APPLICATION_APPDIR_PROPERTY, installerAppdir);
        }
        applicationFolder = System.getProperty("installer.application_folder");
        appName = System.getProperty("channel.app_name");
    }

    public static String getAppDirHash() {
        return appDirHash;
    }

    public static void setAppDirHash(String path) throws IOException {
        appDirHash = EnvConfig.getFullPathToDirectoryHash(FileUtils.getCanonicalPath(path).toString());
    }

    static {
        osAppDataPathMap.put("macos", "Library/Application Support/Jalview-Desktop");
        osAppDataPathMap.put("linux", ".local/share/jalview-desktop");
        osAppDataPathMap.put("windows", "AppData\\Local\\Jalview-Desktop");
        osAppDataPathMap.put("other", ".jalview-desktop");
    }

    public static final class Note {
        public final Level level;
        public final String message;

        public static Note info(String msg) {
            return new Note(Level.INFO, msg);
        }

        public static Note warn(String msg) {
            return new Note(Level.WARN, msg);
        }

        public static Note error(String msg) {
            return new Note(Level.ERROR, msg);
        }

        public Note(Level level, String message) {
            this.level = level;
            this.message = message;
        }

        public static enum Level {
            INFO,
            WARN,
            ERROR;

        }
    }
}

