/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Connection;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.TemplateEdits;
import fr.orsay.lri.varna.applications.templateEditor.TemplatePanel;
import fr.orsay.lri.varna.applications.templateEditor.UnpairedRegion;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.geom.Point2D;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public class TemplateEditorPanelUI {
    private UndoableEditSupport _undoableEditSupport;
    private TemplatePanel _tp;
    private Tool selectedTool = Tool.CREATE_HELIX;

    public TemplateEditorPanelUI(TemplatePanel templatePanel) {
        this._tp = templatePanel;
        this._undoableEditSupport = new UndoableEditSupport(templatePanel);
    }

    public Tool getSelectedTool() {
        return this.selectedTool;
    }

    public void setSelectedTool(Tool tool) {
        this.selectedTool = tool;
    }

    public void undoableEdgeMove(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition, double d, double d2) {
        this._undoableEditSupport.postEdit(new TemplateEdits.ElementEdgeMoveTemplateEdit(graphicalTemplateElement, relativePosition, d, d2, this._tp));
        graphicalTemplateElement.setEdgePosition(relativePosition, new Point2D.Double(d, d2));
        this._tp.repaint();
    }

    public void setEdge5UI(GraphicalTemplateElement graphicalTemplateElement, double d, double d2) {
        this.undoableEdgeMove(graphicalTemplateElement, GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5, d, d2);
    }

    public void setEdge3UI(UnpairedRegion unpairedRegion, double d, double d2) {
        this.undoableEdgeMove(unpairedRegion, GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3, d, d2);
    }

    public void setEdge5TangentUI(UnpairedRegion unpairedRegion, double d, double d2) {
        this.undoableEdgeMove(unpairedRegion, GraphicalTemplateElement.RelativePosition.RP_EDIT_TANGENT_5, d, d2);
    }

    public void setEdge3TangentUI(UnpairedRegion unpairedRegion, double d, double d2) {
        this.undoableEdgeMove(unpairedRegion, GraphicalTemplateElement.RelativePosition.RP_EDIT_TANGENT_3, d, d2);
    }

    public void moveUnpairedUI(UnpairedRegion unpairedRegion, double d, double d2) {
        this.undoableEdgeMove(unpairedRegion, GraphicalTemplateElement.RelativePosition.RP_INNER_MOVE, d, d2);
    }

    public void moveHelixUI(Helix helix, double d, double d2) {
        this.undoableEdgeMove(helix, GraphicalTemplateElement.RelativePosition.RP_INNER_MOVE, d, d2);
    }

    public void setHelixPosUI(Helix helix, double d, double d2) {
        this.undoableEdgeMove(helix, GraphicalTemplateElement.RelativePosition.RP_EDIT_START, d, d2);
    }

    public void setHelixExtentUI(Helix helix, double d, double d2) {
        this.undoableEdgeMove(helix, GraphicalTemplateElement.RelativePosition.RP_EDIT_END, d, d2);
    }

    public void addElementUI(GraphicalTemplateElement graphicalTemplateElement) {
        this._undoableEditSupport.postEdit(new TemplateEdits.ElementAddTemplateEdit(graphicalTemplateElement, this._tp));
        this._tp.addElement(graphicalTemplateElement);
    }

    public void removeElementUI(GraphicalTemplateElement graphicalTemplateElement) {
        this._undoableEditSupport.postEdit(new TemplateEdits.ElementRemoveTemplateEdit(graphicalTemplateElement, this._tp));
        this._tp.removeElement(graphicalTemplateElement);
    }

    public void addUndoableEditListener(UndoManager undoManager) {
        this._undoableEditSupport.addUndoableEditListener(undoManager);
    }

    public void addConnectionUI(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition, GraphicalTemplateElement graphicalTemplateElement2, GraphicalTemplateElement.RelativePosition relativePosition2) {
        if (GraphicalTemplateElement.canConnect(graphicalTemplateElement, relativePosition, graphicalTemplateElement2, relativePosition2)) {
            Connection connection = this._tp.addConnection(graphicalTemplateElement, relativePosition, graphicalTemplateElement2, relativePosition2);
            this._undoableEditSupport.postEdit(new TemplateEdits.ElementAttachTemplateEdit(connection, this._tp));
        }
    }

    public void removeConnectionUI(Connection connection) {
        this._undoableEditSupport.postEdit(new TemplateEdits.ElementDetachTemplateEdit(connection, this._tp));
        this._tp.removeConnection(connection);
    }

    public void flipHelixUI(Helix helix) {
        this._undoableEditSupport.postEdit(new TemplateEdits.HelixFlipTemplateEdit(helix, this._tp));
        this._tp.flip(helix);
        this._tp.repaint();
    }

    public RNATemplate getTemplate() {
        return this._tp.getTemplate();
    }

    public static enum Tool {
        SELECT,
        CREATE_HELIX,
        CREATE_UNPAIRED;

    }
}

