/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.simpleclient.FileWatcher;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.SimpleDocument;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.client.simpleclient.VamsasFile;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.test.simpleclient.ArchiveReports;
import uk.ac.vamsas.test.simpleclient.CommandProcessor;

public class ArchiveWatcher {
    private static Log log = LogFactory.getLog((Class)ArchiveWatcher.class);
    private static CommandProcessor cproc = new CommandProcessor();

    public static void main(String[] args) {
        block16: {
            try {
                if (args == null || args.length <= 0) break block16;
                File archive = new File(args[0]);
                log.info((Object)("Watching file " + args[0]));
                int argc = 1;
                block11: while (argc < args.length) {
                    int com = cproc.getCommand(args, argc);
                    ++argc;
                    switch (com) {
                        case 0: {
                            log.info((Object)"Doing locked deletion and new-file creation.");
                            if (!archive.exists()) {
                                archive.createNewFile();
                            }
                            VamsasFile sf = new VamsasFile(archive);
                            Lock l = sf.getLock();
                            archive.delete();
                            archive.createNewFile();
                            sf.unLock();
                            continue block11;
                        }
                        case 1: {
                            log.info((Object)("Deleting " + archive + " without locking it first."));
                            archive.delete();
                            continue block11;
                        }
                        case 2: {
                            log.info((Object)("Endlessly Watching file " + archive));
                            FileWatcher w = new FileWatcher(archive);
                            while (true) {
                                Lock chlock;
                                if ((chlock = w.getChangedState()) == null) {
                                    continue;
                                }
                                log.info((Object)("Got lock on " + archive + (archive.exists() ? " exists l=" + archive.length() : "(non existant)")));
                                if (archive.length() <= 0L) continue;
                                VamsasArchiveReader vreader = new VamsasArchiveReader(archive);
                                SimpleDocument sdoc = new SimpleDocument("testing vamsas watcher");
                                try {
                                    VamsasDocument d = sdoc.getVamsasDocument(vreader);
                                    if (d != null) {
                                        ArchiveReports.reportDocument(d, vreader, false, System.out);
                                    }
                                    System.out.println("Update at " + System.currentTimeMillis() + "\n\n********************************************************\n");
                                }
                                catch (Exception e) {
                                    log.error((Object)"Unmarshalling failed.", (Throwable)e);
                                }
                                vreader.close();
                                w.setState();
                            }
                        }
                        case 3: {
                            archive = new File(args[argc++]);
                            continue block11;
                        }
                        case 4: {
                            continue block11;
                        }
                    }
                    log.warn((Object)("Unknown command  + " + args[argc++]));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    static {
        cproc.addCommand("new", 0, "no args");
        cproc.addCommand("delete", 0, "no args");
        cproc.addCommand("watch", 0, "no args");
        cproc.addCommand("file", 1, "Need vamsas archive as argument.");
    }
}

