/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.Events;
import uk.ac.vamsas.client.IClient;
import uk.ac.vamsas.client.IClientDocument;
import uk.ac.vamsas.client.IObjectUpdate;
import uk.ac.vamsas.client.InvalidSessionUrnException;
import uk.ac.vamsas.client.SessionHandle;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.client.picking.IPickManager;
import uk.ac.vamsas.client.picking.SocketManager;
import uk.ac.vamsas.client.simpleclient.ClientDocument;
import uk.ac.vamsas.client.simpleclient.EventGeneratorThread;
import uk.ac.vamsas.client.simpleclient.IdFactory;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.LockFactory;
import uk.ac.vamsas.client.simpleclient.SessionUrn;
import uk.ac.vamsas.client.simpleclient.SimpleClientConfig;
import uk.ac.vamsas.client.simpleclient.SimplePickManager;
import uk.ac.vamsas.client.simpleclient.VamsasArchive;
import uk.ac.vamsas.client.simpleclient.VamsasSession;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.objects.utils.ProvenanceStuff;

public class SimpleClient
implements IClient {
    private static Log log = LogFactory.getLog((Class)SimpleClient.class);
    protected UserHandle user = null;
    protected SessionUrn session = null;
    protected VamsasSession _session;
    protected ClientHandle client = null;
    protected EventGeneratorThread evgen = null;
    protected ClientDocument cdocument = null;
    private Lock activeClientFilelock = null;
    private File clientlockFile = null;
    protected Hashtable extantobjects = null;
    private Hashtable handlers = SimpleClient.initHandlers();
    private Vector listeners = new Vector();
    boolean finalized = false;
    SimplePickManager pickmanager = null;
    SimpleClientConfig _config = null;

    private IdFactory makeVorbaIdFactory() {
        if (this.extantobjects == null) {
            this.extantobjects = new Hashtable();
        }
        return new IdFactory(this.getSessionHandle(), this.client, this.user, this.extantobjects);
    }

    protected SimpleClient(UserHandle user, ClientHandle client, VamsasSession sess) throws InvalidSessionUrnException {
        this._session = sess;
        this.user = user;
        this.client = client;
        log.debug((Object)("Creating new session for " + this._session));
        this.session = new SessionUrn(this._session);
        log.debug((Object)"Creating new Event Generator");
        this.evgen = new EventGeneratorThread(this._session, this, this.handlers);
        log.debug((Object)("SimpleClient constructed for session " + this.session.getSessionUrn()));
    }

    public String getAbout() {
        return new String("VORBA SimpleClient version $version$ build $build$");
    }

    public String getSessionUrn() {
        return this.session.getSessionUrn();
    }

    public SessionHandle getSessionHandle() {
        SessionHandle sh = new SessionHandle(this.session.getSessionUrn());
        return sh;
    }

    public ClientHandle getClientHandle() {
        return this.client;
    }

    public UserHandle getUserHandle() {
        return this.user;
    }

    protected String getProvenanceUser() {
        return new String(this.user.getFullName());
    }

    protected Entry getProvenanceEntry(String action) {
        Entry prov = ProvenanceStuff.newProvenanceEntry(this.client.getClientUrn(), this.getProvenanceUser(), action);
        return prov;
    }

    private static Hashtable initHandlers() {
        Hashtable events = new Hashtable();
        Iterator evt = Events.EventList.iterator();
        while (evt.hasNext()) {
            Object ths = evt.next();
            events.put(ths, new PropertyChangeSupport(ths));
        }
        return events;
    }

    public void addDocumentUpdateHandler(PropertyChangeListener evt) {
        this.addVorbaEventHandler("uk.ac.vamsas.client.events.documentUpdateEvent", evt);
    }

    private void haltPickmanager() {
        if (this.pickmanager != null) {
            final SimpleClient dying = this;
            new Thread(){

                public void run() {
                    log.debug((Object)"Stopping pickManager..");
                    dying.pickmanager.shutdown();
                    log.debug((Object)"pickManager halted.");
                }
            }.start();
        }
    }

    public void finalizeClient() {
        if (this.finalized) {
            throw new Error("VAMSAS Client Implementation Error: Finalized called twice for same client instance.");
        }
        this.finalized = true;
        this.evgen._raise("uk.ac.vamsas.client.events.clientFinalizationEvent", null, this, null);
        log.debug((Object)"Stopping pickManager");
        this.haltPickmanager();
        log.debug((Object)"Deregistering Client");
        this._session.removeClient(this);
        this.cdocument = null;
        log.debug((Object)"EventGenerator halted.");
        log.debug((Object)"finalization Complete.");
    }

    public IClientDocument getClientDocument() throws IOException {
        log.debug((Object)"getClientDocument");
        if (this.cdocument != null) {
            return this.cdocument;
        }
        this.evgen.disableDocumentWatch();
        VamsasArchive va = null;
        try {
            va = this._session.getVamsasDocument();
        }
        catch (IOException e) {
            throw new IOException("Failed to get lock on session document");
        }
        VamsasDocument doc = null;
        IdFactory vorba = null;
        try {
            vorba = this.makeVorbaIdFactory();
            va.setVorba(vorba);
            log.debug((Object)"Accessing document");
            doc = va.getVamsasDocument(this.getProvenanceUser(), "created new session document.", null);
            if (doc != null) {
                log.debug((Object)"Successfully retrieved document.");
            } else {
                log.error((Object)"Unexpectedly retrieved null document!");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to get session document for session directory '" + this._session.sessionDir + "'"), (Throwable)e);
            throw new IOException("Failed to get session document for session directory '" + this._session.sessionDir + "'");
        }
        this.cdocument = new ClientDocument(doc, va, vorba, this);
        return this.cdocument;
    }

    public void updateDocument(IClientDocument newdoc) {
        log.debug((Object)"updateDocument:");
        if (!(newdoc instanceof ClientDocument)) {
            throw new Error("Invalid IClientDocument passsed to SimpleClient.");
        }
        if (this.cdocument == null) {
            throw new Error("Client Error - updateDocument() called before getClientDocument() on this SimpleClient instance.");
        }
        if (newdoc != this.cdocument) {
            throw new Error("Client Error - SimpleClient.updateDocument() can only take the IClientDocument instance returned from SimpleClient.getClientDocument()");
        }
        if (this.evgen.isDocumentWatchEnabled()) {
            throw new Error("Probable Client Error (did you remember to call SimpleClient.updateDocument(clientdoc) at the end of the document update handler?) - or Library Bug : Document watcher still enabled whilst ClientDocument instance exists.");
        }
        if (this.cdocument.isInvalidModification()) {
            log.info((Object)"Client has corrupted the vamsas document. It will not be written back to the session - sorry.");
        } else if (!this.cdocument.isModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("updateDocument for " + this.session.getSessionUrn() + " with unmodified IClientDocument (skipping the write)"));
            }
        } else {
            this.writeSessionDocument();
        }
        this.tidyAwaySessionDocumentState();
    }

    protected void tidyAwaySessionDocumentState() {
        try {
            log.debug((Object)"Finalizing ClientDocument instance.");
            this.cdocument.finalize();
        }
        catch (Throwable e) {
            log.error((Object)("Exception when trying to garbage collect ClientDocument for " + this.session.getSessionUrn()), e);
        }
        this.cdocument = null;
        try {
            this._session.unlockVamsasDocument();
            this.evgen.enableDocumentWatch();
        }
        catch (IOException e) {
            log.warn((Object)"IO Problems when releasing lock on session document!", (Throwable)e);
            this._session.slog.error((Object)"IO problems when attempting to release lock on session document.");
        }
    }

    private void writeSessionDocument() {
        try {
            boolean updated = this.cdocument.updateSessionDocument();
            boolean hasContent = this.cdocument.isModified();
            if (!updated) {
                log.warn((Object)("Session document did not update properly for session directory " + this._session.sessionDir));
                this._session.slog.warn((Object)"Session Document updated but may not be valid (false return from org.vamsas.simpleclient.ClientDocument.updateSessionDocument()");
            } else {
                log.debug((Object)"Document update successful.");
            }
            if (hasContent) {
                this._session.setUnsavedFlag();
            }
        }
        catch (IOException e) {
            log.warn((Object)"IO Problems when updating document!", (Throwable)e);
            this._session.slog.error((Object)"IO problems when attempting to update document.");
        }
    }

    public void storeDocument(File location) {
        if (location == null) {
            throw new Error("Vamsas Client API Usage Error: storeDocument called with null location.");
        }
        log.debug((Object)("StoreDocument to " + location));
        Lock vamlock = this.evgen.want_to_store();
        try {
            this._session.writeVamsasDocument(location, vamlock);
            this._session.clearUnsavedFlag();
        }
        catch (Exception e) {
            log.warn((Object)("Exception whilst trying to store document in " + location), (Throwable)e);
        }
        vamlock.release();
    }

    public void addVorbaEventHandler(String EventChain, PropertyChangeListener evt) {
        if (this.handlers.containsKey(EventChain)) {
            log.debug((Object)("Adding new handler for " + EventChain));
            Object handler = this.handlers.get(EventChain);
            ((PropertyChangeSupport)handler).addPropertyChangeListener(evt);
            this.listeners.add(handler);
            this.listeners.add(evt);
        }
    }

    public void pollUpdate() {
        log.debug((Object)"pollUpdate");
        if (this.evgen == null) {
            log.warn((Object)"pollUpdate called on incomplete SimpleClient object.");
            return;
        }
        if (!this.evgen.isWatcherAlive()) {
            log.warn((Object)"pollUpdate called before joinSession() - trying to do this.");
            try {
                this.joinSession();
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception on default call to joinSession", (Throwable)e);
            }
        }
        log.debug((Object)"interrrupting event generator.");
        this.evgen.interruptWatching();
        log.debug((Object)"interrrupted event generator.");
    }

    public void joinSession() throws Exception {
        log.debug((Object)"Joining Session.");
        if (this.evgen == null) {
            log.warn((Object)"joinSession called on incomplete SimpleClient object.");
            return;
        }
        if (this.evgen.isWatcherAlive()) {
            throw new Error("Join session called twice for the same SimpleClient (IClient instance).");
        }
        this.evgen.startWatching();
        if (!this.evgen.isWatcherAlive()) {
            log.warn((Object)"Failed to start EventGenerator thread.");
            throw new Exception("Failed to start event generator thread - client cannot be instantiated.");
        }
        log.debug((Object)"Started EventGenerator thread.");
        if (this.evgen.countHandlersFor("uk.ac.vamsas.client.events.documentCreateEvent") > 0) {
            // empty if block
        }
    }

    public void importDocument(File location) {
        log.error((Object)"importDocument is not yet implemented for a SimpleClient Session.");
    }

    public IObjectUpdate getUpdateHandler(Class rootObject) {
        return null;
    }

    public IObjectUpdate[] getUpdateHandlers() {
        return null;
    }

    public void removeUpdateHandler(Class rootObject) {
    }

    public void setUpdateHandler(IObjectUpdate handler) {
    }

    protected VamsasSession get_session() {
        return this._session;
    }

    public IPickManager getPickManager() {
        this.createPickManager();
        return this.pickmanager;
    }

    private void createPickManager() {
        if (this.pickmanager == null) {
            log.debug((Object)"Creating PickManager (not from sessionURN yet)");
            this.pickmanager = new SimplePickManager(new SocketManager());
        }
    }

    protected void releaseActiveClientFile() throws IOException {
        log.debug((Object)"Releasing active client locks");
        if (this.activeClientFilelock != null) {
            log.debug((Object)"Releasing lock on active client lock file");
            this.activeClientFilelock.release();
            log.debug((Object)"ReleaseActiveClientFile called when client has no lock on its clientLockFile");
            this.activeClientFilelock = null;
        } else {
            log.debug((Object)"ReleaseActiveClientFile called when client has no lock on its clientLockFile");
        }
        if (this.clientlockFile != null) {
            log.debug((Object)"trying to delete active client lock file");
            if (this.clientlockFile.exists()) {
                this.clientlockFile.delete();
                log.debug((Object)"deleted active client lock file");
            }
        } else {
            log.debug((Object)"ReleaseActiveClientFile called when client has no clientLockFile");
        }
    }

    protected void createActiveClientFile() throws IOException {
        if (this.clientlockFile != null) {
            return;
        }
        log.debug((Object)"createActiveClientFile");
        File clientlockFileDir = new File(this.get_session().sessionDir, this.get_session().clientFileDirectory);
        if (!clientlockFileDir.exists()) {
            if (!clientlockFileDir.mkdirs()) {
                throw new IOException("Failed to create sub directory to session directory  for client lock files'" + clientlockFileDir.getAbsolutePath() + "'");
            }
        } else if (!clientlockFileDir.isDirectory() || !clientlockFileDir.canWrite()) {
            throw new IOException("Directory  for client lock files is not a directory or is not accessibl: '" + clientlockFileDir.getAbsolutePath() + "'");
        }
        this.clientlockFile = new File(clientlockFileDir, this.getClientHandle().getClientUrn().replaceAll("[:;/\\\\]+", ""));
        log.debug((Object)("Creating active client lock file " + this.clientlockFile.getAbsolutePath()));
        Lock clientLock = LockFactory.getLock(this.clientlockFile, false);
        if (clientLock == null || !clientLock.isLocked()) {
            log.fatal((Object)("IMPLEMENTATION ERROR: Couldn't get a lock for the client lock file " + this.clientlockFile));
        }
        this.activeClientFilelock = clientLock;
    }

    protected File getClientlockFile() {
        return this.clientlockFile;
    }

    protected Lock getClientLock() {
        return this.activeClientFilelock;
    }

    public SimpleClientConfig getSimpleClientConfig() {
        if (this._config == null) {
            this._config = new SimpleClientConfig();
        }
        return this._config;
    }
}

