/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.LockedFileOutputStream;

public class NativeLock
extends Lock {
    protected FileLock lock = null;

    public NativeLock(File lockfile, boolean block) {
        super(lockfile);
        try {
            this.rafile = new RandomAccessFile(lockfile, "rw");
            this.lock = block ? this.rafile.getChannel().lock() : this.rafile.getChannel().tryLock();
            if (this.lock == null || !this.lock.isValid()) {
                this.log.debug((Object)("failed to get lock for " + lockfile));
                this.rafile.getChannel().close();
                this.lock = null;
            }
        }
        catch (FileNotFoundException e) {
            this.log.debug((Object)"Lock failed - normal behaviour for windows locking.");
        }
        catch (IOException e) {
            this.log.error((Object)("Error! Problems with IO when creating a lock on " + lockfile.getAbsolutePath()), (Throwable)e);
        }
    }

    public boolean isLocked() {
        return this.lock != null && this.lock.isValid();
    }

    public void release() {
        this.release(true);
    }

    public void release(boolean closeChannel) {
        if (this.lock == null) {
            return;
        }
        try {
            if (this.lock.isValid() && this.rafile != null && this.rafile.getFD().valid() && this.rafile.getChannel() != null) {
                if (closeChannel && this.rafile.getChannel().isOpen()) {
                    this.rafile.close();
                    this.rafile = null;
                } else if (this.lock != null && this.lock.isValid()) {
                    this.lock.release();
                }
            }
        }
        catch (IOException e) {
            this.log.warn((Object)"Whilst releasing lock", (Throwable)e);
        }
        this.lock = null;
    }

    public FileInputStream getFileInputStream(boolean atStart) throws IOException {
        if (!this.isLocked()) {
            return null;
        }
        if (atStart) {
            this.rafile.seek(0L);
        }
        return new FileInputStream(this.rafile.getFD());
    }

    public FileOutputStream getFileOutputStream(boolean clear) throws IOException {
        if (!this.isLocked()) {
            return null;
        }
        if (clear) {
            this.rafile.seek(0L);
            this.rafile.setLength(0L);
        } else {
            this.rafile.seek(this.rafile.length());
        }
        return new LockedFileOutputStream(this.rafile.getFD());
    }

    public BufferedOutputStream getBufferedOutputStream(boolean clear) throws IOException {
        FileOutputStream fos = this.getFileOutputStream(clear);
        if (fos != null) {
            return new BufferedOutputStream(fos);
        }
        return null;
    }

    protected void finalize() throws Throwable {
        this.release(true);
        super.finalize();
    }

    public long length() {
        if (this.isLocked()) {
            try {
                return this.rafile.length();
            }
            catch (Exception e) {
                this.log.debug((Object)"getLength exception:", (Throwable)e);
            }
        }
        return -1L;
    }

    public RandomAccessFile getRaFile() throws IOException {
        if (this.isLocked()) {
            return this.rafile;
        }
        this.log.debug((Object)("Failed to getRaFile on " + this.target));
        return null;
    }

    public FileChannel getRaChannel() throws IOException {
        if (this.isLocked()) {
            return this.rafile.getChannel();
        }
        this.log.debug((Object)("Failed to getRaChannel on " + this.target));
        return null;
    }

    public boolean isTargetLockFile(File afile) {
        return this.isLocked() && this.target.equals(afile);
    }
}

