/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.model;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.swing.AbstractListModel;
import org.robsite.jswingreader.model.Channel;
import org.robsite.jswingreader.model.Channels;

public class ChannelListModel
extends AbstractListModel {
    private Channels _channels;

    public ChannelListModel() {
        this._channels = new Channels();
    }

    public ChannelListModel(Collection channels) {
        this._channels.getChannelsList().addAll(channels);
        this.fireIntervalAdded(this, 0, this.getSize());
    }

    public int getSize() {
        return this._channels.getChannelsList().size();
    }

    public Object getElementAt(int index) {
        return this._channels.getChannelsList().get(index);
    }

    public void addChannel(Channel channel) {
        int size = this._channels.getChannelsList().size();
        this._channels.getChannelsList().add(channel);
        this.fireIntervalAdded(this, size, size);
    }

    public boolean removeChannel(Channel channel) {
        int index = this._channels.getChannelsList().indexOf(channel);
        if (index > -1) {
            this._channels.getChannelsList().remove(index);
            this.fireIntervalRemoved(this, index, index);
            return true;
        }
        return false;
    }

    public void replaceChannelAt(int index, Channel channel) {
        this._channels.getChannelsList().remove(index);
        this.fireIntervalRemoved(this, index, index);
        this._channels.getChannelsList().add(index, channel);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeChannelAt(int index) {
        this._channels.getChannelsList().remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void clear() {
        int index = this._channels.getChannelsList().size() - 1;
        this._channels.getChannelsList().clear();
        if (index >= 0) {
            this.fireIntervalRemoved(this, 0, index);
        }
    }

    public Channels getChannels() {
        return this._channels;
    }

    public void setChannels(Channels channels) {
        this.clear();
        this._channels = channels;
        int index = this._channels.getChannelsList().size();
        this.fireIntervalAdded(this, 0, index);
    }

    public void load(InputStream inStream) throws IOException {
        XMLDecoder decoder = new XMLDecoder(inStream);
        Object o = decoder.readObject();
        decoder.close();
        if (o instanceof Channels) {
            Channels channels = (Channels)o;
            this.setChannels(channels);
        }
    }

    public void save(OutputStream out) throws IOException {
        XMLEncoder encoder = new XMLEncoder(out);
        encoder.writeObject(this.getChannels());
        encoder.close();
    }

    public static void main(String[] args) {
        ChannelListModel model = new ChannelListModel();
        Channel c = new Channel();
        c.setTitle("One");
        model.addChannel(c);
        c = new Channel();
        c.setTitle("Two");
        model.addChannel(c);
        c = new Channel();
        c.setTitle("Three");
        model.addChannel(c);
        Channel[] channels = model.getChannels().getChannels();
        int i = 0;
        i = 0;
        while (i < channels.length) {
            System.out.println(channels[i].getTitle());
            ++i;
        }
        System.out.println("***************************************");
        c = new Channel();
        c.setTitle("Two2");
        model.replaceChannelAt(1, c);
        channels = model.getChannels().getChannels();
        i = 0;
        while (i < channels.length) {
            System.out.println(channels[i].getTitle());
            ++i;
        }
    }
}

