/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.robsite.jswingreader.model.ChannelEvent;
import org.robsite.jswingreader.model.ChannelListener;
import org.robsite.jswingreader.model.Item;

public class Channel {
    private String _title;
    private String _link;
    private String _description;
    private List _items;
    private boolean _open = false;
    private String _url;
    private String _httpLastModified;
    private String _httpEtag;
    private boolean _isUserChannel;
    private ArrayList _channelListeners = new ArrayList(1);

    public void setHTTPLastModified(String httpLastModified) {
        this._httpLastModified = httpLastModified;
    }

    public String getHTTPLastModified() {
        return this._httpLastModified;
    }

    public void setHTTPEtag(String httpEtag) {
        this._httpEtag = httpEtag;
    }

    public String getHTTPEtag() {
        return this._httpEtag;
    }

    public boolean isUserChannel() {
        return this._isUserChannel;
    }

    public void setUserChannel(boolean isUserChannel) {
        this._isUserChannel = isUserChannel;
    }

    public boolean equals(Object that) {
        if (that instanceof Channel) {
            String thatURL = ((Channel)that).getURL();
            if (thatURL != null && this._url != null) {
                return this._url.equals(thatURL);
            }
            return this._url == null && thatURL == null;
        }
        return false;
    }

    public int hashCode() {
        if (this._url != null) {
            return this._url.hashCode();
        }
        return super.hashCode();
    }

    public void addChannelListener(ChannelListener cl) {
        this._channelListeners.add(cl);
    }

    public void removeChannelListener(ChannelListener cl) {
        this._channelListeners.remove(cl);
    }

    public void fireItemChanged(Item item) {
        int index = this._items.indexOf(item);
        if (index >= 0) {
            this.fireItemChanged(index);
        }
    }

    public void fireItemChanged(final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int count = Channel.this._channelListeners.size();
                if (count > 0) {
                    ChannelListener[] copy = new ChannelListener[count];
                    Channel.this._channelListeners.toArray(copy);
                    ChannelEvent event = new ChannelEvent(Channel.this, index);
                    int i = 0;
                    while (i < count) {
                        copy[i].itemsChanged(event);
                        ++i;
                    }
                }
            }
        });
    }

    public void fireItemsChanged(Collection items) {
        for (Item item : items) {
            this.fireItemChanged(item);
        }
    }

    public void fireItemsChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int count = Channel.this._channelListeners.size();
                if (count > 0) {
                    ChannelListener[] copy = new ChannelListener[count];
                    Channel.this._channelListeners.toArray(copy);
                    ChannelEvent event = new ChannelEvent(Channel.this);
                    int i = 0;
                    while (i < count) {
                        copy[i].itemsChanged(event);
                        ++i;
                    }
                }
            }
        });
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public void setLink(String link) {
        this._link = link;
    }

    public String getLink() {
        return this._link;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setItems(List items) {
        this._items = items;
    }

    public List getItems() {
        return this._items;
    }

    public int getUnreadItemCount() {
        if (this._items == null) {
            return 0;
        }
        int unreadCount = 0;
        for (Item item : this._items) {
            if (item.isRead()) continue;
            ++unreadCount;
        }
        return unreadCount;
    }

    public void addItem(Item item, boolean overwrite) {
        if (this._items == null) {
            this._items = new ArrayList(10);
        }
        if (overwrite) {
            if (this._items.contains(item)) {
                this._items.remove(item);
            }
            this._items.add(item);
        } else if (!this._items.contains(item)) {
            this._items.add(item);
        }
    }

    public void addAllItems(Channel fromChannel) {
        Iterator iter = fromChannel.getItems().iterator();
        while (iter.hasNext()) {
            this.addItem((Item)iter.next(), true);
        }
    }

    public String dumpString() {
        StringBuffer b = new StringBuffer(1000);
        b.append("[Channel] {Title: " + this._title + "} {Link: " + this._link + "} {Description: " + this._description + "}\n");
        Iterator i = this._items != null ? this._items.iterator() : Collections.EMPTY_LIST.iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            b.append("  ");
            b.append(item.dumpString());
        }
        return b.toString();
    }

    public String toString() {
        if (this._title == null || this._title.length() == 0) {
            if (this._description == null || this._description.length() == 0) {
                return this.getURL();
            }
            if (this._description.length() > 60) {
                return this._description.substring(0, 60);
            }
            return this._description;
        }
        return this._title;
    }

    public void setOpen(boolean open) {
        this._open = open;
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setURL(String url) {
        this._url = url;
    }

    public String getURL() {
        return this._url;
    }
}

