/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.FastaSequence;
import compbio.metadata.Argument;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.LimitExceededException;
import compbio.metadata.Preset;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.metadata.WrongParameterException;
import jalview.analysis.AlignSeq;
import jalview.analysis.AlignmentSorter;
import jalview.analysis.SeqsetUtils;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.SplitFrame;
import jalview.gui.WebserviceInfo;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.ws.AWsJob;
import jalview.ws.JobStateSummary;
import jalview.ws.WSClientI;
import jalview.ws.jws2.AWS2Thread;
import jalview.ws.jws2.JWs2Job;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.dm.JabaWsParamSet;
import jalview.ws.params.WsParamSetI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class MsaWSThread
extends AWS2Thread
implements WSClientI {
    boolean submitGaps = false;
    boolean preserveOrder = true;
    String alTitle;
    AlignmentI dataset;
    MsaWS server = null;
    boolean validInput = false;

    private MsaWSThread(MsaWS server, String wsUrl, WebserviceInfo wsinfo, AlignFrame alFrame, AlignmentView alview, String wsname, boolean subgaps, boolean presorder) {
        super(alFrame, wsinfo, alview, wsname, wsUrl);
        this.server = server;
        this.submitGaps = subgaps;
        this.preserveOrder = presorder;
    }

    MsaWSThread(MsaWS server2, WsParamSetI preset, List<Argument> paramset, String wsUrl, WebserviceInfo wsinfo, AlignFrame alFrame, String wsname, String title, AlignmentView _msa, boolean subgaps, boolean presorder, AlignmentI seqset) {
        this(server2, wsUrl, wsinfo, alFrame, _msa, wsname, subgaps, presorder);
        this.OutputHeader = this.wsInfo.getProgressText();
        this.alTitle = title;
        this.dataset = seqset;
        SequenceI[][] conmsa = _msa.getVisibleContigs('-');
        if (conmsa != null) {
            int nvalid = 0;
            int njobs = conmsa.length;
            this.jobs = new MsaWSJob[njobs];
            for (int j = 0; j < njobs; ++j) {
                this.jobs[j] = j != 0 ? new MsaWSJob(wsinfo.addJobPane(), conmsa[j]) : new MsaWSJob(0, conmsa[j]);
                if (((MsaWSJob)this.jobs[j]).hasValidInput()) {
                    ++nvalid;
                }
                ((MsaWSJob)this.jobs[j]).preset = preset;
                ((MsaWSJob)this.jobs[j]).arguments = paramset;
                ((MsaWSJob)this.jobs[j]).alignmentProgram = wsname;
                if (njobs > 0) {
                    wsinfo.setProgressName("region " + this.jobs[j].getJobnum(), this.jobs[j].getJobnum());
                }
                wsinfo.setProgressText(this.jobs[j].getJobnum(), this.OutputHeader);
            }
            this.validInput = nvalid > 0;
        }
    }

    public boolean hasValidInput() {
        return this.validInput;
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    @Override
    public void cancelJob() {
        if (!this.jobComplete && this.jobs != null) {
            boolean cancelled = true;
            for (int job = 0; job < this.jobs.length; ++job) {
                if (this.jobs[job].isSubmitted() && !this.jobs[job].isSubjobComplete()) {
                    Object cancelledMessage = "";
                    try {
                        boolean cancelledJob = this.server.cancelJob(this.jobs[job].getJobId());
                        cancelledMessage = "Job cancelled.";
                        ((MsaWSJob)this.jobs[job]).cancel();
                        this.wsInfo.setStatus(this.jobs[job].getJobnum(), 3);
                    }
                    catch (Exception exc) {
                        cancelledMessage = (String)cancelledMessage + "\nProblems cancelling the job : Exception received...\n" + exc + "\n";
                        Console.warn("Exception whilst cancelling " + this.jobs[job].getJobId(), exc);
                    }
                    this.wsInfo.setProgressText(this.jobs[job].getJobnum(), this.OutputHeader + (String)cancelledMessage + "\n");
                    continue;
                }
                this.jobs[job].setSubjobComplete(true);
                this.wsInfo.setStatus(this.jobs[job].getJobnum(), 3);
            }
            if (cancelled) {
                this.wsInfo.setStatus(3);
                this.jobComplete = true;
            }
            this.interrupt();
        } else if (!this.jobComplete) {
            this.wsInfo.setProgressText(this.OutputHeader + "Server cannot cancel this job because it has not been submitted properly. just close the window.\n");
        }
    }

    @Override
    public void pollJob(AWsJob job) throws Exception {
        MsaWSJob j = (MsaWSJob)job;
        j.setjobStatus(this.server.getJobStatus(job.getJobId()));
        this.updateJobProgress(j);
    }

    protected boolean updateJobProgress(MsaWSJob j) throws Exception {
        StringBuffer response = j.jobProgress;
        long lastchunk = j.getLastChunk();
        boolean changed = false;
        do {
            j.setLastChunk(lastchunk);
            ChunkHolder chunk = this.server.pullExecStatistics(j.getJobId(), lastchunk);
            if (chunk == null) continue;
            changed |= chunk.getChunk().length() > 0;
            response.append(chunk.getChunk());
            lastchunk = chunk.getNextPosition();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (lastchunk >= 0L && j.getLastChunk() != lastchunk);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void StartJob(AWsJob job) {
        Throwable lex = null;
        if (!(job instanceof MsaWSJob)) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_msawbjob_called", new String[]{job.getClass().toString()}));
        }
        MsaWSJob j = (MsaWSJob)job;
        if (j.isSubmitted()) {
            if (Console.isDebugEnabled()) {
                Console.debug("Tried to submit an already submitted job " + j.getJobId());
            }
            return;
        }
        if (j.seqs == null || j.seqs.size() == 0) {
            j.setjobStatus(JobStatus.FINISHED);
            j.setStatus(MessageManager.getString("label.empty_alignment_job"));
        }
        try {
            j.addInitialStatus();
            if (j.isPresetJob()) {
                j.setJobId(this.server.presetAlign(j.seqs, j.getServerPreset()));
            } else if (j.hasArguments()) {
                j.setJobId(this.server.customAlign(j.seqs, j.getJabaArguments()));
            } else {
                j.setJobId(this.server.align(j.seqs));
            }
            if (j.getJobId() != null) {
                j.setSubmitted(true);
                j.setSubjobComplete(false);
                return;
            }
            try {
                throw new Exception(MessageManager.formatMessage("exception.web_service_returned_null_try_later", new String[]{this.WsUrl}));
            }
            catch (UnsupportedRuntimeException _lex) {
                lex = _lex;
                this.wsInfo.appendProgressText(MessageManager.formatMessage("info.job_couldnt_be_run_server_doesnt_support_program", new String[]{_lex.getMessage()}));
                this.wsInfo.warnUser(_lex.getMessage(), MessageManager.getString("warn.service_not_supported"));
                this.wsInfo.setStatus(5);
                this.wsInfo.setStatus(j.getJobnum(), 5);
            }
            catch (LimitExceededException _lex) {
                lex = _lex;
                this.wsInfo.appendProgressText(MessageManager.formatMessage("info.job_couldnt_be_run_exceeded_hard_limit", new String[]{_lex.getMessage()}));
                this.wsInfo.warnUser(_lex.getMessage(), MessageManager.getString("warn.input_is_too_big"));
                this.wsInfo.setStatus(4);
                this.wsInfo.setStatus(j.getJobnum(), 4);
            }
            catch (WrongParameterException _lex) {
                lex = _lex;
                this.wsInfo.warnUser(_lex.getMessage(), MessageManager.getString("warn.invalid_job_param_set"));
                this.wsInfo.appendProgressText(MessageManager.formatMessage("info.job_couldnt_be_run_incorrect_param_setting", new String[]{_lex.getMessage()}));
                this.wsInfo.setStatus(4);
                this.wsInfo.setStatus(j.getJobnum(), 4);
            }
            catch (Error e) {
                Console.errPrintln(this.WebServiceName + "Client: Failed to submit the sequences for alignment (probably a server side problem)\nWhen contacting Server:" + this.WsUrl + "\n");
                e.printStackTrace(System.err);
                this.wsInfo.setStatus(5);
                this.wsInfo.setStatus(j.getJobnum(), 5);
            }
            catch (Exception e) {
                Console.errPrintln(this.WebServiceName + "Client: Failed to submit the sequences for alignment (probably a server side problem)\nWhen contacting Server:" + this.WsUrl + "\n");
                e.printStackTrace(System.err);
                this.wsInfo.setStatus(5);
                this.wsInfo.setStatus(j.getJobnum(), 5);
            }
        }
        finally {
            if (!j.isSubmitted()) {
                j.setAllowedServerExceptions(0);
                this.wsInfo.appendProgressText(j.getJobnum(), MessageManager.getString("info.failed_to_submit_sequences_for_alignment"));
            }
        }
    }

    @Override
    public void parseResult() {
        long progbar = System.currentTimeMillis();
        this.wsInfo.setProgressBar(MessageManager.getString("status.collecting_job_results"), progbar);
        int results = 0;
        JobStateSummary finalState = new JobStateSummary();
        try {
            for (int j = 0; j < this.jobs.length; ++j) {
                MsaWSJob msjob = (MsaWSJob)this.jobs[j];
                if (this.jobs[j].isFinished() && msjob.alignment == null) {
                    int nunchanged = 3;
                    int nexcept = 3;
                    boolean jpchanged = false;
                    boolean jpex = false;
                    do {
                        try {
                            jpchanged = this.updateJobProgress(msjob);
                            jpex = false;
                            if (jpchanged) {
                                nexcept = 3;
                            }
                        }
                        catch (Exception e) {
                            Console.warn("Exception when retrieving remaining Job progress data for job " + msjob.getJobId() + " on server " + this.WsUrl);
                            e.printStackTrace();
                            --nexcept;
                            nunchanged = 3;
                            jpex = true;
                            jpchanged = false;
                        }
                        if (jpchanged) continue;
                        try {
                            Thread.sleep(jpex ? 2400L : 1200L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        --nunchanged;
                    } while (nunchanged > 0 && nexcept > 0);
                    if (Console.isDebugEnabled()) {
                        Console.outPrintln("Job Execution file for job: " + msjob.getJobId() + " on server " + this.WsUrl);
                        Console.outPrintln(msjob.getStatus());
                        Console.outPrintln("*** End of status");
                    }
                    try {
                        msjob.alignment = this.server.getResult(msjob.getJobId());
                    }
                    catch (ResultNotAvailableException e) {
                        Console.debug("Results not available for finished job - marking as broken job.", e);
                        msjob.jobProgress.append("\nResult not available. Probably due to invalid input or parameter settings. Server error message below:\n\n" + e.getLocalizedMessage());
                        msjob.setjobStatus(JobStatus.FAILED);
                    }
                    catch (Exception e) {
                        Console.error("Couldn't get Alignment for job.", e);
                        msjob.setjobStatus(JobStatus.UNDEFINED);
                    }
                }
                finalState.updateJobPanelState(this.wsInfo, this.OutputHeader, this.jobs[j]);
                if (!this.jobs[j].isSubmitted() || !this.jobs[j].isSubjobComplete() || !this.jobs[j].hasResults()) continue;
                ++results;
                compbio.data.sequence.Alignment alignment = ((MsaWSJob)this.jobs[j]).alignment;
                if (alignment == null) continue;
            }
        }
        catch (Exception ex) {
            Console.error("Unexpected exception when processing results for " + this.alTitle, ex);
            this.wsInfo.setStatus(4);
        }
        if (results > 0) {
            this.wsInfo.showResultsNewFrame.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MsaWSThread.this.displayResults(true);
                }
            });
            this.wsInfo.mergeResults.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MsaWSThread.this.displayResults(false);
                }
            });
            this.wsInfo.setResultsReady();
        } else {
            this.wsInfo.setFinishedNoResults();
        }
        this.updateGlobalStatus(finalState);
        this.wsInfo.setProgressBar(null, progbar);
    }

    void displayResults(boolean newFrame) {
        ArrayList<AlignmentOrder> alorders = new ArrayList<AlignmentOrder>();
        SequenceI[][] results = new SequenceI[this.jobs.length][];
        AlignmentOrder[] orders = new AlignmentOrder[this.jobs.length];
        String lastProgram = null;
        for (int j = 0; j < this.jobs.length; ++j) {
            if (this.jobs[j].hasResults()) {
                MsaWSJob msjob = (MsaWSJob)this.jobs[j];
                Object[] res = msjob.getAlignment();
                lastProgram = msjob.getAlignmentProgram();
                alorders.add((AlignmentOrder)res[1]);
                results[j] = (SequenceI[])res[0];
                orders[j] = (AlignmentOrder)res[1];
                continue;
            }
            results[j] = null;
        }
        Object[] newview = this.input.getUpdatedView(results, orders, this.getGapChar());
        for (int j = 0; j < this.jobs.length; ++j) {
            results[j] = null;
            orders[j] = null;
        }
        SequenceI[] alignment = (SequenceI[])newview[0];
        HiddenColumns hidden = (HiddenColumns)newview[1];
        Alignment al = new Alignment(alignment);
        if (lastProgram != null) {
            al.setProperty("Alignment Program", lastProgram);
        }
        if (this.dataset != null) {
            al.setDataset(this.dataset);
        }
        this.propagateDatasetMappings(al);
        if (newFrame) {
            this.displayInNewFrame(al, alorders, hidden);
        } else {
            Console.outPrintln("MERGE WITH OLD FRAME");
        }
    }

    protected void displayInNewFrame(AlignmentI al, List<AlignmentOrder> alorders, HiddenColumns hidden) {
        AlignFrame requestedBy;
        AlignFrame af = new AlignFrame(al, hidden, 700, 500);
        af.getFeatureRenderer().transferSettings(this.featureSettings);
        if (alorders.size() > 0) {
            this.addSortByMenuItems(af, alorders);
        }
        if ((requestedBy = this.getRequestingAlignFrame()) != null && requestedBy.getSplitViewContainer() != null && requestedBy.getSplitViewContainer().getComplement(requestedBy) != null) {
            AlignmentI complement = requestedBy.getSplitViewContainer().getComplement(requestedBy);
            String complementTitle = requestedBy.getSplitViewContainer().getComplementTitle(requestedBy);
            Alignment copyComplement = new Alignment(complement);
            copyComplement.setGapCharacter(complement.getGapCharacter());
            copyComplement.setDataset(complement.getDataset());
            copyComplement.alignAs(al);
            if (copyComplement.getHeight() > 0) {
                af.setTitle(this.alTitle);
                AlignFrame af2 = new AlignFrame(copyComplement, 700, 500);
                af2.setTitle(complementTitle);
                String linkedTitle = MessageManager.getString("label.linked_view_title");
                SplitFrame splitFrame = new SplitFrame(al.isNucleotide() ? af : af2, al.isNucleotide() ? af2 : af);
                Desktop.addInternalFrame(splitFrame, linkedTitle, -1, -1);
                return;
            }
        }
        Desktop.addInternalFrame(af, this.alTitle, 700, 500);
    }

    protected void addSortByMenuItems(AlignFrame af, List<AlignmentOrder> alorders) {
        if (alorders.size() == 1) {
            af.addSortByOrderMenuItem(this.WebServiceName + " Ordering", alorders.get(0));
        } else {
            int i;
            ArrayList<Object> names = new ArrayList<Object>();
            int l = alorders.size();
            for (i = 0; i < l; ++i) {
                String orderName = " Region " + i;
                int j = i + 1;
                while (j < l) {
                    if (alorders.get(i).equals(alorders.get(j))) {
                        alorders.remove(j);
                        --l;
                        orderName = orderName + "," + j;
                        continue;
                    }
                    ++j;
                }
                if (i == 0 && j == 1) {
                    names.add("");
                    continue;
                }
                names.add(orderName);
            }
            l = alorders.size();
            for (i = 0; i < l; ++i) {
                af.addSortByOrderMenuItem(this.WebServiceName + (String)names.get(i) + " Ordering", alorders.get(i));
            }
        }
    }

    @Override
    public boolean canMergeResults() {
        return false;
    }

    class MsaWSJob
    extends JWs2Job {
        long lastChunk = 0L;
        WsParamSetI preset = null;
        List<Argument> arguments = null;
        ArrayList<FastaSequence> seqs = new ArrayList();
        compbio.data.sequence.Alignment alignment;
        private boolean returnInput = false;
        Hashtable<String, Map> SeqNames = new Hashtable();
        Vector<String[]> emptySeqs = new Vector();
        StringBuffer jobProgress = new StringBuffer();
        String alignmentProgram = null;

        public MsaWSJob(int jobNum, SequenceI[] inSeqs) {
            this.jobnum = jobNum;
            if (!this.prepareInput(inSeqs, 2)) {
                this.submitted = true;
                this.subjobComplete = true;
                this.returnInput = true;
            }
        }

        private boolean prepareInput(SequenceI[] seqs, int minlen) {
            int nseqs = 0;
            if (minlen < 0) {
                throw new Error(MessageManager.getString("error.implementation_error_minlen_must_be_greater_zero"));
            }
            for (int i = 0; i < seqs.length; ++i) {
                if (seqs[i].getEnd() - seqs[i].getStart() <= minlen - 1) continue;
                ++nseqs;
            }
            boolean valid = nseqs > 1;
            boolean n = false;
            for (int i = 0; i < seqs.length; ++i) {
                String newname = SeqsetUtils.unique_name(i);
                this.SeqNames.put(newname, SeqsetUtils.SeqCharacterHash(seqs[i]));
                if (valid && seqs[i].getEnd() - seqs[i].getStart() > minlen - 1) {
                    FastaSequence seq = new FastaSequence(newname, MsaWSThread.this.submitGaps ? seqs[i].getSequenceAsString() : AlignSeq.extractGaps(Comparison.GapChars, seqs[i].getSequenceAsString()));
                    this.seqs.add(seq);
                    continue;
                }
                String empty = null;
                if (seqs[i].getEnd() >= seqs[i].getStart()) {
                    empty = MsaWSThread.this.submitGaps ? seqs[i].getSequenceAsString() : AlignSeq.extractGaps(Comparison.GapChars, seqs[i].getSequenceAsString());
                }
                this.emptySeqs.add(new String[]{newname, empty});
            }
            return valid;
        }

        @Override
        public boolean hasResults() {
            return this.subjobComplete && this.isFinished() && (this.alignment != null || this.emptySeqs != null && this.emptySeqs.size() > 0);
        }

        public Object[] getAlignment() {
            if (this.hasResults()) {
                SequenceI[] alseqs = null;
                char alseq_gapchar = '-';
                int alseq_l = 0;
                if (this.alignment.getSequences().size() > 0) {
                    alseqs = new SequenceI[this.alignment.getSequences().size()];
                    for (FastaSequence seq : this.alignment.getSequences()) {
                        alseqs[alseq_l++] = new Sequence(seq.getId(), seq.getSequence());
                    }
                    alseq_gapchar = this.alignment.getMetadata().getGapchar();
                }
                if (this.emptySeqs.size() > 0) {
                    int sw;
                    int i;
                    SequenceI[] t_alseqs = new SequenceI[alseq_l + this.emptySeqs.size()];
                    int w = 0;
                    if (alseq_l > 0) {
                        w = alseqs[0].getLength();
                        for (int i2 = 0; i2 < alseq_l; ++i2) {
                            if (w < alseqs[i2].getLength()) {
                                w = alseqs[i2].getLength();
                            }
                            t_alseqs[i2] = alseqs[i2];
                            alseqs[i2] = null;
                        }
                    }
                    int ow = w;
                    int nw = w;
                    w = this.emptySeqs.size();
                    for (i = 0; i < w; ++i) {
                        String[] es = this.emptySeqs.get(i);
                        if (es == null || es[1] == null || nw >= (sw = es[1].length())) continue;
                        nw = sw;
                    }
                    StringBuffer insbuff = new StringBuffer(w);
                    for (i = 0; i < nw; ++i) {
                        insbuff.append(alseq_gapchar);
                    }
                    if (ow < nw) {
                        for (i = 0; i < alseq_l; ++i) {
                            sw = t_alseqs[i].getLength();
                            if (nw <= sw) continue;
                            alseqs[i].setSequence(t_alseqs[i].getSequenceAsString() + insbuff.substring(0, sw - nw));
                        }
                    }
                    w = this.emptySeqs.size();
                    for (i = 0; i < w; ++i) {
                        String[] es = this.emptySeqs.get(i);
                        t_alseqs[i + alseq_l] = es[1] == null ? new Sequence(es[0], insbuff.toString(), 1, 0) : (es[1].length() < nw ? new Sequence(es[0], es[1] + insbuff.substring(0, nw - es[1].length()), 1, 1 + es[1].length()) : new Sequence(es[0], es[1]));
                    }
                    alseqs = t_alseqs;
                }
                AlignmentOrder msaorder = new AlignmentOrder(alseqs);
                AlignmentSorter.recoverOrder(alseqs);
                SeqsetUtils.deuniquify(this.SeqNames, alseqs);
                return new Object[]{alseqs, msaorder};
            }
            return null;
        }

        void cancel() {
            this.cancelled = true;
            this.subjobComplete = true;
            this.alignment = null;
        }

        @Override
        public boolean hasValidInput() {
            return this.seqs != null && this.seqs.size() >= 2;
        }

        public void setStatus(String string) {
            this.jobProgress.setLength(0);
            this.jobProgress.append(string);
        }

        @Override
        public String getStatus() {
            return this.jobProgress.toString();
        }

        @Override
        public boolean hasStatus() {
            return this.jobProgress != null;
        }

        public long getLastChunk() {
            return this.lastChunk;
        }

        public void setLastChunk(long lastChunk) {
            this.lastChunk = lastChunk;
        }

        public String getAlignmentProgram() {
            return this.alignmentProgram;
        }

        public boolean hasArguments() {
            return this.arguments != null && this.arguments.size() > 0 || this.preset != null && this.preset instanceof JabaWsParamSet;
        }

        public List<Argument> getJabaArguments() {
            ArrayList<Argument> newargs = new ArrayList<Argument>();
            if (this.preset != null && this.preset instanceof JabaWsParamSet) {
                newargs.addAll(((JabaWsParamSet)this.preset).getjabaArguments());
            }
            if (this.arguments != null && this.arguments.size() > 0) {
                newargs.addAll(this.arguments);
            }
            return newargs;
        }

        public void addInitialStatus() {
            if (this.preset != null) {
                this.jobProgress.append("Using " + (this.preset instanceof JabaPreset ? "Server" : "User") + "Preset: " + this.preset.getName());
                if (this.preset instanceof JabaWsParamSet) {
                    for (Argument argument : ((JabaWsParamSet)this.preset).getjabaArguments()) {
                        this.jobProgress.append(argument.getName() + " " + argument.getDefaultValue() + "\n");
                    }
                }
            }
            if (this.arguments != null && this.arguments.size() > 0) {
                this.jobProgress.append("With custom parameters : \n");
                for (Argument argument : this.arguments) {
                    this.jobProgress.append(argument.getName() + " " + argument.getDefaultValue() + "\n");
                }
            }
            this.jobProgress.append("\nJob Output:\n");
        }

        public boolean isPresetJob() {
            return this.preset != null && this.preset instanceof JabaPreset;
        }

        public Preset getServerPreset() {
            return this.isPresetJob() ? ((JabaPreset)this.preset).p : null;
        }
    }
}

