/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import com.stevesoft.pat.Regex;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.EmblFlatFile;
import jalview.io.FileParse;
import jalview.ws.dbsources.EbiFileRetrievedProxy;
import jalview.ws.ebi.EBIFetchClient;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public abstract class EmblFlatfileSource
extends EbiFileRetrievedProxy {
    private static final Regex ACCESSION_REGEX = new Regex("^[A-Z]+[0-9]+");

    @Override
    public String getDbVersion() {
        return "0";
    }

    @Override
    public String getAccessionSeparator() {
        return null;
    }

    @Override
    public Regex getAccessionValidator() {
        return ACCESSION_REGEX;
    }

    @Override
    public boolean isValidReference(String accession) {
        if (accession == null || accession.length() < 2) {
            return false;
        }
        return this.getAccessionValidator().search(accession);
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return null;
    }

    @Override
    public int getTier() {
        return 0;
    }

    protected AlignmentI getEmblSequenceRecords(String dbName, String query) throws Exception {
        File reply;
        this.startQuery();
        EBIFetchClient dbFetch = new EBIFetchClient();
        try {
            reply = dbFetch.fetchDataAsFile(dbName.toLowerCase(Locale.ROOT) + ":" + query.trim(), null, "gz");
        }
        catch (Exception e) {
            this.stopQuery();
            throw new Exception(String.format("EBI EMBL retrieval failed for %s:%s", dbName.toLowerCase(Locale.ROOT), query.trim()), e);
        }
        return this.getEmblSequenceRecords(dbName, query, reply);
    }

    private AlignmentI getEmblSequenceRecords(String dbName, String query, File reply) throws IOException {
        Alignment al = null;
        if (reply != null && reply.exists()) {
            this.file = reply.getAbsolutePath();
            FileParse fp = new FileParse(this.file, DataSourceType.FILE);
            EmblFlatFile emblParser = new EmblFlatFile(fp, this.getDbSource());
            SequenceI[] seqs = emblParser.getSeqsAsArray();
            if (seqs.length > 0) {
                al = new Alignment(seqs);
            }
            if (al == null) {
                Console.error("No record found for '" + dbName + ":" + query + "'");
            }
        }
        this.stopQuery();
        return al;
    }

    @Override
    public boolean isDnaCoding() {
        return true;
    }
}

