/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.datamodel.alphafold;

import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactListImpl;
import jalview.datamodel.ContactListProviderI;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.GroupSet;
import jalview.datamodel.GroupSetI;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceI;
import jalview.util.MapList;
import jalview.ws.datamodel.MappableContactMatrixI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.BitSet;

public abstract class MappableContactMatrix<T extends MappableContactMatrix<T>>
implements MappableContactMatrixI {
    protected ContactMatrixI mappedMatrix = null;
    SequenceI refSeq = null;
    MapList toSeq = null;
    int length;

    @Override
    public ContactListI getContactList(int column) {
        return this.mappedMatrix.getContactList(column);
    }

    @Override
    public float getMin() {
        return this.mappedMatrix.getMin();
    }

    @Override
    public float getMax() {
        return this.mappedMatrix.getMax();
    }

    @Override
    public int getWidth() {
        return this.mappedMatrix.getWidth();
    }

    @Override
    public int getHeight() {
        return this.mappedMatrix.getHeight();
    }

    @Override
    public ContactMatrixI getMappedMatrix() {
        return this.mappedMatrix;
    }

    @Override
    public GroupSetI getGroupSet() {
        return this.mappedMatrix.getGroupSet();
    }

    @Override
    public void setGroupSet(GroupSet makeGroups) {
        this.mappedMatrix.setGroupSet(makeGroups);
    }

    @Override
    public boolean hasReferenceSeq() {
        return this.refSeq != null;
    }

    @Override
    public SequenceI getReferenceSeq() {
        return this.refSeq;
    }

    @Override
    public MapList getMapFor(SequenceI mapSeq) {
        if (this.refSeq != null) {
            while (mapSeq != this.refSeq && mapSeq.getDatasetSequence() != null) {
                mapSeq = mapSeq.getDatasetSequence();
            }
            if (mapSeq != this.refSeq) {
                return null;
            }
        } else if (mapSeq != null) {
            return null;
        }
        return this.toSeq;
    }

    public void setRefSeq(SequenceI _refSeq) {
        this.refSeq = _refSeq;
        while (this.refSeq.getDatasetSequence() != null) {
            this.refSeq = this.refSeq.getDatasetSequence();
        }
        this.length = _refSeq.getEnd() - _refSeq.getStart() + 1;
        this.toSeq = new MapList(new int[]{_refSeq.getStart(), _refSeq.getEnd()}, new int[]{0, this.length - 1}, 1, 1);
    }

    public T liftOver(SequenceI newRefSeq, Mapping sp2sq) {
        if (sp2sq.getMappedWidth() != sp2sq.getWidth()) {
            throw new Error("liftOver currently not implemented for transfer of annotation between different types of seqeunce");
        }
        boolean mapIsTo = sp2sq != null ? sp2sq.getTo() == this.refSeq : false;
        int[] refMap = this.toSeq.locateInFrom(0, this.length - 1);
        ArrayList<Integer> newFromMap = new ArrayList<Integer>();
        int last = -1;
        for (int i = 0; i < refMap.length; i += 2) {
            int[] sp2map;
            int[] nArray = sp2map = mapIsTo ? sp2sq.getMap().locateInFrom(refMap[i], refMap[i + 1]) : sp2sq.getMap().locateInTo(refMap[i], refMap[i + 1]);
            if (sp2map == null) continue;
            for (int spm = 0; spm < sp2map.length; spm += 2) {
                if (last > -1) {
                    if (sp2map[spm] != last + 1) {
                        newFromMap.add(sp2map[spm]);
                    } else {
                        newFromMap.remove(newFromMap.size() - 1);
                    }
                } else {
                    newFromMap.add(sp2map[spm]);
                }
                last = sp2map[spm + 1];
                newFromMap.add(last);
            }
        }
        if (newFromMap.size() % 2 != 0) {
            throw new Error("PAEMatrix liftover failed.");
        }
        int[] fromIntMap = new int[newFromMap.size()];
        int ipos = 0;
        for (Integer i : newFromMap) {
            fromIntMap[ipos++] = i;
        }
        MapList newFromMapList = new MapList(fromIntMap, new int[]{0, this.length - 1}, 1, 1);
        T newCM = this.newMappableContactMatrix(newRefSeq, newFromMapList);
        return newCM;
    }

    protected abstract T newMappableContactMatrix(SequenceI var1, MapList var2);

    @Override
    public int[] getMappedPositionsFor(SequenceI localFrame, int column) {
        return this.getMappedPositionsFor(localFrame, column, column);
    }

    @Override
    public int[] getMappedPositionsFor(SequenceI localFrame, int from, int to) {
        if (localFrame == null) {
            throw new Error("Unimplemented when no local sequence given.");
        }
        SequenceI lf = localFrame;
        SequenceI uf = this.refSeq;
        while (lf.getDatasetSequence() != null || uf.getDatasetSequence() != null) {
            if (lf.getDatasetSequence() != null) {
                lf = lf.getDatasetSequence();
            }
            if (uf.getDatasetSequence() == null) continue;
            uf = uf.getDatasetSequence();
        }
        if (lf != uf) {
            throw new Error("This Matrix associated with '" + this.refSeq.getName() + "' is not mappable for the given localFrame sequence. (" + localFrame.getName() + ")");
        }
        if (this.toSeq == null) {
            return new int[]{from, to};
        }
        int[] mappedPositions = this.toSeq.locateInFrom(from, to);
        if (mappedPositions == null) {
            return null;
        }
        return mappedPositions;
    }

    @Override
    public ContactListI getMappableContactList(final SequenceI localFrame, final int column) {
        int[] nArray;
        int _column;
        if (localFrame == null) {
            throw new Error("Unimplemented when no local sequence given.");
        }
        final MappableContactMatrix us = this;
        int _lcolumn = localFrame.findPosition(column);
        if (this.toSeq != null) {
            SequenceI lf = localFrame;
            SequenceI uf = this.refSeq;
            while (lf.getDatasetSequence() != null || uf.getDatasetSequence() != null) {
                if (lf.getDatasetSequence() != null) {
                    lf = lf.getDatasetSequence();
                }
                if (uf.getDatasetSequence() == null) continue;
                uf = uf.getDatasetSequence();
            }
            if (lf != uf) {
                throw new Error("This Matrix associated with '" + this.refSeq.getName() + "' is not mappable for the given localFrame sequence. (" + localFrame.getName() + ")");
            }
            int[] word = this.toSeq.locateInTo(_lcolumn, _lcolumn);
            if (word == null) {
                return null;
            }
            _column = word[0];
        } else {
            _column = _lcolumn;
        }
        if (_column < 0 || this.toSeq != null && _column > this.toSeq.getToHighest() || this.toSeq == null && this.getHeight() <= _column) {
            return null;
        }
        if (this.toSeq == null) {
            int[] nArray2 = new int[2];
            nArray2[0] = localFrame.getStart();
            nArray = nArray2;
            nArray2[1] = localFrame.getEnd();
        } else {
            nArray = this.toSeq.locateInTo(localFrame.getStart(), localFrame.getEnd());
        }
        final int[] matrixRange = nArray;
        int h = 0;
        for (int p = 0; p < matrixRange.length; p += 2) {
            h += 1 + Math.abs(matrixRange[p + 1] - matrixRange[p]);
        }
        final int rangeHeight = h;
        return new ContactListImpl(new ContactListProviderI(){

            public int getColumn() {
                return column;
            }

            @Override
            public int getPosition() {
                return _column;
            }

            @Override
            public int getContactHeight() {
                return rangeHeight;
            }

            @Override
            public double getContactAt(int mcolumn) {
                if (mcolumn < 0 || mcolumn >= rangeHeight) {
                    return -1.0;
                }
                return MappableContactMatrix.this.getElementAt(_column, this.locateInRange(mcolumn));
            }

            @Override
            public int[] getMappedPositionsFor(int cStart, int cEnd) {
                int realCend;
                if (!MappableContactMatrix.this.hasReferenceSeq()) {
                    return ContactListProviderI.super.getMappedPositionsFor(cStart, cEnd);
                }
                int realCstart = this.locateInRange(cStart);
                int[] mappedPositions = MappableContactMatrix.this.toSeq.locateInFrom(realCstart, realCend = this.locateInRange(cEnd));
                if (mappedPositions != null) {
                    int s = -1;
                    int e = -1;
                    for (int p = 0; p < mappedPositions.length; ++p) {
                        if (s == -1 && mappedPositions[p] >= localFrame.getStart()) {
                            s = p;
                        }
                        if (e != -1 && mappedPositions[p] > localFrame.getEnd()) continue;
                        e = p;
                        mappedPositions[p] = localFrame.findIndex(mappedPositions[p]);
                    }
                }
                return mappedPositions;
            }

            private int locateInRange(int mcolumn) {
                int h = 0;
                int p = 0;
                while (h < mcolumn && p + 2 < matrixRange.length) {
                    h += 1 + Math.abs(matrixRange[p + 1] - matrixRange[p]);
                    p += 2;
                }
                return matrixRange[p] + mcolumn - h;
            }

            @Override
            public Color getColourForGroup() {
                BitSet gp = us.getGroupsFor(_column);
                Color col = us.getColourForGroup(gp);
                return col;
            }
        });
    }

    @Override
    public double getElementAt(int _column, int i) {
        return this.mappedMatrix.getElementAt(_column, i);
    }

    public int hashCode() {
        return 7 * (this.refSeq != null ? this.refSeq.hashCode() : 0) + 11 * (this.toSeq != null ? this.toSeq.hashCode() : 0) + 13 * (this.mappedMatrix != null ? this.mappedMatrix.hashCode() : 0) + this.length * 3;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        MappableContactMatrix them = (MappableContactMatrix)obj;
        return this.mappedMatrix == them.mappedMatrix && this.length == them.length && this.refSeq == them.refSeq && this.toSeq.equals(them.toSeq);
    }
}

