/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel.seqfeatures;

import jalview.api.FeatureColourI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.schemes.FeatureColour;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FeatureRendererSettings
implements Cloneable {
    String[] renderOrder;
    Map<String, Boolean> featureGroups;
    Map<String, FeatureColourI> featureColours;
    Map<String, FeatureMatcherSetI> featureFilters;
    float transparency;
    Map<String, Float> featureOrder;

    public FeatureRendererSettings(String[] renderOrder, Map<String, Boolean> featureGroups, Map<String, FeatureColourI> featureColours, float transparency, Map<String, Float> featureOrder) {
        this.renderOrder = Arrays.copyOf(renderOrder, renderOrder.length);
        this.featureGroups = new ConcurrentHashMap<String, Boolean>(featureGroups);
        this.featureColours = new ConcurrentHashMap<String, FeatureColourI>(featureColours);
        this.transparency = transparency;
        this.featureOrder = new ConcurrentHashMap<String, Float>(featureOrder);
    }

    public FeatureRendererSettings(FeatureRendererModel fr) {
        this.renderOrder = null;
        this.featureGroups = new ConcurrentHashMap<String, Boolean>();
        this.featureColours = new ConcurrentHashMap<String, FeatureColourI>();
        this.featureFilters = new HashMap<String, FeatureMatcherSetI>();
        this.featureOrder = new ConcurrentHashMap<String, Float>();
        if (fr.renderOrder != null) {
            this.renderOrder = new String[fr.renderOrder.length];
            System.arraycopy(fr.renderOrder, 0, this.renderOrder, 0, fr.renderOrder.length);
        }
        if (fr.featureGroups != null) {
            this.featureGroups = new ConcurrentHashMap<String, Boolean>(fr.featureGroups);
        }
        if (fr.featureColours != null) {
            this.featureColours = new ConcurrentHashMap<String, FeatureColourI>(fr.featureColours);
        }
        for (String next : fr.featureColours.keySet()) {
            FeatureColourI val = this.featureColours.get(next);
            if (!val.isGraduatedColour() && !val.isColourByLabel()) continue;
            this.featureColours.put(next, new FeatureColour((FeatureColour)val));
        }
        if (fr.featureFilters != null) {
            this.featureFilters.putAll(fr.featureFilters);
        }
        this.transparency = fr.transparency;
        if (fr.featureOrder != null) {
            this.featureOrder = new ConcurrentHashMap<String, Float>(fr.featureOrder);
        }
    }
}

