/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Console;
import jalview.util.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public class FileUtils {
    public static List<File> getFilesFromGlob(String pattern) {
        return FileUtils.getFilesFromGlob(pattern, true);
    }

    public static List<File> getFilesFromGlob(String pattern, boolean allowSingleFilenameThatDoesNotExist) {
        String relativePattern = (pattern = FileUtils.substituteHomeDir(pattern)).startsWith(File.separator) ? null : pattern;
        final ArrayList<File> files = new ArrayList<File>();
        int firstGlobChar = -1;
        boolean foundGlobChar = false;
        for (char c : new char[]{'*', '{', '?'}) {
            if (pattern.indexOf(c) <= -1 || pattern.indexOf(c) >= firstGlobChar && foundGlobChar) continue;
            firstGlobChar = pattern.indexOf(c);
            foundGlobChar = true;
        }
        int lastFS = pattern.lastIndexOf(File.separatorChar, firstGlobChar);
        if (foundGlobChar) {
            Path parentDir;
            String pS = pattern.substring(0, lastFS + 1);
            String rest = pattern.substring(lastFS + 1);
            if ("".equals(pS)) {
                pS = ".";
            }
            if ((parentDir = Paths.get(pS, new String[0])).toFile().exists()) {
                try {
                    String glob = "glob:" + parentDir.toString() + File.separator + rest;
                    final PathMatcher pm = FileSystems.getDefault().getPathMatcher(glob);
                    int maxDepth = rest.contains("**") ? 1028 : (int)rest.chars().filter(ch -> ch == File.separatorChar).count() + 1;
                    Files.walkFileTree(parentDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                            if (pm.matches(path)) {
                                files.add(path.toFile());
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            File f = new File(pattern);
            if (allowSingleFilenameThatDoesNotExist || f.exists()) {
                files.add(f);
            }
        }
        Collections.sort(files);
        return files;
    }

    public static List<String> getFilenamesFromGlob(String pattern) {
        return FileUtils.getFilesFromGlob(pattern).stream().map(f -> f.getPath()).collect(Collectors.toList());
    }

    public static String substituteHomeDir(String path) {
        return path.startsWith("~" + File.separator) ? System.getProperty("user.home") + path.substring(1) : path;
    }

    public static String getBasename(File file) {
        return FileUtils.getBasenameOrExtension(file, false);
    }

    public static String getExtension(File file) {
        return FileUtils.getBasenameOrExtension(file, true);
    }

    public static String getBasenameOrExtension(File file, boolean extension) {
        if (file == null) {
            return null;
        }
        String value = null;
        String filename = file.getName();
        int lastDot = filename.lastIndexOf(46);
        value = lastDot > 0 ? (extension ? filename.substring(lastDot + 1) : filename.substring(0, lastDot)) : (extension ? "" : filename);
        return value;
    }

    public static String getDirname(File file) {
        if (file == null) {
            return null;
        }
        String dirname = null;
        File p = file.getParentFile();
        if (p == null) {
            p = new File(".");
        }
        File d = new File(FileUtils.substituteHomeDir(p.getPath()));
        dirname = d.getPath();
        return dirname;
    }

    public static String convertWildcardsToPath(String value, String wildcard, String dirname, String basename) {
        if (value == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        int lastFileSeparatorIndex = value.lastIndexOf(File.separatorChar);
        int wildcardBeforeIndex = value.indexOf(wildcard);
        if (lastFileSeparatorIndex > wildcard.length() - 1 && wildcardBeforeIndex < lastFileSeparatorIndex) {
            path.append(value.substring(0, wildcardBeforeIndex));
            path.append(dirname);
            path.append(value.substring(wildcardBeforeIndex + wildcard.length(), lastFileSeparatorIndex + 1));
        } else {
            path.append(value.substring(0, lastFileSeparatorIndex + 1));
        }
        int wildcardAfterIndex = value.indexOf(wildcard, lastFileSeparatorIndex);
        if (wildcardAfterIndex > lastFileSeparatorIndex) {
            path.append(value.substring(lastFileSeparatorIndex + 1, wildcardAfterIndex));
            path.append(basename);
            path.append(value.substring(wildcardAfterIndex + wildcard.length()));
        } else {
            path.append(value.substring(lastFileSeparatorIndex + 1));
        }
        return path.toString();
    }

    public static File getParentDir(File file) {
        if (file == null) {
            return null;
        }
        File parentDir = file.getAbsoluteFile().getParentFile();
        return parentDir;
    }

    public static boolean checkParentDir(File file, boolean mkdirs) {
        if (file == null) {
            return false;
        }
        File parentDir = FileUtils.getParentDir(file);
        if (parentDir.exists()) {
            return true;
        }
        if (!mkdirs) {
            return false;
        }
        Path path = file.toPath();
        for (int i = 0; i < path.getNameCount(); ++i) {
            Path p = path.getName(i);
            if (!"..".equals(p.toString())) continue;
            Console.warn("Cautiously not running mkdirs on " + file.toString() + " because the path to be made contains '..'");
            return false;
        }
        return parentDir.mkdirs();
    }

    public static String getExtension(String filename) {
        return FileUtils.getBaseOrExtension(filename, true);
    }

    public static String getBase(String filename) {
        return FileUtils.getBaseOrExtension(filename, false);
    }

    public static String getBaseOrExtension(String filename0, boolean extension) {
        boolean hasExtension;
        if (filename0 == null) {
            return null;
        }
        String filename = filename0;
        boolean isUrl = false;
        if (HttpUtils.startsWithHttpOrHttps(filename)) {
            try {
                URL url = new URL(filename);
                filename = url.getPath();
                isUrl = true;
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        int dot = filename.lastIndexOf(46);
        int slash = filename.lastIndexOf(47);
        if (!File.separator.equals("/") && !isUrl) {
            slash = filename.lastIndexOf(File.separator);
        }
        boolean bl = hasExtension = dot > slash + 1;
        if (extension) {
            return hasExtension ? filename.substring(dot + 1) : null;
        }
        dot = filename0.lastIndexOf(46);
        return hasExtension ? filename0.substring(0, dot + 1) : filename0;
    }
}

