/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import com.stevesoft.pat.Regex;
import jalview.bin.Console;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.Mapping;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.util.MapList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DBRefUtils {
    private static Map<String, String> canonicalSourceNameLookup = new HashMap<String, String>();
    public static final int DB_SOURCE = 1;
    public static final int DB_VERSION = 2;
    public static final int DB_ID = 4;
    public static final int DB_MAP = 8;
    public static final int SEARCH_MODE_NO_MAP_NO_VERSION = 5;
    public static final int SEARCH_MODE_FULL = 15;
    public static DbRefComp matchNonNullonA;
    public static DbRefComp matchEitherNonNull;
    public static DbRefComp matchDbAndIdAndEitherMap;
    public static DbRefComp matchDbAndIdAndComplementaryMapList;
    public static DbRefComp matchDbAndIdAndEquivalentMapList;
    public static DbRefComp matchDbAndIdAndEitherMapOrEquivalentMapList;

    public static List<DBRefEntry> selectRefs(List<DBRefEntry> dbrefs, String[] sources) {
        if (dbrefs == null || sources == null) {
            return dbrefs;
        }
        HashSet<String> srcs = new HashSet<String>();
        for (String src : sources) {
            srcs.add(src.toUpperCase(Locale.ROOT));
        }
        int nrefs = dbrefs.size();
        ArrayList<DBRefEntry> res = new ArrayList<DBRefEntry>();
        for (int ib = 0; ib < nrefs; ++ib) {
            DBRefEntry dbr = dbrefs.get(ib);
            String source = DBRefUtils.getCanonicalName(dbr.getSource());
            if (!srcs.contains(source.toUpperCase(Locale.ROOT))) continue;
            res.add(dbr);
        }
        if (res.size() > 0) {
            return res;
        }
        return null;
    }

    private static boolean selectRefsBS(List<DBRefEntry> dbrefs, int sourceKeys, BitSet bsSelect) {
        if (dbrefs == null || sourceKeys == 0) {
            return false;
        }
        int n = dbrefs.size();
        for (int i = 0; i < n; ++i) {
            DBRefEntry dbr = dbrefs.get(i);
            if ((dbr.getSourceKey() & sourceKeys) == 0) continue;
            bsSelect.clear(i);
        }
        return !bsSelect.isEmpty();
    }

    static List<DBRefEntry> searchRefs(DBRefEntry[] refs, DBRefEntry entry, DbRefComp comparator) {
        ArrayList<DBRefEntry> rfs = new ArrayList<DBRefEntry>();
        if (refs == null || entry == null) {
            return rfs;
        }
        for (int i = 0; i < refs.length; ++i) {
            if (!comparator.matches(entry, refs[i])) continue;
            rfs.add(refs[i]);
        }
        return rfs;
    }

    public static String getCanonicalName(String source) {
        if (source == null) {
            return null;
        }
        String canonical = canonicalSourceNameLookup.get(source.toLowerCase(Locale.ROOT));
        return canonical == null ? source : canonical;
    }

    public static List<DBRefEntry> searchRefs(List<DBRefEntry> ref, DBRefEntry entry, int mode) {
        return DBRefUtils.searchRefs(ref, entry, matchDbAndIdAndEitherMapOrEquivalentMapList, mode);
    }

    public static List<DBRefEntry> searchRefs(List<DBRefEntry> refs, String accId) {
        ArrayList<DBRefEntry> rfs = new ArrayList<DBRefEntry>();
        if (refs == null || accId == null) {
            return rfs;
        }
        int n = refs.size();
        for (int i = 0; i < n; ++i) {
            DBRefEntry e = refs.get(i);
            if (!accId.equals(e.getAccessionId())) continue;
            rfs.add(e);
        }
        return rfs;
    }

    static List<DBRefEntry> searchRefs(List<DBRefEntry> refs, DBRefEntry entry, DbRefComp comparator, int mode) {
        ArrayList<DBRefEntry> rfs = new ArrayList<DBRefEntry>();
        if (refs == null || entry == null) {
            return rfs;
        }
        int n = refs.size();
        for (int i = 0; i < n; ++i) {
            DBRefEntry e = refs.get(i);
            if (!comparator.matches(entry, e, 15)) continue;
            rfs.add(e);
        }
        return rfs;
    }

    public static DBRefEntry parseToDbRef(SequenceI seq, String dbname, String version, String acn) {
        DBRefEntry ref = null;
        if (dbname != null) {
            String locsrc = DBRefUtils.getCanonicalName(dbname);
            if (locsrc.equals("PDB")) {
                Regex r = new Regex("([0-9][0-9A-Za-z]{3})\\s*(.?)\\s*;\\s*([0-9]+)-([0-9]+)");
                if (r.search(acn.trim())) {
                    String pdbid = r.stringMatched(1);
                    String chaincode = r.stringMatched(2);
                    if (chaincode == null) {
                        chaincode = " ";
                    }
                    if (chaincode.equals(" ")) {
                        chaincode = "_";
                    }
                    ref = new DBRefEntry(locsrc, version, pdbid + chaincode);
                    PDBEntry pdbr = new PDBEntry();
                    pdbr.setId(pdbid);
                    pdbr.setType(PDBEntry.Type.PDB);
                    pdbr.setChainCode(chaincode);
                    seq.addPDBId(pdbr);
                } else {
                    Console.errPrintln("Malformed PDB DR line:" + acn);
                }
            } else {
                ref = new DBRefEntry(locsrc, version, acn.trim());
            }
        }
        if (ref != null) {
            seq.addDBRef(ref);
        }
        return ref;
    }

    public static List<DBRefEntry> searchRefsForSource(DBRefEntry[] dbRefs, String source) {
        ArrayList<DBRefEntry> matches = new ArrayList<DBRefEntry>();
        if (dbRefs != null && source != null) {
            for (DBRefEntry dbref : dbRefs) {
                if (!source.equalsIgnoreCase(dbref.getSource())) continue;
                matches.add(dbref);
            }
        }
        return matches;
    }

    public static boolean nullOrEqual(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return true;
        }
        return o1.equals(o2);
    }

    public static boolean nullOrEqualSource(String o1, String o2) {
        if (o1 == null || o2 == null) {
            return true;
        }
        return DBRefUtils.getCanonicalName(o1).equals(DBRefUtils.getCanonicalName(o2));
    }

    public static List<DBRefEntry> selectDbRefs(boolean selectDna, List<DBRefEntry> refs) {
        return DBRefUtils.selectRefs(refs, selectDna ? DBRefSource.DNACODINGDBS : DBRefSource.PROTEINDBS);
    }

    public static List<DBRefEntry> searchRefsForSource(List<DBRefEntry> dbRefs, String source) {
        ArrayList<DBRefEntry> matches = new ArrayList<DBRefEntry>();
        if (dbRefs != null && source != null) {
            for (DBRefEntry dbref : dbRefs) {
                if (!source.equalsIgnoreCase(dbref.getSource())) continue;
                matches.add(dbref);
            }
        }
        return matches;
    }

    public static void ensurePrimaries(SequenceI sequence, List<DBRefEntry> pr) {
        if (pr.size() == 0) {
            return;
        }
        int sstart = sequence.getStart();
        int send = sequence.getEnd();
        boolean isProtein = sequence.isProtein();
        BitSet bsSelect = new BitSet();
        Sequence.DBModList<DBRefEntry> dbrefs = sequence.getDBRefs();
        bsSelect.set(0, dbrefs.size());
        if (!DBRefUtils.selectRefsBS(dbrefs, isProtein ? 141 : 2168, bsSelect)) {
            return;
        }
        int ip = pr.size();
        while (--ip >= 0) {
            DBRefEntry p = pr.get(ip);
            int i = bsSelect.nextSetBit(0);
            while (i >= 0) {
                if (dbrefs.get(i) == p) {
                    bsSelect.clear(i);
                }
                i = bsSelect.nextSetBit(i + 1);
            }
        }
        ip = pr.size();
        int keys = 0;
        while (--ip >= 0 && keys != 9) {
            DBRefEntry p = pr.get(ip);
            if (isProtein) {
                switch (DBRefUtils.getCanonicalName(p.getSource())) {
                    case "UNIPROT": {
                        keys |= 1;
                        break;
                    }
                    case "ENSEMBL": {
                        keys |= 8;
                    }
                }
            }
            if (keys == 0 || !DBRefUtils.selectRefsBS(dbrefs, keys, bsSelect)) {
                return;
            }
            int ic = bsSelect.nextSetBit(0);
            while (ic >= 0) {
                MapList mlist;
                Mapping map;
                SequenceI cto;
                DBRefEntry cand = (DBRefEntry)dbrefs.get(ic);
                if (!(cand.hasMap() && ((cto = (map = cand.getMap()).getTo()) != null && cto != sequence || (mlist = map.getMap()).getFromLowest() != sstart && mlist.getFromHighest() != send))) {
                    cand.setVersion(cand.getVersion() + " (promoted)");
                    bsSelect.clear(ic);
                    if (!cand.isPrimaryCandidate() && Console.isDebugEnabled()) {
                        Console.debug("Warning: Couldn't promote dbref " + cand.toString() + " for sequence " + sequence.toString());
                    }
                }
                ic = bsSelect.nextSetBit(ic + 1);
            }
        }
    }

    static {
        canonicalSourceNameLookup.put("uniprotkb/swiss-prot", "UNIPROT");
        canonicalSourceNameLookup.put("uniprotkb/trembl", "UNIPROT");
        canonicalSourceNameLookup.put("uniprot/sptrembl", "UNIPROT");
        canonicalSourceNameLookup.put("uniprot/swissprot", "UNIPROT");
        canonicalSourceNameLookup.put("pdb", "PDB");
        canonicalSourceNameLookup.put("ensembl", "ENSEMBL");
        canonicalSourceNameLookup.put("ensembl-tr", "ENSEMBL");
        canonicalSourceNameLookup.put("ensembl-gn", "ENSEMBL");
        for (String k : canonicalSourceNameLookup.keySet()) {
            canonicalSourceNameLookup.put(k.toLowerCase(Locale.ROOT), canonicalSourceNameLookup.get(k));
        }
        matchNonNullonA = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb, int mode) {
                return !((mode & 1) == 0 || refa.getSource() != null && !DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) || (mode & 2) == 0 || refa.getVersion() != null && !refb.getVersion().equals(refa.getVersion()) || (mode & 4) == 0 || refa.getAccessionId() != null && !refb.getAccessionId().equals(refa.getAccessionId()) || (mode & 8) == 0 || refa.getMap() != null && (refb.getMap() == null || !refb.getMap().equals(refa.getMap())));
            }
        };
        matchEitherNonNull = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb, int mode) {
                return DBRefUtils.nullOrEqualSource(refa.getSource(), refb.getSource()) && DBRefUtils.nullOrEqual(refa.getVersion(), refb.getVersion()) && DBRefUtils.nullOrEqual(refa.getAccessionId(), refb.getAccessionId()) && DBRefUtils.nullOrEqual(refa.getMap(), refb.getMap());
            }
        };
        matchDbAndIdAndEitherMap = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb, int mode) {
                return refa.getSource() != null && refb.getSource() != null && DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) && (refa.getAccessionId() != null && refb.getAccessionId() != null || refb.getAccessionId().equals(refa.getAccessionId())) && (refa.getMap() == null || refb.getMap() == null || refa.getMap() != null && refb.getMap() != null && refb.getMap().equals(refa.getMap()));
            }
        };
        matchDbAndIdAndComplementaryMapList = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb, int mode) {
                return refa.getSource() != null && refb.getSource() != null && DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) && (refa.getAccessionId() != null && refb.getAccessionId() != null || refb.getAccessionId().equals(refa.getAccessionId())) && (refa.getMap() == null && refb.getMap() == null || refa.getMap() != null && refb.getMap() != null) && (refb.getMap().getMap() == null && refa.getMap().getMap() == null || refb.getMap().getMap() != null && refa.getMap().getMap() != null && refb.getMap().getMap().getInverse().equals(refa.getMap().getMap()));
            }
        };
        matchDbAndIdAndEquivalentMapList = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb, int mode) {
                if (refa.getSource() != null && refb.getSource() != null && DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) && (refa.getAccessionId() != null && refb.getAccessionId() != null || refb.getAccessionId().equals(refa.getAccessionId()))) {
                    if (refa.getMap() == null && refb.getMap() == null) {
                        return true;
                    }
                    if (refa.getMap() != null && refb.getMap() != null && (refb.getMap().getMap() == null && refa.getMap().getMap() == null || refb.getMap().getMap() != null && refa.getMap().getMap() != null && refb.getMap().getMap().equals(refa.getMap().getMap()))) {
                        return true;
                    }
                }
                return false;
            }
        };
        matchDbAndIdAndEitherMapOrEquivalentMapList = new DbRefComp(){

            @Override
            public boolean matches(DBRefEntry refa, DBRefEntry refb, int mode) {
                if (refa.getSource() != null && refb.getSource() != null && DBRefUtils.getCanonicalName(refb.getSource()).equals(DBRefUtils.getCanonicalName(refa.getSource())) && (refa.getAccessionId() == null || refa.getAccessionId().equals(refb.getAccessionId()))) {
                    if (refa.getMap() == null || refb.getMap() == null) {
                        return true;
                    }
                    if (refa.getMap() != null && refb.getMap() != null && refb.getMap().getMap() == null && refa.getMap().getMap() == null || refb.getMap().getMap() != null && refa.getMap().getMap() != null && refb.getMap().getMap().equals(refa.getMap().getMap())) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    static interface DbRefComp {
        default public boolean matches(DBRefEntry refa, DBRefEntry refb) {
            return this.matches(refa, refb, 15);
        }

        public boolean matches(DBRefEntry var1, DBRefEntry var2, int var3);
    }
}

