/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.bin.Console;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.xml.binding.jalview.JalviewUserColours;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class ColourSchemeLoader {
    public static UserColourScheme loadColourScheme(String filePath) {
        UserColourScheme ucs = null;
        Color[] newColours = null;
        File file = new File(filePath);
        try {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            JAXBContext jc = JAXBContext.newInstance((String)"jalview.xml.binding.jalview");
            Unmarshaller um = jc.createUnmarshaller();
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            JAXBElement jbe = um.unmarshal(streamReader, JalviewUserColours.class);
            JalviewUserColours jucs = (JalviewUserColours)jbe.getValue();
            newColours = new Color[24];
            Color[] lowerCase = new Color[23];
            boolean caseSensitive = false;
            for (int i = 0; i < jucs.getColour().size(); ++i) {
                String name = jucs.getColour().get(i).getName();
                int index = ResidueProperties.aa3Hash.containsKey(name) ? ResidueProperties.aa3Hash.get(name) : ResidueProperties.aaIndex[name.charAt(0)];
                if (index == -1) continue;
                Color color = new Color(Integer.parseInt(jucs.getColour().get(i).getRGB(), 16));
                if (name.toLowerCase(Locale.ROOT).equals(name)) {
                    caseSensitive = true;
                    lowerCase[index] = color;
                    continue;
                }
                newColours[index] = color;
            }
            ucs = new UserColourScheme(newColours);
            ucs.setName(jucs.getSchemeName());
            if (caseSensitive) {
                ucs.setLowerCaseColours(lowerCase);
            }
        }
        catch (Exception ex) {
            Console.errPrintln("Failed to read colour scheme from " + filePath + " : " + ex.toString());
        }
        return ucs;
    }
}

