/*
 * Decompiled with CFR 0.152.
 */
package jalview.log;

import jalview.log.JLoggerI;
import jalview.util.Log4j;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;

public class JalviewAppender
extends AbstractAppender {
    public static final String NAME = "JalviewAppender";
    private static JTextArea jTextArea = null;

    public JalviewAppender() {
        this(JLoggerI.LogLevel.INFO);
    }

    public JalviewAppender(JLoggerI.LogLevel loglevel) {
        super(NAME, Log4j.getThresholdFilter(loglevel == null ? Level.INFO : Log4j.log4jLevel(loglevel)), Log4j.getSimpleLayout(), false, new Property[0]);
    }

    protected JalviewAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public static void setTextArea(JTextArea jTextArea) {
        JalviewAppender.jTextArea = jTextArea;
    }

    public void append(LogEvent logEvent) {
        final String message = new String(this.getLayout().toByteArray(logEvent), StandardCharsets.UTF_8);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jTextArea != null) {
                    jTextArea.append(message);
                }
            }
        });
    }
}

